/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearDynamicSystems;

import Jama.Matrix;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.dataStructures.ObsoletePolynomial;
import us.ihmc.robotics.linearDynamicSystems.PolynomialMatrix;

public class PolynomialMatrixTest {
    @BeforeEach
    public void setUp() throws Exception {
    }

    @AfterEach
    public void tearDown() throws Exception {
    }

    @Test
    public void testComputeDeterminantOne() {
        ObsoletePolynomial zero = new ObsoletePolynomial(new double[]{0.0});
        ObsoletePolynomial one = new ObsoletePolynomial(new double[]{1.0});
        ObsoletePolynomial two = new ObsoletePolynomial(new double[]{2.0});
        ObsoletePolynomial[][] polynomials = new ObsoletePolynomial[][]{{one}};
        PolynomialMatrix m0 = new PolynomialMatrix((ObsoletePolynomial[][])polynomials);
        Assert.assertTrue(m0.computeDeterminant().epsilonEquals(one, 1.0E-7));
        polynomials = new ObsoletePolynomial[][]{{one, one}, {zero, one}};
        m0 = new PolynomialMatrix((ObsoletePolynomial[][])polynomials);
        ObsoletePolynomial determinant = m0.computeDeterminant();
        Assert.assertTrue(determinant.epsilonEquals(one, 1.0E-7));
        polynomials = new ObsoletePolynomial[][]{{one, two}, {two, two}};
        m0 = new PolynomialMatrix((ObsoletePolynomial[][])polynomials);
        determinant = m0.computeDeterminant();
        Assert.assertTrue(determinant.epsilonEquals(two.times(-1.0), 1.0E-7));
    }

    @Test
    public void testComputeDeterminantTwo() {
        ObsoletePolynomial s = new ObsoletePolynomial(new double[]{1.0, 0.0});
        ObsoletePolynomial zero = new ObsoletePolynomial(new double[]{0.0});
        ObsoletePolynomial one = new ObsoletePolynomial(new double[]{1.0});
        ObsoletePolynomial negativeOne = one.times(-1.0);
        ObsoletePolynomial[][] polynomials = new ObsoletePolynomial[][]{{s, zero, negativeOne, zero}, {zero, s, zero, negativeOne}, {one, negativeOne, s, zero}, {negativeOne, one, zero, s}};
        ObsoletePolynomial expectedDeterminant = new ObsoletePolynomial(new double[]{1.0, 0.0, 2.0, 0.0, 0.0});
        PolynomialMatrix m0 = new PolynomialMatrix((ObsoletePolynomial[][])polynomials);
        ObsoletePolynomial determinant = m0.computeDeterminant();
        Assert.assertTrue(determinant.epsilonEquals(expectedDeterminant, 1.0E-7));
    }

    @Test
    public void testComputeDeterminantAndConstructSIMinusA() {
        Matrix matrixA = new Matrix((double[][])new double[][]{{1.0}});
        PolynomialMatrix sIMinusA = PolynomialMatrix.constructSIMinusA((Matrix)matrixA);
        ObsoletePolynomial determinant = sIMinusA.computeDeterminant();
        ObsoletePolynomial expectedPolynomial = new ObsoletePolynomial(new double[]{1.0, -1.0});
        Assert.assertTrue(expectedPolynomial.epsilonEquals(determinant, 1.0E-7));
        matrixA = new Matrix((double[][])new double[][]{{0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}, {-1.0, 1.0, 0.0, 0.0}, {1.0, -1.0, 0.0, 0.0}});
        sIMinusA = PolynomialMatrix.constructSIMinusA((Matrix)matrixA);
        determinant = sIMinusA.computeDeterminant();
        expectedPolynomial = new ObsoletePolynomial(new double[]{1.0, 0.0, 2.0, 0.0, 0.0});
        Assert.assertTrue(expectedPolynomial.epsilonEquals(determinant, 1.0E-7));
    }

    @Test
    public void testComputeDeterminantAndCofactors() {
        double[][] elementsA = new double[][]{{2.0, -2.0, 3.0}, {1.0, 1.0, 1.0}, {1.0, 3.0, -1.0}};
        Matrix matrixA = new Matrix((double[][])elementsA);
        PolynomialMatrix sIMinusA = PolynomialMatrix.constructSIMinusA((Matrix)matrixA);
        ObsoletePolynomial determinant = sIMinusA.computeDeterminant();
        ObsoletePolynomial expectedPolynomial = ObsoletePolynomial.constructFromRealRoot((double)1.0).times(ObsoletePolynomial.constructFromRealRoot((double)-2.0)).times(ObsoletePolynomial.constructFromRealRoot((double)3.0));
        Assert.assertTrue(expectedPolynomial.epsilonEquals(determinant, 1.0E-7));
        ObsoletePolynomial[][] cofactors = sIMinusA.computeCofactors();
        Assert.assertTrue(cofactors[0][0].epsilonEquals(new ObsoletePolynomial(1.0, 0.0, -4.0), 1.0E-7));
        Assert.assertTrue(cofactors[0][1].epsilonEquals(new ObsoletePolynomial(1.0, 2.0), 1.0E-7));
        Assert.assertTrue(cofactors[0][2].epsilonEquals(new ObsoletePolynomial(1.0, 2.0), 1.0E-7));
        Assert.assertTrue(cofactors[1][0].epsilonEquals(new ObsoletePolynomial(-2.0, 7.0), 1.0E-7));
        Assert.assertTrue(cofactors[1][1].epsilonEquals(new ObsoletePolynomial(1.0, -1.0, -5.0), 1.0E-7));
        Assert.assertTrue(cofactors[1][2].epsilonEquals(new ObsoletePolynomial(3.0, -8.0), 1.0E-7));
        Assert.assertTrue(cofactors[2][0].epsilonEquals(new ObsoletePolynomial(3.0, -5.0), 1.0E-7));
        Assert.assertTrue(cofactors[2][1].epsilonEquals(new ObsoletePolynomial(1.0, 1.0), 1.0E-7));
        Assert.assertTrue(cofactors[2][2].epsilonEquals(new ObsoletePolynomial(1.0, -3.0, 4.0), 1.0E-7));
    }
}

