/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearDynamicSystems;

import Jama.Matrix;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.dataStructures.ComplexNumber;
import us.ihmc.robotics.linearDynamicSystems.ComplexMatrix;
import us.ihmc.robotics.linearDynamicSystems.DynamicSystemsTestHelpers;
import us.ihmc.robotics.linearDynamicSystems.EigenvalueDecomposer;

public class EigenvalueDecomposerTest {
    private static final double wn = 1.0;
    private static final double zeta = 0.5;
    private static final double P1 = 0.5;
    private static final double P2 = Math.sqrt(0.75) * 1.0;
    private static final double P3 = 1.0;
    private double epsilon = 1.0E-7;

    @Test
    public void testGetEigenvalues() {
        Matrix matrixAOneReal = new Matrix((double[][])new double[][]{{1.0}});
        Matrix matrixBTwoComplex = new Matrix((double[][])new double[][]{{3.0, -2.0}, {4.0, -1.0}});
        Matrix matrixCOneRealTwoComplex = new Matrix((double[][])new double[][]{{3.0, -2.0, 0.0}, {4.0, -1.0, 0.0}, {0.0, 0.0, -5.0}});
        Matrix matrixMassSpringDamper = new Matrix((double[][])new double[][]{{-1.0, -1.0}, {1.0, 0.0}});
        EigenvalueDecomposer decomposerAOneReal = new EigenvalueDecomposer(matrixAOneReal);
        EigenvalueDecomposer decomposerBTwoComplex = new EigenvalueDecomposer(matrixBTwoComplex);
        EigenvalueDecomposer decomposerCOneRealTwoComplex = new EigenvalueDecomposer(matrixCOneRealTwoComplex);
        EigenvalueDecomposer decomposerMassSpringDamper = new EigenvalueDecomposer(matrixMassSpringDamper);
        this.verifyOneRealEigenvalue(decomposerAOneReal.getEigenvalues(), 1.0);
        this.verifyTwoComplexConjugateEigenvalue(decomposerBTwoComplex.getEigenvalues(), 1.0, 2.0);
        this.verifyOneRealTwoComplexConjugateEigenvalue(decomposerCOneRealTwoComplex.getEigenvalues(), -5.0, 1.0, 2.0);
        this.verifyTwoComplexConjugateEigenvalue(decomposerMassSpringDamper.getEigenvalues(), -0.5, P2);
    }

    @Test
    public void testDecompositions() {
        Matrix matrixAOneReal = new Matrix((double[][])new double[][]{{1.0}});
        Matrix matrixBTwoComplex = new Matrix((double[][])new double[][]{{3.0, -2.0}, {4.0, -1.0}});
        Matrix matrixCOneRealTwoComplex = new Matrix((double[][])new double[][]{{3.0, -2.0, 0.0}, {4.0, -1.0, 0.0}, {0.0, 0.0, -5.0}});
        Matrix matrixMassSpringDamper = new Matrix((double[][])new double[][]{{-1.0, -1.0}, {1.0, 0.0}});
        EigenvalueDecomposer decomposerAOneReal = new EigenvalueDecomposer(matrixAOneReal);
        EigenvalueDecomposer decomposerBTwoComplex = new EigenvalueDecomposer(matrixBTwoComplex);
        EigenvalueDecomposer decomposerCOneRealTwoComplex = new EigenvalueDecomposer(matrixCOneRealTwoComplex);
        EigenvalueDecomposer decomposerMassSpringDamper = new EigenvalueDecomposer(matrixMassSpringDamper);
        EigenvalueDecomposerTest.verifyDecomposition(matrixAOneReal, decomposerAOneReal);
        EigenvalueDecomposerTest.verifyDecomposition(matrixBTwoComplex, decomposerBTwoComplex);
        EigenvalueDecomposerTest.verifyDecomposition(matrixCOneRealTwoComplex, decomposerCOneRealTwoComplex);
        EigenvalueDecomposerTest.verifyDecomposition(matrixMassSpringDamper, decomposerMassSpringDamper);
    }

    private void verifyOneRealEigenvalue(ComplexNumber[] eigenvalues, double real) {
        Assert.assertEquals(1L, eigenvalues.length);
        Assert.assertEquals(real, eigenvalues[0].real(), 1.0E-7);
        Assert.assertEquals(0.0, eigenvalues[0].imag(), this.epsilon);
    }

    private void verifyTwoComplexConjugateEigenvalue(ComplexNumber[] eigenvalues, double real, double imag) {
        Assert.assertEquals(2L, eigenvalues.length);
        this.verifyTwoComplexConjugateEigenvalue(eigenvalues[0], eigenvalues[1], real, imag);
    }

    private void verifyTwoComplexConjugateEigenvalue(ComplexNumber eigenvalueOne, ComplexNumber eigenvalueTwo, double real, double imag) {
        Assert.assertEquals(real, eigenvalueOne.real(), 1.0E-7);
        Assert.assertEquals(real, eigenvalueTwo.real(), 1.0E-7);
        Assert.assertEquals(Math.abs(imag), Math.abs(eigenvalueOne.imag()), 1.0E-7);
        Assert.assertEquals(Math.abs(imag), Math.abs(eigenvalueTwo.imag()), 1.0E-7);
        Assert.assertEquals(eigenvalueOne.imag(), -eigenvalueTwo.imag(), 1.0E-7);
    }

    private void verifyOneRealTwoComplexConjugateEigenvalue(ComplexNumber[] eigenvalues, double oneReal, double realPart, double imagPart) {
        Assert.assertEquals(3L, eigenvalues.length);
        boolean foundRealOne = false;
        boolean foundComplexPair = false;
        int index = 0;
        while (index < eigenvalues.length) {
            ComplexNumber eigenvalue = eigenvalues[index];
            if (eigenvalue.imag() == 0.0) {
                Assert.assertFalse(foundRealOne);
                Assert.assertEquals(oneReal, eigenvalue.real(), 1.0E-7);
                foundRealOne = true;
                ++index;
                continue;
            }
            Assert.assertFalse(foundComplexPair);
            ComplexNumber eigenvalueTwo = eigenvalues[index + 1];
            this.verifyTwoComplexConjugateEigenvalue(eigenvalue, eigenvalueTwo, realPart, imagPart);
            foundComplexPair = true;
            ++index;
            ++index;
        }
        Assert.assertTrue(foundRealOne);
        Assert.assertTrue(foundComplexPair);
    }

    @Test
    public void testCircleGenerator() {
        Matrix matrixA = new Matrix((double[][])new double[][]{{0.0, -1.0}, {1.0, 0.0}});
        EigenvalueDecomposer circleDecomposer = new EigenvalueDecomposer(matrixA);
        EigenvalueDecomposerTest.verifyDecomposition(matrixA, circleDecomposer);
    }

    @Test
    public void testZeroMatrix() {
        Matrix matrixA = new Matrix((double[][])new double[][]{{0.0}});
        EigenvalueDecomposer eigenvalueDecomposer = new EigenvalueDecomposer(matrixA);
        EigenvalueDecomposerTest.verifyDecomposition(matrixA, eigenvalueDecomposer);
    }

    @Test
    public void testIdentityMatrix() {
        Matrix matrixA = new Matrix((double[][])new double[][]{{1.0, 0.0}, {0.0, 1.0}});
        EigenvalueDecomposer eigenvalueDecomposer = new EigenvalueDecomposer(matrixA);
        EigenvalueDecomposerTest.verifyDecomposition(matrixA, eigenvalueDecomposer);
    }

    @Test
    public void testThreeByThreeIdentityMatrix() {
        Matrix matrixA = new Matrix((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}});
        EigenvalueDecomposer eigenvalueDecomposer = new EigenvalueDecomposer(matrixA);
        EigenvalueDecomposerTest.verifyDecomposition(matrixA, eigenvalueDecomposer);
    }

    @Test
    public void testRepeatedPoles() {
        Matrix matrixA = new Matrix((double[][])new double[][]{{0.0, 0.0}, {0.0, 0.0}});
        EigenvalueDecomposer eigenvalueDecomposer = new EigenvalueDecomposer(matrixA);
        EigenvalueDecomposerTest.verifyDecomposition(matrixA, eigenvalueDecomposer);
    }

    @Disabled
    @Test
    public void testMCSExample() {
        Matrix matrixA = new Matrix((double[][])new double[][]{{0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}, {-1.0, 1.0, 0.0, 0.0}, {1.0, -1.0, 0.0, 0.0}});
        EigenvalueDecomposer eigenvalueDecomposer = new EigenvalueDecomposer(matrixA);
        EigenvalueDecomposerTest.verifyDecomposition(matrixA, eigenvalueDecomposer);
    }

    @Test
    public void testRandomExample() {
        Matrix matrixA = new Matrix((double[][])new double[][]{{1.0, 5.0, 1.0, 7.0}, {0.0, 3.0, 0.0, 1.0}, {-1.0, 1.0, 0.0, 9.0}, {1.0, -1.0, 0.0, 0.0}});
        EigenvalueDecomposer eigenvalueDecomposer = new EigenvalueDecomposer(matrixA);
        EigenvalueDecomposerTest.verifyDecomposition(matrixA, eigenvalueDecomposer);
    }

    private static void verifyDecomposition(Matrix matrix, EigenvalueDecomposer decomposer) {
        EigenvalueDecomposerTest.verifyWEqualsVInverse(decomposer);
        EigenvalueDecomposerTest.verifyAEqualsVLambdaW(matrix, decomposer);
    }

    private static void verifyWEqualsVInverse(EigenvalueDecomposer decomposer) {
        ComplexNumber[][] leftEigenvectors = decomposer.getLeftEigenvectors();
        ComplexNumber[][] rightEigenvectors = decomposer.getRightEigenvectors();
        ComplexMatrix complexV = new ComplexMatrix(leftEigenvectors);
        complexV.transpose();
        ComplexMatrix complexW = new ComplexMatrix(rightEigenvectors);
        ComplexMatrix identityReconstructed = complexV.times(complexW);
        ComplexMatrix identity = ComplexMatrix.constructIdentity((int)leftEigenvectors.length);
        identityReconstructed.epsilonEquals(identity, 1.0E-7);
    }

    private static void verifyAEqualsVLambdaW(Matrix matrixA, EigenvalueDecomposer decomposer) {
        ComplexNumber[] eigenvalues = decomposer.getEigenvalues();
        ComplexNumber[][] leftEigenvectors = decomposer.getLeftEigenvectors();
        ComplexNumber[][] rightEigenvectors = decomposer.getRightEigenvectors();
        ComplexMatrix complexV = new ComplexMatrix(leftEigenvectors);
        complexV = complexV.transpose();
        ComplexMatrix complexW = new ComplexMatrix(rightEigenvectors);
        ComplexMatrix lambda = ComplexMatrix.constructDiagonalMatrix((ComplexNumber[])eigenvalues);
        System.out.println("V = " + complexV);
        System.out.println("lambda = " + lambda);
        System.out.println("W = " + complexW);
        ComplexMatrix aReconstructed = complexV.times(lambda).times(complexW);
        boolean passed = aReconstructed.epsilonEquals(matrixA, 1.0E-7);
        if (!passed) {
            DynamicSystemsTestHelpers.printMatrix("matrixA: ", matrixA);
            System.out.println("\naReconstructed: \n" + aReconstructed);
            System.out.println("V = " + complexV);
            System.out.println("W = " + complexW);
            System.out.println("lambda = " + lambda);
        }
        Assert.assertTrue(passed);
    }
}

