/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearDynamicSystems;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.dataStructures.ComplexNumber;
import us.ihmc.robotics.linearDynamicSystems.ComplexConjugateMode;
import us.ihmc.robotics.linearDynamicSystems.DynamicSystemsTestHelpers;
import us.ihmc.robotics.linearDynamicSystems.TransferFunction;
import us.ihmc.robotics.linearDynamicSystems.TransferFunctionMatrix;

public class ComplexConjugateModeTest {
    @BeforeEach
    public void setUp() throws Exception {
    }

    @AfterEach
    public void tearDown() throws Exception {
    }

    @Test
    public void testSecondOrderMassSpringDamper() {
        double wn = 7.2;
        double zeta = 0.3;
        double P1 = zeta * wn;
        double P2 = Math.sqrt(1.0 - zeta * zeta) * wn;
        double P3 = wn * wn;
        ComplexNumber[] leftEigenvectorV = new ComplexNumber[]{new ComplexNumber(-P2, -P1), new ComplexNumber(0.0, 1.0)};
        ComplexNumber[] rightEigenvectorW = new ComplexNumber[]{new ComplexNumber(-1.0 / (2.0 * P2), 0.0), new ComplexNumber(-P1 / (2.0 * P2), -0.5)};
        ComplexNumber eigenvalue = new ComplexNumber(-P1, P2);
        ComplexConjugateMode complexConjugateMode = new ComplexConjugateMode(eigenvalue, leftEigenvectorV, rightEigenvectorW);
        DynamicSystemsTestHelpers.assertEpsilonEquals(eigenvalue, complexConjugateMode.getEigenvalue(), 1.0E-7);
        TransferFunctionMatrix transferFunctionMatrix = complexConjugateMode.constructTransferFunctionMatrix();
        TransferFunction transferFunction00 = transferFunctionMatrix.get(0, 0);
        TransferFunction transferFunction01 = transferFunctionMatrix.get(0, 1);
        TransferFunction transferFunction10 = transferFunctionMatrix.get(1, 0);
        TransferFunction transferFunction11 = transferFunctionMatrix.get(1, 1);
        TransferFunction expectedTransferFunction10 = new TransferFunction(new double[]{1.0}, new double[]{1.0, 2.0 * zeta * wn, wn * wn});
        Assert.assertTrue(expectedTransferFunction10.epsilonEquals(transferFunction10, 1.0E-7));
    }

    @Test
    public void testCircleGenerator() {
        ComplexNumber[] leftEigenvectorV = new ComplexNumber[]{new ComplexNumber(1.0, 0.0), new ComplexNumber(0.0, -1.0)};
        ComplexNumber[] rightEigenvectorW = new ComplexNumber[]{new ComplexNumber(0.5, 0.0), new ComplexNumber(0.0, 0.5)};
        ComplexNumber eigenvalue = new ComplexNumber(0.0, 1.0);
        ComplexConjugateMode complexConjugateMode = new ComplexConjugateMode(eigenvalue, leftEigenvectorV, rightEigenvectorW);
        DynamicSystemsTestHelpers.assertEpsilonEquals(eigenvalue, complexConjugateMode.getEigenvalue(), 1.0E-7);
        TransferFunctionMatrix transferFunctionMatrix = complexConjugateMode.constructTransferFunctionMatrix();
        TransferFunction transferFunction00 = transferFunctionMatrix.get(0, 0);
        TransferFunction transferFunction01 = transferFunctionMatrix.get(0, 1);
        TransferFunction transferFunction10 = transferFunctionMatrix.get(1, 0);
        TransferFunction transferFunction11 = transferFunctionMatrix.get(1, 1);
        TransferFunction expectedTransferFunction01 = new TransferFunction(new double[]{-1.0}, new double[]{1.0, 0.0, 1.0});
        Assert.assertTrue(expectedTransferFunction01.epsilonEquals(transferFunction01, 1.0E-7));
    }
}

