/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra.commonOps;

import java.util.Random;
import org.apache.commons.math3.util.Precision;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.RandomMatrices_DDRM;
import org.ejml.dense.row.linsol.qr.LinearSolverQrHouseCol_DDRM;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.Conversions;
import us.ihmc.matrixlib.MatrixTestTools;
import us.ihmc.matrixlib.NativeCommonOps;
import us.ihmc.robotics.functionApproximation.DampedLeastSquaresSolver;
import us.ihmc.robotics.linearAlgebra.DampedLeastSquaresNullspaceCalculator;

public class NativeCommonOpsBenchmarkTest {
    private static final int maxSize = 80;
    private static final int warmumIterations = 2000;
    private static final int iterations = 5000;
    private static final double epsilon = 1.0E-8;

    @Test
    public void testSolveLeastSquare() {
        int i;
        Random random = new Random(40L);
        System.out.println("Testing solving least square problem with random matrices...");
        long nativeDampedTime = 0L;
        long nativeUndampedTime = 0L;
        long ejmlDampedTime = 0L;
        long ejmlUndampedTime = 0L;
        double matrixSizes = 0.0;
        double alpha = 0.01;
        int localMaxSize = 106;
        DampedLeastSquaresSolver dampedSolver = new DampedLeastSquaresSolver(localMaxSize, alpha);
        LinearSolverQrHouseCol_DDRM undampedSolver = new LinearSolverQrHouseCol_DDRM();
        for (i = 0; i < 2000; ++i) {
            DMatrixRMaj A = RandomMatrices_DDRM.rectangle((int)80, (int)80, (Random)random);
            DMatrixRMaj x = RandomMatrices_DDRM.rectangle((int)80, (int)1, (Random)random);
            DMatrixRMaj b = new DMatrixRMaj(80, 1);
            CommonOps_DDRM.mult((DMatrix1Row)A, (DMatrix1Row)x, (DMatrix1Row)b);
            dampedSolver.setA((Matrix)A);
            dampedSolver.solve((Matrix)b, (Matrix)x);
            undampedSolver.setA((Matrix)A);
            undampedSolver.solve((Matrix)b, (Matrix)x);
            NativeCommonOps.solveDamped((DMatrix1Row)A, (DMatrix1Row)b, (double)alpha, (DMatrix1Row)x);
            NativeCommonOps.solveRobust((DMatrix1Row)A, (DMatrix1Row)b, (DMatrix1Row)x);
        }
        for (i = 0; i < 5000; ++i) {
            int aRows = random.nextInt(localMaxSize) + 2;
            int aCols = random.nextInt(aRows - 1) + 1;
            matrixSizes += (double)(aRows + aCols) / 2.0;
            DMatrixRMaj A = RandomMatrices_DDRM.rectangle((int)aRows, (int)aCols, (Random)random);
            DMatrixRMaj x = RandomMatrices_DDRM.rectangle((int)aCols, (int)1, (Random)random);
            DMatrixRMaj b = new DMatrixRMaj(aRows, 1);
            CommonOps_DDRM.mult((DMatrix1Row)A, (DMatrix1Row)x, (DMatrix1Row)b);
            DMatrixRMaj nativeDampedResult = new DMatrixRMaj(aCols, 1);
            DMatrixRMaj nativeUndampedResult = new DMatrixRMaj(aCols, 1);
            DMatrixRMaj ejmlDampedResult = new DMatrixRMaj(aCols, 1);
            DMatrixRMaj ejmlUndampedResult = new DMatrixRMaj(aCols, 1);
            nativeDampedTime -= System.nanoTime();
            NativeCommonOps.solveDamped((DMatrix1Row)A, (DMatrix1Row)b, (double)alpha, (DMatrix1Row)nativeDampedResult);
            nativeDampedTime += System.nanoTime();
            nativeUndampedTime -= System.nanoTime();
            NativeCommonOps.solveRobust((DMatrix1Row)A, (DMatrix1Row)b, (DMatrix1Row)nativeUndampedResult);
            nativeUndampedTime += System.nanoTime();
            ejmlDampedTime -= System.nanoTime();
            dampedSolver.setA((Matrix)A);
            dampedSolver.solve((Matrix)b, (Matrix)ejmlDampedResult);
            ejmlDampedTime += System.nanoTime();
            ejmlUndampedTime -= System.nanoTime();
            undampedSolver.setA((Matrix)A);
            undampedSolver.solve((Matrix)b, (Matrix)ejmlUndampedResult);
            ejmlUndampedTime += System.nanoTime();
            MatrixTestTools.assertMatrixEquals((DMatrix)ejmlDampedResult, (DMatrix)nativeDampedResult, (double)1.0E-8);
            MatrixTestTools.assertMatrixEquals((DMatrix)x, (DMatrix)nativeUndampedResult, (double)1.0E-8);
            MatrixTestTools.assertMatrixEquals((DMatrix)x, (DMatrix)ejmlUndampedResult, (double)1.0E-8);
        }
        System.out.println("Native damped took " + Precision.round((double)Conversions.nanosecondsToMilliseconds((double)(nativeDampedTime / 5000L)), (int)3) + " ms on average");
        System.out.println("Native undamped took " + Precision.round((double)Conversions.nanosecondsToMilliseconds((double)(nativeUndampedTime / 5000L)), (int)3) + " ms on average");
        System.out.println("EJML damped took " + Precision.round((double)Conversions.nanosecondsToMilliseconds((double)(ejmlDampedTime / 5000L)), (int)3) + " ms on average");
        System.out.println("EJML undamped took " + Precision.round((double)Conversions.nanosecondsToMilliseconds((double)(ejmlUndampedTime / 5000L)), (int)3) + " ms on average");
        System.out.println("Average matrix size was " + Precision.round((double)(matrixSizes / 5000.0), (int)1));
        System.out.println("Native damped takes " + Precision.round((double)(100.0 * (double)nativeDampedTime / (double)ejmlDampedTime), (int)0) + "% of EJML time.");
        System.out.println("Native undamped takes " + Precision.round((double)(100.0 * (double)nativeUndampedTime / (double)ejmlUndampedTime), (int)0) + "% of EJML time.\n");
    }

    @Test
    public void testNullspaceProjection() {
        int i;
        Random random = new Random(40L);
        System.out.println("Testing nullspace projection with random matrices...");
        long nativeTime = 0L;
        long ejmlTime = 0L;
        double matrixSizes = 0.0;
        double alpha = 0.05;
        DampedLeastSquaresNullspaceCalculator calculator = new DampedLeastSquaresNullspaceCalculator(80, alpha);
        for (i = 0; i < 2000; ++i) {
            DMatrixRMaj A = RandomMatrices_DDRM.rectangle((int)80, (int)80, (Random)random);
            DMatrixRMaj B = RandomMatrices_DDRM.rectangle((int)80, (int)80, (Random)random);
            DMatrixRMaj C = new DMatrixRMaj(80, 80);
            calculator.projectOntoNullspace(A, B, C);
            NativeCommonOps.projectOnNullspace((DMatrix1Row)A, (DMatrix1Row)B, (DMatrix1Row)C, (double)alpha);
        }
        for (i = 0; i < 5000; ++i) {
            int aRows = random.nextInt(80) + 1;
            int bRows = random.nextInt(80) + 1;
            int bCols = random.nextInt(80) + 1;
            matrixSizes += (double)(aRows + bRows + bCols) / 3.0;
            DMatrixRMaj A = RandomMatrices_DDRM.rectangle((int)aRows, (int)bCols, (Random)random);
            DMatrixRMaj B = RandomMatrices_DDRM.rectangle((int)bRows, (int)bCols, (Random)random);
            DMatrixRMaj actual = new DMatrixRMaj(aRows, bCols);
            DMatrixRMaj expected = new DMatrixRMaj(aRows, bCols);
            nativeTime -= System.nanoTime();
            NativeCommonOps.projectOnNullspace((DMatrix1Row)A, (DMatrix1Row)B, (DMatrix1Row)actual, (double)alpha);
            nativeTime += System.nanoTime();
            ejmlTime -= System.nanoTime();
            calculator.projectOntoNullspace(A, B, expected);
            ejmlTime += System.nanoTime();
            MatrixTestTools.assertMatrixEquals((DMatrix)expected, (DMatrix)actual, (double)1.0E-8);
        }
        System.out.println("Native took " + Precision.round((double)Conversions.nanosecondsToMilliseconds((double)(nativeTime / 5000L)), (int)3) + " ms on average");
        System.out.println("EJML took " + Precision.round((double)Conversions.nanosecondsToMilliseconds((double)(ejmlTime / 5000L)), (int)3) + " ms on average");
        System.out.println("Average matrix size was " + Precision.round((double)(matrixSizes / 5000.0), (int)1));
        System.out.println("Native takes " + Precision.round((double)(100.0 * (double)nativeTime / (double)ejmlTime), (int)0) + "% of EJML time.\n");
    }

    public static void main(String[] args) {
        int size = 500;
        Random random = new Random(40L);
        DMatrixRMaj A = RandomMatrices_DDRM.rectangle((int)size, (int)size, (Random)random);
        DMatrixRMaj B = RandomMatrices_DDRM.rectangle((int)size, (int)size, (Random)random);
        DMatrixRMaj AtBA = new DMatrixRMaj(size, size);
        System.out.println("Running...");
        while (true) {
            NativeCommonOps.multQuad((DMatrix1Row)A, (DMatrix1Row)B, (DMatrix1Row)AtBA);
        }
    }
}

