/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra.careSolvers;

import java.util.Random;
import org.ejml.EjmlUnitTests;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.linearAlgebra.careSolvers.CARETools;

public class CAREToolsTest {
    private static final int iters = 1000;
    private static final double epsilon = 1.0E-7;

    @Test
    public void testCalculatingS() {
        Random random = new Random(1738L);
        for (int iter = 0; iter < 1000; ++iter) {
            int rows = RandomNumbers.nextInt((Random)random, (int)1, (int)20);
            int cols = RandomNumbers.nextInt((Random)random, (int)1, (int)20);
            DMatrixRMaj B = new DMatrixRMaj(rows, cols);
            DMatrixRMaj R = new DMatrixRMaj(cols, cols);
            DMatrixRMaj Rinv = new DMatrixRMaj(cols, cols);
            DMatrixRMaj RinvExpected = new DMatrixRMaj(cols, cols);
            R.zero();
            for (int i = 0; i < cols; ++i) {
                double value = RandomNumbers.nextDouble((Random)random, (double)0.01, (double)5.0);
                R.set(i, i, value);
                RinvExpected.set(i, i, 1.0 / value);
            }
            B.setData(RandomNumbers.nextDoubleArray((Random)random, (int)(rows * cols), (double)10.0));
            DMatrixRMaj BTranspose = new DMatrixRMaj(B);
            CommonOps_DDRM.transpose((DMatrixRMaj)BTranspose);
            DMatrixRMaj S = new DMatrixRMaj(rows, rows);
            CARETools.computeM((DMatrixRMaj)BTranspose, (DMatrixRMaj)R, (DMatrixRMaj)Rinv, (DMatrixRMaj)S);
            DMatrixRMaj RinvBTranspose = new DMatrixRMaj(cols, rows);
            CommonOps_DDRM.multTransB((DMatrix1Row)Rinv, (DMatrix1Row)B, (DMatrix1Row)RinvBTranspose);
            DMatrixRMaj Sexpected = new DMatrixRMaj(rows, rows);
            CommonOps_DDRM.mult((DMatrix1Row)B, (DMatrix1Row)RinvBTranspose, (DMatrix1Row)Sexpected);
            EjmlUnitTests.assertEquals((DMatrix)RinvExpected, (DMatrix)Rinv, (double)1.0E-7);
            EjmlUnitTests.assertEquals((DMatrix)Sexpected, (DMatrix)S, (double)1.0E-7);
        }
    }

    @Test
    public void testAssemblingHamiltonian() {
        Random random = new Random(1738L);
        for (int iter = 0; iter < 1000; ++iter) {
            int n = RandomNumbers.nextInt((Random)random, (int)1, (int)20);
            DMatrixRMaj A = new DMatrixRMaj(n, n);
            DMatrixRMaj ATranspose = new DMatrixRMaj(n, n);
            DMatrixRMaj S = new DMatrixRMaj(n, n);
            DMatrixRMaj Q = new DMatrixRMaj(n, n);
            DMatrixRMaj H = new DMatrixRMaj(2 * n, 2 * n);
            DMatrixRMaj HExpected = new DMatrixRMaj(2 * n, 2 * n);
            A.setData(RandomNumbers.nextDoubleArray((Random)random, (int)(n * n), (double)10.0));
            S.setData(RandomNumbers.nextDoubleArray((Random)random, (int)(n * n), (double)10.0));
            for (int i = 0; i < n; ++i) {
                double value = RandomNumbers.nextDouble((Random)random, (double)0.01, (double)5.0);
                Q.set(i, i, value);
            }
            CommonOps_DDRM.transpose((DMatrixRMaj)A, (DMatrixRMaj)ATranspose);
            CARETools.assembleHamiltonian((DMatrixRMaj)A, (DMatrixRMaj)ATranspose, (DMatrixRMaj)Q, (DMatrixRMaj)S, (DMatrixRMaj)H);
            MatrixTools.setMatrixBlock((DMatrix)HExpected, (int)0, (int)0, (DMatrix)A, (int)0, (int)0, (int)n, (int)n, (double)1.0);
            MatrixTools.setMatrixBlock((DMatrix)HExpected, (int)0, (int)n, (DMatrix)S, (int)0, (int)0, (int)n, (int)n, (double)-1.0);
            MatrixTools.setMatrixBlock((DMatrix)HExpected, (int)n, (int)0, (DMatrix)Q, (int)0, (int)0, (int)n, (int)n, (double)-1.0);
            MatrixTools.setMatrixBlock((DMatrix)HExpected, (int)n, (int)n, (DMatrix)ATranspose, (int)0, (int)0, (int)n, (int)n, (double)-1.0);
            EjmlUnitTests.assertEquals((DMatrix)HExpected, (DMatrix)H, (double)1.0E-7);
        }
    }
}

