/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra.careSolvers;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.matrixlib.MatrixTools;

public class CARESolverTestTools {
    public static DMatrixRMaj generateRandomSymmetricPDMatrix(Random random, int size) {
        DMatrixRMaj matrix = CARESolverTestTools.generateRandomSymmetricMatrix(random, size);
        MatrixTools.addDiagonal((DMatrix)matrix, (double)size);
        return matrix;
    }

    public static DMatrixRMaj generateRandomSymmetricMatrix(Random random, int size) {
        DMatrixRMaj a = new DMatrixRMaj(size, size);
        double[] aValues = RandomNumbers.nextDoubleArray((Random)random, (int)(size * size), (double)1.0);
        a.setData(aValues);
        DMatrixRMaj matrix = new DMatrixRMaj(size, size);
        CommonOps_DDRM.transpose((DMatrixRMaj)a, (DMatrixRMaj)matrix);
        CommonOps_DDRM.addEquals((DMatrixD1)matrix, (DMatrixD1)a);
        CommonOps_DDRM.scale((double)0.5, (DMatrixD1)a);
        return matrix;
    }
}

