/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.lidar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;
import us.ihmc.commons.Assertions;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.commons.RunnableThatThrows;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.lidar.LidarScan;
import us.ihmc.robotics.lidar.LidarScanParameters;

public class LidarScanTest {
    @Test
    public void testFlipNew() {
        float[] ranges = new float[720];
        Random random = new Random();
        for (int i = 0; i < 720; ++i) {
            ranges[i] = random.nextFloat();
        }
        float[] flippedRanges = Arrays.copyOf(ranges, 720);
        ArrayUtils.reverse((float[])flippedRanges);
        LidarScan lidarScan = new LidarScan(new LidarScanParameters(), new RigidBodyTransform(), new RigidBodyTransform(), ranges, 2);
        LidarScan flippedScan = new LidarScan(new LidarScanParameters(), new RigidBodyTransform(), new RigidBodyTransform(), flippedRanges, 2);
        LidarScanTest.assertLidarScanEquals(flippedScan, lidarScan.flipNew(), 1.0E-7, 1.0E-7f);
        LidarScanTest.assertLidarScanEquals(lidarScan, lidarScan.flipNew().flipNew(), 1.0E-7, 1.0E-7f);
    }

    @Test
    public void testAssertLidarScanRangesEqual() {
        Random random = new Random();
        float[] ranges1 = RandomNumbers.nextFloatArray((Random)random, (int)720, (float)0.0f, (float)5000.0f);
        float[] ranges2 = RandomNumbers.nextFloatArray((Random)random, (int)720, (float)0.0f, (float)5000.0f);
        final LidarScan lidarScan1 = new LidarScan(new LidarScanParameters(), new RigidBodyTransform(), new RigidBodyTransform(), ranges1, random.nextInt());
        final LidarScan lidarScan2 = new LidarScan(new LidarScanParameters(), new RigidBodyTransform(), new RigidBodyTransform(), ranges2, random.nextInt());
        Assertions.assertExceptionThrown(AssertionFailedError.class, (RunnableThatThrows)new RunnableThatThrows(){

            public void run() throws Throwable {
                LidarScanTest.assertLidarScanRangesEqual(lidarScan1, lidarScan2, 1.0E-7);
            }
        });
        LidarScan lidarScan3 = new LidarScan(new LidarScanParameters(), new RigidBodyTransform(), new RigidBodyTransform(), ranges1, random.nextInt());
        LidarScanTest.assertLidarScanRangesEqual(lidarScan1, lidarScan3, 1.0E-7);
        float[] ranges1Shortened = ArrayUtils.subarray((float[])ranges1, (int)0, (int)3000);
        LidarScan lidarScan4 = new LidarScan(new LidarScanParameters(), new RigidBodyTransform(), new RigidBodyTransform(), ranges1Shortened, random.nextInt());
        LidarScanTest.assertLidarScanRangesEqual(lidarScan1, lidarScan4, 1.0E-7);
    }

    @Test
    public void testAssertLidarScanTransformsEqual() {
        Random random = new Random();
        float[] ranges1 = RandomNumbers.nextFloatArray((Random)random, (int)720, (float)0.0f, (float)5000.0f);
        float[] ranges2 = RandomNumbers.nextFloatArray((Random)random, (int)720, (float)0.0f, (float)5000.0f);
        RigidBodyTransform randomTransform1 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        RigidBodyTransform randomTransform2 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        RigidBodyTransform randomTransform3 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        RigidBodyTransform randomTransform4 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        final LidarScan lidarScan1 = new LidarScan(new LidarScanParameters(), randomTransform1, randomTransform2, ranges1);
        LidarScan lidarScan2 = new LidarScan(new LidarScanParameters(), randomTransform1, randomTransform2, ranges2);
        LidarScanTest.assertLidarScanTransformsEqual(lidarScan1, lidarScan2, 1.0E-7);
        final LidarScan lidarScan3 = new LidarScan(new LidarScanParameters(), randomTransform3, randomTransform4, ranges2);
        Assertions.assertExceptionThrown(AssertionError.class, (RunnableThatThrows)new RunnableThatThrows(){

            public void run() throws Throwable {
                LidarScanTest.assertLidarScanTransformsEqual(lidarScan1, lidarScan3, 1.0E-7);
            }
        });
    }

    @Test
    public void testAssertLidarScanEquals() {
        Random random = new Random();
        float[] ranges1 = RandomNumbers.nextFloatArray((Random)random, (int)720, (float)0.0f, (float)5000.0f);
        float[] ranges1Shortened = ArrayUtils.subarray((float[])ranges1, (int)0, (int)3000);
        RigidBodyTransform randomTransform1 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        RigidBodyTransform randomTransform2 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        LidarScan lidarScan1 = new LidarScan(new LidarScanParameters(), randomTransform1, randomTransform2, ranges1);
        LidarScan lidarScan2 = new LidarScan(new LidarScanParameters(), randomTransform1, randomTransform2, ranges1Shortened);
        LidarScanTest.assertLidarScanEquals(lidarScan1, lidarScan2, 1.0E-7, 1.0E-7f);
    }

    public static void assertLidarScanRangesEqual(LidarScan lidarScan1, LidarScan lidarScan2, double rangeTolerance) {
        for (int i = 0; i < lidarScan1.size() && i < lidarScan2.size(); ++i) {
            double value = lidarScan1.getRange(i);
            double value1 = lidarScan2.getRange(i);
            if (!(value > 0.0) || !(value < Double.POSITIVE_INFINITY) || !(value1 > 0.0) || !(value1 < Double.POSITIVE_INFINITY)) continue;
            Assert.assertEquals(LidarScanTest.class.getSimpleName() + ": lidar scans differ: ", (double)lidarScan1.getRange(i), (double)lidarScan2.getRange(i), rangeTolerance);
        }
    }

    public static void assertLidarScanTransformsEqual(LidarScan lidarScan1, LidarScan lidarScan2, double transformTolerance) {
        EuclidCoreTestTools.assertEquals((EuclidGeometry)lidarScan1.getStartTransform(), (EuclidGeometry)lidarScan2.getStartTransform(), (double)transformTolerance);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)lidarScan1.getEndTransform(), (EuclidGeometry)lidarScan2.getEndTransform(), (double)transformTolerance);
    }

    public static void assertLidarScanEquals(LidarScan lidarScan1, LidarScan lidarScan2, double transformTolerance, float rangeTolerance) {
        LidarScanTest.assertLidarScanTransformsEqual(lidarScan1, lidarScan2, transformTolerance);
        LidarScanTest.assertLidarScanRangesEqual(lidarScan1, lidarScan2, rangeTolerance);
    }

    @Test
    public void testConstructor() {
        Random random = new Random();
        LidarScan lidarScan1 = null;
        for (int i = 0; i < 1000; ++i) {
            float[] ranges1 = RandomNumbers.nextFloatArray((Random)random, (int)720, (float)0.0f, (float)5000.0f);
            RigidBodyTransform randomTransform1 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform randomTransform2 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            lidarScan1 = new LidarScan(new LidarScanParameters(), randomTransform1, randomTransform2, ranges1);
        }
        Assert.assertEquals(lidarScan1.size(), 720.0f, 1.0E-7f);
    }

    @Test
    public void testConstructor2() {
        Random random = new Random();
        LidarScan lidarScan1 = null;
        for (int i = 0; i < 1000; ++i) {
            int id = random.nextInt();
            float[] ranges1 = RandomNumbers.nextFloatArray((Random)random, (int)720, (float)0.0f, (float)5000.0f);
            lidarScan1 = new LidarScan(new LidarScanParameters(), ranges1, id);
            Assert.assertEquals(lidarScan1.size(), 720.0f, 1.0E-7f);
            Assert.assertEquals(lidarScan1.getSensorId(), id);
        }
    }

    @Test
    public void testGetRanges() {
        Random random = new Random();
        LidarScan lidarScan1 = null;
        for (int i = 0; i < 1000; ++i) {
            int id = random.nextInt();
            float[] ranges1 = RandomNumbers.nextFloatArray((Random)random, (int)720, (float)0.0f, (float)5000.0f);
            lidarScan1 = new LidarScan(new LidarScanParameters(), ranges1, id);
            Assert.assertEquals(lidarScan1.getRanges().length, (float)ranges1.length, 1.0E-7f);
            for (int j = 0; j < ranges1.length; ++j) {
                Assert.assertEquals(lidarScan1.getRanges()[j], ranges1[j], 1.0E-7f);
            }
        }
    }

    @Test
    public void testGetCopy() {
        Random random = new Random();
        LidarScan lidarScan1 = null;
        for (int i = 0; i < 1000; ++i) {
            int id = random.nextInt();
            float[] ranges1 = RandomNumbers.nextFloatArray((Random)random, (int)720, (float)0.0f, (float)5000.0f);
            lidarScan1 = new LidarScan(new LidarScanParameters(), ranges1, id);
            LidarScan lidarScanCopy = lidarScan1.getCopy();
            for (int j = 0; j < ranges1.length; ++j) {
                Assert.assertEquals(lidarScan1.getRanges()[j], lidarScanCopy.getRanges()[j], 1.0E-7f);
            }
        }
    }

    @Test
    public void testScanParameters() {
        Random random = new Random();
        LidarScan lidarScan1 = null;
        for (int i = 0; i < 1000; ++i) {
            int id = random.nextInt();
            float[] ranges1 = RandomNumbers.nextFloatArray((Random)random, (int)720, (float)0.0f, (float)5000.0f);
            int pointsPerSweep = random.nextInt();
            int fov = (int)((double)random.nextFloat() * Math.PI);
            double minRange = random.nextDouble();
            double maxRange = random.nextDouble();
            LidarScanParameters lidarScanParameters = new LidarScanParameters(pointsPerSweep, (double)fov, minRange, maxRange);
            lidarScan1 = new LidarScan(lidarScanParameters, ranges1, id);
            LidarScan lidarScanCopy = lidarScan1.getCopy();
            for (int j = 0; j < ranges1.length; ++j) {
                Assert.assertEquals(lidarScan1.getRanges()[j], lidarScanCopy.getRanges()[j], 1.0E-7f);
                Assert.assertEquals((double)lidarScan1.getScanParameters().getMaxRange(), maxRange, 1.0E-7);
                Assert.assertEquals((double)lidarScan1.getScanParameters().getMinRange(), minRange, 1.0E-7);
                Assert.assertEquals((double)lidarScan1.getScanParameters().getPointsPerSweep(), (double)pointsPerSweep, 1.0E-7);
                Assert.assertEquals((double)lidarScan1.getScanParameters().getFieldOfView(), (double)fov, 1.0E-7);
                Assert.assertEquals((double)lidarScan1.getScanParameters().getSweepYawMin(), (double)(-fov) / 2.0, 1.0E-7);
                Assert.assertEquals((double)lidarScan1.getScanParameters().getSweepYawMax(), (double)fov / 2.0, 1.0E-7);
                Assert.assertEquals((double)lidarScan1.getScanParameters().getTimeIncrement(), 0.0, 1.0E-7);
                Assert.assertEquals((double)lidarScan1.getScanParameters().getScanTime(), 0.0, 1.0E-7);
                Assert.assertEquals((double)lidarScan1.getScanParameters().getScanTimeNanos(), 0.0, 1.0E-7);
                Assert.assertEquals((double)lidarScan1.getScanParameters().getTimestamp(), 0.0, 1.0E-7);
            }
        }
    }

    @Test
    public void testGetAllPoints() {
        Random random = new Random();
        LidarScan lidarScan1 = null;
        for (int i = 0; i < 10; ++i) {
            int id = random.nextInt();
            float[] ranges1 = RandomNumbers.nextFloatArray((Random)random, (int)100, (float)0.0f, (float)5000.0f);
            int pointsPerSweep = 1080;
            int fov = (int)((double)random.nextFloat() * Math.PI);
            double minRange = random.nextDouble();
            double maxRange = random.nextDouble();
            LidarScanParameters lidarScanParameters = new LidarScanParameters(pointsPerSweep, (double)fov, minRange, maxRange);
            lidarScan1 = new LidarScan(lidarScanParameters, new RigidBodyTransform(), new RigidBodyTransform(), ranges1, id);
            ArrayList list = lidarScan1.getAllPoints();
            Assert.assertEquals((double)list.size(), 100.0, 1.0E-7);
            Assert.assertEquals((double)lidarScan1.getAllPoints3f().size(), 100.0, 1.0E-7);
            for (int j = 0; j < list.size(); ++j) {
                Assert.assertEquals(((Point3D)list.get(j)).getX(), ((Point3D32)lidarScan1.getAllPoints3f().get(j)).getX(), 0.001);
                Assert.assertEquals(((Point3D)list.get(j)).getY(), ((Point3D32)lidarScan1.getAllPoints3f().get(j)).getY(), 0.001);
                Assert.assertEquals(((Point3D)list.get(j)).getZ(), ((Point3D32)lidarScan1.getAllPoints3f().get(j)).getZ(), 0.001);
            }
        }
    }
}

