/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.kinematics;

import java.util.List;
import java.util.Random;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.kinematics.DdoglegInverseKinematicsCalculator;
import us.ihmc.robotics.random.RandomGeometry;
import us.ihmc.robotics.screwTheory.GeometricJacobian;

public class DdoglegInverseKinematicsCalculatorTest {
    private static final Vector3D X = new Vector3D(1.0, 0.0, 0.0);
    private static final Vector3D Y = new Vector3D(0.0, 1.0, 0.0);
    private static final Vector3D Z = new Vector3D(0.0, 0.0, 1.0);

    @Test
    public void testInfeasible() {
        Random random = new Random(1235125L);
        Vector3D[] jointAxes = new Vector3D[]{X, Y, Z, Y, Y, X};
        MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain randomFloatingChain = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(random, jointAxes);
        GeometricJacobian jacobian = new GeometricJacobian(randomFloatingChain.getRootJoint().getSuccessor(), randomFloatingChain.getLeafBody(), (ReferenceFrame)randomFloatingChain.getLeafBody().getBodyFixedFrame());
        DdoglegInverseKinematicsCalculator calculator = new DdoglegInverseKinematicsCalculator(jacobian, 1.0, 1.0, 2000, true, 1.0E-12, 0.01, 0.1, 0.1);
        List revoluteJoints = randomFloatingChain.getRevoluteJoints();
        int nTests = 100;
        SummaryStatistics iterationStatistics = new SummaryStatistics();
        SummaryStatistics timeStatistics = new SummaryStatistics();
        for (int i = 0; i < nTests; ++i) {
            this.setRandomPositions(random, revoluteJoints, Math.PI);
            AxisAngle axisAngle = RandomGeometry.nextAxisAngle((Random)random);
            RotationMatrix rotation = new RotationMatrix();
            rotation.set((Orientation3DReadOnly)axisAngle);
            Vector3D translation = RandomGeometry.nextVector3D((Random)random, (double)50.0);
            RigidBodyTransform desiredTransform = new RigidBodyTransform((Orientation3DReadOnly)rotation, (Tuple3DReadOnly)translation);
            long t0 = System.nanoTime();
            calculator.solve((RigidBodyTransformReadOnly)desiredTransform);
            long tf = System.nanoTime();
            long solutionTime = tf - t0;
            if (i <= 500) continue;
            timeStatistics.addValue(Conversions.nanosecondsToSeconds((long)solutionTime));
            iterationStatistics.addValue((double)calculator.getNumberOfIterations());
        }
        this.printStatistics(iterationStatistics, timeStatistics);
    }

    @Test
    public void testForwardThenInverse() {
        Random random = new Random(125125L);
        Vector3D[] jointAxes = new Vector3D[]{X, Y, Z, Y, Y, X};
        MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain randomFloatingChain = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(random, jointAxes);
        GeometricJacobian jacobian = new GeometricJacobian(randomFloatingChain.getRootJoint().getSuccessor(), randomFloatingChain.getLeafBody(), (ReferenceFrame)randomFloatingChain.getLeafBody().getBodyFixedFrame());
        DdoglegInverseKinematicsCalculator calculator = new DdoglegInverseKinematicsCalculator(jacobian, 1.0, 1.0, 2000, true, 1.0E-12, 0.01, 0.1, 0.0);
        List revoluteJoints = randomFloatingChain.getRevoluteJoints();
        int nTests = 100;
        SummaryStatistics iterationStatistics = new SummaryStatistics();
        SummaryStatistics timeStatistics = new SummaryStatistics();
        for (int i = 0; i < nTests; ++i) {
            this.setRandomPositions(random, revoluteJoints, Math.PI);
            jacobian.compute();
            double det = jacobian.det();
            RigidBodyTransform desiredTransform = jacobian.getEndEffectorFrame().getTransformToDesiredFrame(jacobian.getBaseFrame());
            this.setRandomPositions(random, revoluteJoints, Math.PI);
            long t0 = System.nanoTime();
            calculator.solve((RigidBodyTransformReadOnly)desiredTransform);
            long tf = System.nanoTime();
            long solutionTime = tf - t0;
            timeStatistics.addValue(Conversions.nanosecondsToSeconds((long)solutionTime));
            iterationStatistics.addValue((double)calculator.getNumberOfIterations());
            RigidBodyTransform solvedTransform = jacobian.getEndEffectorFrame().getTransformToDesiredFrame(jacobian.getBaseFrame());
            boolean equal = solvedTransform.epsilonEquals((EuclidGeometry)desiredTransform, 1.0E-5);
            if (equal) continue;
            System.out.println("Test number " + i + " failed.");
            System.out.println("Initial Jacobian determinant: " + det);
            System.out.println("Current Jacobian determinant: " + jacobian.det());
            System.out.println("Number of iterations: " + calculator.getNumberOfIterations());
            System.out.println("Error: " + calculator.getErrorScalar());
            System.out.print("Joint angles: ");
            for (RevoluteJoint revoluteJoint : revoluteJoints) {
                System.out.print(revoluteJoint.getQ() + ", ");
            }
            System.out.println("\n");
            Assert.fail();
        }
        this.printStatistics(iterationStatistics, timeStatistics);
    }

    private void printStatistics(SummaryStatistics iterationStatistics, SummaryStatistics timeStatistics) {
        System.out.println("max time per solve: " + timeStatistics.getMax() + " [s]");
        System.out.println("avg time per solve: " + timeStatistics.getMean() + " [s]");
        System.out.println("max number of iterations necessary: " + iterationStatistics.getMax());
        System.out.println("avg number of iterations necessary: " + iterationStatistics.getMean());
    }

    private void setRandomPositions(Random random, List<RevoluteJoint> revoluteJoints, double deltaThetaMax) {
        for (RevoluteJoint revoluteJoint : revoluteJoints) {
            revoluteJoint.setQ(revoluteJoint.getQ() + RandomNumbers.nextDouble((Random)random, (double)(-deltaThetaMax), (double)deltaThetaMax));
            revoluteJoint.getFrameAfterJoint().update();
        }
    }
}

