/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.hyperCubeTree;

import java.util.concurrent.locks.LockSupport;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.hyperCubeTree.HyperCubeLeaf;
import us.ihmc.robotics.hyperCubeTree.HyperCubeTree;
import us.ihmc.robotics.hyperCubeTree.LowPassTimingReporter;
import us.ihmc.robotics.hyperCubeTree.OneDimensionalBounds;
import us.ihmc.robotics.hyperCubeTree.RecursableHyperTreeNode;
import us.ihmc.robotics.hyperCubeTree.SimpleLossyDoubleTree;

public class HyperCubeTreeTest {
    public static final double eps = 1.0E-13;
    private long startTime;
    private long averageTime;
    private double averageSeconds;
    private static final int alpha = 9;
    private static final double DIVISOR = 0.001953125;

    @Test
    public void testPutGetNoSplit() {
        int dimensionality = 3;
        HyperCubeTree<Double, Void> tree = this.setupTree(dimensionality, 1.0);
        double[] point = new double[]{0.25, 0.6, 0.6};
        Double testValue1 = 0.25;
        Double testValue2 = 0.7;
        Assert.assertNull(tree.get(point));
        tree.put(point, (Object)testValue1);
        Assert.assertEquals(testValue1, tree.get(point).getValue());
        Assert.assertEquals(1L, tree.listAllLeafNodes().size());
        point = new double[]{0.25, 0.25, 0.25};
        Assert.assertEquals(testValue1, tree.get(point).getValue());
        point = new double[]{0.25, 0.25, 0.75};
        Assert.assertEquals(testValue1, tree.get(point).getValue());
        point = new double[]{0.25, 0.75, 0.25};
        Assert.assertEquals(testValue1, tree.get(point).getValue());
        point = new double[]{0.75, 0.25, 0.25};
        Assert.assertEquals(testValue1, tree.get(point).getValue());
        point = new double[]{0.25, 0.25, 0.25};
        tree.put(point, (Object)testValue2);
        Assert.assertFalse(tree.getRootNode().hasChildren());
        Assert.assertEquals(1L, tree.listAllLeafNodes().size());
        Assert.assertEquals(testValue2, tree.get(point).getValue());
        point = new double[]{0.25, 0.25, 0.75};
        Assert.assertEquals(testValue2, tree.get(point).getValue());
        point = new double[]{0.25, 0.75, 0.25};
        Assert.assertEquals(testValue2, tree.get(point).getValue());
        point = new double[]{0.75, 0.25, 0.25};
        Assert.assertEquals(testValue2, tree.get(point).getValue());
    }

    private HyperCubeTree<Double, Void> setupTree(int dimensionality, double resolution) {
        OneDimensionalBounds[] bounds = new OneDimensionalBounds[dimensionality];
        for (int i = 0; i < dimensionality; ++i) {
            bounds[i] = new OneDimensionalBounds(Double.valueOf(0.0), Double.valueOf(1.0));
        }
        SimpleLossyDoubleTree tree = new SimpleLossyDoubleTree(bounds, resolution, 0.001);
        return tree;
    }

    @Test
    public void testPutGetRemove2D() {
        int dimensionality = 2;
        HyperCubeTree<Double, Void> tree = this.setupTree(dimensionality, 0.5);
        double low = 0.25;
        double high = 0.75;
        double[] point = new double[]{low, high};
        Double testValue1 = 0.1;
        Double testValue2 = 0.6;
        Assert.assertNull(tree.get(point));
        tree.put(point, (Object)testValue1);
        Assert.assertEquals(testValue1, tree.get(point).getValue());
        HyperCubeTreeTest.testQuadNodeFourPointsAreTheSame(tree, low, high, testValue1);
        point = new double[]{high, high};
        tree.put(point, (Object)testValue2);
        Assert.assertEquals(4L, tree.listAllLeafNodes().size());
        HyperCubeLeaf leafToRemove = tree.get(point);
        point = new double[]{low, low};
        Assert.assertNull(tree.get(point));
        point = new double[]{low, high};
        Assert.assertEquals(testValue1, tree.get(point).getValue());
        point = new double[]{high, low};
        Assert.assertNull(tree.get(point));
        point = new double[]{high, high};
        Assert.assertEquals(testValue2, tree.get(point).getValue());
        tree.remove(leafToRemove);
        Assert.assertEquals(1L, tree.listAllLeafNodes().size());
        HyperCubeTreeTest.testQuadNodeFourPointsAreTheSame(tree, low, high, testValue1);
    }

    private static void testQuadNodeFourPointsAreTheSame(HyperCubeTree<Double, Void> tree, double low, double high, Double testValue1) {
        double[] point = new double[]{low, low};
        Assert.assertEquals(testValue1, tree.get(point).getValue());
        point = new double[]{low, high};
        Assert.assertEquals(testValue1, tree.get(point).getValue());
        point = new double[]{high, low};
        Assert.assertEquals(testValue1, tree.get(point).getValue());
        point = new double[]{high, high};
        Assert.assertEquals(testValue1, tree.get(point).getValue());
    }

    @Test
    public void testPutGetWithSplit2() {
        int dimensionality = 2;
        HyperCubeTree<Double, Void> tree = this.setupTree(dimensionality, 0.5);
        double low = 0.25;
        double high = 0.75;
        double[] point = new double[]{low, high};
        Double testValue1 = 0.1;
        Double testValue2 = 0.6;
        Assert.assertNull(tree.get(point));
        tree.put(point, (Object)testValue1);
        Assert.assertEquals(testValue1, tree.get(point).getValue());
        Assert.assertEquals(1L, tree.listAllLeafNodes().size());
        point = new double[]{low, low};
        Assert.assertEquals(testValue1, tree.get(point).getValue());
        point = new double[]{low, low};
        Assert.assertEquals(testValue1, tree.get(point).getValue());
        point = new double[]{low, high};
        Assert.assertEquals(testValue1, tree.get(point).getValue());
        point = new double[]{high, low};
        Assert.assertEquals(testValue1, tree.get(point).getValue());
        point = new double[]{high, high};
        Assert.assertEquals(testValue1, tree.get(point).getValue());
        tree.put(point, (Object)testValue2);
        Assert.assertEquals(4L, tree.listAllLeafNodes().size());
        point = new double[]{low, low};
        Assert.assertNull(tree.get(point));
        point = new double[]{low, high};
        Assert.assertEquals(testValue1, tree.get(point).getValue());
        point = new double[]{high, low};
        Assert.assertNull(tree.get(point));
        point = new double[]{high, high};
        Assert.assertEquals(testValue2, tree.get(point).getValue());
    }

    @Test
    public void testPutGetWithSplit3() {
        int dimensionality = 3;
        HyperCubeTree<Double, Void> tree = this.setupTree(dimensionality, 0.5);
        double low = 0.25;
        double high = 0.75;
        double[] point = new double[]{low, high, high};
        Double testValue1 = 0.1;
        Double testValue2 = 0.6;
        Assert.assertNull(tree.get(point));
        tree.put(point, (Object)testValue1);
        Assert.assertEquals(testValue1, tree.get(point).getValue());
        point = new double[]{low, low, low};
        Assert.assertEquals(testValue1, tree.get(point).getValue());
        point = new double[]{low, low, high};
        Assert.assertEquals(testValue1, tree.get(point).getValue());
        point = new double[]{low, high, low};
        Assert.assertEquals(testValue1, tree.get(point).getValue());
        point = new double[]{high, low, low};
        Assert.assertEquals(testValue1, tree.get(point).getValue());
        tree.put(point, (Object)testValue2);
        Assert.assertEquals(8L, tree.listAllLeafNodes().size());
        point = new double[]{low, low, low};
        Assert.assertNull(tree.get(point));
        point = new double[]{low, low, high};
        Assert.assertNull(tree.get(point));
        point = new double[]{high, low, low};
        Assert.assertEquals(testValue2, tree.get(point).getValue());
        point = new double[]{low, high, high};
        Assert.assertEquals(testValue1, tree.get(point).getValue());
    }

    @Test
    public void testLocationSpecificRecursions() {
        int dimensionality = 3;
        HyperCubeTree<Double, Void> tree = this.setupTree(dimensionality, 0.25);
        RecursableHyperTreeNode node = tree.getRootNode();
        tree.put(new double[]{0.25, 0.25, 0.25}, (Object)1.6);
        Assert.assertEquals(1.6, (Double)node.getLeaf().getValue(), 1.0E-13);
    }

    @Test
    public void testSimplePutting() {
        int dimensionality = 3;
        HyperCubeTree<Double, Void> tree = this.setupTree(dimensionality, 0.25);
        RecursableHyperTreeNode node = tree.getRootNode();
        node.setLeaf(new HyperCubeLeaf((Object)1.6, new double[]{0.25, 0.25, 0.25}));
        Assert.assertEquals(1.6, (Double)node.getLeaf().getValue(), 1.0E-13);
    }

    @Test
    public void testGatherAllLeaves() {
        int dimensionality = 2;
        HyperCubeTree<Double, Void> tree = this.setupTree(dimensionality, 0.25);
        OneDimensionalBounds[] gatherBounds = new OneDimensionalBounds[dimensionality];
        for (int i = 0; i < dimensionality; ++i) {
            gatherBounds[i] = new OneDimensionalBounds(Double.valueOf(0.2), Double.valueOf(0.45));
        }
        double[] xVals = new double[]{0.0, 0.1, 0.4, 0.4, 0.4, 0.9, 1.0};
        double[] yVals = new double[]{0.0, 0.1, 0.4, 0.0, 0.4, 0.9, 0.0};
        double[] zVals = new double[]{0.1, 0.2, 0.3, 0.5, 0.5, 0.5, 0.6};
        for (int i = 0; i < xVals.length; ++i) {
            tree.put(new double[]{xVals[i], yVals[i]}, (Object)zVals[i]);
        }
    }

    @Test
    public void testTimingMeasurement() {
        for (int i = 0; i < 1000; ++i) {
            this.startTime = System.nanoTime();
            LockSupport.parkNanos(1000000L);
            this.averageTime = (this.averageTime >> 9) * 511L + System.nanoTime() - this.startTime;
            this.averageSeconds = (double)this.averageTime * 0.001953125 * 1.0E-9;
        }
        System.out.println("ThreadTools.sleep(1L) takes on average " + this.averageSeconds + " seconds to store a point.");
    }

    @Test
    public void testTimer() {
        LowPassTimingReporter time = new LowPassTimingReporter(7);
        boolean numTimes = true;
        for (int j = 0; j < 30; ++j) {
            time = new LowPassTimingReporter(6);
            for (int i = 0; i < 10000; ++i) {
                time.startTime();
                time.endTime();
            }
            System.out.println(time.generateMessage("the timer itself", "do basically nothing"));
        }
    }

    @Test
    public void testMinimumMeasurableTime() {
        LowPassTimingReporter time = new LowPassTimingReporter(7);
        int numTimes = 1;
        long[] times = new long[numTimes];
        for (int j = 0; j < 50; ++j) {
            time = new LowPassTimingReporter(6);
            for (int i = 0; i < 10000; ++i) {
                time.startTime();
                for (int k = 0; k < numTimes; ++k) {
                    times[k] = System.nanoTime();
                }
                time.endTime();
            }
            for (int k = 1; k < numTimes; ++k) {
                times[k] = times[k] % times[k - 1];
            }
            System.out.println(time.generateMessage("testMinimumMeasurableTime", "record several calls to system.nanoTime(). hash = " + times[times.length - 1]));
        }
    }

    @Test
    public void testSystemTimeNano() {
        int i;
        long[] times = new long[1000];
        long[] deltaTimes = new long[999];
        for (i = 0; i < 1000; ++i) {
            times[i] = System.nanoTime();
        }
        for (i = 0; i < 999; ++i) {
            deltaTimes[i] = times[i + 1] - times[i];
        }
        for (i = 0; i < 1000; ++i) {
        }
        for (i = 0; i < 999; ++i) {
        }
    }
}

