/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry.shapes;

import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.HullFace;
import us.ihmc.robotics.geometry.QuickHull3dWrapper;

public class QuickHull3DWrapperTest {
    @Test
    public void testSimplexHull() {
        ArrayList<Point3D> points = new ArrayList<Point3D>();
        points.add(new Point3D(0.0, 0.0, 0.0));
        points.add(new Point3D(1.0, 0.0, 0.0));
        points.add(new Point3D(0.0, 1.0, 0.0));
        points.add(new Point3D(0.0, 0.0, 1.0));
        QuickHull3dWrapper quickHull = new QuickHull3dWrapper(points);
        Assert.assertTrue(quickHull.getNumVertices() == 4.0);
        Assert.assertTrue(quickHull.getNumFaces() == 4.0);
    }

    @Test
    public void testExtraPointInSimplex() {
        ArrayList<Point3D> points = new ArrayList<Point3D>();
        points.add(new Point3D(0.0, 0.0, 0.0));
        points.add(new Point3D(1.0, 0.0, 0.0));
        points.add(new Point3D(0.0, 1.0, 0.0));
        points.add(new Point3D(0.0, 0.0, 1.0));
        points.add(new Point3D(0.35, 0.35, 0.0));
        QuickHull3dWrapper quickHull = new QuickHull3dWrapper(points);
        Assert.assertTrue(quickHull.getNumVertices() == 4.0);
        Assert.assertTrue(quickHull.getNumFaces() == 4.0);
    }

    @Test
    public void testExtraPointOnSimplex() {
        ArrayList<Point3D> points = new ArrayList<Point3D>();
        points.add(new Point3D(0.0, 0.0, 0.0));
        points.add(new Point3D(1.0, 0.0, 0.0));
        points.add(new Point3D(0.0, 1.0, 0.0));
        points.add(new Point3D(0.0, 0.0, 1.0));
        points.add(new Point3D(0.25, 0.25, 0.5));
        QuickHull3dWrapper quickHull = new QuickHull3dWrapper(points);
        Assert.assertTrue(quickHull.getNumVertices() == 4.0);
        Assert.assertTrue(quickHull.getNumFaces() == 4.0);
    }

    @Test
    public void testFivePointHull() {
        ArrayList<Point3D> points = new ArrayList<Point3D>();
        points.add(new Point3D(0.0, 0.0, 0.0));
        points.add(new Point3D(1.0, 0.0, 0.0));
        points.add(new Point3D(0.0, 1.0, 0.0));
        points.add(new Point3D(0.0, 0.0, 1.0));
        points.add(new Point3D(0.25, 0.25, 1.0));
        QuickHull3dWrapper quickHull = new QuickHull3dWrapper(points);
        Assert.assertTrue(quickHull.getNumVertices() == 5.0);
        Assert.assertTrue(quickHull.getNumFaces() == 6.0);
    }

    @Test
    public void testExtraPointApproximatelyOnSimplex() {
        double testTolerance = 1.0E-15;
        ArrayList<Point3D> points = new ArrayList<Point3D>();
        points.add(new Point3D(0.0, 0.0, 0.0));
        points.add(new Point3D(1.0, 0.0, 0.0));
        points.add(new Point3D(0.0, 1.0, 0.0));
        points.add(new Point3D(0.0, 0.0, 1.0));
        points.add(new Point3D(0.25, 0.25, 0.5 + testTolerance));
        QuickHull3dWrapper quickHull = new QuickHull3dWrapper(points);
        if (testTolerance < quickHull.getDistanceTolerance()) {
            Assert.assertTrue(quickHull.getNumVertices() == 4.0);
            Assert.assertTrue(quickHull.getNumFaces() == 4.0);
        } else {
            Assert.assertTrue(quickHull.getNumVertices() == 5.0);
            Assert.assertTrue(quickHull.getNumFaces() == 6.0);
        }
    }

    @Test
    public void testCubeHull() {
        ArrayList<Point3D> points = new ArrayList<Point3D>();
        points.add(new Point3D(0.0, 0.0, 0.0));
        points.add(new Point3D(0.0, 0.0, 1.0));
        points.add(new Point3D(0.0, 1.0, 0.0));
        points.add(new Point3D(0.0, 1.0, 1.0));
        points.add(new Point3D(1.0, 0.0, 0.0));
        points.add(new Point3D(1.0, 0.0, 1.0));
        points.add(new Point3D(1.0, 1.0, 0.0));
        points.add(new Point3D(1.0, 1.0, 1.0));
        QuickHull3dWrapper quickHull = new QuickHull3dWrapper(points);
        Assert.assertTrue(quickHull.getNumVertices() == 8.0);
        Assert.assertTrue(quickHull.getNumFaces() == 6.0);
        List faces = quickHull.getFaces();
        for (HullFace face : faces) {
            Assert.assertEquals(1.0, face.getArea(), 1.0E-15);
        }
    }

    @Test
    public void testTrapezoidalPrismHull() {
        ArrayList<Point3D> points = new ArrayList<Point3D>();
        points.add(new Point3D(2.0, 2.0, 0.0));
        points.add(new Point3D(-2.0, 2.0, 0.0));
        points.add(new Point3D(-2.0, -2.0, 0.0));
        points.add(new Point3D(2.0, -2.0, 0.0));
        points.add(new Point3D(1.0, 1.0, 1.0));
        points.add(new Point3D(-1.0, 1.0, 1.0));
        points.add(new Point3D(-1.0, -1.0, 1.0));
        points.add(new Point3D(1.0, -1.0, 1.0));
        QuickHull3dWrapper quickHull = new QuickHull3dWrapper(points);
        Assert.assertTrue(quickHull.getNumVertices() == 8.0);
        Assert.assertTrue(quickHull.getNumFaces() == 6.0);
        List faces = quickHull.getFaces();
        Plane3D facePlane = new Plane3D();
        Vector3D planeNormal = new Vector3D();
        for (HullFace face : faces) {
            face.getPlane(facePlane);
            planeNormal.set((Tuple3DReadOnly)facePlane.getNormal());
            if (planeNormal.epsilonEquals((EuclidGeometry)new Vector3D(0.0, 0.0, 1.0), 1.0E-14)) {
                Assert.assertEquals(0.0, face.getSlopeAngle(), 1.0E-14);
                Assert.assertEquals(4.0, face.getArea(), 1.0E-14);
                continue;
            }
            if (planeNormal.epsilonEquals((EuclidGeometry)new Vector3D(0.0, 0.0, -1.0), 1.0E-14)) {
                Assert.assertEquals(Math.PI, face.getSlopeAngle(), 1.0E-14);
                Assert.assertEquals(16.0, face.getArea(), 1.0E-14);
                continue;
            }
            Assert.assertEquals(0.7853981633974483, face.getSlopeAngle(), 1.0E-14);
            Assert.assertEquals(3.0 * Math.sqrt(2.0), face.getArea(), 1.0E-14);
        }
    }

    @Test
    public void testFaceToPolygonTrapezoidalPrismHull() {
        ArrayList<Point3D> points = new ArrayList<Point3D>();
        points.add(new Point3D(2.0, 2.0, 0.0));
        points.add(new Point3D(-2.0, 2.0, 0.0));
        points.add(new Point3D(-2.0, -2.0, 0.0));
        points.add(new Point3D(2.0, -2.0, 0.0));
        points.add(new Point3D(1.0, 1.0, 1.0));
        points.add(new Point3D(-1.0, 1.0, 1.0));
        points.add(new Point3D(-1.0, -1.0, 1.0));
        points.add(new Point3D(1.0, -1.0, 1.0));
        QuickHull3dWrapper quickHull = new QuickHull3dWrapper(points);
        Assert.assertTrue(quickHull.getNumVertices() == 8.0);
        Assert.assertTrue(quickHull.getNumFaces() == 6.0);
        List faces = quickHull.getFaces();
        ArrayList vertices = new ArrayList();
        ConvexPolygon2D currentPolygon = new ConvexPolygon2D();
        Pose3D polygonPose = new Pose3D((Tuple3DReadOnly)new Point3D(), (Orientation3DReadOnly)new Quaternion());
        ((HullFace)faces.get(0)).get2DPolygonAndPose(currentPolygon, polygonPose);
        vertices.addAll(((HullFace)faces.get(0)).getPoints());
        double sideLength = Math.sqrt(2.0) * 2.0;
        double tolerance = 1.0E-10;
        System.out.println(vertices.get(2));
        Assert.assertTrue(((Point3D)vertices.get(0)).epsilonEquals((EuclidGeometry)new Point3D(2.0, -2.0, 0.0), tolerance));
        Assert.assertTrue(((Point3D)vertices.get(1)).epsilonEquals((EuclidGeometry)new Point3D(2.0, 2.0, 0.0), tolerance));
        Assert.assertTrue(((Point3D)vertices.get(2)).epsilonEquals((EuclidGeometry)new Point3D(-2.0, 2.0, 0.0), tolerance));
        Assert.assertTrue(((Point3D)vertices.get(3)).epsilonEquals((EuclidGeometry)new Point3D(-2.0, -2.0, 0.0), tolerance));
        Assert.assertTrue(currentPolygon.getVertex(0).epsilonEquals((EuclidGeometry)new Point2D(-sideLength, 0.0), tolerance));
        Assert.assertTrue(currentPolygon.getVertex(1).epsilonEquals((EuclidGeometry)new Point2D(0.0, sideLength), tolerance));
        Assert.assertTrue(currentPolygon.getVertex(2).epsilonEquals((EuclidGeometry)new Point2D(sideLength, 0.0), tolerance));
        Assert.assertTrue(currentPolygon.getVertex(3).epsilonEquals((EuclidGeometry)new Point2D(0.0, -sideLength), tolerance));
        Assert.assertTrue(polygonPose.getPosition().epsilonEquals((EuclidGeometry)new Point3D(), tolerance));
        Assert.assertEquals(polygonPose.getOrientation().getYaw(), -0.7853981633974483, tolerance);
    }
}

