/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry.shapes;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FrameLine3D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.shapes.FramePlane3d;

public class FramePlane3dTest {
    private static ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static double epsilon = 1.0E-14;

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testIsOnOrAbove() {
        FramePlane3d plane = new FramePlane3d(worldFrame, (Point3DReadOnly)new Point3D(), (Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0));
        FramePoint3D q = new FramePoint3D(worldFrame, 0.0, 0.0, 2.0);
        Assert.assertTrue(plane.isOnOrAbove(q));
        q = new FramePoint3D(worldFrame, 0.0, 0.0, 0.0);
        Assert.assertTrue(plane.isOnOrAbove(q));
        q = new FramePoint3D(worldFrame, 0.0, 0.0, -2.0);
        Assert.assertFalse(plane.isOnOrAbove(q));
    }

    @Test
    public void testIsOnOrBelow() {
        FramePlane3d plane = new FramePlane3d(worldFrame, (Point3DReadOnly)new Point3D(), (Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0));
        FramePoint3D q = new FramePoint3D(worldFrame, 0.0, 0.0, -2.0);
        Assert.assertTrue(plane.isOnOrBelow(q));
        q.set(0.0, 0.0, 1.0);
        Assert.assertFalse(plane.isOnOrBelow(q));
    }

    @Test
    public void testOrthogonalProjection() {
        FramePoint3D point = new FramePoint3D(worldFrame, 1.0, 2.0, -3.0);
        FramePoint3D expectedPoint = new FramePoint3D(worldFrame, 1.0, 2.0, 0.0);
        FramePlane3d plane = new FramePlane3d(worldFrame, (Point3DReadOnly)new Point3D(), (Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0));
        Assert.assertTrue(expectedPoint.epsilonEquals((EuclidFrameGeometry)plane.orthogonalProjectionCopy(point), 1.0E-14));
        point.set(3.0, 3.0, -4.0);
        plane.setPoint(1.0, 1.0, 1.0);
        plane.setNormal(2.0, 0.0, 0.0);
        expectedPoint.set(1.0, 3.0, -4.0);
        Assert.assertTrue(expectedPoint.epsilonEquals((EuclidFrameGeometry)plane.orthogonalProjectionCopy(point), 1.0E-14));
    }

    @Test
    public void testDistance() {
        FramePoint3D point = new FramePoint3D(worldFrame, 1.0, 1.0, 1.0);
        FramePlane3d plane = new FramePlane3d(worldFrame, (Point3DReadOnly)new Point3D(), (Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0));
        Assert.assertEquals(1.0, plane.distance(point), 1.0E-14);
        point.set(0.0, 0.0, 0.0);
        plane.setNormal(1.0, 1.0, 0.0);
        plane.setPoint(1.0, 1.0, 0.0);
        Assert.assertEquals(Math.sqrt(2.0), plane.distance(point), epsilon);
    }

    @Test
    public void testApplyTransform() {
        RigidBodyTransform transformation = new RigidBodyTransform();
        transformation.setRotationYawAndZeroTranslation(2.3);
        FramePlane3d plane = new FramePlane3d(worldFrame, (Point3DReadOnly)new Point3D(), (Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0));
        plane.applyTransform(transformation);
        FrameVector3D expectedNormal = new FrameVector3D(worldFrame, 0.0, 0.0, 1.0);
        FramePoint3D expectedPoint = new FramePoint3D(worldFrame, 0.0, 0.0, 0.0);
        Assert.assertTrue(plane.epsilonEquals(new FramePlane3d(expectedNormal, expectedPoint), epsilon));
        RigidBodyTransform transformation2 = new RigidBodyTransform();
        transformation2.getTranslation().set((Tuple3DReadOnly)new Vector3D(1.0, 2.0, 3.0));
        FramePlane3d plane2 = new FramePlane3d(worldFrame, (Point3DReadOnly)new Point3D(), (Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0));
        plane2.applyTransform(transformation2);
        expectedNormal.set(0.0, 0.0, 1.0);
        expectedPoint.set(1.0, 2.0, 3.0);
        Assert.assertTrue(plane2.epsilonEquals(new FramePlane3d(expectedNormal, expectedPoint), epsilon));
        RigidBodyTransform transformation3 = new RigidBodyTransform();
        transformation3.setRotationPitchAndZeroTranslation(1.5707963267948966);
        transformation3.getTranslation().set((Tuple3DReadOnly)new Vector3D(1.0, 2.0, 3.0));
        FramePlane3d plane3 = new FramePlane3d(worldFrame, (Point3DReadOnly)new Point3D(), (Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0));
        plane3.applyTransform(transformation3);
        expectedNormal.set(1.0, 0.0, 0.0);
        expectedPoint.set(1.0, 2.0, 3.0);
        Assert.assertTrue(plane3.epsilonEquals(new FramePlane3d(expectedNormal, expectedPoint), epsilon));
        RigidBodyTransform transformation4 = new RigidBodyTransform();
        transformation4.setRotationPitchAndZeroTranslation(1.5707963267948966);
        transformation4.getTranslation().set((Tuple3DReadOnly)new Vector3D(1.0, 2.0, 3.0));
        FramePlane3d plane4 = new FramePlane3d(worldFrame, (Point3DReadOnly)new Point3D(), (Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0));
        FramePlane3d plane5 = plane4.applyTransformCopy(transformation4);
        expectedNormal.set(0.0, 0.0, 1.0);
        expectedPoint.set(0.0, 0.0, 0.0);
        Assert.assertTrue(plane4.epsilonEquals(new FramePlane3d(expectedNormal, expectedPoint), epsilon));
        expectedNormal.set(1.0, 0.0, 0.0);
        expectedPoint.set(1.0, 2.0, 3.0);
        Assert.assertTrue(plane5.epsilonEquals(new FramePlane3d(expectedNormal, expectedPoint), epsilon));
    }

    @Test
    public void testIntersectionWithLine() {
        FrameVector3D normal = new FrameVector3D(worldFrame, 0.0, 0.0, 1.0);
        FramePoint3D point = new FramePoint3D(worldFrame, 0.0, 0.0, 0.0);
        FramePlane3d plane = new FramePlane3d(normal, point);
        FramePoint3D origin = new FramePoint3D(worldFrame, 0.0, 1.0, -1.0);
        FrameVector3D direction = new FrameVector3D(worldFrame, 1.0, 0.0, 1.0);
        FrameLine3D line = new FrameLine3D((FramePoint3DReadOnly)origin, (FrameVector3DReadOnly)direction);
        FramePoint3D pointToPack = new FramePoint3D(worldFrame);
        plane.getIntersectionWithLine(pointToPack, line);
        FramePoint3D expectedIntersection = new FramePoint3D(worldFrame, 1.0, 1.0, 0.0);
        Assert.assertTrue(pointToPack.epsilonEquals((EuclidFrameGeometry)expectedIntersection, epsilon));
    }
}

