/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry.shapes;

import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.dataStructures.DataGridTools;
import us.ihmc.robotics.dataStructures.DoubleHashHeightMap;
import us.ihmc.robotics.dataStructures.HeightMapWithPoints;
import us.ihmc.robotics.geometry.HeightMapBestFitPlaneCalculator;
import us.ihmc.robotics.geometry.InsufficientDataException;

public class BestFitPlaneCalculatorTest {
    private static final double eps = 1.0E-7;

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void basicBestFitPlaneCalculatorTest() throws InsufficientDataException {
        double gridResolution = 1.0;
        DoubleHashHeightMap map = new DoubleHashHeightMap(gridResolution);
        FramePoint2D footCenterPoint = new FramePoint2D(ReferenceFrame.getWorldFrame(), 0.0, 0.0);
        DMatrixRMaj matrix = new DMatrixRMaj(7, 7);
        matrix.setData(new double[]{0.0, 0.0, 0.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 8.0, 8.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 8.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 2.0, 2.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0});
        DataGridTools.fillMapWithMatrixCentered((HeightMapWithPoints)map, (DMatrixRMaj)matrix, (double)gridResolution);
        HeightMapBestFitPlaneCalculator calculator = new HeightMapBestFitPlaneCalculator();
        Plane3D plane = calculator.calculatePlane((HeightMapWithPoints)map, (Point2DBasics)footCenterPoint, 2.0, 2.0);
        System.out.println("BestFitPlaneCalculatorTest: calculator.getPointList() = " + calculator.getPointList());
        Point3D point = new Point3D((Tuple3DReadOnly)plane.getPoint());
        Vector3D normal = new Vector3D((Tuple3DReadOnly)plane.getNormal());
        Assert.assertEquals(1.0, point.getZ(), 1.0E-7);
        Assert.assertEquals(footCenterPoint.getX(), point.getX(), 1.0E-7);
        Assert.assertEquals(footCenterPoint.getY(), point.getY(), 1.0E-7);
        Assert.assertEquals(-Math.sqrt(2.0) / 2.0, normal.getX(), 1.0E-7);
        Assert.assertEquals(0.0, normal.getY(), 1.0E-7);
        Assert.assertEquals(Math.sqrt(2.0) / 2.0, normal.getZ(), 1.0E-7);
    }

    @Test
    public void basicBestFitPlaneCalculatorNaNTest() throws InsufficientDataException {
        double gridResolution = 1.0;
        DoubleHashHeightMap map = new DoubleHashHeightMap(gridResolution);
        double n = Double.NaN;
        DMatrixRMaj matrix = new DMatrixRMaj(7, 7);
        matrix.setData(new double[]{0.0, 0.0, 0.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, n, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, n, 1.0, 0.0, 0.0, 0.0, 0.0, 2.0, n, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0});
        DataGridTools.fillMapWithMatrix((HeightMapWithPoints)map, (DMatrixRMaj)matrix, (double)gridResolution);
        HeightMapBestFitPlaneCalculator calculator = new HeightMapBestFitPlaneCalculator();
        double xyCenter = 3.0;
        Plane3D plane = calculator.calculatePlane((HeightMapWithPoints)map, (Point2DBasics)new Point2D(xyCenter, xyCenter), 2.0, 2.0);
        Point3D point = new Point3D((Tuple3DReadOnly)plane.getPoint());
        Vector3D normal = new Vector3D((Tuple3DReadOnly)plane.getNormal());
        if (!(MathTools.epsilonEquals((double)normal.getX(), (double)(Math.sqrt(2.0) / 2.0), (double)1.0E-7) && MathTools.epsilonEquals((double)normal.getZ(), (double)(-Math.sqrt(2.0) / 2.0), (double)1.0E-7) || MathTools.epsilonEquals((double)normal.getX(), (double)(-Math.sqrt(2.0) / 2.0), (double)1.0E-7) && MathTools.epsilonEquals((double)normal.getZ(), (double)(Math.sqrt(2.0) / 2.0), (double)1.0E-7))) {
            Assert.fail();
        }
        Assert.assertEquals(0.0, normal.getY(), 1.0E-7);
        Assert.assertEquals(xyCenter, point.getX(), 1.0E-7);
        Assert.assertEquals(xyCenter, point.getY(), 1.0E-7);
        Assert.assertEquals(1.0, point.getZ(), 1.0E-7);
    }
}

