/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.MinMaxPointHolder;
import us.ihmc.robotics.geometry.StringStretcher2d;
import us.ihmc.robotics.random.RandomGeometry;

public class StringStretcher2dTest {
    @Test
    public void testSimpleExampleWithNoWaypoints() {
        StringStretcher2d stringStretcher2d = new StringStretcher2d();
        Point2D startPoint = new Point2D(0.0, 1.0);
        Point2D endPoint = new Point2D(1.0, 1.0);
        stringStretcher2d.setStartPoint(startPoint);
        stringStretcher2d.setEndPoint((Point2DReadOnly)endPoint);
        Point2D minPoint1 = new Point2D(0.5, 0.0);
        Point2D maxPoint1 = new Point2D(0.5, 2.0);
        stringStretcher2d.addMinMaxPoints((Point2DReadOnly)minPoint1, (Point2DReadOnly)maxPoint1);
        Point2DReadOnly worstMinViolator = stringStretcher2d.findWorstMinViolator(startPoint, endPoint);
        Point2DReadOnly worstMaxViolator = stringStretcher2d.findWorstMaxViolator(startPoint, endPoint);
        Assert.assertNull(worstMinViolator);
        Assert.assertNull(worstMaxViolator);
        ArrayList waypoints = new ArrayList();
        stringStretcher2d.findWaypoints(waypoints);
        Assert.assertEquals(0L, waypoints.size());
        ArrayList solution = new ArrayList();
        stringStretcher2d.stretchString(solution);
        Assert.assertEquals(3L, solution.size());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)startPoint, (EuclidGeometry)((EuclidGeometry)solution.get(0)), (double)1.0E-7);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(0.5, 1.0), (EuclidGeometry)((EuclidGeometry)solution.get(1)), (double)1.0E-7);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)endPoint, (EuclidGeometry)((EuclidGeometry)solution.get(2)), (double)1.0E-7);
    }

    @Test
    public void testSimpleExampleWithOneWaypointsNoInterpolation() {
        StringStretcher2d stringStretcher2d = new StringStretcher2d();
        Point2D startPoint = new Point2D(0.0, 1.0);
        Point2D endPoint = new Point2D(10.0, 1.0);
        stringStretcher2d.setStartPoint(startPoint);
        stringStretcher2d.setEndPoint((Point2DReadOnly)endPoint);
        Point2D minPoint = new Point2D(5.0, -1.0);
        Point2D maxPoint = new Point2D(5.0, 0.0);
        stringStretcher2d.addMinMaxPoints((Point2DReadOnly)minPoint, (Point2DReadOnly)maxPoint);
        ArrayList waypoints = new ArrayList();
        stringStretcher2d.findWaypoints(waypoints);
        Assert.assertEquals(1L, waypoints.size());
        Assert.assertTrue(maxPoint.epsilonEquals((EuclidGeometry)waypoints.get(0), 1.0E-6));
    }

    @Test
    public void testSimpleExampleWithAllWaypointsNoInterpolation() {
        StringStretcher2d stringStretcher2d = new StringStretcher2d();
        Point2D startPoint = new Point2D(0.0, 1.0);
        Point2D endPoint = new Point2D(10.0, 1.0);
        stringStretcher2d.setStartPoint(startPoint);
        stringStretcher2d.setEndPoint((Point2DReadOnly)endPoint);
        Point2D minPoint1 = new Point2D(2.0, 2.0);
        Point2D maxPoint1 = new Point2D(2.0, 3.0);
        stringStretcher2d.addMinMaxPoints((Point2DReadOnly)minPoint1, (Point2DReadOnly)maxPoint1);
        Point2D minPoint2 = new Point2D(8.0, 2.0);
        Point2D maxPoint2 = new Point2D(8.0, 3.0);
        stringStretcher2d.addMinMaxPoints((Point2DReadOnly)minPoint2, (Point2DReadOnly)maxPoint2);
        Point2D minPoint3 = new Point2D(5.0, -1.0);
        Point2D maxPoint3 = new Point2D(5.0, 0.0);
        stringStretcher2d.addMinMaxPoints((Point2DReadOnly)minPoint3, (Point2DReadOnly)maxPoint3);
        ArrayList waypoints = new ArrayList();
        stringStretcher2d.findWaypoints(waypoints);
        Assert.assertEquals(3L, waypoints.size());
        Assert.assertTrue(minPoint1.epsilonEquals((EuclidGeometry)waypoints.get(0), 1.0E-8));
        Assert.assertTrue(maxPoint3.epsilonEquals((EuclidGeometry)waypoints.get(1), 1.0E-8));
        Assert.assertTrue(minPoint2.epsilonEquals((EuclidGeometry)waypoints.get(2), 1.0E-8));
    }

    @Test
    public void testStartAndEnd() {
        StringStretcher2d stringStretcher2d = new StringStretcher2d();
        Point2D startPoint = new Point2D(0.0, 1.0);
        Point2D endPoint = new Point2D(1.0, 1.0);
        stringStretcher2d.setStartPoint(startPoint);
        stringStretcher2d.setEndPoint((Point2DReadOnly)endPoint);
        ArrayList waypoints = new ArrayList();
        stringStretcher2d.stretchString(waypoints);
        Assert.assertEquals(2L, waypoints.size());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)startPoint, (EuclidGeometry)((EuclidGeometry)waypoints.get(0)), (double)1.0E-7);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)endPoint, (EuclidGeometry)((EuclidGeometry)waypoints.get(1)), (double)1.0E-7);
    }

    @Test
    public void testRandomExample() {
        StringStretcher2d stringStretcher2d = new StringStretcher2d();
        Point2D startPoint = new Point2D(-10.0, 0.0);
        stringStretcher2d.setStartPoint(startPoint);
        Point2D endPoint = new Point2D(10.0, 0.0);
        stringStretcher2d.setEndPoint((Point2DReadOnly)endPoint);
        Random random = new Random(1776L);
        int numberOfPoints = 1000;
        for (int i = 0; i < numberOfPoints; ++i) {
            Point2D point = RandomGeometry.nextPoint2D((Random)random, (double)10.0, (double)10.0);
            Point2D otherPoint = new Point2D((Tuple2DReadOnly)point);
            otherPoint.setY(RandomNumbers.nextDouble((Random)random, (double)-10.0, (double)10.0));
            if (point.getY() < otherPoint.getY()) {
                stringStretcher2d.addMinMaxPoints((Point2DReadOnly)point, (Point2DReadOnly)otherPoint);
                continue;
            }
            stringStretcher2d.addMinMaxPoints((Point2DReadOnly)otherPoint, (Point2DReadOnly)point);
        }
        ArrayList waypoints = new ArrayList();
        stringStretcher2d.findWaypoints(waypoints);
        ArrayList stretchedString = new ArrayList();
        stringStretcher2d.stretchString(stretchedString);
        Assert.assertEquals(numberOfPoints + 2, stretchedString.size());
        double previousX = Double.NEGATIVE_INFINITY;
        for (Point2DBasics point2d : stretchedString) {
            double x = point2d.getX();
            if (x <= previousX) {
                Assert.fail();
            } else {
                previousX = x;
            }
            if (this.hasSameX((Point2DReadOnly)point2d, (Point2DReadOnly)startPoint) || this.hasSameX((Point2DReadOnly)point2d, (Point2DReadOnly)endPoint)) continue;
            MinMaxPointHolder minMaxPoints = stringStretcher2d.findMinMaxPoints(x);
            Assert.assertTrue(point2d.getY() >= minMaxPoints.getMinPoint().getY());
            Assert.assertTrue(point2d.getY() <= minMaxPoints.getMaxPoint().getY());
        }
    }

    private boolean hasSameX(Point2DReadOnly pointA, Point2DReadOnly pointB) {
        return Math.abs(pointA.getX() - pointB.getX()) < 1.0E-7;
    }
}

