/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.RotationalInertiaCalculator;

public class RotationalInertiaCalculatorTest {
    private static final double DELTA = 0.001;
    private static final int ITERATIONS = 1000;
    private double maxRandomValue;
    private Random random;

    @BeforeEach
    public void setUp() {
        this.maxRandomValue = 1000.0;
        this.random = new Random();
    }

    private double randomPositiveDouble() {
        return this.random.nextDouble() * this.maxRandomValue;
    }

    @Test
    public void testBasicCylinder() {
        for (int i = 0; i < 1000; ++i) {
            double inCircleAxis1;
            double inCircleAxis0;
            double mass = this.randomPositiveDouble();
            double radius = this.randomPositiveDouble();
            double height = this.randomPositiveDouble();
            int pick = this.random.nextInt(Axis3D.values().length);
            Axis3D axis = Axis3D.values()[pick];
            double[] IxxIyyIzz = RotationalInertiaCalculator.getIxxIyyIzzOfSolidCylinder((double)mass, (double)radius, (double)height, (Axis3D)axis);
            double mainAxis = switch (axis) {
                case Axis3D.X -> {
                    inCircleAxis0 = IxxIyyIzz[1];
                    inCircleAxis1 = IxxIyyIzz[2];
                    yield IxxIyyIzz[0];
                }
                case Axis3D.Y -> {
                    inCircleAxis0 = IxxIyyIzz[0];
                    inCircleAxis1 = IxxIyyIzz[2];
                    yield IxxIyyIzz[1];
                }
                case Axis3D.Z -> {
                    inCircleAxis0 = IxxIyyIzz[0];
                    inCircleAxis1 = IxxIyyIzz[1];
                    yield IxxIyyIzz[2];
                }
                default -> throw new RuntimeException("A new axis has been added to the Axis enum, but is not covered in the testcase.");
            };
            Assert.assertEquals(mass * (3.0 * radius * radius + height * height) / 12.0, inCircleAxis0, 0.001);
            Assert.assertEquals(mass * (3.0 * radius * radius + height * height) / 12.0, inCircleAxis1, 0.001);
            Assert.assertEquals(0.5 * mass * radius * radius, mainAxis, 0.001);
            Matrix3D rotationMatrix = RotationalInertiaCalculator.getRotationalInertiaMatrixOfSolidCylinder((double)mass, (double)radius, (double)height, (Axis3D)axis);
            Assert.assertEquals(IxxIyyIzz[0], rotationMatrix.getM00(), 0.001);
            Assert.assertEquals(IxxIyyIzz[1], rotationMatrix.getM11(), 0.001);
            Assert.assertEquals(IxxIyyIzz[2], rotationMatrix.getM22(), 0.001);
            Assert.assertEquals(0.0, rotationMatrix.getM01(), 0.001);
            Assert.assertEquals(0.0, rotationMatrix.getM02(), 0.001);
            Assert.assertEquals(0.0, rotationMatrix.getM10(), 0.001);
            Assert.assertEquals(0.0, rotationMatrix.getM12(), 0.001);
            Assert.assertEquals(0.0, rotationMatrix.getM20(), 0.001);
            Assert.assertEquals(0.0, rotationMatrix.getM21(), 0.001);
        }
    }

    @Test
    public void testBasicCylinderNegativeMass() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            double mass = -1.0;
            double radius = 1.0;
            double height = 1.0;
            Axis3D axis = Axis3D.Z;
            RotationalInertiaCalculator.getIxxIyyIzzOfSolidCylinder((double)mass, (double)radius, (double)height, (Axis3D)axis);
        });
    }

    @Test
    public void testBasicCylinderNegativeRadius() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            double mass = 1.0;
            double radius = -1.0;
            double height = 1.0;
            Axis3D axis = Axis3D.Z;
            RotationalInertiaCalculator.getIxxIyyIzzOfSolidCylinder((double)mass, (double)radius, (double)height, (Axis3D)axis);
        });
    }

    @Test
    public void testBasicCylinderNegativeHeight() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            double mass = 1.0;
            double radius = 1.0;
            double height = -1.0;
            Axis3D axis = Axis3D.Z;
            RotationalInertiaCalculator.getIxxIyyIzzOfSolidCylinder((double)mass, (double)radius, (double)height, (Axis3D)axis);
        });
    }

    @Test
    public void testSolidEllipsoid() {
        for (int i = 0; i < 1000; ++i) {
            double mass = this.randomPositiveDouble();
            double xRadius = this.randomPositiveDouble();
            double yRadius = this.randomPositiveDouble();
            double zRadius = this.randomPositiveDouble();
            double Ixx = mass * (MathTools.square((double)yRadius) + MathTools.square((double)zRadius)) / 5.0;
            double Iyy = mass * (MathTools.square((double)xRadius) + MathTools.square((double)zRadius)) / 5.0;
            double Izz = mass * (MathTools.square((double)yRadius) + MathTools.square((double)xRadius)) / 5.0;
            Matrix3D inertiaTensor = RotationalInertiaCalculator.getRotationalInertiaMatrixOfSolidEllipsoid((double)mass, (double)xRadius, (double)yRadius, (double)zRadius);
            Assert.assertEquals(Ixx, inertiaTensor.getM00(), 0.001);
            Assert.assertEquals(Iyy, inertiaTensor.getM11(), 0.001);
            Assert.assertEquals(Izz, inertiaTensor.getM22(), 0.001);
        }
    }

    @Test
    public void testSolidEllipsoidNegativeMass() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            double mass = -1.0;
            double xRadius = 1.0;
            double yRadius = 1.0;
            double zRadius = 1.0;
            RotationalInertiaCalculator.getRotationalInertiaMatrixOfSolidEllipsoid((double)mass, (double)xRadius, (double)yRadius, (double)zRadius);
        });
    }

    @Test
    public void testSolidEllipsoidNegativeXRadius() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            double mass = 1.0;
            double xRadius = -1.0;
            double yRadius = 1.0;
            double zRadius = 1.0;
            RotationalInertiaCalculator.getRotationalInertiaMatrixOfSolidEllipsoid((double)mass, (double)xRadius, (double)yRadius, (double)zRadius);
        });
    }

    @Test
    public void testSolidEllipsoidNegativeYRadius() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            double mass = 1.0;
            double xRadius = 1.0;
            double yRadius = -1.0;
            double zRadius = 1.0;
            RotationalInertiaCalculator.getRotationalInertiaMatrixOfSolidEllipsoid((double)mass, (double)xRadius, (double)yRadius, (double)zRadius);
        });
    }

    @Test
    public void testSolidEllipsoidNegativeZRadius() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            double mass = 1.0;
            double xRadius = 1.0;
            double yRadius = 1.0;
            double zRadius = -1.0;
            RotationalInertiaCalculator.getRotationalInertiaMatrixOfSolidEllipsoid((double)mass, (double)xRadius, (double)yRadius, (double)zRadius);
        });
    }

    @Test
    public void testRadiiOfGyration() {
        for (int i = 0; i < 1000; ++i) {
            double mass = this.randomPositiveDouble();
            double xRadius = this.randomPositiveDouble();
            double yRadius = this.randomPositiveDouble();
            double zRadius = this.randomPositiveDouble();
            Matrix3D rotationalInertia = RotationalInertiaCalculator.getRotationalInertiaFromRadiiOfGyration((double)mass, (double)xRadius, (double)yRadius, (double)zRadius);
            Assert.assertEquals(mass * (MathTools.square((double)yRadius) + MathTools.square((double)zRadius)), rotationalInertia.getM00(), 0.001);
            Assert.assertEquals(mass * (MathTools.square((double)zRadius) + MathTools.square((double)xRadius)), rotationalInertia.getM11(), 0.001);
            Assert.assertEquals(mass * (MathTools.square((double)xRadius) + MathTools.square((double)yRadius)), rotationalInertia.getM22(), 0.001);
            Assert.assertEquals(0.0, rotationalInertia.getM01(), 0.001);
            Assert.assertEquals(0.0, rotationalInertia.getM02(), 0.001);
            Assert.assertEquals(0.0, rotationalInertia.getM10(), 0.001);
            Assert.assertEquals(0.0, rotationalInertia.getM12(), 0.001);
            Assert.assertEquals(0.0, rotationalInertia.getM20(), 0.001);
            Assert.assertEquals(0.0, rotationalInertia.getM21(), 0.001);
        }
    }

    @Test
    public void testRadiiOfGyrationNegativeMass() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            double mass = -1.0;
            double xRadius = 1.0;
            double yRadius = 1.0;
            double zRadius = 1.0;
            RotationalInertiaCalculator.getRotationalInertiaFromRadiiOfGyration((double)mass, (double)xRadius, (double)yRadius, (double)zRadius);
        });
    }

    @Test
    public void testRadiiOfGyrationNegativeXRadius() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            double mass = 1.0;
            double xRadius = -1.0;
            double yRadius = 1.0;
            double zRadius = 1.0;
            RotationalInertiaCalculator.getRotationalInertiaFromRadiiOfGyration((double)mass, (double)xRadius, (double)yRadius, (double)zRadius);
        });
    }

    @Test
    public void testRadiiOfGyrationNegativeYRadius() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            double mass = 1.0;
            double xRadius = 1.0;
            double yRadius = -1.0;
            double zRadius = 1.0;
            RotationalInertiaCalculator.getRotationalInertiaFromRadiiOfGyration((double)mass, (double)xRadius, (double)yRadius, (double)zRadius);
        });
    }

    @Test
    public void testRadiiOfGyrationNegativeZRadius() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            double mass = 1.0;
            double xRadius = 1.0;
            double yRadius = 1.0;
            double zRadius = -1.0;
            RotationalInertiaCalculator.getRotationalInertiaFromRadiiOfGyration((double)mass, (double)xRadius, (double)yRadius, (double)zRadius);
        });
    }
}

