/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.PointToLineUnProjector;
import us.ihmc.robotics.random.RandomGeometry;

public class PointToLineUnProjectorTest {
    private static final double eps = 1.0E-7;

    @Test
    public void testsimpleCase() {
        double x0 = 1.0;
        double y0 = 0.0;
        double z0 = 0.0;
        double x1 = 0.0;
        double y1 = 0.0;
        double z1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double z2 = 0.0;
        this.runTest(x0, y0, z0, x1, y1, z1, x2, y2, z2);
    }

    @Test
    public void testGeneralCase() {
        Random gen = new Random(124L);
        for (int i = 0; i < 100000; ++i) {
            Point3D point1 = RandomGeometry.nextPoint3D((Random)gen, (double)-1000.0, (double)-1000.0, (double)-1000.0, (double)1000.0, (double)1000.0, (double)1000.0);
            Point3D point2 = RandomGeometry.nextPoint3D((Random)gen, (double)-1000.0, (double)-1000.0, (double)-1000.0, (double)1000.0, (double)1000.0, (double)1000.0);
            double s = RandomNumbers.nextDouble((Random)gen, (double)0.0, (double)1.0);
            Point3D temp = new Point3D((Tuple3DReadOnly)point1);
            temp.scale(1.0 - s);
            Point3D point3 = new Point3D((Tuple3DReadOnly)temp);
            temp.set(point2);
            temp.scale(s);
            point3.add((Tuple3DReadOnly)temp);
            this.runTest(point1.getX(), point1.getY(), point1.getZ(), point2.getX(), point2.getY(), point2.getZ(), point3.getX(), point3.getY(), point3.getZ());
        }
    }

    @Test
    public void testDegenerateCase() {
        Random gen = new Random(124L);
        for (int i = 0; i < 100000; ++i) {
            Point3D point1 = RandomGeometry.nextPoint3D((Random)gen, (double)-1000.0, (double)-1000.0, (double)-1000.0, (double)1000.0, (double)1000.0, (double)1000.0);
            Point3D point2 = new Point3D((Tuple3DReadOnly)point1);
            double s = RandomNumbers.nextDouble((Random)gen, (double)0.0, (double)1.0);
            Point3D temp = new Point3D((Tuple3DReadOnly)point1);
            temp.scale(1.0 - s);
            Point3D point3 = new Point3D((Tuple3DReadOnly)temp);
            temp.set(point2);
            temp.scale(s);
            point3.add((Tuple3DReadOnly)temp);
            this.runTest(point1.getX(), point1.getY(), point1.getZ(), point2.getX(), point2.getY(), point2.getZ(), point3.getX(), point3.getY(), point3.getZ());
        }
    }

    @Test
    public void testYCase() {
        Random gen = new Random(124L);
        for (int i = 0; i < 100000; ++i) {
            Point3D point1 = RandomGeometry.nextPoint3D((Random)gen, (double)-1000.0, (double)-1000.0, (double)-1000.0, (double)1000.0, (double)1000.0, (double)1000.0);
            Point3D point2 = RandomGeometry.nextPoint3D((Random)gen, (double)-1000.0, (double)-1000.0, (double)-1000.0, (double)1000.0, (double)1000.0, (double)1000.0);
            point2.setY(point1.getY());
            double s = RandomNumbers.nextDouble((Random)gen, (double)0.0, (double)1.0);
            Point3D temp = new Point3D((Tuple3DReadOnly)point1);
            temp.scale(1.0 - s);
            Point3D point3 = new Point3D((Tuple3DReadOnly)temp);
            temp.set(point2);
            temp.scale(s);
            point3.add((Tuple3DReadOnly)temp);
            this.runTest(point1.getX(), point1.getY(), point1.getZ(), point2.getX(), point2.getY(), point2.getZ(), point3.getX(), point3.getY(), point3.getZ());
        }
    }

    @Test
    public void testXCase() {
        Random gen = new Random(124L);
        for (int i = 0; i < 100000; ++i) {
            Point3D point1 = RandomGeometry.nextPoint3D((Random)gen, (double)-1000.0, (double)-1000.0, (double)-1000.0, (double)1000.0, (double)1000.0, (double)1000.0);
            Point3D point2 = RandomGeometry.nextPoint3D((Random)gen, (double)-1000.0, (double)-1000.0, (double)-1000.0, (double)1000.0, (double)1000.0, (double)1000.0);
            point2.setX(point1.getX());
            double s = RandomNumbers.nextDouble((Random)gen, (double)0.0, (double)1.0);
            Point3D temp = new Point3D((Tuple3DReadOnly)point1);
            temp.scale(1.0 - s);
            Point3D point3 = new Point3D((Tuple3DReadOnly)temp);
            temp.set(point2);
            temp.scale(s);
            point3.add((Tuple3DReadOnly)temp);
            this.runTest(point1.getX(), point1.getY(), point1.getZ(), point2.getX(), point2.getY(), point2.getZ(), point3.getX(), point3.getY(), point3.getZ());
        }
    }

    private void runTest(double x0, double y0, double z0, double x1, double y1, double z1, double x2, double y2, double z2) {
        PointToLineUnProjector unProjector = new PointToLineUnProjector();
        unProjector.setLine(new Point2D(x0, y0), new Point2D(x1, y1), z0, z1);
        Assert.assertEquals(z2, unProjector.unProject(x2, y2), 1.0E-7);
    }
}

