/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.AngleTools;
import us.ihmc.robotics.geometry.GeometryTools;
import us.ihmc.robotics.geometry.RotationTools;
import us.ihmc.robotics.random.RandomGeometry;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;

public class FramePoseTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testGetOrientationDistanceTrivial() {
        RigidBodyTransform transform1 = new RigidBodyTransform();
        transform1.setIdentity();
        FramePose3D framePose1 = new FramePose3D(ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)transform1);
        RigidBodyTransform transform2 = new RigidBodyTransform();
        transform2.setIdentity();
        FramePose3D framePose2 = new FramePose3D(ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)transform2);
        double distance = framePose1.getOrientationDistance((FramePose3DReadOnly)framePose2);
        Assert.assertEquals(0.0, distance, 1.0E-9);
    }

    @Test
    public void testGetTransform() {
        Random random = new Random(1179L);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        FramePose3D framePose = new FramePose3D(ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)transform);
        RigidBodyTransform transformCheck = new RigidBodyTransform();
        framePose.get((RigidBodyTransformBasics)transformCheck);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)transform, (EuclidGeometry)transformCheck, (double)1.0E-10);
    }

    @Test
    public void testRotatePoseAboutOffsetAxisAndCheckTranslation() {
        Random random = new Random(1179L);
        double angleToRotate = RandomNumbers.nextDouble((Random)random, (double)Math.toRadians(720.0));
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        FramePose3D framePose = new FramePose3D(worldFrame);
        framePose.getPosition().set(1.0, 0.0, 1.0);
        framePose.getOrientation().set((QuaternionReadOnly)RandomGeometry.nextQuaternion((Random)random));
        FrameVector3D rotationAxis = new FrameVector3D(worldFrame, 0.0, 0.0, 1.0);
        FramePoint3D rotationAxisOrigin = new FramePoint3D(worldFrame, 0.0, 0.0, 0.0);
        GeometryTools.rotatePoseAboutAxis((FrameVector3D)rotationAxis, (FramePoint3D)rotationAxisOrigin, (double)angleToRotate, (FramePose3D)framePose);
        Point3D actualPosePositionAfterRotation = new Point3D((Tuple3DReadOnly)framePose.getPosition());
        Point3D desiredPosition = new Point3D(Math.cos(angleToRotate), Math.sin(angleToRotate), 1.0);
        Vector3D positionError = new Vector3D();
        positionError.sub((Tuple3DReadOnly)desiredPosition, (Tuple3DReadOnly)actualPosePositionAfterRotation);
        Assert.assertTrue("Reference Frame shoud not have changed.  Actual frame: " + framePose.getReferenceFrame().getName() + ", Desired frame: " + worldFrame.getName(), framePose.getReferenceFrame() == worldFrame);
        Assert.assertEquals("FramePose Position after rotation is wrong.  Desired position: " + desiredPosition + ", actual position: " + actualPosePositionAfterRotation, 0.0, positionError.length(), 0.001);
    }

    @Test
    public void testRotatePoseAboutCollinearAxisAndCheckTranslation() {
        Random random = new Random(1179L);
        double angleToRotate = RandomNumbers.nextDouble((Random)random, (double)Math.toRadians(720.0));
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        FramePose3D framePose = new FramePose3D(worldFrame);
        framePose.getPosition().set(1.0, 0.0, 1.0);
        framePose.getOrientation().set((QuaternionReadOnly)RandomGeometry.nextQuaternion((Random)random));
        GeometryTools.rotatePoseAboutAxis((ReferenceFrame)framePose.getReferenceFrame(), (Axis3D)Axis3D.Z, (double)angleToRotate, (FramePose3D)framePose);
        Point3D actualPosePositionAfterRotation = new Point3D((Tuple3DReadOnly)framePose.getPosition());
        Point3D desiredPosition = new Point3D(Math.cos(angleToRotate), Math.sin(angleToRotate), 1.0);
        Vector3D positionError = new Vector3D();
        positionError.sub((Tuple3DReadOnly)desiredPosition, (Tuple3DReadOnly)actualPosePositionAfterRotation);
        Assert.assertTrue("Reference Frame shoud not have changed.  Actual frame: " + framePose.getReferenceFrame().getName() + ", Desired frame: " + worldFrame.getName(), framePose.getReferenceFrame() == worldFrame);
        Assert.assertEquals("FramePose Position after rotation is wrong.  Desired position: " + desiredPosition + ", actual position: " + actualPosePositionAfterRotation, 0.0, positionError.length(), 0.001);
    }

    @Test
    public void testRotatePoseAboutZAxisAndCheckOrientation() {
        double angleToRotate;
        Random random = new Random(1179L);
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        FramePose3D initialPose = new FramePose3D(worldFrame);
        FramePose3D rotatedPose = new FramePose3D(worldFrame);
        AxisAngle desiredRotationAxisAngle = new AxisAngle(0.0, 0.0, 1.0, angleToRotate);
        for (angleToRotate = Math.toRadians(-720.01); angleToRotate < Math.toRadians(720.0); angleToRotate += Math.toRadians(5.0)) {
            initialPose.getPosition().set(0.0, 0.0, RandomNumbers.nextDouble((Random)random, (double)10.0));
            rotatedPose.setIncludingFrame((FramePose3DReadOnly)initialPose);
            desiredRotationAxisAngle.setAngle(angleToRotate);
            GeometryTools.rotatePoseAboutAxis((ReferenceFrame)rotatedPose.getReferenceFrame(), (Axis3D)Axis3D.Z, (double)angleToRotate, (FramePose3D)rotatedPose);
            PoseReferenceFrame initialPoseFrame = new PoseReferenceFrame("initialPoseFrame", (FramePose3DReadOnly)initialPose);
            rotatedPose.changeFrame((ReferenceFrame)initialPoseFrame);
            AxisAngle actualRotationAxisAngle = new AxisAngle((Orientation3DReadOnly)rotatedPose.getOrientation());
            Assert.assertTrue("Actual rotation: " + actualRotationAxisAngle + " does not match desired: " + desiredRotationAxisAngle, RotationTools.axisAngleEpsilonEquals((AxisAngleReadOnly)desiredRotationAxisAngle, (AxisAngleReadOnly)actualRotationAxisAngle, (double)1.0E-5, (RotationTools.AxisAngleComparisonMode)RotationTools.AxisAngleComparisonMode.IGNORE_FLIPPED_AXES_ROTATION_DIRECTION_AND_COMPLETE_ROTATIONS));
        }
    }

    @Test
    public void testRotatePoseAboutCollinearAxisIncrementally() {
        Random random = new Random(1179L);
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        double angleToRotate = RandomNumbers.nextDouble((Random)random, (double)Math.toRadians(720.0));
        FramePose3D framePose = new FramePose3D(worldFrame);
        framePose.getPosition().set(0.0, 0.0, 1.0);
        FramePose3D framePoseCopy = new FramePose3D((FramePose3DReadOnly)framePose);
        GeometryTools.rotatePoseAboutAxis((ReferenceFrame)framePose.getReferenceFrame(), (Axis3D)Axis3D.Z, (double)(0.5 * angleToRotate), (FramePose3D)framePose);
        GeometryTools.rotatePoseAboutAxis((ReferenceFrame)framePose.getReferenceFrame(), (Axis3D)Axis3D.Z, (double)(0.5 * angleToRotate), (FramePose3D)framePose);
        double positionDistance = framePose.getPositionDistance((FramePose3DReadOnly)framePoseCopy);
        double orientationDistance = AngleTools.trimAngleMinusPiToPi((double)framePose.getOrientationDistance((FramePose3DReadOnly)framePoseCopy));
        double desiredOrientationDistance = AngleTools.trimAngleMinusPiToPi((double)angleToRotate);
        Assert.assertTrue("Reference Frame shoud not have changed.  Actual frame: " + framePose.getReferenceFrame().getName() + ", Desired frame: " + worldFrame.getName(), framePose.getReferenceFrame() == worldFrame);
        Assert.assertEquals("Change in FramePose Position after rotation is wrong.", 0.0, positionDistance, 0.001);
        Assert.assertEquals("Change in FramePose Orientation after rotation is wrong.", desiredOrientationDistance, orientationDistance, Math.toRadians(0.1));
    }

    @Test
    public void testRotateAndUnrotatePoseAboutCollinearAxis() {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        double angleToRotate = Math.toRadians(90.0);
        FramePose3D framePose = new FramePose3D(worldFrame);
        framePose.getPosition().set(0.0, 0.0, 1.0);
        FramePose3D framePoseCopy = new FramePose3D((FramePose3DReadOnly)framePose);
        GeometryTools.rotatePoseAboutAxis((ReferenceFrame)framePose.getReferenceFrame(), (Axis3D)Axis3D.Z, (double)(0.5 * angleToRotate), (FramePose3D)framePose);
        GeometryTools.rotatePoseAboutAxis((ReferenceFrame)framePose.getReferenceFrame(), (Axis3D)Axis3D.Z, (double)(-0.5 * angleToRotate), (FramePose3D)framePose);
        double positionDistance = framePose.getPositionDistance((FramePose3DReadOnly)framePoseCopy);
        double orientationDistance = framePose.getOrientationDistance((FramePose3DReadOnly)framePoseCopy);
        Assert.assertTrue("Reference Frame shoud not have changed.  Actual frame: " + framePose.getReferenceFrame().getName() + ", Desired frame: " + worldFrame.getName(), framePose.getReferenceFrame() == worldFrame);
        Assert.assertEquals("Change in FramePose Position after rotation is wrong.", 0.0, positionDistance, 0.001);
        Assert.assertEquals("Change in FramePose Orientation after rotation is wrong.", 0.0, orientationDistance, Math.toRadians(0.1));
    }

    @Test
    public void testRotatePoseLockOrientation() {
        boolean lockPosition = false;
        boolean lockOrientation = true;
        Random random = new Random(1179L);
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        FramePose3D initialPose = new FramePose3D(worldFrame);
        FramePose3D rotatedPose = new FramePose3D(worldFrame);
        Point3D actualPosition = new Point3D();
        Point3D desiredPosition = new Point3D();
        Vector3D positionError = new Vector3D();
        for (double angleToRotate = Math.toRadians(-720.0); angleToRotate < Math.toRadians(720.0); angleToRotate += Math.toRadians(1.0)) {
            initialPose.getPosition().set(1.0, 0.0, 1.0);
            initialPose.getOrientation().set((QuaternionReadOnly)RandomGeometry.nextQuaternion((Random)random));
            rotatedPose.setIncludingFrame((FramePose3DReadOnly)initialPose);
            GeometryTools.rotatePoseAboutAxis((ReferenceFrame)worldFrame, (Axis3D)Axis3D.Z, (double)angleToRotate, (boolean)lockPosition, (boolean)lockOrientation, (FramePose3D)rotatedPose);
            actualPosition.set((Tuple3DReadOnly)rotatedPose.getPosition());
            desiredPosition.set(Math.cos(angleToRotate), Math.sin(angleToRotate), 1.0);
            positionError.sub((Tuple3DReadOnly)desiredPosition, (Tuple3DReadOnly)actualPosition);
            Assert.assertTrue("Reference Frame shoud not have changed.  Actual frame: " + rotatedPose.getReferenceFrame().getName() + ", Desired frame: " + worldFrame.getName(), rotatedPose.getReferenceFrame() == worldFrame);
            Assert.assertEquals("FramePose Position after rotation is wrong.  Desired position: " + desiredPosition + ", actual position: " + actualPosition, 0.0, positionError.length(), 0.001);
            Assert.assertEquals("Change in FramePose Orientation after rotation is wrong.  Orientation should not have changed.", 0.0, rotatedPose.getOrientationDistance((FramePose3DReadOnly)initialPose), Math.toRadians(0.1));
        }
    }

    @Test
    public void testRotatePoseLockPosition() {
        boolean lockPosition = true;
        boolean lockOrientation = false;
        Random random = new Random(1179L);
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        FramePose3D rotatedPose = new FramePose3D(worldFrame);
        FramePose3D initialPose = new FramePose3D(worldFrame);
        for (double angleToRotate = RandomNumbers.nextDouble((Random)random, (double)0.0); angleToRotate < Math.toRadians(180.0); angleToRotate += Math.toRadians(5.0)) {
            rotatedPose.getPosition().set(1.0, 0.0, 1.0);
            rotatedPose.getOrientation().set((QuaternionReadOnly)RandomGeometry.nextQuaternion((Random)random));
            initialPose.setIncludingFrame((FramePose3DReadOnly)rotatedPose);
            Point3D actualpositionBeforeRotation = new Point3D((Tuple3DReadOnly)rotatedPose.getPosition());
            GeometryTools.rotatePoseAboutAxis((ReferenceFrame)rotatedPose.getReferenceFrame(), (Axis3D)Axis3D.Z, (double)angleToRotate, (boolean)lockPosition, (boolean)lockOrientation, (FramePose3D)rotatedPose);
            Point3D actualPosePositionAfterRotation = new Point3D((Tuple3DReadOnly)rotatedPose.getPosition());
            Vector3D changeInPosition = new Vector3D();
            changeInPosition.sub((Tuple3DReadOnly)actualPosePositionAfterRotation, (Tuple3DReadOnly)actualpositionBeforeRotation);
            Assert.assertTrue("Reference Frame shoud not have changed.  Actual frame: " + rotatedPose.getReferenceFrame().getName() + ", Desired frame: " + worldFrame.getName(), rotatedPose.getReferenceFrame() == worldFrame);
            Assert.assertEquals("FramePose Position after rotation is wrong.", 0.0, changeInPosition.length(), 0.001);
            Assert.assertEquals("Change in FramePose Orientation after rotation is wrong.", angleToRotate, rotatedPose.getOrientationDistance((FramePose3DReadOnly)initialPose), Math.toRadians(0.1));
        }
    }
}

