/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.functionApproximation;

import java.util.ArrayList;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.functionApproximation.LinearMapping;

public class LinearMappingTest {
    private static final boolean VERBOSE = false;
    private LinearMapping linearMappingOneD = null;
    private LinearMapping linearMappingTwoD = null;

    @BeforeEach
    public void setUp() throws Exception {
        ArrayList<double[]> inputDimensions = new ArrayList<double[]>();
        ArrayList<double[]> outputDimensions = new ArrayList<double[]>();
        inputDimensions.add(new double[]{0.0, 1.0});
        outputDimensions.add(new double[]{1.0, 10.0});
        this.linearMappingOneD = new LinearMapping(inputDimensions, outputDimensions);
        inputDimensions.add(new double[]{-1.0, 1.0});
        outputDimensions.add(new double[]{10.0, -5.0});
        this.linearMappingTwoD = new LinearMapping(inputDimensions, outputDimensions);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.linearMappingOneD = null;
        this.linearMappingTwoD = null;
    }

    @Test
    public void testMapFromInputSpaceToOutputSpace() {
        double[] input = new double[]{0.1111111111111111};
        double[] expectedReturn = new double[]{2.0};
        double[] actualReturn = this.linearMappingOneD.mapFromInputSpaceToOutputSpace(input);
        Assert.assertEquals("oneD return value", expectedReturn[0], actualReturn[0], 1.0E-10);
        input = new double[]{0.1111111111111111, 0.0};
        expectedReturn = new double[]{2.0, 2.5};
        actualReturn = this.linearMappingTwoD.mapFromInputSpaceToOutputSpace(input);
        Assert.assertEquals("twoD return value", expectedReturn[0], actualReturn[0], 1.0E-10);
        Assert.assertEquals("twoD return value", expectedReturn[1], actualReturn[1], 1.0E-10);
        input = new double[]{-1.0, 10.0};
        expectedReturn = new double[]{-8.0, -72.5};
        actualReturn = this.linearMappingTwoD.mapFromInputSpaceToOutputSpace(input);
        Assert.assertEquals("twoD return value", expectedReturn[0], actualReturn[0], 1.0E-10);
        Assert.assertEquals("twoD return value", expectedReturn[1], actualReturn[1], 1.0E-10);
    }

    @Test
    public void testMapFromOutputSpaceToInputSpace() {
        double[] input = new double[]{0.1111111111111111};
        double[] expectedReturn = new double[]{2.0};
        double[] actualReturn = this.linearMappingOneD.mapFromOutputSpaceToInputSpace(expectedReturn);
        Assert.assertEquals("oneD return value", input[0], actualReturn[0], 1.0E-10);
        input = new double[]{0.1111111111111111, 0.0};
        expectedReturn = new double[]{2.0, 2.5};
        actualReturn = this.linearMappingTwoD.mapFromOutputSpaceToInputSpace(expectedReturn);
        Assert.assertEquals("twoD return value", input[0], actualReturn[0], 1.0E-10);
        Assert.assertEquals("twoD return value", input[1], actualReturn[1], 1.0E-10);
        input = new double[]{-1.0, 10.0};
        expectedReturn = new double[]{-8.0, -72.5};
        actualReturn = this.linearMappingTwoD.mapFromOutputSpaceToInputSpace(expectedReturn);
        Assert.assertEquals("twoD return value", input[0], actualReturn[0], 1.0E-10);
        Assert.assertEquals("twoD return value", input[1], actualReturn[1], 1.0E-10);
    }
}

