/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.dataStructures;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.dataStructures.ComplexNumber;
import us.ihmc.robotics.dataStructures.ObsoletePolynomial;

public class PolynomialTest {
    private ObsoletePolynomial constant5Polynomial;
    private ObsoletePolynomial twoXPlus3Polynomial;
    private ObsoletePolynomial fourX4ThreeX3TwoX2OneX1Polynomial;

    @BeforeEach
    public void setUp() {
        this.constant5Polynomial = new ObsoletePolynomial(new double[]{5.0});
        this.twoXPlus3Polynomial = new ObsoletePolynomial(new double[]{2.0, 3.0});
        this.fourX4ThreeX3TwoX2OneX1Polynomial = new ObsoletePolynomial(new double[]{4.0, 3.0, 2.0, 1.0, 0.0});
    }

    @AfterEach
    public void tearDown() {
        this.constant5Polynomial = null;
        this.twoXPlus3Polynomial = null;
        this.fourX4ThreeX3TwoX2OneX1Polynomial = null;
    }

    @Test
    public void testConstructFromRealRoot() {
        double realRoot = 7.7;
        ObsoletePolynomial polynomial = ObsoletePolynomial.constructFromRealRoot((double)realRoot);
        Assert.assertEquals(0.0, polynomial.evaluate(realRoot), 1.0E-7);
        Assert.assertEquals(-realRoot, polynomial.evaluate(0.0), 1.0E-7);
    }

    @Test
    public void testConstructFromScaleFactorAndRoots() {
        double scaleFactor = 3.3;
        double[] realRoots = new double[]{1.1, 2.7, 3.91};
        ComplexNumber[] complexRootPairs = new ComplexNumber[]{new ComplexNumber(10.2, 7.7), new ComplexNumber(7.9, 3.3)};
        ObsoletePolynomial polynomial = ObsoletePolynomial.constructFromScaleFactorAndRoots((double)scaleFactor, (double[])realRoots, (ComplexNumber[])complexRootPairs);
        double[] objectArray = realRoots;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Double realRoot = objectArray[i];
            Assert.assertEquals(0.0, polynomial.evaluate(realRoot.doubleValue()), 1.0E-7);
        }
        for (ComplexNumber complexRoot : complexRootPairs) {
            this.verifyEpsilonEquals(new ComplexNumber(0.0, 0.0), polynomial.evaluate(complexRoot), 1.0E-6);
        }
    }

    @Test
    public void testConstructFromComplexPairRoot() {
        this.verifyComplexPair(2.1, 3.3);
        this.verifyComplexPair(5.0, 0.0);
        this.verifyComplexPair(0.0, 5.0);
    }

    private void verifyComplexPair(double real, double imag) {
        ComplexNumber complexNumber = new ComplexNumber(real, imag);
        ObsoletePolynomial polynomial = ObsoletePolynomial.constructFromComplexPairRoot((ComplexNumber)complexNumber);
        double x = 3.7;
        double expectedValue = x * x - 2.0 * real * x + real * real + imag * imag;
        double evaluation = polynomial.evaluate(x);
        Assert.assertEquals(expectedValue, evaluation, 1.0E-7);
    }

    @Test
    public void testEvaluate() {
        this.verifyEvaluations(0.0);
        this.verifyEvaluations(1.0);
        this.verifyEvaluations(7.17);
        this.verifyEvaluations(new ComplexNumber(0.0, 0.0));
        this.verifyEvaluations(new ComplexNumber(1.0, 0.0));
        this.verifyEvaluations(new ComplexNumber(0.0, 1.0));
        this.verifyEvaluations(new ComplexNumber(5.76, 3.96));
    }

    @Test
    public void testSetQuintic() {
        ObsoletePolynomial quintic = new ObsoletePolynomial(new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0});
        quintic.setQuintic(0.0, 1.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0);
        Assert.assertEquals(quintic.evaluate(0.0), 1.0, 1.0E-7);
        Assert.assertEquals(quintic.evaluateDerivative(0.0), 2.0, 1.0E-7);
        Assert.assertEquals(quintic.evaluateDoubleDerivative(0.0), 3.0, 1.0E-7);
        Assert.assertEquals(quintic.evaluate(1.0), 4.0, 1.0E-7);
        Assert.assertEquals(quintic.evaluateDerivative(1.0), 5.0, 1.0E-7);
        Assert.assertEquals(quintic.evaluateDoubleDerivative(1.0), 6.0, 1.0E-7);
        quintic.setQuintic(-1.0, 1.0, 1.0, -2.0, 3.0, -4.0, -5.0, 6.0);
        Assert.assertEquals(quintic.evaluate(-1.0), 1.0, 1.0E-7);
        Assert.assertEquals(quintic.evaluateDerivative(-1.0), -2.0, 1.0E-7);
        Assert.assertEquals(quintic.evaluateDoubleDerivative(-1.0), 3.0, 1.0E-7);
        Assert.assertEquals(quintic.evaluate(1.0), -4.0, 1.0E-7);
        Assert.assertEquals(quintic.evaluateDerivative(1.0), -5.0, 1.0E-7);
        Assert.assertEquals(quintic.evaluateDoubleDerivative(1.0), 6.0, 1.0E-7);
    }

    @Test
    public void testSetCubic() {
        ObsoletePolynomial quintic = new ObsoletePolynomial(new double[]{1.0, 1.0, 1.0, 1.0});
        quintic.setCubic(-1.0, 1.0, 1.0, 2.0, 3.0, 4.0);
        Assert.assertEquals(quintic.evaluate(-1.0), 1.0, 1.0E-7);
        Assert.assertEquals(quintic.evaluateDerivative(-1.0), 2.0, 1.0E-7);
        Assert.assertEquals(quintic.evaluate(1.0), 3.0, 1.0E-7);
        Assert.assertEquals(quintic.evaluateDerivative(1.0), 4.0, 1.0E-7);
        quintic.setCubic(0.0, 1.0, 3.0, 1.0, 4.0, 2.0);
        Assert.assertEquals(quintic.evaluate(0.0), 3.0, 1.0E-7);
        Assert.assertEquals(quintic.evaluateDerivative(0.0), 1.0, 1.0E-7);
        Assert.assertEquals(quintic.evaluate(1.0), 4.0, 1.0E-7);
        Assert.assertEquals(quintic.evaluateDerivative(1.0), 2.0, 1.0E-7);
    }

    @Test
    public void testDerivatives() {
        double[] expectedCoeffs = this.constant5Polynomial.getDerivativeCoefficients();
        Assert.assertTrue(expectedCoeffs.length == 1);
        Assert.assertTrue(expectedCoeffs[0] == 0.0);
        expectedCoeffs = this.twoXPlus3Polynomial.getDerivativeCoefficients();
        Assert.assertTrue(expectedCoeffs.length == 1);
        Assert.assertTrue(expectedCoeffs[0] == 2.0);
        expectedCoeffs = this.fourX4ThreeX3TwoX2OneX1Polynomial.getDerivativeCoefficients();
        Assert.assertTrue(expectedCoeffs.length == 4);
        Assert.assertTrue(expectedCoeffs[0] == 16.0);
        Assert.assertTrue(expectedCoeffs[1] == 9.0);
        Assert.assertTrue(expectedCoeffs[2] == 4.0);
        Assert.assertTrue(expectedCoeffs[3] == 1.0);
    }

    @Test
    public void testDoubleDerivatives() {
        double[] expectedCoeffs = this.constant5Polynomial.getDoubleDerivativeCoefficients();
        Assert.assertTrue(expectedCoeffs.length == 1);
        Assert.assertTrue(expectedCoeffs[0] == 0.0);
        expectedCoeffs = this.twoXPlus3Polynomial.getDoubleDerivativeCoefficients();
        Assert.assertTrue(expectedCoeffs.length == 1);
        Assert.assertTrue(expectedCoeffs[0] == 0.0);
        expectedCoeffs = this.fourX4ThreeX3TwoX2OneX1Polynomial.getDoubleDerivativeCoefficients();
        Assert.assertTrue(expectedCoeffs.length == 3);
        Assert.assertTrue(expectedCoeffs[0] == 48.0);
        Assert.assertTrue(expectedCoeffs[1] == 18.0);
        Assert.assertTrue(expectedCoeffs[2] == 4.0);
    }

    private void verifyEvaluations(double x) {
        double x2 = x * x;
        double x3 = x * x * x;
        double x4 = x * x * x * x;
        double epsilon = 1.0E-7;
        Assert.assertEquals(5.0, this.constant5Polynomial.evaluate(x), epsilon);
        Assert.assertEquals(2.0 * x + 3.0, this.twoXPlus3Polynomial.evaluate(x), epsilon);
        Assert.assertEquals(4.0 * x4 + 3.0 * x3 + 2.0 * x2 + 1.0 * x + 0.0, this.fourX4ThreeX3TwoX2OneX1Polynomial.evaluate(x), epsilon);
    }

    private void verifyEvaluations(ComplexNumber x) {
        ComplexNumber x2 = x.times(x);
        ComplexNumber x3 = x2.times(x);
        ComplexNumber x4 = x3.times(x);
        double epsilon = 1.0E-7;
        this.verifyEpsilonEquals(new ComplexNumber(5.0, 0.0), this.constant5Polynomial.evaluate(x), epsilon);
        ComplexNumber twoXPlus3 = x.times(2.0).plus(new ComplexNumber(3.0, 0.0));
        this.verifyEpsilonEquals(twoXPlus3, this.twoXPlus3Polynomial.evaluate(x), epsilon);
        ComplexNumber fourX4ThreeX3TwoX2OneX1 = x4.times(4.0).plus(x3.times(3.0).plus(x2.times(2.0).plus(x.times(1.0))));
        this.verifyEpsilonEquals(fourX4ThreeX3TwoX2OneX1, this.fourX4ThreeX3TwoX2OneX1Polynomial.evaluate(x), 1.0E-7);
    }

    @Test
    public void testGetOrder() {
        Assert.assertEquals(0L, this.constant5Polynomial.getOrder());
        Assert.assertEquals(1L, this.twoXPlus3Polynomial.getOrder());
        Assert.assertEquals(4L, this.fourX4ThreeX3TwoX2OneX1Polynomial.getOrder());
    }

    @Test
    public void testGetCoefficients() {
        this.verifyEpsilonEquals(new double[]{5.0}, this.constant5Polynomial.getCoefficients(), 1.0E-7);
        this.verifyEpsilonEquals(new double[]{2.0, 3.0}, this.twoXPlus3Polynomial.getCoefficients(), 1.0E-7);
        this.verifyEpsilonEquals(new double[]{4.0, 3.0, 2.0, 1.0, 0.0}, this.fourX4ThreeX3TwoX2OneX1Polynomial.getCoefficients(), 1.0E-7);
    }

    @Test
    public void testImmutable() {
        double[] coefficients = this.constant5Polynomial.getCoefficients();
        coefficients[0] = 9.99;
        this.verifyEpsilonEquals(new double[]{5.0}, this.constant5Polynomial.getCoefficients(), 1.0E-7);
    }

    private void verifyEpsilonEquals(double[] expectedArray, double[] actualArray, double epsilon) {
        Assert.assertEquals(expectedArray.length, actualArray.length);
        for (int i = 0; i < expectedArray.length; ++i) {
            Assert.assertEquals(expectedArray[i], actualArray[i], epsilon);
        }
    }

    private void verifyEpsilonEquals(ComplexNumber expectedComplexNumber, ComplexNumber actualComplexNumber, double epsilon) {
        Assert.assertEquals(expectedComplexNumber.real(), actualComplexNumber.real(), epsilon);
        Assert.assertEquals(expectedComplexNumber.imag(), actualComplexNumber.imag(), epsilon);
    }

    @Test
    public void testTimes() {
        ObsoletePolynomial tenXPlus15Polynomial = this.constant5Polynomial.times(this.twoXPlus3Polynomial);
        this.verifyEpsilonEquals(new double[]{10.0, 15.0}, tenXPlus15Polynomial.getCoefficients(), 1.0E-7);
        ObsoletePolynomial multipliedPolynomial = this.twoXPlus3Polynomial.times(this.fourX4ThreeX3TwoX2OneX1Polynomial);
        this.verifyEpsilonEquals(new double[]{8.0, 18.0, 13.0, 8.0, 3.0, 0.0}, multipliedPolynomial.getCoefficients(), 1.0E-7);
    }

    @Test
    public void testTimesScalar() {
        ObsoletePolynomial eighteenXPlus27Polynomial = this.twoXPlus3Polynomial.times(9.0);
        this.verifyEpsilonEquals(new double[]{18.0, 27.0}, eighteenXPlus27Polynomial.getCoefficients(), 1.0E-7);
    }

    @Test
    public void testPlus() {
        ObsoletePolynomial twoXPlus8Polynomial = this.constant5Polynomial.plus(this.twoXPlus3Polynomial);
        this.verifyEpsilonEquals(new double[]{2.0, 8.0}, twoXPlus8Polynomial.getCoefficients(), 1.0E-7);
        ObsoletePolynomial plusPolynomial = this.twoXPlus3Polynomial.plus(this.fourX4ThreeX3TwoX2OneX1Polynomial);
        this.verifyEpsilonEquals(new double[]{4.0, 3.0, 2.0, 3.0, 3.0}, plusPolynomial.getCoefficients(), 1.0E-7);
        ObsoletePolynomial zero = new ObsoletePolynomial(new double[]{0.0});
        ObsoletePolynomial zero2 = new ObsoletePolynomial(new double[]{0.0});
        ObsoletePolynomial zero3 = zero.plus(zero2);
        Assert.assertTrue(zero3.epsilonEquals(zero, 1.0E-7));
    }

    @Test
    public void testEpsilonEquals() {
        Assert.assertTrue(this.constant5Polynomial.epsilonEquals(this.constant5Polynomial, 1.0E-30));
        Assert.assertTrue(this.twoXPlus3Polynomial.epsilonEquals(this.twoXPlus3Polynomial.plus(new ObsoletePolynomial(new double[]{0.0})), 1.0E-30));
        Assert.assertFalse(this.twoXPlus3Polynomial.epsilonEquals(this.twoXPlus3Polynomial.plus(new ObsoletePolynomial(new double[]{1.0})), 0.1));
    }

    @Test
    public void testToString() {
        Assert.assertEquals("5.0", this.constant5Polynomial.toString());
        Assert.assertEquals("2.0 * x + 3.0", this.twoXPlus3Polynomial.toString());
        Assert.assertEquals("4.0 * x^4 + 3.0 * x^3 + 2.0 * x^2 + 1.0 * x + 0.0", this.fourX4ThreeX3TwoX2OneX1Polynomial.toString());
    }

    @Test
    public void testEqualsZero() {
        ObsoletePolynomial zeroPolynomial = new ObsoletePolynomial(new double[]{0.0});
        ObsoletePolynomial zeroPolynomial2 = new ObsoletePolynomial(new double[]{0.0, 0.0});
        ObsoletePolynomial nonZeroPolynomial = new ObsoletePolynomial(new double[]{1.0, 0.1});
        ObsoletePolynomial nonZeroPolynomial2 = new ObsoletePolynomial(new double[]{0.0, 0.1});
        Assert.assertTrue(zeroPolynomial.equalsZero());
        Assert.assertTrue(zeroPolynomial2.equalsZero());
        Assert.assertFalse(nonZeroPolynomial.equalsZero());
        Assert.assertFalse(nonZeroPolynomial2.equalsZero());
    }
}

