/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers.stiction;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.controllers.stiction.ConstantStictionModel;
import us.ihmc.robotics.controllers.stiction.StictionCompensator;
import us.ihmc.robotics.controllers.stiction.StictionModel;
import us.ihmc.yoVariables.parameters.DefaultParameterReader;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class StictionCompensatorTest {
    private static final int iters = 100;
    private static final double epsilon = 1.0E-8;
    private static final double controlDT = 0.01;

    @Test
    public void testSetDesiredTorque() {
        YoRegistry registry = new YoRegistry("test");
        YoDouble constantStictionProvider = new YoDouble("constantStictionProvider", registry);
        ConstantStictionModel stictionModel = new ConstantStictionModel((DoubleProvider)constantStictionProvider);
        StictionCompensator stictionCompensator = new StictionCompensator("", (StictionModel)stictionModel, 0.01, registry);
        Random random = new Random(1738L);
        for (int iter = 0; iter < 100; ++iter) {
            double desiredTorqueExpected = RandomNumbers.nextDouble((Random)random, (double)-1000.0, (double)1000.0);
            stictionCompensator.setDesiredTorque(desiredTorqueExpected);
            Assert.assertEquals(desiredTorqueExpected, stictionCompensator.getDesiredTorque(), 1.0E-8);
        }
    }

    @Test
    public void testResetStictionCompensation() {
        YoRegistry registry = new YoRegistry("test");
        YoDouble constantStictionProvider = new YoDouble("constantStictionProvider", registry);
        ConstantStictionModel stictionModel = new ConstantStictionModel((DoubleProvider)constantStictionProvider);
        StictionCompensator stictionCompensator = new StictionCompensator("", (StictionModel)stictionModel, 0.01, registry);
        YoDouble stictionCompensationLimit = (YoDouble)registry.findVariable("_StictionCompensationLimit");
        YoDouble stictionCompensation = (YoDouble)registry.findVariable("_StictionCompensation");
        Random random = new Random(1738L);
        for (int iter = 0; iter < 100; ++iter) {
            stictionCompensationLimit.set(RandomNumbers.nextDouble((Random)random, (double)1000.0));
            stictionCompensation.set(RandomNumbers.nextDouble((Random)random, (double)1000.0));
            Assert.assertNotEquals(0.0, stictionCompensationLimit.getDoubleValue(), 1.0E-8);
            Assert.assertNotEquals(0.0, stictionCompensation.getDoubleValue(), 1.0E-8);
            stictionCompensator.resetStictionCompensation();
            Assert.assertEquals(0.0, stictionCompensationLimit.getDoubleValue(), 1.0E-8);
            Assert.assertEquals(0.0, stictionCompensation.getDoubleValue(), 1.0E-8);
        }
    }

    @Test
    public void testComputeStictionCompensation() {
        YoRegistry registry = new YoRegistry("test");
        YoDouble constantStictionProvider = new YoDouble("constantStictionProvider", registry);
        ConstantStictionModel stictionModel = new ConstantStictionModel((DoubleProvider)constantStictionProvider);
        StictionCompensator stictionCompensator = new StictionCompensator("", (StictionModel)stictionModel, 0.01, registry);
        YoDouble stictionCompensationLimit = (YoDouble)registry.findVariable("_StictionCompensationLimit");
        YoDouble yoStictionCompensation = (YoDouble)registry.findVariable("_StictionCompensation");
        YoDouble stictionCompensationRate = (YoDouble)registry.findVariable("_StictionCompensationRate");
        YoDouble desiredTorqueStictionLimitFactor = (YoDouble)registry.findVariable("_DesiredTorqueStictionLimitFactor");
        YoDouble minTimeInMode = (YoDouble)registry.findVariable("_MinTimeInMode");
        YoEnum actionMode = (YoEnum)registry.findVariable("_StictionActionMode");
        DefaultParameterReader reader = new DefaultParameterReader();
        reader.readParametersInRegistry(registry);
        stictionCompensator.computeStictionCompensation();
        Random random = new Random(1738L);
        double expectedStictionCompensation = 0.0;
        for (int iter = 0; iter < 100; ++iter) {
            double stictionMagnitude = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)10.0);
            double limitFactor = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)10.0);
            double expectedDesiredTorque = RandomNumbers.nextDouble((Random)random, (double)50.0);
            double maxRate = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)100.0);
            constantStictionProvider.set(stictionMagnitude);
            desiredTorqueStictionLimitFactor.set(limitFactor);
            stictionCompensationRate.set(maxRate);
            stictionCompensator.setDesiredTorque(expectedDesiredTorque);
            stictionCompensator.setDesiredAcceleration(5.0 * Math.signum(expectedDesiredTorque));
            stictionCompensator.setVelocities(5.0 * Math.signum(expectedDesiredTorque), 5.0 * Math.signum(expectedDesiredTorque));
            actionMode.set((Enum)StictionCompensator.StictionActionMode.Moving);
            double stictionCompensation = stictionCompensator.computeStictionCompensation();
            Assert.assertEquals(stictionCompensation, yoStictionCompensation.getDoubleValue(), 1.0E-8);
            Assert.assertEquals(stictionCompensation, stictionCompensator.getStictionCompensation(), 1.0E-8);
            double torqueSign = Math.signum(expectedDesiredTorque);
            double maxCompensationFromTorque = torqueSign * limitFactor * expectedDesiredTorque;
            double expectedCompensationLimit = Math.min(maxCompensationFromTorque, stictionMagnitude);
            Assert.assertEquals(expectedCompensationLimit, stictionCompensationLimit.getDoubleValue(), 1.0E-8);
            double expectedCompensation = torqueSign * expectedCompensationLimit;
            double expectedCompensationLowerLimit = expectedStictionCompensation - maxRate * 0.01;
            double expectedCompensationUpperLimit = expectedStictionCompensation + maxRate * 0.01;
            expectedStictionCompensation = MathTools.clamp((double)expectedCompensation, (double)expectedCompensationLowerLimit, (double)expectedCompensationUpperLimit);
            Assert.assertEquals("Iter " + iter, expectedStictionCompensation, stictionCompensation, 1.0E-8);
        }
    }

    @Test
    public void testActionForwardMode() {
        YoRegistry registry = new YoRegistry("test");
        YoDouble constantStictionProvider = new YoDouble("constantStictionProvider", registry);
        ConstantStictionModel stictionModel = new ConstantStictionModel((DoubleProvider)constantStictionProvider);
        StictionCompensator stictionCompensator = new StictionCompensator("", (StictionModel)stictionModel, 0.01, registry);
        YoDouble minTimeInMode = (YoDouble)registry.findVariable("_MinTimeInMode");
        YoEnum actionMode = (YoEnum)registry.findVariable("_StictionActionMode");
        DefaultParameterReader reader = new DefaultParameterReader();
        reader.readParametersInRegistry(registry);
        StictionCompensator.StictionActionMode currentExpectedMode = (StictionCompensator.StictionActionMode)actionMode.getEnumValue();
        stictionCompensator.setVelocities(1.0, 1.0);
        stictionCompensator.setDesiredAcceleration(5.0);
        stictionCompensator.setDesiredTorque(5.0);
        int i = 0;
        while ((double)i < minTimeInMode.getDoubleValue() / 0.01) {
            stictionCompensator.computeStictionCompensation();
            Assert.assertEquals(currentExpectedMode, actionMode.getEnumValue());
            ++i;
        }
        stictionCompensator.computeStictionCompensation();
        currentExpectedMode = StictionCompensator.StictionActionMode.Accelerating;
        Assert.assertEquals(currentExpectedMode, actionMode.getEnumValue());
        stictionCompensator.setDesiredAcceleration(0.0);
        i = 0;
        while ((double)i < minTimeInMode.getDoubleValue() / 0.01) {
            stictionCompensator.computeStictionCompensation();
            Assert.assertEquals(currentExpectedMode, actionMode.getEnumValue());
            ++i;
        }
        stictionCompensator.computeStictionCompensation();
        currentExpectedMode = StictionCompensator.StictionActionMode.Moving;
        Assert.assertEquals(currentExpectedMode, actionMode.getEnumValue());
        stictionCompensator.setDesiredAcceleration(-5.0);
        i = 0;
        while ((double)i < minTimeInMode.getDoubleValue() / 0.01) {
            stictionCompensator.computeStictionCompensation();
            Assert.assertEquals(currentExpectedMode, actionMode.getEnumValue());
            ++i;
        }
        stictionCompensator.computeStictionCompensation();
        currentExpectedMode = StictionCompensator.StictionActionMode.Braking;
        Assert.assertEquals(currentExpectedMode, actionMode.getEnumValue());
    }

    @Test
    public void testActionBackwardMode() {
        YoRegistry registry = new YoRegistry("test");
        YoDouble constantStictionProvider = new YoDouble("constantStictionProvider", registry);
        ConstantStictionModel stictionModel = new ConstantStictionModel((DoubleProvider)constantStictionProvider);
        StictionCompensator stictionCompensator = new StictionCompensator("", (StictionModel)stictionModel, 0.01, registry);
        YoDouble minTimeInMode = (YoDouble)registry.findVariable("_MinTimeInMode");
        YoEnum actionMode = (YoEnum)registry.findVariable("_StictionActionMode");
        DefaultParameterReader reader = new DefaultParameterReader();
        reader.readParametersInRegistry(registry);
        StictionCompensator.StictionActionMode currentExpectedMode = (StictionCompensator.StictionActionMode)actionMode.getEnumValue();
        stictionCompensator.setVelocities(-1.0, -1.0);
        stictionCompensator.setDesiredAcceleration(-5.0);
        stictionCompensator.setDesiredTorque(-5.0);
        int i = 0;
        while ((double)i < minTimeInMode.getDoubleValue() / 0.01) {
            stictionCompensator.computeStictionCompensation();
            Assert.assertEquals(currentExpectedMode, actionMode.getEnumValue());
            ++i;
        }
        stictionCompensator.computeStictionCompensation();
        currentExpectedMode = StictionCompensator.StictionActionMode.Accelerating;
        Assert.assertEquals(currentExpectedMode, actionMode.getEnumValue());
        stictionCompensator.setDesiredAcceleration(0.0);
        i = 0;
        while ((double)i < minTimeInMode.getDoubleValue() / 0.01) {
            stictionCompensator.computeStictionCompensation();
            Assert.assertEquals(currentExpectedMode, actionMode.getEnumValue());
            ++i;
        }
        stictionCompensator.computeStictionCompensation();
        currentExpectedMode = StictionCompensator.StictionActionMode.Moving;
        Assert.assertEquals(currentExpectedMode, actionMode.getEnumValue());
        stictionCompensator.setDesiredAcceleration(5.0);
        i = 0;
        while ((double)i < minTimeInMode.getDoubleValue() / 0.01) {
            stictionCompensator.computeStictionCompensation();
            Assert.assertEquals(currentExpectedMode, actionMode.getEnumValue());
            ++i;
        }
        stictionCompensator.computeStictionCompensation();
        currentExpectedMode = StictionCompensator.StictionActionMode.Braking;
        Assert.assertEquals(currentExpectedMode, actionMode.getEnumValue());
    }
}

