/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.controllers.pidGains.implementations.YoPDGains;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoPDGainsTest {
    @Test
    public void testParameters() {
        YoPDGains gains = new YoPDGains("pdGains", new YoRegistry("testRegistry"));
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            double kp = rand.nextDouble() * 100.0;
            double kd = rand.nextDouble() * 100.0;
            double maxAcc = rand.nextDouble() * 100.0;
            double maxJerk = rand.nextDouble() * 100.0;
            double zeta = rand.nextDouble() * 100.0;
            double deadband = rand.nextDouble() * 100.0;
            gains.setKd(kd);
            gains.setKp(kp);
            gains.setMaximumFeedback(maxAcc);
            gains.setMaximumFeedbackRate(maxJerk);
            gains.setZeta(zeta);
            gains.setPositionDeadband(deadband);
            Assert.assertEquals(kp, gains.getKp(), 1.0E-6);
            Assert.assertEquals(kp, gains.getYoKp().getDoubleValue(), 1.0E-6);
            Assert.assertEquals(kd, gains.getKd(), 1.0E-6);
            Assert.assertEquals(kd, gains.getYoKd().getDoubleValue(), 1.0E-6);
            Assert.assertEquals(maxAcc, gains.getMaximumFeedback(), 1.0E-6);
            Assert.assertEquals(maxAcc, gains.getYoMaximumFeedback().getDoubleValue(), 1.0E-6);
            Assert.assertEquals(maxJerk, gains.getMaximumFeedbackRate(), 1.0E-6);
            Assert.assertEquals(maxJerk, gains.getYoMaximumFeedbackRate().getDoubleValue(), 1.0E-6);
            Assert.assertEquals(zeta, gains.getZeta(), 1.0E-6);
            Assert.assertEquals(zeta, gains.getYoZeta().getDoubleValue(), 1.0E-6);
            Assert.assertEquals(deadband, gains.getPositionDeadband(), 1.0E-6);
            Assert.assertEquals(deadband, gains.getYoPositionDeadband().getDoubleValue(), 1.0E-6);
        }
    }

    @Test
    public void testParameters_2() {
        YoPDGains gains = new YoPDGains("pdGains", new YoRegistry("testRegistry"));
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            double kp = rand.nextDouble() * 100.0;
            double maxAcc = rand.nextDouble() * 100.0;
            double maxJerk = rand.nextDouble() * 100.0;
            double zeta = rand.nextDouble() * 100.0;
            gains.setPDGains(kp, zeta);
            gains.setMaximumFeedbackAndMaximumFeedbackRate(maxAcc, maxJerk);
            Assert.assertEquals(kp, gains.getKp(), 1.0E-6);
            Assert.assertEquals(0.0, gains.getKd(), 1.0E-6);
            Assert.assertEquals(maxAcc, gains.getMaximumFeedback(), 1.0E-6);
            Assert.assertEquals(maxJerk, gains.getMaximumFeedbackRate(), 1.0E-6);
            Assert.assertEquals(zeta, gains.getZeta(), 1.0E-6);
            Assert.assertEquals(0.0, gains.getPositionDeadband(), 1.0E-6);
            Assert.assertEquals(0.0, gains.getYoPositionDeadband().getDoubleValue(), 1.0E-6);
        }
    }
}

