/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.controllers.PIDController;
import us.ihmc.robotics.controllers.pidGains.implementations.YoPIDGains;
import us.ihmc.tools.MemoryTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class PIDControllerTest {
    private final Random random = new Random();

    @BeforeEach
    public void showMemoryUsageBeforeTest() {
        MemoryTools.printCurrentMemoryUsageAndReturnUsedMemoryInMB((String)(this.getClass().getSimpleName() + " before test."));
    }

    @AfterEach
    public void showMemoryUsageAfterTest() {
        MemoryTools.printCurrentMemoryUsageAndReturnUsedMemoryInMB((String)(this.getClass().getSimpleName() + " after test."));
    }

    @Test
    public void testPIDControllerConstructor() {
        YoRegistry registry = new YoRegistry("mike");
        YoDouble proportional = new YoDouble("proportional", registry);
        proportional.set(2.0);
        YoDouble integral = new YoDouble("integral", registry);
        integral.set(3.0);
        YoDouble derivative = new YoDouble("derivative", registry);
        derivative.set(4.0);
        YoDouble maxError = new YoDouble("maxError", registry);
        maxError.set(10.0);
        new PIDController(proportional, integral, derivative, maxError, "", registry);
        Assert.assertEquals(2.0, proportional.getDoubleValue(), 0.001);
        Assert.assertEquals(3.0, integral.getDoubleValue(), 0.001);
        Assert.assertEquals(4.0, derivative.getDoubleValue(), 0.001);
        Assert.assertEquals(10.0, maxError.getDoubleValue(), 0.001);
    }

    @Test
    public void testPIDControllerConstructorFromGains() {
        YoRegistry registry = new YoRegistry("robert");
        double proportional = this.random.nextDouble();
        double integral = this.random.nextDouble();
        double derivative = this.random.nextDouble();
        double maxError = this.random.nextDouble();
        double deadband = this.random.nextDouble();
        double leakRate = this.random.nextDouble();
        double maxOutput = 100.0 * this.random.nextDouble();
        YoPIDGains pidGains = new YoPIDGains("", registry);
        pidGains.setKp(proportional);
        pidGains.setKi(integral);
        pidGains.setKd(derivative);
        pidGains.setMaximumIntegralError(maxError);
        pidGains.setPositionDeadband(deadband);
        pidGains.setIntegralLeakRatio(leakRate);
        pidGains.setMaximumFeedback(maxOutput);
        PIDController pid = new PIDController(pidGains, "", registry);
        Assert.assertEquals(proportional, pid.getProportionalGain(), 0.001);
        Assert.assertEquals(integral, pid.getIntegralGain(), 0.001);
        Assert.assertEquals(derivative, pid.getDerivativeGain(), 0.001);
        Assert.assertEquals(maxError, pid.getMaxIntegralError(), 0.001);
        Assert.assertEquals(deadband, pid.getPositionDeadband(), 0.001);
        Assert.assertEquals(leakRate, pid.getIntegralLeakRatio(), 0.001);
        Assert.assertEquals(maxOutput, pid.getMaximumFeedback(), 1.0E-5);
    }

    @Test
    public void testPIDControllerConstructorFromGains2() {
        YoRegistry registry = new YoRegistry("robert");
        double proportional = this.random.nextDouble();
        double integral = this.random.nextDouble();
        double derivative = this.random.nextDouble();
        double maxError = this.random.nextDouble();
        double deadband = this.random.nextDouble();
        double maxOutput = this.random.nextDouble() * 100.0;
        YoPIDGains pidGains = new YoPIDGains("", registry);
        pidGains.setKp(proportional);
        pidGains.setKi(integral);
        pidGains.setKd(derivative);
        pidGains.setMaximumIntegralError(maxError);
        pidGains.setPositionDeadband(deadband);
        pidGains.setMaximumFeedback(maxOutput);
        PIDController pid = new PIDController(pidGains, "", registry);
        Assert.assertEquals(proportional, pid.getProportionalGain(), 0.001);
        Assert.assertEquals(integral, pid.getIntegralGain(), 0.001);
        Assert.assertEquals(derivative, pid.getDerivativeGain(), 0.001);
        Assert.assertEquals(maxError, pid.getMaxIntegralError(), 0.001);
        Assert.assertEquals(deadband, pid.getPositionDeadband(), 0.001);
        Assert.assertEquals(maxOutput, pid.getMaximumFeedback(), 0.001);
        Assert.assertEquals(1.0, pid.getIntegralLeakRatio(), 0.001);
    }

    @Test
    public void testPIDControllerConstructorFromGains3() {
        YoRegistry registry = new YoRegistry("robert");
        double proportional = this.random.nextDouble();
        double integral = this.random.nextDouble();
        double derivative = this.random.nextDouble();
        double maxIntegralError = this.random.nextDouble();
        double maxOutput = this.random.nextDouble() * 100.0;
        YoPIDGains pidGains = new YoPIDGains("", registry);
        pidGains.setKp(proportional);
        pidGains.setKi(integral);
        pidGains.setKd(derivative);
        pidGains.setMaximumIntegralError(maxIntegralError);
        pidGains.setMaximumFeedback(maxOutput);
        PIDController pid = new PIDController(pidGains, "", registry);
        Assert.assertEquals(proportional, pid.getProportionalGain(), 0.001);
        Assert.assertEquals(integral, pid.getIntegralGain(), 0.001);
        Assert.assertEquals(derivative, pid.getDerivativeGain(), 0.001);
        Assert.assertEquals(maxIntegralError, pid.getMaxIntegralError(), 0.001);
        Assert.assertEquals(maxOutput, pid.getMaximumFeedback(), 1.0E-5);
        Assert.assertEquals(0.0, pid.getPositionDeadband(), 0.001);
        Assert.assertEquals(1.0, pid.getIntegralLeakRatio(), 0.001);
    }

    @Test
    public void testPIDControllerConstructorFromGains4() {
        YoRegistry registry = new YoRegistry("robert");
        double proportional = this.random.nextDouble();
        double integral = this.random.nextDouble();
        double derivative = this.random.nextDouble();
        double maxIntegralError = this.random.nextDouble();
        YoPIDGains pidGains = new YoPIDGains("", registry);
        pidGains.setKp(proportional);
        pidGains.setKi(integral);
        pidGains.setKd(derivative);
        pidGains.setMaximumIntegralError(maxIntegralError);
        PIDController pid = new PIDController(pidGains, "", registry);
        Assert.assertEquals(proportional, pid.getProportionalGain(), 0.001);
        Assert.assertEquals(integral, pid.getIntegralGain(), 0.001);
        Assert.assertEquals(derivative, pid.getDerivativeGain(), 0.001);
        Assert.assertEquals(maxIntegralError, pid.getMaxIntegralError(), 0.001);
        Assert.assertEquals(Double.POSITIVE_INFINITY, pid.getMaximumFeedback(), 0.001);
        Assert.assertEquals(0.0, pid.getPositionDeadband(), 0.001);
        Assert.assertEquals(1.0, pid.getIntegralLeakRatio(), 0.001);
    }

    @Test
    public void testGetProportionalGain() {
        YoRegistry registry = new YoRegistry("mike");
        PIDController pid = new PIDController("", registry);
        Assert.assertEquals(0.0, pid.getProportionalGain(), 0.001);
    }

    @Test
    public void testGetIntegralGain() {
        YoRegistry registry = new YoRegistry("mike");
        PIDController pid = new PIDController("", registry);
        Assert.assertEquals(0.0, pid.getIntegralGain(), 0.001);
    }

    @Test
    public void testGetDerivativeGain() {
        YoRegistry registry = new YoRegistry("mike");
        PIDController pid = new PIDController("", registry);
        Assert.assertEquals(0.0, pid.getDerivativeGain(), 0.001);
    }

    @Test
    public void testGetDeadband() {
        YoRegistry registry = new YoRegistry("robert");
        PIDController pid = new PIDController("", registry);
        Assert.assertEquals(0.0, pid.getPositionDeadband(), 0.001);
    }

    @Test
    public void testGetMaxIntegralError() {
        YoRegistry registry = new YoRegistry("mike");
        PIDController pid = new PIDController("", registry);
        Assert.assertEquals(Double.POSITIVE_INFINITY, pid.getMaxIntegralError(), 0.001);
    }

    @Test
    public void testGetCumulativeError() {
        YoRegistry registry = new YoRegistry("mike");
        PIDController pid = new PIDController("", registry);
        Assert.assertEquals(0.0, pid.getCumulativeError(), 0.001);
    }

    @Test
    public void testGetLeakRate() {
        YoRegistry registry = new YoRegistry("robert");
        PIDController pid = new PIDController("", registry);
        Assert.assertEquals(1.0, pid.getIntegralLeakRatio(), 0.001);
    }

    @Test
    public void testSetProportionalGain() {
        YoRegistry registry = new YoRegistry("mike");
        PIDController pid = new PIDController("", registry);
        pid.setProportionalGain(5.0);
        Assert.assertEquals(5.0, pid.getProportionalGain(), 0.001);
    }

    @Test
    public void testSetIntegralGain() {
        YoRegistry registry = new YoRegistry("mike");
        PIDController pid = new PIDController("", registry);
        pid.setIntegralGain(5.0);
        Assert.assertEquals(5.0, pid.getIntegralGain(), 0.001);
    }

    @Test
    public void testSetDerivativeGain() {
        YoRegistry registry = new YoRegistry("mike");
        PIDController pid = new PIDController("", registry);
        pid.setDerivativeGain(5.0);
        Assert.assertEquals(5.0, pid.getDerivativeGain(), 0.001);
    }

    @Test
    public void testSetDeadband() {
        double deadband = this.random.nextDouble() * 10.0;
        YoRegistry registry = new YoRegistry("robert");
        PIDController pid = new PIDController("", registry);
        pid.setPositionDeadband(deadband);
        Assert.assertEquals(deadband, pid.getPositionDeadband(), 0.001);
    }

    @Test
    public void testSetMaxIntegralError() {
        YoRegistry registry = new YoRegistry("mike");
        PIDController pid = new PIDController("", registry);
        pid.setMaxIntegralError(5.0);
        Assert.assertEquals(5.0, pid.getMaxIntegralError(), 0.001);
    }

    @Test
    public void testSetCumulativeError() {
        YoRegistry registry = new YoRegistry("mike");
        PIDController pid = new PIDController("", registry);
        pid.setCumulativeError(5.0);
        Assert.assertEquals(5.0, pid.getCumulativeError(), 0.001);
    }

    @Test
    public void testSetIntegralLeakRatio() {
        double leakRatio = this.random.nextDouble();
        YoRegistry registry = new YoRegistry("robert");
        PIDController pid = new PIDController("", registry);
        pid.setIntegralLeakRatio(leakRatio);
        Assert.assertEquals(leakRatio, pid.getIntegralLeakRatio(), 0.001);
    }

    @Test
    public void testSetIntegralLeakRatio2() {
        YoRegistry registry = new YoRegistry("robert");
        PIDController pid = new PIDController("", registry);
        double leakRatio = this.random.nextDouble() * 100.0;
        pid.setIntegralLeakRatio(leakRatio);
        Assert.assertTrue(pid.getIntegralLeakRatio() <= 1.0);
        leakRatio = this.random.nextDouble() * -100.0;
        pid.setIntegralLeakRatio(leakRatio);
        Assert.assertTrue(pid.getIntegralLeakRatio() >= 0.0);
    }

    @Test
    public void testSetIntegralLeakRatio3() {
        YoRegistry registry = new YoRegistry("robert");
        PIDController pid = new PIDController("", registry);
        YoDouble yoLeakRatio = (YoDouble)registry.findVariable("leak_");
        double leakRatio = this.random.nextDouble();
        yoLeakRatio.set(leakRatio);
        Assert.assertEquals(leakRatio, yoLeakRatio.getDoubleValue(), 1.0E-5);
        Assert.assertEquals(leakRatio, pid.getIntegralLeakRatio(), 1.0E-5);
        leakRatio = this.random.nextDouble() * 100.0;
        yoLeakRatio.set(leakRatio);
        Assert.assertTrue(pid.getIntegralLeakRatio() <= 1.0);
        Assert.assertTrue(pid.getIntegralLeakRatio() >= 0.0);
        leakRatio = this.random.nextDouble() * -100.0;
        yoLeakRatio.set(leakRatio);
        Assert.assertTrue(pid.getIntegralLeakRatio() <= 1.0);
        Assert.assertTrue(pid.getIntegralLeakRatio() >= 0.0);
    }

    @Test
    public void testCompute() {
        YoRegistry registry = new YoRegistry("mike");
        YoDouble proportional = new YoDouble("proportional", registry);
        proportional.set(3.0);
        YoDouble integral = new YoDouble("integral", registry);
        integral.set(2.0);
        YoDouble derivative = new YoDouble("derivative", registry);
        derivative.set(1.0);
        YoDouble maxError = new YoDouble("maxError", registry);
        maxError.set(10.0);
        PIDController pid = new PIDController(proportional, integral, derivative, maxError, "", registry);
        double currentPosition = 0.0;
        double desiredPosition = 5.0;
        double currentRate = 0.0;
        double desiredRate = 1.0;
        Assert.assertEquals(17.0, pid.compute(currentPosition, desiredPosition, currentRate, desiredRate, 0.1), 0.001);
    }

    @Test
    public void testComputeFromYoPIDGains() {
        YoRegistry registry = new YoRegistry("robert");
        double proportional = 3.0;
        double integral = 2.0;
        double derivative = 1.0;
        double maxError = 10.0;
        YoPIDGains pidGains = new YoPIDGains("", registry);
        pidGains.setKp(proportional);
        pidGains.setKi(integral);
        pidGains.setKd(derivative);
        pidGains.setMaximumIntegralError(maxError);
        PIDController pid = new PIDController(pidGains, "", registry);
        double currentPosition = 0.0;
        double desiredPosition = 5.0;
        double currentRate = 0.0;
        double desiredRate = 1.0;
        Assert.assertEquals(17.0, pid.compute(currentPosition, desiredPosition, currentRate, desiredRate, 0.1), 0.001);
    }

    @Test
    public void testCompute_proportional() {
        PIDController pid = new PIDController("", null);
        pid.setProportionalGain(3.0);
        double currentPosition = 0.0;
        double desiredPosition = 5.0;
        double currentRate = 0.0;
        double desiredRate = 1.0;
        Assert.assertEquals(15.0, pid.compute(currentPosition, desiredPosition, currentRate, desiredRate, 0.1), 0.001);
        pid.setProportionalGain(6.0);
        Assert.assertEquals(30.0, pid.compute(currentPosition, desiredPosition, currentRate, desiredRate, 0.1), 0.001);
    }

    @Test
    public void testCompute_proportional_withDeadband() {
        PIDController pid = new PIDController("", null);
        pid.setProportionalGain(3.0);
        pid.setPositionDeadband(1.0);
        double currentPosition = 0.0;
        double desiredPosition = 5.0;
        double currentRate = 0.0;
        double desiredRate = 1.0;
        Assert.assertEquals(12.0, pid.compute(currentPosition, desiredPosition, currentRate, desiredRate, 0.1), 0.001);
        pid.setProportionalGain(6.0);
        pid.setPositionDeadband(4.0);
        Assert.assertEquals(6.0, pid.compute(currentPosition, desiredPosition, currentRate, desiredRate, 0.1), 0.001);
    }

    @Test
    public void testCompute_integral() {
        PIDController pid = new PIDController("", null);
        pid.setIntegralGain(4.0);
        double currentPosition = 0.0;
        double desiredPosition = 5.0;
        double currentRate = 0.0;
        double desiredRate = 3.0;
        Assert.assertEquals(2.0, pid.compute(currentPosition, desiredPosition, currentRate, desiredRate, 0.1), 0.001);
        pid.setIntegralGain(8.0);
        Assert.assertEquals(8.0, pid.compute(currentPosition, desiredPosition, currentRate, desiredRate, 0.1), 0.001);
    }

    @Test
    public void testCompute_derivative() {
        PIDController pid = new PIDController("", null);
        pid.setDerivativeGain(6.0);
        double currentPosition = 0.0;
        double desiredPosition = 5.0;
        double currentRate = 0.0;
        double desiredRate = 3.0;
        Assert.assertEquals(18.0, pid.compute(currentPosition, desiredPosition, currentRate, desiredRate, 0.1), 0.001);
        pid.setDerivativeGain(12.0);
        Assert.assertEquals(36.0, pid.compute(currentPosition, desiredPosition, currentRate, desiredRate, 0.1), 0.001);
    }

    @Test
    public void testCompute_all_PID() {
        PIDController pid = new PIDController("", null);
        pid.setProportionalGain(2.0);
        pid.setIntegralGain(3.0);
        pid.setDerivativeGain(4.0);
        pid.setMaxIntegralError(10.0);
        double currentPosition = 0.0;
        double desiredPosition = 5.0;
        double currentRate = 0.0;
        double desiredRate = 2.0;
        Assert.assertEquals(19.5, pid.compute(currentPosition, desiredPosition, currentRate, desiredRate, 0.1), 0.001);
        Assert.assertEquals(21.0, pid.compute(currentPosition, desiredPosition, currentRate, desiredRate, 0.1), 0.001);
        Assert.assertEquals(36.0, pid.compute(currentPosition, desiredPosition, currentRate, desiredRate, 1.0), 0.001);
        Assert.assertEquals(48.0, pid.compute(currentPosition, desiredPosition, currentRate, desiredRate, 1.01), 0.001);
    }

    @Test
    public void testCompute_all_PID_withDeadband() {
        PIDController pid = new PIDController("", null);
        pid.setProportionalGain(2.0);
        pid.setIntegralGain(3.0);
        pid.setDerivativeGain(4.0);
        pid.setMaxIntegralError(10.0);
        pid.setPositionDeadband(1.5);
        double currentPosition = 0.0;
        double desiredPosition = 5.0;
        double currentRate = 0.0;
        double desiredRate = 2.0;
        Assert.assertEquals(16.05, pid.compute(currentPosition, desiredPosition, currentRate, desiredRate, 0.1), 0.001);
        Assert.assertEquals(17.1, pid.compute(currentPosition, desiredPosition, currentRate, desiredRate, 0.1), 0.001);
        Assert.assertEquals(27.6, pid.compute(currentPosition, desiredPosition, currentRate, desiredRate, 1.0), 0.001);
        Assert.assertEquals(45.0, pid.compute(currentPosition, desiredPosition, currentRate, desiredRate, 3.0), 0.001);
    }

    @Test
    public void testCompute_all_PID_From_YoPID() {
        YoRegistry registry = new YoRegistry("robert");
        YoPIDGains pidGains = new YoPIDGains("", registry);
        double proportional = 2.0;
        double integral = 3.0;
        double derivative = 4.0;
        double maxIntegral = 10.0;
        pidGains.setKp(proportional);
        pidGains.setKi(integral);
        pidGains.setKd(derivative);
        pidGains.setMaximumIntegralError(maxIntegral);
        PIDController pid1 = new PIDController(pidGains, "1", registry);
        PIDController pid2 = new PIDController("2", registry);
        pid2.setProportionalGain(proportional);
        pid2.setIntegralGain(integral);
        pid2.setDerivativeGain(derivative);
        pid2.setMaxIntegralError(maxIntegral);
        Assert.assertEquals(proportional, pid1.getProportionalGain(), 0.001);
        Assert.assertEquals(integral, pid1.getIntegralGain(), 0.001);
        Assert.assertEquals(derivative, pid1.getDerivativeGain(), 0.001);
        Assert.assertEquals(maxIntegral, pid1.getMaxIntegralError(), 0.001);
        Assert.assertEquals(pid2.getProportionalGain(), pid1.getProportionalGain(), 0.001);
        Assert.assertEquals(pid2.getIntegralGain(), pid1.getIntegralGain(), 0.001);
        Assert.assertEquals(pid2.getDerivativeGain(), pid1.getDerivativeGain(), 0.001);
        Assert.assertEquals(pid2.getMaxIntegralError(), pid1.getMaxIntegralError(), 0.001);
        double currentPosition = 0.0;
        double desiredPosition = 5.0;
        double currentRate = 0.0;
        double desiredRate = 2.0;
        Assert.assertEquals(19.5, pid1.compute(currentPosition, desiredPosition, currentRate, desiredRate, 0.1), 0.001);
        Assert.assertEquals(21.0, pid1.compute(currentPosition, desiredPosition, currentRate, desiredRate, 0.1), 0.001);
        Assert.assertEquals(36.0, pid1.compute(currentPosition, desiredPosition, currentRate, desiredRate, 1.0), 0.001);
        Assert.assertEquals(19.5, pid2.compute(currentPosition, desiredPosition, currentRate, desiredRate, 0.1), 0.001);
        Assert.assertEquals(21.0, pid2.compute(currentPosition, desiredPosition, currentRate, desiredRate, 0.1), 0.001);
        Assert.assertEquals(36.0, pid2.compute(currentPosition, desiredPosition, currentRate, desiredRate, 1.0), 0.001);
        Assert.assertEquals(pid2.compute(currentPosition, desiredPosition, currentRate, desiredRate, 0.1), pid1.compute(currentPosition, desiredPosition, currentRate, desiredRate, 0.1), 0.001);
        Assert.assertEquals(pid2.compute(currentPosition, desiredPosition, currentRate, desiredRate, 0.1), pid1.compute(currentPosition, desiredPosition, currentRate, desiredRate, 0.1), 0.001);
        Assert.assertEquals(pid2.compute(currentPosition, desiredPosition, currentRate, desiredRate, 1.0), pid1.compute(currentPosition, desiredPosition, currentRate, desiredRate, 1.0), 0.001);
        Assert.assertEquals(48.0, pid1.compute(currentPosition, desiredPosition, currentRate, desiredRate, 1.01), 0.001);
    }
}

