/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.alphaToAlpha;

import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.alphaToAlpha.YoMiniJerkUpAndDownAlphaToAlpha;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoMiniJerkUpAndDownAlphaToAlphaTest {
    private double EPSILON = 1.0E-6;

    @Test
    public void testInvalidYoVariables() {
        YoRegistry registry = new YoRegistry("dummy");
        YoDouble startOfRampUp = new YoDouble("startOfRampUp", registry);
        YoDouble endOfRamp = new YoDouble("endOfRamp", registry);
        YoDouble startOfRampDown = new YoDouble("startOfRampDown", registry);
        YoDouble endOfRampDown = new YoDouble("endOfRampDown", registry);
        YoMiniJerkUpAndDownAlphaToAlpha yoMiniJerkUpAndDownAlphaToAlpha = new YoMiniJerkUpAndDownAlphaToAlpha(startOfRampUp, endOfRamp, startOfRampDown, endOfRampDown);
        this.testRangeOfAlphas(0.0, yoMiniJerkUpAndDownAlphaToAlpha);
        startOfRampUp.set(0.1);
        this.testRangeOfAlphas(0.0, yoMiniJerkUpAndDownAlphaToAlpha);
        endOfRamp.set(0.2);
        this.testRangeOfAlphas(0.0, yoMiniJerkUpAndDownAlphaToAlpha);
        startOfRampDown.set(0.3);
        this.testRangeOfAlphas(0.0, yoMiniJerkUpAndDownAlphaToAlpha);
        endOfRampDown.set(1.0);
        this.testRangeOfAlphas(0.0, yoMiniJerkUpAndDownAlphaToAlpha);
        endOfRampDown.set(0.9);
        startOfRampDown.set(0.95);
        this.testRangeOfAlphas(0.0, yoMiniJerkUpAndDownAlphaToAlpha);
    }

    @Test
    public void testValidYoVariables() {
        YoRegistry registry = new YoRegistry("dummy");
        YoDouble startOfRampUp = new YoDouble("startOfRampUp", registry);
        YoDouble endOfRamp = new YoDouble("endOfRamp", registry);
        YoDouble startOfRampDown = new YoDouble("startOfRampDown", registry);
        YoDouble endOfRampDown = new YoDouble("endOfRampDown", registry);
        YoMiniJerkUpAndDownAlphaToAlpha yoVariableRampUpAndDownAlphaToAlpha = new YoMiniJerkUpAndDownAlphaToAlpha(startOfRampUp, endOfRamp, startOfRampDown, endOfRampDown);
        startOfRampUp.set(0.1);
        endOfRamp.set(0.3);
        startOfRampDown.set(0.5);
        endOfRampDown.set(0.7);
        double value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.1);
        Assert.assertEquals(value, 0.0, this.EPSILON);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.2);
        Assert.assertEquals(value, 0.5, this.EPSILON);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.3);
        Assert.assertEquals(value, 1.0, this.EPSILON);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.4);
        Assert.assertEquals(value, 1.0, this.EPSILON);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.5);
        Assert.assertEquals(value, 1.0, this.EPSILON);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.6);
        Assert.assertEquals(value, 0.5, this.EPSILON);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.7);
        Assert.assertEquals(value, 0.0, this.EPSILON);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.8);
        Assert.assertEquals(value, 0.0, this.EPSILON);
        startOfRampUp.set(0.8);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.1);
        Assert.assertEquals(value, 0.0, this.EPSILON);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.2);
        Assert.assertEquals(value, 0.0, this.EPSILON);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.3);
        Assert.assertEquals(value, 0.0, this.EPSILON);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.4);
        Assert.assertEquals(value, 0.0, this.EPSILON);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.5);
        Assert.assertEquals(value, 0.0, this.EPSILON);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.6);
        Assert.assertEquals(value, 0.0, this.EPSILON);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.7);
        Assert.assertEquals(value, 0.0, this.EPSILON);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.8);
        Assert.assertEquals(value, 0.0, this.EPSILON);
    }

    @Test
    public void testHalfWay() {
        YoRegistry registry = new YoRegistry("dummy");
        YoDouble startOfRampUp = new YoDouble("startOfRampUp", registry);
        YoDouble endOfRamp = new YoDouble("endOfRamp", registry);
        YoDouble startOfRampDown = new YoDouble("startOfRampDown", registry);
        YoDouble endOfRampDown = new YoDouble("endOfRampDown", registry);
        YoMiniJerkUpAndDownAlphaToAlpha yoVariableRampUpAndDownAlphaToAlpha = new YoMiniJerkUpAndDownAlphaToAlpha(startOfRampUp, endOfRamp, startOfRampDown, endOfRampDown);
        startOfRampUp.set(0.1);
        endOfRamp.set(0.3);
        startOfRampDown.set(0.5);
        endOfRampDown.set(0.7);
        double value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.1);
        Assert.assertEquals(value, 0.0, this.EPSILON);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.2);
        Assert.assertEquals(value, 0.5, this.EPSILON);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.3);
        Assert.assertEquals(value, 1.0, this.EPSILON);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.4);
        Assert.assertEquals(value, 1.0, this.EPSILON);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.5);
        Assert.assertEquals(value, 1.0, this.EPSILON);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.6);
        Assert.assertEquals(value, 0.5, this.EPSILON);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.7);
        Assert.assertEquals(value, 0.0, this.EPSILON);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.8);
        Assert.assertEquals(value, 0.0, this.EPSILON);
    }

    @Test
    public void testSmallDifferences() {
        YoRegistry registry = new YoRegistry("dummy");
        YoDouble startOfRampUp = new YoDouble("startOfRampUp", registry);
        YoDouble endOfRamp = new YoDouble("endOfRamp", registry);
        YoDouble startOfRampDown = new YoDouble("startOfRampDown", registry);
        YoDouble endOfRampDown = new YoDouble("endOfRampDown", registry);
        YoMiniJerkUpAndDownAlphaToAlpha yoVariableRampUpAndDownAlphaToAlpha = new YoMiniJerkUpAndDownAlphaToAlpha(startOfRampUp, endOfRamp, startOfRampDown, endOfRampDown);
        startOfRampUp.set(0.1);
        endOfRamp.set(startOfRampUp.getDoubleValue() + this.EPSILON);
        startOfRampDown.set(0.5);
        endOfRampDown.set(startOfRampDown.getDoubleValue() + this.EPSILON);
        double value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.1);
        Assert.assertEquals(value, 0.0, this.EPSILON);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.1 + this.EPSILON / 2.0);
        Assert.assertEquals(value, 0.5, this.EPSILON);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.3);
        Assert.assertEquals(value, 1.0, this.EPSILON);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.5);
        Assert.assertEquals(value, 1.0, this.EPSILON);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.5 + this.EPSILON / 2.0);
        Assert.assertEquals(value, 0.5, this.EPSILON);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.7);
        Assert.assertEquals(value, 0.0, this.EPSILON);
        value = yoVariableRampUpAndDownAlphaToAlpha.getAlphaPrime(0.8);
        Assert.assertEquals(value, 0.0, this.EPSILON);
    }

    private void testRangeOfAlphas(double expectedValue, YoMiniJerkUpAndDownAlphaToAlpha yoMiniJerkUpAndDownAlphaToAlpha) {
        for (double alpha = -1.0; alpha < 2.0; alpha += 0.001) {
            double value = yoMiniJerkUpAndDownAlphaToAlpha.getAlphaPrime(alpha);
            Assert.assertEquals(value, expectedValue, this.EPSILON);
        }
    }
}

