/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.PlanarRegionFileTools;
import us.ihmc.robotics.geometry.PlanarRegionsList;

public class PlanarRegionFileToolsTest {
    private static final Random rand = new Random();
    private static Path tempDirectory = null;

    private static Path getTestDirectory() {
        Path dir = null;
        try {
            String callingMethod;
            if (tempDirectory == null) {
                tempDirectory = Files.createTempDirectory(PlanarRegionFileToolsTest.class.getSimpleName() + "_", new FileAttribute[0]);
            }
            if (!Files.exists(dir = tempDirectory.resolve(callingMethod = new Throwable().getStackTrace()[1].getMethodName()), new LinkOption[0])) {
                Files.createDirectory(dir, new FileAttribute[0]);
            }
            System.out.println("Test taking place in directory " + dir.toAbsolutePath());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            Assertions.fail((String)"The test could not be performed, as getTestDirectory() threw an IOException.");
        }
        return dir;
    }

    @Test
    public void exportAsFolderAndImportTest() {
        Path path = PlanarRegionFileToolsTest.getTestDirectory();
        PlanarRegionsList list = PlanarRegionsList.generatePlanarRegionsListFromRandomPolygonsWithRandomTransform((Random)rand, (int)5, (double)5.0, (int)5, (int)5);
        PlanarRegionFileTools.exportPlanarRegionData((Path)path, (PlanarRegionsList)list);
        PlanarRegionsList test = PlanarRegionFileTools.importPlanarRegionData((File)path.toFile());
        Assertions.assertEquals((Object)list, (Object)test);
    }

    @Test
    public void exportAsFileAndImportTest() {
        Path path = PlanarRegionFileToolsTest.getTestDirectory().resolve("regions.prl");
        PlanarRegionsList list = PlanarRegionsList.generatePlanarRegionsListFromRandomPolygonsWithRandomTransform((Random)rand, (int)5, (double)5.0, (int)5, (int)5);
        PlanarRegionFileTools.exportPlanarRegionDataAsFile((Path)path, (PlanarRegionsList)list);
        PlanarRegionsList test = PlanarRegionFileTools.importPlanarRegionData((File)path.toFile());
        Assertions.assertEquals((Object)list, (Object)test);
    }

    @Test
    public void exportToStreamAndImportTest() {
        Path path = PlanarRegionFileToolsTest.getTestDirectory().resolve("regions.prl");
        PlanarRegionsList list = PlanarRegionsList.generatePlanarRegionsListFromRandomPolygonsWithRandomTransform((Random)rand, (int)5, (double)5.0, (int)5, (int)5);
        try {
            FileOutputStream ostream = new FileOutputStream(path.toFile());
            PlanarRegionFileTools.exportPlanarRegionDataToStream((OutputStream)ostream, (PlanarRegionsList)list);
            ostream.close();
        }
        catch (IOException ex) {
            Assertions.fail((String)("IOException thrown - " + ex.getMessage()));
        }
        PlanarRegionsList test = PlanarRegionFileTools.importPlanarRegionData((File)path.toFile());
        Assertions.assertEquals((Object)list, (Object)test);
    }

    @Test
    public void isPlanarRegionDirectoryTest() {
        Path path = PlanarRegionFileToolsTest.getTestDirectory();
        PlanarRegionsList list = PlanarRegionsList.generatePlanarRegionsListFromRandomPolygonsWithRandomTransform((Random)rand, (int)1, (double)5.0, (int)5, (int)5);
        Assertions.assertFalse((boolean)PlanarRegionFileTools.isPlanarRegionFile((File)path.toFile()));
        PlanarRegionFileTools.exportPlanarRegionData((Path)path, (PlanarRegionsList)list);
        Assertions.assertTrue((boolean)PlanarRegionFileTools.isPlanarRegionFile((File)path.toFile()));
    }

    @Test
    public void isPlanarRegionFileTest() {
        Path path = PlanarRegionFileToolsTest.getTestDirectory().resolve("regions.prl");
        PlanarRegionsList list = PlanarRegionsList.generatePlanarRegionsListFromRandomPolygonsWithRandomTransform((Random)rand, (int)1, (double)5.0, (int)5, (int)5);
        Assertions.assertFalse((boolean)PlanarRegionFileTools.isPlanarRegionFile((File)path.toFile()));
        PlanarRegionFileTools.exportPlanarRegionDataAsFile((Path)path, (PlanarRegionsList)list);
        Assertions.assertTrue((boolean)PlanarRegionFileTools.isPlanarRegionFile((File)path.toFile()));
    }
}

