/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.matrixlib.MatrixTestTools;
import us.ihmc.matrixlib.NativeCommonOps;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.MatrixMissingTools;

public class MatrixMissingToolsTest {
    @Test
    public void testSetDiagonalValues() {
        int iters = 100;
        DMatrixRMaj matrixToSet = new DMatrixRMaj(4, 7);
        Random random = new Random(1738L);
        for (int i = 0; i < iters; ++i) {
            matrixToSet.setData(RandomNumbers.nextDoubleArray((Random)random, (int)28, (double)100.0));
            DMatrixRMaj originalMatrix = new DMatrixRMaj(matrixToSet);
            double value = RandomNumbers.nextDouble((Random)random, (double)10.0);
            MatrixMissingTools.setDiagonalValues((DMatrix1Row)matrixToSet, (double)value, (int)1, (int)3);
            for (int row = 0; row < 4; ++row) {
                for (int col = 0; col < 7; ++col) {
                    if (row == 1 && col == 3) {
                        Assert.assertEquals(value, matrixToSet.get(row, col), 1.0E-7);
                        continue;
                    }
                    if (row == 2 && col == 4) {
                        Assert.assertEquals(value, matrixToSet.get(row, col), 1.0E-7);
                        continue;
                    }
                    if (row == 3 && col == 5) {
                        Assert.assertEquals(value, matrixToSet.get(row, col), 1.0E-7);
                        continue;
                    }
                    Assert.assertEquals("(" + row + ", " + col + ")", originalMatrix.get(row, col), matrixToSet.get(row, col), 1.0E-7);
                }
            }
        }
    }

    @Test
    public void testFast2x2Inverse() {
        int iters = 500;
        double epsilon = 1.0E-8;
        Random random = new Random(1738L);
        for (int i = 0; i < iters; ++i) {
            DMatrixRMaj matrix = new DMatrixRMaj(2, 2);
            DMatrixRMaj matrixInverseExpected = new DMatrixRMaj(2, 2);
            DMatrixRMaj matrixInverse = new DMatrixRMaj(2, 2);
            matrix.setData(RandomNumbers.nextDoubleArray((Random)random, (int)4, (double)10.0));
            NativeCommonOps.invert((DMatrix1Row)matrix, (DMatrix1Row)matrixInverseExpected);
            MatrixMissingTools.fast2x2Inverse((DMatrixRMaj)matrix, (DMatrixRMaj)matrixInverse);
            MatrixTestTools.assertMatrixEquals((DMatrix)matrixInverseExpected, (DMatrix)matrixInverse, (double)epsilon);
        }
    }

    @Test
    public void testToSkewSymmetric() {
        int iters = 500;
        double epsilon = 1.0E-8;
        Random random = new Random(1738L);
        for (int i = 0; i < iters; ++i) {
            Vector3D vectorA = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D vectorB = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D vectorC = new Vector3D();
            vectorC.cross((Tuple3DReadOnly)vectorA, (Tuple3DReadOnly)vectorB);
            DMatrixRMaj vectorBVector = new DMatrixRMaj(3, 1);
            DMatrixRMaj vectorCVector = new DMatrixRMaj(3, 1);
            DMatrixRMaj vectorCActual = new DMatrixRMaj(3, 1);
            DMatrixRMaj skewVectorA = new DMatrixRMaj(3, 3);
            vectorB.get((DMatrix)vectorBVector);
            MatrixMissingTools.toSkewSymmetricMatrix((Tuple3DReadOnly)vectorA, (DMatrixRMaj)skewVectorA);
            CommonOps_DDRM.mult((DMatrix1Row)skewVectorA, (DMatrix1Row)vectorBVector, (DMatrix1Row)vectorCVector);
            vectorC.get((DMatrix)vectorCActual);
            MatrixTestTools.assertMatrixEquals((DMatrix)vectorCActual, (DMatrix)vectorCVector, (double)epsilon);
        }
    }
}

