/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.trajectories;

import java.util.Random;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.trajectories.yoVariables.YoPolynomial;
import us.ihmc.yoVariables.registry.YoRegistry;

public class PolynomialSplineTest {
    private YoRegistry registry;

    @BeforeEach
    public void setUp() {
        this.registry = new YoRegistry("test");
    }

    @Test
    public void testGetPosition() {
        Random random = new Random(165L);
        int order = 5;
        YoPolynomial spline = new YoPolynomial("test", order, this.registry);
        double[] coefficients = this.getRandomCoefficients(order, random);
        spline.setDirectly(coefficients);
        double x = random.nextDouble();
        spline.compute(x);
        double y = spline.getValue();
        double yCheck = coefficients[0] + coefficients[1] * x + coefficients[2] * x * x + coefficients[3] * x * x * x + coefficients[4] * x * x * x * x;
        Assert.assertEquals(yCheck, y, 1.0E-12);
    }

    @Test
    public void testGetVelocity() {
        Random random = new Random(1675L);
        int order = 5;
        YoPolynomial spline = new YoPolynomial("test", order, this.registry);
        double[] coefficients = this.getRandomCoefficients(order, random);
        spline.setDirectly(coefficients);
        double x = random.nextDouble();
        double dx = 1.0E-9;
        spline.compute(x);
        double yx = spline.getValue();
        double dydx = spline.getVelocity();
        spline.compute(x + dx);
        double yxPlusdx = spline.getValue();
        double dydxNumerical = (yxPlusdx - yx) / dx;
        Assert.assertEquals(dydxNumerical, dydx, 1.0E-6);
    }

    @Test
    public void testGetAcceleration() {
        Random random = new Random(1675L);
        int order = 5;
        YoPolynomial spline = new YoPolynomial("test", order, this.registry);
        double[] coefficients = this.getRandomCoefficients(order, random);
        spline.setDirectly(coefficients);
        double x = random.nextDouble();
        double dx = 1.0E-9;
        spline.compute(x);
        double d2ydx2 = spline.getAcceleration();
        double dydxx = spline.getVelocity();
        spline.compute(x + dx);
        double dydxxPlusdx = spline.getVelocity();
        double d2ydx2Numerical = (dydxxPlusdx - dydxx) / dx;
        Assert.assertEquals(d2ydx2Numerical, d2ydx2, 1.0E-6);
    }

    @Test
    public void testGetIntegral() {
        int order = 5;
        YoPolynomial spline = new YoPolynomial("test", order, this.registry);
        double[] coefficients = new double[]{2.0, 6.0, 9.0, 4.0, 10.0};
        spline.setDirectly(coefficients);
        double from = 1.0;
        double to = 2.0;
        double expected = 109.0;
        double actual = spline.getIntegral(from, to);
        Assert.assertEquals(expected, actual, 1.0E-12);
    }

    @Test
    public void testSetBasedOnMidPoint() {
        Random random = new Random(1635L);
        YoPolynomial spline = new YoPolynomial("test", 5, this.registry);
        double x0 = random.nextDouble();
        double xFinal = x0 + random.nextDouble();
        double xMid = x0 + (xFinal - x0) / 2.0;
        double z0 = random.nextDouble();
        double zd0 = random.nextDouble();
        double zMid = random.nextDouble();
        double zFinal = random.nextDouble();
        double zdFinal = random.nextDouble();
        spline.setQuarticUsingMidPoint(x0, xFinal, z0, zd0, zMid, zFinal, zdFinal);
        double epsilon = 1.0E-6;
        spline.compute(x0);
        Assert.assertEquals(z0, spline.getValue(), epsilon);
        Assert.assertEquals(zd0, spline.getVelocity(), epsilon);
        spline.compute(xMid);
        Assert.assertEquals(zMid, spline.getValue(), epsilon);
        spline.compute(xFinal);
        Assert.assertEquals(zFinal, spline.getValue(), epsilon);
        Assert.assertEquals(zdFinal, spline.getVelocity(), epsilon);
    }

    @Test
    public void testSetBasedOnFinalAcceleration() {
        Random random = new Random(1635L);
        YoPolynomial spline = new YoPolynomial("test", 5, this.registry);
        double x0 = random.nextDouble();
        double xFinal = x0 + random.nextDouble();
        double z0 = random.nextDouble();
        double zd0 = random.nextDouble();
        double zFinal = random.nextDouble();
        double zdFinal = random.nextDouble();
        double zddFinal = random.nextDouble();
        spline.setQuarticUsingFinalAcceleration(x0, xFinal, z0, zd0, zFinal, zdFinal, zddFinal);
        double epsilon = 1.0E-6;
        spline.compute(x0);
        Assert.assertEquals(z0, spline.getValue(), epsilon);
        Assert.assertEquals(zd0, spline.getVelocity(), epsilon);
        spline.compute(xFinal);
        Assert.assertEquals(zFinal, spline.getValue(), epsilon);
        Assert.assertEquals(zdFinal, spline.getVelocity(), epsilon);
        Assert.assertEquals(zddFinal, spline.getAcceleration(), epsilon);
    }

    @Test
    public void testConstant() {
        Random random = new Random(1635L);
        YoPolynomial spline = new YoPolynomial("test", 5, this.registry);
        double z = random.nextDouble();
        spline.setConstant(z);
        double[] coefficients = spline.getCoefficients();
        double epsilon = 1.0E-9;
        Assert.assertEquals(z, coefficients[0], epsilon);
        for (int i = 1; i < coefficients.length; ++i) {
            Assert.assertEquals(Double.NaN, coefficients[i], epsilon);
        }
        for (double time = -10.0; time <= 10.0; time += 0.05) {
            spline.compute(time);
            Assert.assertEquals(z, spline.getValue(), epsilon);
            Assert.assertEquals(0.0, spline.getVelocity(), epsilon);
            Assert.assertEquals(0.0, spline.getAcceleration(), epsilon);
        }
    }

    private double[] getRandomCoefficients(int order, Random random) {
        double[] coefficients = new double[order];
        for (int i = 0; i < coefficients.length; ++i) {
            coefficients[i] = random.nextDouble();
        }
        return coefficients;
    }
}

