/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.trajectories;

import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.trajectories.MinimumJerkTrajectory;

public class MinimumJerkTrajectoryTest {
    private double randomBetween(double min, double max) {
        return min + Math.random() * (max - min);
    }

    @Test
    public void testRandomInitialFinalConditions() {
        MinimumJerkTrajectory minimumJerkTrajectory = new MinimumJerkTrajectory();
        int numberOfTests = 1000000;
        double epsilon = 0.001;
        for (int i = 0; i < numberOfTests; ++i) {
            double x0 = this.randomBetween(-10.0, 10.0);
            double v0 = this.randomBetween(-10.0, 10.0);
            double a0 = this.randomBetween(-10.0, 10.0);
            double xf = this.randomBetween(-10.0, 10.0);
            double vf = this.randomBetween(-10.0, 10.0);
            double af = this.randomBetween(-10.0, 10.0);
            double moveDuration = this.randomBetween(0.1, 10.0);
            minimumJerkTrajectory.setMoveParameters(x0, v0, a0, xf, vf, af, moveDuration);
            minimumJerkTrajectory.computeTrajectory(this.randomBetween(-10.0, 10.0));
            minimumJerkTrajectory.computeTrajectory(0.0);
            Assert.assertEquals(x0, minimumJerkTrajectory.getPosition(), epsilon);
            Assert.assertEquals(v0, minimumJerkTrajectory.getVelocity(), epsilon);
            Assert.assertEquals(a0, minimumJerkTrajectory.getAcceleration(), epsilon);
            minimumJerkTrajectory.computeTrajectory(moveDuration);
            Assert.assertEquals(xf, minimumJerkTrajectory.getPosition(), epsilon);
            Assert.assertEquals(vf, minimumJerkTrajectory.getVelocity(), epsilon);
            Assert.assertEquals(af, minimumJerkTrajectory.getAcceleration(), epsilon);
        }
    }

    @Test
    public void testCheckVelocityAndAcceleration() {
        double x0 = 0.0;
        double v0 = 0.0;
        double a0 = 0.0;
        double xf = 1.0;
        double vf = 0.0;
        double af = 0.0;
        double moveDuration = 2.0;
        MinimumJerkTrajectory minimumJerkTrajectory = new MinimumJerkTrajectory();
        minimumJerkTrajectory.setMoveParameters(x0, v0, a0, xf, vf, af, moveDuration);
        double epsilon = 1.0E-6;
        minimumJerkTrajectory.computeTrajectory(0.0);
        Assert.assertEquals(x0, minimumJerkTrajectory.getPosition(), epsilon);
        Assert.assertEquals(v0, minimumJerkTrajectory.getVelocity(), epsilon);
        Assert.assertEquals(a0, minimumJerkTrajectory.getAcceleration(), epsilon);
        minimumJerkTrajectory.computeTrajectory(moveDuration);
        Assert.assertEquals(xf, minimumJerkTrajectory.getPosition(), epsilon);
        Assert.assertEquals(vf, minimumJerkTrajectory.getVelocity(), epsilon);
        Assert.assertEquals(af, minimumJerkTrajectory.getAcceleration(), epsilon);
    }
}

