/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.trajectories;

import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.trajectories.LinearInterpolater;

public class LinearInterpolatorTest {
    private double x0 = 0.0;
    private double y0 = 0.0;
    private double x1 = 1.0;
    private double y1 = 1.0;
    private double slope = (this.y1 - this.y0) / (this.x1 - this.x0);
    private double yIntercept = this.y0 - this.slope * this.x0;
    private double xTest = 0.5;
    private double yTest = this.slope * this.xTest + this.yIntercept;

    @Test
    public void testLinearInterpolationSimple() {
        int numberOfPoints = 2;
        double[] xPoints = new double[numberOfPoints];
        double[] yPoints = new double[numberOfPoints];
        xPoints[0] = this.x0;
        yPoints[0] = this.y0;
        xPoints[1] = this.x1;
        yPoints[1] = this.y1;
        LinearInterpolater linearInterpolater = new LinearInterpolater(xPoints, yPoints);
        double xPointValue = 0.5;
        double yPointValueExpected = this.slope * xPointValue + this.yIntercept;
        double yPointValue = linearInterpolater.getPoint(xPointValue);
        Assert.assertEquals(yPointValueExpected, yPointValue, 1.0E-5);
    }

    @Test
    public void testLinearInterpolationSimpleWithArrayListConstructor() {
        int numberOfPoints = 2;
        ArrayList<Double> xPointsArrayList = new ArrayList<Double>(numberOfPoints);
        ArrayList<Double> yPointsArrayList = new ArrayList<Double>(numberOfPoints);
        xPointsArrayList.add(this.x0);
        yPointsArrayList.add(this.y0);
        xPointsArrayList.add(this.x1);
        yPointsArrayList.add(this.y1);
        try {
            LinearInterpolater linearInterpolater = new LinearInterpolater(xPointsArrayList, yPointsArrayList);
            double xPointValue = 0.5;
            double yPointValueExpected = this.slope * xPointValue + this.yIntercept;
            double yPointValue = linearInterpolater.getPoint(xPointValue);
            Assert.assertEquals(yPointValueExpected, yPointValue, 1.0E-5);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testLinearInterpolationSimpleWithInteroplatedIndexConstructor() {
        int numberOfPoints = 2;
        ArrayList<Double> xPointsArrayList = new ArrayList<Double>(numberOfPoints);
        xPointsArrayList.add(this.x0);
        xPointsArrayList.add(this.x1);
        try {
            LinearInterpolater linearInterpolater = new LinearInterpolater(xPointsArrayList);
            double xPointValue = this.x0;
            double yPointValueExpected = 0.0;
            double yPointValue = linearInterpolater.getPoint(xPointValue);
            Assert.assertEquals(yPointValueExpected, yPointValue, 1.0E-5);
            xPointValue = this.x1;
            yPointValueExpected = 1.0;
            yPointValue = linearInterpolater.getPoint(xPointValue);
            Assert.assertEquals(yPointValueExpected, yPointValue, 1.0E-5);
            double indexFraction = 0.73;
            xPointValue = this.x1 * indexFraction;
            yPointValueExpected = indexFraction;
            yPointValue = linearInterpolater.getPoint(xPointValue);
            Assert.assertEquals(yPointValueExpected, yPointValue, 1.0E-5);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testLinearInterpolationBetweenTwoRandomPoints() {
        int numberOfPoints = 2;
        double[] xPoints = new double[numberOfPoints];
        double[] yPoints = new double[numberOfPoints];
        Random random = new Random(100L);
        double scale = 10.0;
        int numberOfTests = 100;
        int numberOfEvaluationsPerTest = 10;
        for (int i = 0; i < numberOfTests; ++i) {
            double slope = scale * (random.nextDouble() - 0.5);
            double yIntercept = scale * (random.nextDouble() - 0.5);
            xPoints[0] = scale * (random.nextDouble() - 0.5);
            yPoints[0] = slope * xPoints[0] + yIntercept;
            xPoints[1] = xPoints[0] + Math.abs(scale * random.nextDouble());
            yPoints[1] = slope * xPoints[1] + yIntercept;
            LinearInterpolater linearInterpolater = new LinearInterpolater(xPoints, yPoints);
            double xIncrement = (xPoints[1] - xPoints[0]) / (double)numberOfEvaluationsPerTest;
            for (int j = 0; j <= numberOfEvaluationsPerTest; ++j) {
                double xPointValue = xPoints[0] + (double)j * xIncrement;
                double yPointValueExpected = slope * xPointValue + yIntercept;
                double yPointValue = linearInterpolater.getPoint(xPointValue);
                Assert.assertEquals(yPointValueExpected, yPointValue, 1.0E-5);
            }
        }
    }
}

