/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.testExecutor;

import us.ihmc.robotics.stateMachine.core.State;

public class CountActionsTask
implements State {
    private int numberOfTimesTransitionIntoActionWasCalled = 0;
    private int numberOfTimesDoActionWasCalled = 0;
    private int numberOfTimesTransitionOutOfActionWasCalled = 0;
    private final int numberOfDoActionsBeforeDone;

    public CountActionsTask(int numberOfDoActionsBeforeDone) {
        this.numberOfDoActionsBeforeDone = numberOfDoActionsBeforeDone;
    }

    public void onEntry() {
        ++this.numberOfTimesTransitionIntoActionWasCalled;
    }

    public void doAction(double timeInState) {
        ++this.numberOfTimesDoActionWasCalled;
    }

    public void onExit(double timeInState) {
        ++this.numberOfTimesTransitionOutOfActionWasCalled;
    }

    public boolean isDone(double timeInState) {
        return this.numberOfTimesDoActionWasCalled >= this.numberOfDoActionsBeforeDone;
    }

    public boolean checkNumberOfCalls(int expectedTransitionIntoCalls, int expectedDoActionCalls, int expectedTransactionOutOfCalls) {
        if (this.numberOfTimesTransitionIntoActionWasCalled != expectedTransitionIntoCalls) {
            return false;
        }
        if (this.numberOfTimesDoActionWasCalled != expectedDoActionCalls) {
            return false;
        }
        return this.numberOfTimesTransitionOutOfActionWasCalled == expectedTransactionOutOfCalls;
    }
}

