/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.statistics;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.statistics.OnlineStandardDeviationCalculator;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class StandardDeviationCalculatorTest {
    private static final double epsilon = 1.0E-8;

    @Test
    public void testNoVariance() {
        YoRegistry testRegistry = new YoRegistry(this.getClass().getSimpleName());
        YoDouble valueProvider = new YoDouble("valueProvider", testRegistry);
        OnlineStandardDeviationCalculator calculator = new OnlineStandardDeviationCalculator("value", (DoubleProvider)valueProvider, testRegistry);
        int numberOfValues = 100;
        double value = 17.3;
        valueProvider.set(value);
        for (int i = 0; i < numberOfValues; ++i) {
            calculator.update();
        }
        Assert.assertEquals(value, calculator.getMean(), 1.0E-8);
        Assert.assertEquals(0.0, calculator.getStandardDeviation(), 1.0E-8);
        Assert.assertEquals(0.0, calculator.getVariance(), 1.0E-8);
    }

    @Test
    public void testFromList() {
        YoRegistry testRegistry = new YoRegistry(this.getClass().getSimpleName());
        YoDouble valueProvider = new YoDouble("valueProvider", testRegistry);
        OnlineStandardDeviationCalculator calculator = new OnlineStandardDeviationCalculator("value", (DoubleProvider)valueProvider, testRegistry);
        int numberOfValues = 100;
        Random random = new Random(1738L);
        TDoubleArrayList valueList = new TDoubleArrayList();
        double bias = 10.0;
        double seed = 5.0;
        for (int i = 0; i < numberOfValues; ++i) {
            double value = bias + RandomNumbers.nextDouble((Random)random, (double)seed);
            valueList.add(value);
            valueProvider.set(value);
            calculator.update();
        }
        double summedValues = 0.0;
        for (int i = 0; i < numberOfValues; ++i) {
            summedValues += valueList.get(i);
        }
        double mean = summedValues / (double)numberOfValues;
        double sumOfSquares = 0.0;
        for (int i = 0; i < numberOfValues; ++i) {
            sumOfSquares += MathTools.square((double)(valueList.get(i) - mean));
        }
        double variance = sumOfSquares / (double)numberOfValues;
        double populationVariance = sumOfSquares / (double)(numberOfValues - 1);
        double standardDeviation = Math.sqrt(variance);
        Assert.assertEquals(mean, calculator.getMean(), 1.0E-8);
        Assert.assertEquals(variance, calculator.getVariance(), 1.0E-8);
        Assert.assertEquals(standardDeviation, calculator.getStandardDeviation(), 1.0E-8);
    }
}

