/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.statistics;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.statistics.OnePassMeanAndStandardDeviation;

public class OnePassMeanAndStandardDeviationTest {
    private OnePassMeanAndStandardDeviation meanAndStandardDeviation;

    @BeforeEach
    public void setUp() throws Exception {
        this.meanAndStandardDeviation = new OnePassMeanAndStandardDeviation();
    }

    @AfterEach
    public void tearDown() throws Exception {
    }

    @Test
    public void testCalculateMeanAndStandardDeviationExample() {
        double[] data;
        for (double measurement : data = new double[]{65.0, 66.0, 67.0, 69.0, 70.0, 70.0, 70.0, 71.0, 71.0, 72.0, 73.0, 74.0, 76.0}) {
            this.meanAndStandardDeviation.compute(measurement);
        }
        double delta = 1.0E-10;
        Assert.assertEquals(70.3076923076923, this.meanAndStandardDeviation.getAverage(), delta);
        Assert.assertEquals(8.982248520710021, this.meanAndStandardDeviation.getVariance(), delta);
        Assert.assertEquals(2.997039959812018, this.meanAndStandardDeviation.getStandardDeviation(), delta);
        Assert.assertEquals(9.730769230769189, this.meanAndStandardDeviation.getSampleVariance(), delta);
    }

    @Test
    public void testCalculateMeanAndStandardDeviationSingleValue() {
        this.meanAndStandardDeviation.compute(65.0);
        double delta = 1.0E-10;
        Assert.assertEquals(65.0, this.meanAndStandardDeviation.getAverage(), delta);
        Assert.assertEquals(0.0, this.meanAndStandardDeviation.getVariance(), delta);
        Assert.assertEquals(0.0, this.meanAndStandardDeviation.getStandardDeviation(), delta);
    }

    @Test
    public void testCalculateSampleVarianceSingleValue() {
        this.meanAndStandardDeviation.compute(65.0);
        double delta = 1.0E-10;
        Assertions.assertThrows(OnePassMeanAndStandardDeviation.InsufficientMeasurementsException.class, () -> Assert.assertEquals(0.0, this.meanAndStandardDeviation.getSampleVariance(), delta));
    }

    @Test
    public void testCalculateAverageNoValue() {
        Assertions.assertThrows(OnePassMeanAndStandardDeviation.InsufficientMeasurementsException.class, () -> {
            double delta = 1.0E-10;
            Assert.assertEquals(0.0, this.meanAndStandardDeviation.getAverage(), delta);
        });
    }

    @Test
    public void testCalculateVarianceNoValue() {
        Assertions.assertThrows(OnePassMeanAndStandardDeviation.InsufficientMeasurementsException.class, () -> {
            double delta = 1.0E-10;
            Assert.assertEquals(0.0, this.meanAndStandardDeviation.getVariance(), delta);
        });
    }
}

