/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine;

import java.util.ArrayList;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine.State;
import us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine.StateMachine;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class StateMachineTest {
    private static final double EPSILON = 1.0E-7;
    private static final boolean VERBOSE = false;
    private final double INTO = 0.0;
    private final double ACTION = 0.1;
    private final double OUT_OF = 0.9;
    private final int MAX_NUMBER_OF_CALLS = 2;

    @Test
    public void testStateTransitions() {
        int i;
        ArrayList<Double> listOfActions = new ArrayList<Double>();
        SimpleState[] arrayOfStates = new SimpleState[States.values().length];
        YoRegistry registry = new YoRegistry("registry");
        YoDouble time = new YoDouble("time", registry);
        StateMachine stateMachine = new StateMachine("stateMachine", "switchTime", States.class, time, registry);
        for (i = 0; i < arrayOfStates.length; ++i) {
            arrayOfStates[i] = new SimpleState(States.values()[i], i, listOfActions);
        }
        for (i = 0; i < arrayOfStates.length - 1; ++i) {
            arrayOfStates[i].setDefaultNextState((States)arrayOfStates[i + 1].getStateEnum());
        }
        for (SimpleState state : arrayOfStates) {
            stateMachine.addState((State)state);
        }
        stateMachine.setCurrentState((Enum)((States)arrayOfStates[0].getStateEnum()));
        do {
            stateMachine.doAction();
            stateMachine.checkTransitionConditions();
            time.add(0.01);
        } while (!((States)stateMachine.getCurrentStateEnum()).equals((Object)States.values()[States.values().length - 1]));
        boolean didTransitionInto = false;
        boolean didAction = false;
        boolean didTransitionOutOf = true;
        boolean initialized = false;
        int previousState = 0;
        for (Double value : listOfActions) {
            int currentState = value.intValue();
            if (!initialized) {
                previousState = currentState;
                initialized = true;
            }
            if (previousState != currentState) {
                Assert.assertEquals((double)currentState, (double)(previousState + 1), 1.0E-7);
                Assert.assertTrue(didTransitionOutOf);
                didTransitionOutOf = false;
                previousState = currentState;
            }
            double actionCode = value - Math.floor(value);
            if (!didTransitionInto) {
                Assert.assertEquals(actionCode, 0.0, 0.0);
                didTransitionInto = true;
                continue;
            }
            if (!didAction) {
                Assert.assertEquals(0.1, actionCode, 1.0E-7);
                didAction = true;
                continue;
            }
            Assert.assertTrue("actionCode = " + actionCode + ", ACTION = 0.1, OUT_OF = 0.9", Math.abs(actionCode - 0.1) < 1.0E-7 || Math.abs(actionCode - 0.9) < 1.0E-7);
            if (!(Math.abs(actionCode - 0.9) < 1.0E-7)) continue;
            didTransitionInto = false;
            didAction = false;
            didTransitionOutOf = true;
        }
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForPackage(StateMachineTest.class);
    }

    private static enum States {
        ZERO,
        ONE,
        TWO,
        THREE,
        FOUR,
        FIVE,
        SIX;

    }

    public class SimpleState
    extends State<States> {
        private final int stateID;
        private ArrayList<Double> listOfActions;
        private int callCounter;

        public SimpleState(States stateEnum, int stateID, ArrayList<Double> listOfActions) {
            super((Enum)stateEnum);
            this.callCounter = 1;
            this.listOfActions = listOfActions;
            this.stateID = stateID;
        }

        public void doAction() {
            double actionID = (double)this.stateID + 0.1;
            this.listOfActions.add(actionID);
            if (this.callCounter >= 2) {
                this.transitionToDefaultNextState();
            }
            ++this.callCounter;
        }

        public void doTransitionIntoAction() {
            double actionID = (double)this.stateID + 0.0;
            this.listOfActions.add(actionID);
        }

        public void doTransitionOutOfAction() {
            double actionID = (double)this.stateID + 0.9;
            this.listOfActions.add(actionID);
        }
    }
}

