/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine;

import java.util.ArrayList;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine.State;
import us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine.StateChangeRecorder;

public class StateChangeRecorderTest {
    private ArrayList<State<TestEnum>> listOfStates;
    private StateChangeRecorder<TestEnum> stateChangeRecorder;

    @BeforeEach
    public void setUp() throws Exception {
        this.listOfStates = this.getListOfStates();
        this.stateChangeRecorder = new StateChangeRecorder();
    }

    @AfterEach
    public void tearDown() throws Exception {
    }

    @Test
    public void testConstructor() {
    }

    @Test
    public void testAddingValues() {
        int index = Math.max(0, this.listOfStates.size() - 2);
        State<TestEnum> stateToTest = this.listOfStates.get(index);
        ArrayList<Double> listOfTimes = new ArrayList<Double>();
        listOfTimes.add(0.1345);
        listOfTimes.add(1.567);
        listOfTimes.add(4.8653456);
        listOfTimes.add(1.012234322324234E8);
        for (Double value : listOfTimes) {
            this.stateChangeRecorder.stateChanged(stateToTest, stateToTest, value.doubleValue());
        }
        ArrayList listOfSwitchTimes = (ArrayList)this.stateChangeRecorder.getStatesAndSwitchTimes().get(stateToTest);
        Assert.assertEquals(listOfSwitchTimes.size(), listOfTimes.size());
        for (int i = 0; i < listOfSwitchTimes.size(); ++i) {
            Assert.assertEquals(listOfSwitchTimes.get(i), listOfTimes.get(i));
        }
    }

    @Test
    public void testClearAllData() {
        int index = Math.max(0, this.listOfStates.size() - 2);
        State<TestEnum> stateToTest = this.listOfStates.get(index);
        ArrayList<Double> listOfTimes = new ArrayList<Double>();
        listOfTimes.add(0.1345);
        listOfTimes.add(1.567);
        listOfTimes.add(4.8653456);
        listOfTimes.add(10.2324234);
        for (Double d : listOfTimes) {
            this.stateChangeRecorder.stateChanged(stateToTest, stateToTest, d.doubleValue());
        }
        this.stateChangeRecorder.clearAllData();
        for (State state : this.listOfStates) {
            ArrayList listOfSwitchTimes = (ArrayList)this.stateChangeRecorder.getStatesAndSwitchTimes().get(state);
            if (listOfSwitchTimes == null || listOfSwitchTimes.size() <= 0) continue;
            Assert.fail();
        }
    }

    private ArrayList<State<TestEnum>> getListOfStates() {
        ArrayList<State<TestEnum>> listOfStates = new ArrayList<State<TestEnum>>();
        for (TestEnum enumValue : TestEnum.values()) {
            DummyState state = new DummyState(enumValue);
            listOfStates.add(state);
        }
        return listOfStates;
    }

    private static enum TestEnum {
        HIP_PITCH,
        HIP_ROLL,
        HIP_YAW,
        KNEE,
        ANKLE_ROLL,
        ANKLE_PITCH;

    }

    private class DummyState
    extends State<TestEnum> {
        public DummyState(TestEnum stateEnum) {
            super((Enum)stateEnum);
        }

        public void doAction() {
        }

        public void doTransitionIntoAction() {
        }

        public void doTransitionOutOfAction() {
        }
    }
}

