/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.util.ArrayList;
import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.ejml.dense.row.RandomMatrices_DDRM;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FrameMatrix3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.weightMatrices.WeightMatrix3D;

public class WeightMatrix3DTest {
    private static final int ITERATIONS = 1000;

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testSettersGetters() throws Exception {
        Random random = new Random(123423L);
        WeightMatrix3D weightMatrix3D = new WeightMatrix3D();
        Assert.assertNull(weightMatrix3D.getWeightFrame());
        Assert.assertTrue(Double.isNaN(weightMatrix3D.getXAxisWeight()));
        Assert.assertTrue(Double.isNaN(weightMatrix3D.getYAxisWeight()));
        Assert.assertTrue(Double.isNaN(weightMatrix3D.getZAxisWeight()));
        for (int i = 0; i < 1000; ++i) {
            double xWeight = random.nextDouble();
            double yWeight = random.nextDouble();
            double zWeight = random.nextDouble();
            weightMatrix3D.setWeights(xWeight, yWeight, zWeight);
            Assert.assertEquals(xWeight, weightMatrix3D.getXAxisWeight(), 1.0E-8);
            Assert.assertEquals(yWeight, weightMatrix3D.getYAxisWeight(), 1.0E-8);
            Assert.assertEquals(zWeight, weightMatrix3D.getZAxisWeight(), 1.0E-8);
            xWeight = random.nextDouble();
            yWeight = random.nextDouble();
            zWeight = random.nextDouble();
            weightMatrix3D.setXAxisWeight(xWeight);
            weightMatrix3D.setYAxisWeight(yWeight);
            weightMatrix3D.setZAxisWeight(zWeight);
            Assert.assertEquals(xWeight, weightMatrix3D.getXAxisWeight(), 1.0E-8);
            Assert.assertEquals(yWeight, weightMatrix3D.getYAxisWeight(), 1.0E-8);
            Assert.assertEquals(zWeight, weightMatrix3D.getZAxisWeight(), 1.0E-8);
            weightMatrix3D.clear();
            Assert.assertNull(weightMatrix3D.getWeightFrame());
            Assert.assertTrue(Double.isNaN(weightMatrix3D.getXAxisWeight()));
            Assert.assertTrue(Double.isNaN(weightMatrix3D.getYAxisWeight()));
            Assert.assertTrue(Double.isNaN(weightMatrix3D.getZAxisWeight()));
            ReferenceFrame randomFrame = EuclidFrameRandomTools.nextReferenceFrame((String)("blop" + i), (Random)random, (ReferenceFrame)ReferenceFrame.getWorldFrame());
            weightMatrix3D.setWeightFrame(randomFrame);
            Assert.assertTrue(randomFrame == weightMatrix3D.getWeightFrame());
            weightMatrix3D.clearWeightFrame();
            Assert.assertNull(weightMatrix3D.getWeightFrame());
            weightMatrix3D.setWeightFrame(randomFrame);
            weightMatrix3D.clear();
            Assert.assertNull(weightMatrix3D.getWeightFrame());
            weightMatrix3D.setWeightFrame(randomFrame);
            weightMatrix3D.clear();
            Assert.assertNull(weightMatrix3D.getWeightFrame());
        }
    }

    @Test
    public void testGetFullSelectionMatrixInFrame() throws Exception {
        Random random = new Random(456465L);
        WeightMatrix3D weightMatrix3D = new WeightMatrix3D();
        FrameMatrix3D frameMatrix3D = new FrameMatrix3D();
        RigidBodyTransform randomTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        ArrayList<ReferenceFrame> referenceFrames = new ArrayList<ReferenceFrame>();
        referenceFrames.add(null);
        referenceFrames.add(ReferenceFrame.getWorldFrame());
        referenceFrames.add(ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"blop1", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)randomTransform));
        referenceFrames.add(EuclidFrameRandomTools.nextReferenceFrame((String)"blop2", (Random)random, (ReferenceFrame)ReferenceFrame.getWorldFrame()));
        referenceFrames.add(ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"blop1Bis", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)randomTransform));
        for (int i = 0; i < 1000; ++i) {
            for (ReferenceFrame selectionFrame : referenceFrames) {
                for (ReferenceFrame destinationFrame : referenceFrames.subList(1, referenceFrames.size())) {
                    DMatrixRMaj actualWeightMatrix = RandomMatrices_DDRM.rectangle((int)3, (int)3, (double)-1.0, (double)1.0, (Random)random);
                    DMatrixRMaj expectedWeightMatrix = RandomMatrices_DDRM.rectangle((int)3, (int)3, (double)-1.0, (double)1.0, (Random)random);
                    double xWeight = random.nextDouble();
                    double yWeight = random.nextDouble();
                    double zWeight = random.nextDouble();
                    weightMatrix3D.setWeights(xWeight, yWeight, zWeight);
                    weightMatrix3D.setWeightFrame(selectionFrame);
                    frameMatrix3D.setToZero(selectionFrame);
                    frameMatrix3D.setM00(xWeight);
                    frameMatrix3D.setM11(yWeight);
                    frameMatrix3D.setM22(zWeight);
                    weightMatrix3D.getFullWeightMatrixInFrame(destinationFrame, actualWeightMatrix);
                    if (selectionFrame != null) {
                        frameMatrix3D.changeFrame(destinationFrame);
                    }
                    frameMatrix3D.get((DMatrix)expectedWeightMatrix);
                    WeightMatrix3DTest.assertMatrixEquals(expectedWeightMatrix, actualWeightMatrix, 1.0E-12);
                    DMatrixRMaj expectedSubspaceVector = new DMatrixRMaj(3, 1);
                    DMatrixRMaj actualSubspaceVector = new DMatrixRMaj(3, 1);
                    FrameVector3D randomVector = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)destinationFrame);
                    DMatrixRMaj originalVector = new DMatrixRMaj(3, 1);
                    randomVector.get((DMatrix)originalVector);
                    weightMatrix3D.getFullWeightMatrixInFrame(destinationFrame, expectedWeightMatrix);
                    CommonOps_DDRM.mult((DMatrix1Row)expectedWeightMatrix, (DMatrix1Row)originalVector, (DMatrix1Row)actualSubspaceVector);
                    FrameVector3D weights = new FrameVector3D();
                    weights.set(xWeight, yWeight, zWeight);
                    if (selectionFrame != null) {
                        weights.setIncludingFrame(selectionFrame, xWeight, yWeight, zWeight);
                        randomVector.changeFrame(selectionFrame);
                    }
                    randomVector.setX(randomVector.getX() * weights.getX());
                    randomVector.setY(randomVector.getY() * weights.getY());
                    randomVector.setZ(randomVector.getZ() * weights.getZ());
                    if (selectionFrame != null) {
                        randomVector.changeFrame(destinationFrame);
                    }
                    randomVector.get((DMatrix)expectedSubspaceVector);
                    WeightMatrix3DTest.assertMatrixEquals(expectedSubspaceVector, actualSubspaceVector, 1.0E-12);
                }
            }
        }
    }

    @Test
    public void testGetEfficientSelectionMatrixInFrame() throws Exception {
        Random random = new Random(456465L);
        WeightMatrix3D weightMatrix3D = new WeightMatrix3D();
        RigidBodyTransform randomTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        ArrayList<ReferenceFrame> referenceFrames = new ArrayList<ReferenceFrame>();
        referenceFrames.add(null);
        referenceFrames.add(ReferenceFrame.getWorldFrame());
        referenceFrames.add(ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"blop1", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)randomTransform));
        referenceFrames.add(EuclidFrameRandomTools.nextReferenceFrame((String)"blop2", (Random)random, (ReferenceFrame)ReferenceFrame.getWorldFrame()));
        referenceFrames.add(ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"blop1Bis", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)randomTransform));
        for (int i = 0; i < 1000; ++i) {
            for (ReferenceFrame selectionFrame : referenceFrames) {
                for (ReferenceFrame destinationFrame : referenceFrames.subList(1, referenceFrames.size())) {
                    DMatrixRMaj actualSelectionMatrix = RandomMatrices_DDRM.rectangle((int)3, (int)3, (double)-1.0, (double)1.0, (Random)random);
                    DMatrixRMaj expectedSelectionMatrix = RandomMatrices_DDRM.rectangle((int)3, (int)3, (double)-1.0, (double)1.0, (Random)random);
                    double xWeight = random.nextDouble();
                    double yWeight = random.nextDouble();
                    double zWeight = random.nextDouble();
                    weightMatrix3D.setWeights(xWeight, yWeight, zWeight);
                    weightMatrix3D.setWeightFrame(selectionFrame);
                    weightMatrix3D.getFullWeightMatrixInFrame(destinationFrame, expectedSelectionMatrix);
                    MatrixTools.removeZeroRows((DMatrix1Row)expectedSelectionMatrix, (double)1.0E-6);
                    weightMatrix3D.getEfficientWeightMatrixInFrame(destinationFrame, actualSelectionMatrix);
                    WeightMatrix3DTest.assertMatrixEquals(expectedSelectionMatrix, actualSelectionMatrix, 1.0E-12);
                }
            }
        }
    }

    private static void assertMatrixEquals(DMatrixRMaj expected, DMatrixRMaj actual, double epsilon) {
        Assert.assertTrue(WeightMatrix3DTest.assertErrorMessage(expected, actual), MatrixFeatures_DDRM.isEquals((DMatrixD1)expected, (DMatrixD1)actual, (double)epsilon));
    }

    private static String assertErrorMessage(DMatrixRMaj expected, DMatrixRMaj actual) {
        return "Expected:\n" + expected + "\nActual:\n" + actual;
    }
}

