/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.random.RandomGeometry;
import us.ihmc.robotics.screwTheory.TotalMassCalculator;

public class TotalMassCalculatorTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testComputeSubTreeMass() {
        Random random = new Random(100L);
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        RigidBody elevator = new RigidBody("body", worldFrame);
        int numberOfJoints = 100;
        double addedMass = TotalMassCalculatorTest.createRandomRigidBodyTreeAndReturnTotalMass(worldFrame, (RigidBodyBasics)elevator, numberOfJoints, random);
        Assert.assertEquals(addedMass, TotalMassCalculator.computeSubTreeMass((RigidBodyReadOnly)elevator), 1.0E-5);
    }

    public static double createRandomRigidBodyTreeAndReturnTotalMass(ReferenceFrame worldFrame, RigidBodyBasics elevator, int numberOfJoints, Random random) {
        double totalMass = 0.0;
        boolean rootAdded = false;
        ArrayList<RevoluteJoint> potentialInverseDynamicsParentJoints = new ArrayList<RevoluteJoint>();
        for (int i = 0; i < numberOfJoints; ++i) {
            RigidBodyBasics inverseDynamicsParentBody;
            Vector3D jointOffset = RandomGeometry.nextVector3D((Random)random);
            Vector3D jointAxis = new Vector3D(random.nextDouble(), random.nextDouble(), random.nextDouble());
            jointAxis.normalize();
            Matrix3D momentOfInertia = RandomGeometry.nextDiagonalMatrix3D((Random)random);
            double mass = random.nextDouble();
            totalMass += mass;
            Vector3D comOffset = RandomGeometry.nextVector3D((Random)random);
            if (!rootAdded) {
                rootAdded = true;
                inverseDynamicsParentBody = elevator;
            } else {
                int parentIndex = random.nextInt(potentialInverseDynamicsParentJoints.size());
                RevoluteJoint inverseDynamicsParentJoint = (RevoluteJoint)potentialInverseDynamicsParentJoints.get(parentIndex);
                inverseDynamicsParentBody = inverseDynamicsParentJoint.getSuccessor();
            }
            RevoluteJoint currentJoint = new RevoluteJoint("jointID" + i, inverseDynamicsParentBody, (Tuple3DReadOnly)jointOffset, (Vector3DReadOnly)jointAxis);
            double jointPosition = random.nextDouble();
            currentJoint.setQ(jointPosition);
            currentJoint.setQd(0.0);
            currentJoint.setQdd(0.0);
            new RigidBody("bodyID" + i, (JointBasics)currentJoint, (Matrix3DReadOnly)momentOfInertia, mass, (Tuple3DReadOnly)comOffset);
            potentialInverseDynamicsParentJoints.add(currentJoint);
        }
        elevator.updateFramesRecursively();
        return totalMass;
    }
}

