/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.util.ArrayList;
import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.ejml.dense.row.RandomMatrices_DDRM;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;
import us.ihmc.robotics.screwTheory.SelectionMatrix3DTest;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;

public class SelectionMatrix6DTest {
    private static final int ITERATIONS = 500;

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testGettersSetters() {
        Random random = new Random(123423L);
        SelectionMatrix6D selectionMatrix6D = new SelectionMatrix6D();
        Assert.assertNull(selectionMatrix6D.getAngularSelectionFrame());
        Assert.assertNull(selectionMatrix6D.getLinearSelectionFrame());
        Assert.assertTrue(selectionMatrix6D.isAngularXSelected());
        Assert.assertTrue(selectionMatrix6D.isAngularYSelected());
        Assert.assertTrue(selectionMatrix6D.isAngularZSelected());
        Assert.assertTrue(selectionMatrix6D.isAngularPartActive());
        Assert.assertTrue(selectionMatrix6D.isLinearXSelected());
        Assert.assertTrue(selectionMatrix6D.isLinearYSelected());
        Assert.assertTrue(selectionMatrix6D.isLinearZSelected());
        Assert.assertTrue(selectionMatrix6D.isLinearPartActive());
        for (int i = 0; i < 500; ++i) {
            boolean xAngularSelected = random.nextBoolean();
            boolean yAngularSelected = random.nextBoolean();
            boolean zAngularSelected = random.nextBoolean();
            boolean xLinearSelected = random.nextBoolean();
            boolean yLinearSelected = random.nextBoolean();
            boolean zLinearSelected = random.nextBoolean();
            selectionMatrix6D.setAngularAxisSelection(xAngularSelected, yAngularSelected, zAngularSelected);
            selectionMatrix6D.setLinearAxisSelection(xLinearSelected, yLinearSelected, zLinearSelected);
            Assert.assertEquals(xAngularSelected, selectionMatrix6D.isAngularXSelected());
            Assert.assertEquals(yAngularSelected, selectionMatrix6D.isAngularYSelected());
            Assert.assertEquals(zAngularSelected, selectionMatrix6D.isAngularZSelected());
            Assert.assertEquals(xAngularSelected || yAngularSelected || zAngularSelected, selectionMatrix6D.isAngularPartActive());
            Assert.assertEquals(xLinearSelected, selectionMatrix6D.isLinearXSelected());
            Assert.assertEquals(yLinearSelected, selectionMatrix6D.isLinearYSelected());
            Assert.assertEquals(zLinearSelected, selectionMatrix6D.isLinearZSelected());
            Assert.assertEquals(xLinearSelected || yLinearSelected || zLinearSelected, selectionMatrix6D.isLinearPartActive());
            xAngularSelected = random.nextBoolean();
            yAngularSelected = random.nextBoolean();
            zAngularSelected = random.nextBoolean();
            xLinearSelected = random.nextBoolean();
            yLinearSelected = random.nextBoolean();
            zLinearSelected = random.nextBoolean();
            selectionMatrix6D.selectAngularX(xAngularSelected);
            selectionMatrix6D.selectAngularY(yAngularSelected);
            selectionMatrix6D.selectAngularZ(zAngularSelected);
            selectionMatrix6D.selectLinearX(xLinearSelected);
            selectionMatrix6D.selectLinearY(yLinearSelected);
            selectionMatrix6D.selectLinearZ(zLinearSelected);
            Assert.assertEquals(xAngularSelected, selectionMatrix6D.isAngularXSelected());
            Assert.assertEquals(yAngularSelected, selectionMatrix6D.isAngularYSelected());
            Assert.assertEquals(zAngularSelected, selectionMatrix6D.isAngularZSelected());
            Assert.assertEquals(xLinearSelected, selectionMatrix6D.isLinearXSelected());
            Assert.assertEquals(yLinearSelected, selectionMatrix6D.isLinearYSelected());
            Assert.assertEquals(zLinearSelected, selectionMatrix6D.isLinearZSelected());
            selectionMatrix6D.resetSelection();
            Assert.assertTrue(selectionMatrix6D.isAngularXSelected());
            Assert.assertTrue(selectionMatrix6D.isAngularYSelected());
            Assert.assertTrue(selectionMatrix6D.isAngularZSelected());
            Assert.assertTrue(selectionMatrix6D.isAngularPartActive());
            Assert.assertTrue(selectionMatrix6D.isLinearXSelected());
            Assert.assertTrue(selectionMatrix6D.isLinearYSelected());
            Assert.assertTrue(selectionMatrix6D.isLinearZSelected());
            Assert.assertTrue(selectionMatrix6D.isLinearPartActive());
            selectionMatrix6D.setToLinearSelectionOnly();
            Assert.assertFalse(selectionMatrix6D.isAngularXSelected());
            Assert.assertFalse(selectionMatrix6D.isAngularYSelected());
            Assert.assertFalse(selectionMatrix6D.isAngularZSelected());
            Assert.assertFalse(selectionMatrix6D.isAngularPartActive());
            Assert.assertTrue(selectionMatrix6D.isLinearXSelected());
            Assert.assertTrue(selectionMatrix6D.isLinearYSelected());
            Assert.assertTrue(selectionMatrix6D.isLinearZSelected());
            Assert.assertTrue(selectionMatrix6D.isLinearPartActive());
            selectionMatrix6D.setToAngularSelectionOnly();
            Assert.assertTrue(selectionMatrix6D.isAngularXSelected());
            Assert.assertTrue(selectionMatrix6D.isAngularYSelected());
            Assert.assertTrue(selectionMatrix6D.isAngularZSelected());
            Assert.assertTrue(selectionMatrix6D.isAngularPartActive());
            Assert.assertFalse(selectionMatrix6D.isLinearXSelected());
            Assert.assertFalse(selectionMatrix6D.isLinearYSelected());
            Assert.assertFalse(selectionMatrix6D.isLinearZSelected());
            Assert.assertFalse(selectionMatrix6D.isLinearPartActive());
            Assert.assertNull(selectionMatrix6D.getAngularSelectionFrame());
            Assert.assertNull(selectionMatrix6D.getLinearSelectionFrame());
            ReferenceFrame randomFrame = EuclidFrameRandomTools.nextReferenceFrame((String)("blop" + i), (Random)random, (ReferenceFrame)ReferenceFrame.getWorldFrame());
            selectionMatrix6D.setSelectionFrame(randomFrame);
            Assert.assertTrue(randomFrame == selectionMatrix6D.getAngularSelectionFrame());
            Assert.assertTrue(randomFrame == selectionMatrix6D.getLinearSelectionFrame());
            selectionMatrix6D.clearSelectionFrame();
            Assert.assertNull(selectionMatrix6D.getAngularSelectionFrame());
            Assert.assertNull(selectionMatrix6D.getLinearSelectionFrame());
            selectionMatrix6D.setSelectionFrame(randomFrame);
            selectionMatrix6D.setToLinearSelectionOnly();
            Assert.assertNull(selectionMatrix6D.getAngularSelectionFrame());
            Assert.assertNull(selectionMatrix6D.getLinearSelectionFrame());
            selectionMatrix6D.setSelectionFrame(randomFrame);
            selectionMatrix6D.setToAngularSelectionOnly();
            Assert.assertNull(selectionMatrix6D.getAngularSelectionFrame());
            Assert.assertNull(selectionMatrix6D.getLinearSelectionFrame());
            selectionMatrix6D.setSelectionFrame(randomFrame);
            selectionMatrix6D.resetSelection();
            Assert.assertNull(selectionMatrix6D.getAngularSelectionFrame());
            Assert.assertNull(selectionMatrix6D.getLinearSelectionFrame());
            selectionMatrix6D.setSelectionFrame(randomFrame);
            selectionMatrix6D.clearAngularSelectionFrame();
            Assert.assertNull(selectionMatrix6D.getAngularSelectionFrame());
            Assert.assertTrue(randomFrame == selectionMatrix6D.getLinearSelectionFrame());
            selectionMatrix6D.setSelectionFrame(randomFrame);
            selectionMatrix6D.clearLinearSelectionFrame();
            Assert.assertTrue(randomFrame == selectionMatrix6D.getAngularSelectionFrame());
            Assert.assertNull(selectionMatrix6D.getLinearSelectionFrame());
        }
    }

    @Test
    public void testGetFullSelectionMatrixInFrame() throws Exception {
        Random random = new Random(456465L);
        SelectionMatrix6D selectionMatrix6D = new SelectionMatrix6D();
        SelectionMatrix3D angularPart3D = new SelectionMatrix3D();
        SelectionMatrix3D linearPart3D = new SelectionMatrix3D();
        RigidBodyTransform randomTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        ArrayList<ReferenceFrame> referenceFrames = new ArrayList<ReferenceFrame>();
        referenceFrames.add(null);
        referenceFrames.add(ReferenceFrame.getWorldFrame());
        referenceFrames.add(ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"blop1", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)randomTransform));
        referenceFrames.add(EuclidFrameRandomTools.nextReferenceFrame((String)"blop2", (Random)random, (ReferenceFrame)ReferenceFrame.getWorldFrame()));
        referenceFrames.add(ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"blop1Bis", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)randomTransform));
        for (int i = 0; i < 500; ++i) {
            for (ReferenceFrame selectionFrame : referenceFrames) {
                for (ReferenceFrame destinationFrame : referenceFrames.subList(1, referenceFrames.size())) {
                    DMatrixRMaj actualSelectionMatrix = RandomMatrices_DDRM.rectangle((int)6, (int)6, (double)-1.0, (double)1.0, (Random)random);
                    DMatrixRMaj expectedSelectionMatrix = RandomMatrices_DDRM.rectangle((int)6, (int)6, (double)-1.0, (double)1.0, (Random)random);
                    boolean xAngularSelected = random.nextBoolean();
                    boolean yAngularSelected = random.nextBoolean();
                    boolean zAngularSelected = random.nextBoolean();
                    boolean xLinearSelected = random.nextBoolean();
                    boolean yLinearSelected = random.nextBoolean();
                    boolean zLinearSelected = random.nextBoolean();
                    selectionMatrix6D.setAngularAxisSelection(xAngularSelected, yAngularSelected, zAngularSelected);
                    selectionMatrix6D.setLinearAxisSelection(xLinearSelected, yLinearSelected, zLinearSelected);
                    selectionMatrix6D.setSelectionFrame(selectionFrame);
                    angularPart3D.setAxisSelection(xAngularSelected, yAngularSelected, zAngularSelected);
                    angularPart3D.setSelectionFrame(selectionFrame);
                    linearPart3D.setAxisSelection(xLinearSelected, yLinearSelected, zLinearSelected);
                    linearPart3D.setSelectionFrame(selectionFrame);
                    selectionMatrix6D.getFullSelectionMatrixInFrame(destinationFrame, actualSelectionMatrix);
                    expectedSelectionMatrix.zero();
                    angularPart3D.getFullSelectionMatrixInFrame(destinationFrame, 0, 0, expectedSelectionMatrix);
                    linearPart3D.getFullSelectionMatrixInFrame(destinationFrame, 3, 3, expectedSelectionMatrix);
                    SelectionMatrix6DTest.assertMatrixEquals(expectedSelectionMatrix, actualSelectionMatrix, 1.0E-12);
                    DMatrixRMaj expectedSubspaceVector = new DMatrixRMaj(6, 1);
                    DMatrixRMaj actualSubspaceVector = new DMatrixRMaj(6, 1);
                    FrameVector3D randomAngularVector = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)destinationFrame);
                    FrameVector3D randomLinearVector = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)destinationFrame);
                    DMatrixRMaj originalVector = new DMatrixRMaj(6, 1);
                    randomAngularVector.get(0, (DMatrix)originalVector);
                    randomLinearVector.get(3, (DMatrix)originalVector);
                    selectionMatrix6D.getFullSelectionMatrixInFrame(destinationFrame, expectedSelectionMatrix);
                    CommonOps_DDRM.mult((DMatrix1Row)expectedSelectionMatrix, (DMatrix1Row)originalVector, (DMatrix1Row)actualSubspaceVector);
                    if (selectionFrame != null) {
                        randomAngularVector.changeFrame(selectionFrame);
                        randomLinearVector.changeFrame(selectionFrame);
                    }
                    if (!xAngularSelected) {
                        randomAngularVector.setX(0.0);
                    }
                    if (!yAngularSelected) {
                        randomAngularVector.setY(0.0);
                    }
                    if (!zAngularSelected) {
                        randomAngularVector.setZ(0.0);
                    }
                    if (!xLinearSelected) {
                        randomLinearVector.setX(0.0);
                    }
                    if (!yLinearSelected) {
                        randomLinearVector.setY(0.0);
                    }
                    if (!zLinearSelected) {
                        randomLinearVector.setZ(0.0);
                    }
                    if (selectionFrame != null) {
                        randomAngularVector.changeFrame(destinationFrame);
                        randomLinearVector.changeFrame(destinationFrame);
                    }
                    randomAngularVector.get(0, (DMatrix)expectedSubspaceVector);
                    randomLinearVector.get(3, (DMatrix)expectedSubspaceVector);
                    SelectionMatrix6DTest.assertMatrixEquals(expectedSubspaceVector, actualSubspaceVector, 1.0E-12);
                }
            }
        }
    }

    @Test
    public void testGetEfficientSelectionMatrixInFrame() throws Exception {
        Random random = new Random(456465L);
        SelectionMatrix6D selectionMatrix6D = new SelectionMatrix6D();
        RigidBodyTransform randomTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        ArrayList<ReferenceFrame> referenceFrames = new ArrayList<ReferenceFrame>();
        referenceFrames.add(null);
        referenceFrames.add(ReferenceFrame.getWorldFrame());
        referenceFrames.add(ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"blop1", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)randomTransform));
        referenceFrames.add(EuclidFrameRandomTools.nextReferenceFrame((String)"blop2", (Random)random, (ReferenceFrame)ReferenceFrame.getWorldFrame()));
        referenceFrames.add(ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"blop1Bis", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)randomTransform));
        for (int i = 0; i < 500; ++i) {
            for (ReferenceFrame selectionFrame : referenceFrames) {
                for (ReferenceFrame destinationFrame : referenceFrames.subList(1, referenceFrames.size())) {
                    DMatrixRMaj actualSelectionMatrix = RandomMatrices_DDRM.rectangle((int)6, (int)6, (double)-1.0, (double)1.0, (Random)random);
                    DMatrixRMaj expectedSelectionMatrix = RandomMatrices_DDRM.rectangle((int)6, (int)6, (double)-1.0, (double)1.0, (Random)random);
                    boolean xAngularSelected = random.nextBoolean();
                    boolean yAngularSelected = random.nextBoolean();
                    boolean zAngularSelected = random.nextBoolean();
                    boolean xLinearSelected = random.nextBoolean();
                    boolean yLinearSelected = random.nextBoolean();
                    boolean zLinearSelected = random.nextBoolean();
                    selectionMatrix6D.setAngularAxisSelection(xAngularSelected, yAngularSelected, zAngularSelected);
                    selectionMatrix6D.setLinearAxisSelection(xLinearSelected, yLinearSelected, zLinearSelected);
                    selectionMatrix6D.setSelectionFrame(selectionFrame);
                    selectionMatrix6D.getFullSelectionMatrixInFrame(destinationFrame, expectedSelectionMatrix);
                    MatrixTools.removeZeroRows((DMatrix1Row)expectedSelectionMatrix, (double)1.0E-7);
                    selectionMatrix6D.getCompactSelectionMatrixInFrame(destinationFrame, actualSelectionMatrix);
                    SelectionMatrix6DTest.assertMatrixEquals(expectedSelectionMatrix, actualSelectionMatrix, 1.0E-12);
                }
            }
        }
    }

    private static void assertMatrixEquals(DMatrixRMaj expected, DMatrixRMaj actual, double epsilon) {
        Assert.assertTrue(SelectionMatrix6DTest.assertErrorMessage(expected, actual), MatrixFeatures_DDRM.isEquals((DMatrixD1)expected, (DMatrixD1)actual, (double)epsilon));
    }

    private static String assertErrorMessage(DMatrixRMaj expected, DMatrixRMaj actual) {
        return "Expected:\n" + expected + "\nActual:\n" + actual;
    }

    public static void main(String[] args) {
        MutationTestFacilitator mutationTestFacilitator = new MutationTestFacilitator();
        mutationTestFacilitator.addClassesToMutate(new Class[]{SelectionMatrix3D.class, SelectionMatrix6D.class});
        mutationTestFacilitator.addTestClassesToRun(new Class[]{SelectionMatrix3DTest.class, SelectionMatrix6DTest.class});
        mutationTestFacilitator.doMutationTest();
        mutationTestFacilitator.openResultInBrowser();
    }
}

