/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.OneDoFJoint;
import us.ihmc.mecano.multiBodySystem.PrismaticJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoTestTools;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.robotics.screwTheory.TwistCalculator;

public class MovingReferenceFrameTest {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testAgainstTwistCalculatorWithPrismaticChainRobot() throws Exception {
        Random random = new Random(435423L);
        int numberOfJoints = 100;
        List joints = MultiBodySystemRandomTools.nextPrismaticJointChain((Random)random, (int)numberOfJoints);
        TwistCalculator twistCalculator = new TwistCalculator(worldFrame, ((PrismaticJoint)joints.get(0)).getPredecessor());
        Twist actualTwist = new Twist();
        Twist expectedTwist = new Twist();
        for (int i = 0; i < 100; ++i) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (double)-1.0, (double)1.0, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (double)-1.0, (double)1.0, (Iterable)joints);
            ((PrismaticJoint)joints.get(0)).getPredecessor().updateFramesRecursively();
            twistCalculator.compute();
            for (int jointIndex = 0; jointIndex < numberOfJoints; ++jointIndex) {
                OneDoFJointBasics joint = (OneDoFJointBasics)joints.get(jointIndex);
                RigidBodyBasics body = joint.getSuccessor();
                MovingReferenceFrame bodyFrame = body.getBodyFixedFrame();
                twistCalculator.getTwistOfBody(body, expectedTwist);
                bodyFrame.getTwistOfFrame((TwistBasics)actualTwist);
                MecanoTestTools.assertTwistEquals((TwistReadOnly)expectedTwist, (TwistReadOnly)actualTwist, (double)1.0E-5);
            }
        }
    }

    @Test
    public void testAgainstTwistCalculatorWithChainRobot() throws Exception {
        Random random = new Random(435423L);
        int numberOfJoints = 100;
        List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
        TwistCalculator twistCalculator = new TwistCalculator(worldFrame, ((OneDoFJoint)joints.get(0)).getPredecessor());
        Twist actualTwist = new Twist();
        Twist expectedTwist = new Twist();
        for (int i = 0; i < 100; ++i) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (double)-1.0, (double)1.0, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (double)-1.0, (double)1.0, (Iterable)joints);
            ((OneDoFJoint)joints.get(0)).getPredecessor().updateFramesRecursively();
            twistCalculator.compute();
            for (int jointIndex = 0; jointIndex < numberOfJoints; ++jointIndex) {
                OneDoFJointBasics joint = (OneDoFJointBasics)joints.get(jointIndex);
                RigidBodyBasics body = joint.getSuccessor();
                MovingReferenceFrame bodyFrame = body.getBodyFixedFrame();
                twistCalculator.getTwistOfBody(body, expectedTwist);
                bodyFrame.getTwistOfFrame((TwistBasics)actualTwist);
                MecanoTestTools.assertTwistEquals((TwistReadOnly)expectedTwist, (TwistReadOnly)actualTwist, (double)1.0E-5);
            }
        }
    }

    @Test
    public void testAgainstTwistCalculatorWithTreeRobot() throws Exception {
        Random random = new Random(435423L);
        int numberOfJoints = 100;
        List joints = MultiBodySystemRandomTools.nextOneDoFJointTree((Random)random, (int)numberOfJoints);
        TwistCalculator twistCalculator = new TwistCalculator(worldFrame, ((OneDoFJoint)joints.get(0)).getPredecessor());
        Twist actualTwist = new Twist();
        Twist expectedTwist = new Twist();
        for (int i = 0; i < 100; ++i) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (double)-1.0, (double)1.0, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (double)-1.0, (double)1.0, (Iterable)joints);
            ((OneDoFJoint)joints.get(0)).getPredecessor().updateFramesRecursively();
            twistCalculator.compute();
            for (int jointIndex = 0; jointIndex < numberOfJoints; ++jointIndex) {
                OneDoFJointBasics joint = (OneDoFJointBasics)joints.get(jointIndex);
                RigidBodyBasics body = joint.getSuccessor();
                MovingReferenceFrame bodyFrame = body.getBodyFixedFrame();
                twistCalculator.getTwistOfBody(body, expectedTwist);
                bodyFrame.getTwistOfFrame((TwistBasics)actualTwist);
                MecanoTestTools.assertTwistEquals((TwistReadOnly)expectedTwist, (TwistReadOnly)actualTwist, (double)1.0E-5);
                twistCalculator.getTwistOfBody(body, expectedTwist);
                expectedTwist.setBodyFrame((ReferenceFrame)joint.getFrameAfterJoint());
                expectedTwist.changeFrame((ReferenceFrame)joint.getFrameAfterJoint());
                joint.getFrameAfterJoint().getTwistOfFrame((TwistBasics)actualTwist);
                MecanoTestTools.assertTwistEquals((TwistReadOnly)expectedTwist, (TwistReadOnly)actualTwist, (double)1.0E-5);
                for (JointBasics child : body.getChildrenJoints()) {
                    twistCalculator.getTwistOfBody(body, expectedTwist);
                    expectedTwist.setBodyFrame((ReferenceFrame)child.getFrameBeforeJoint());
                    expectedTwist.changeFrame((ReferenceFrame)child.getFrameBeforeJoint());
                    child.getFrameBeforeJoint().getTwistOfFrame((TwistBasics)actualTwist);
                    MecanoTestTools.assertTwistEquals((TwistReadOnly)expectedTwist, (TwistReadOnly)actualTwist, (double)1.0E-5);
                }
            }
        }
    }
}

