/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.util.ArrayList;
import java.util.Random;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleMatrix;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.algorithms.CompositeRigidBodyMassMatrixCalculator;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialInertia;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.screwTheory.DifferentialIDMassMatrixCalculator;
import us.ihmc.robotics.screwTheory.MassMatrixCalculator;

public abstract class MassMatrixCalculatorTest {
    protected static final Vector3D X = new Vector3D(1.0, 0.0, 0.0);
    protected static final Vector3D Y = new Vector3D(0.0, 1.0, 0.0);
    protected static final Vector3D Z = new Vector3D(0.0, 0.0, 1.0);
    protected final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    protected ArrayList<RevoluteJoint> joints;
    protected RigidBodyBasics elevator;
    private final Random random = new Random(1776L);

    @BeforeEach
    public void setUp() {
        this.elevator = new RigidBody("elevator", this.worldFrame);
    }

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    protected void setUpRandomChainRobot() {
        Random random = new Random();
        this.joints = new ArrayList();
        Vector3D[] jointAxes = new Vector3D[]{X, Y, Z, X, Z, Z, X, Y, Z, X};
        this.joints.addAll(MultiBodySystemRandomTools.nextRevoluteJointChain((Random)random, (String)"", (RigidBodyBasics)this.elevator, (Vector3DReadOnly[])jointAxes));
        MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (double)-1.5707963267948966, (double)1.5707963267948966, this.joints);
        this.elevator.updateFramesRecursively();
        MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, this.joints);
    }

    protected double computeKineticEnergy(ArrayList<RevoluteJoint> joints) {
        double ret = 0.0;
        MovingReferenceFrame elevatorFrame = this.elevator.getBodyFixedFrame();
        Twist twistWithRespectToWorld = new Twist((ReferenceFrame)elevatorFrame, (ReferenceFrame)elevatorFrame, (ReferenceFrame)elevatorFrame);
        Twist successorTwist = new Twist();
        for (RevoluteJoint joint : joints) {
            joint.getSuccessorTwist((TwistBasics)successorTwist);
            successorTwist.changeFrame((ReferenceFrame)elevatorFrame);
            twistWithRespectToWorld.add((TwistReadOnly)successorTwist);
            SpatialInertia inertia = new SpatialInertia((SpatialInertiaReadOnly)joint.getSuccessor().getInertia());
            inertia.changeFrame((ReferenceFrame)elevatorFrame);
            ret += inertia.computeKineticCoEnergy((TwistReadOnly)twistWithRespectToWorld);
        }
        return ret;
    }

    protected double computeKineticEnergy(ArrayList<RevoluteJoint> joints, DMatrixRMaj massMatrix) {
        SimpleMatrix jointVelocities = new SimpleMatrix(joints.size(), 1);
        for (int i = 0; i < joints.size(); ++i) {
            jointVelocities.set(i, 0, joints.get(i).getQd());
        }
        SimpleMatrix massMatrix_ = SimpleMatrix.wrap((Matrix)massMatrix);
        SimpleMatrix kineticEnergy = (SimpleMatrix)((SimpleMatrix)((SimpleMatrix)jointVelocities.transpose()).mult((SimpleBase)massMatrix_)).mult((SimpleBase)jointVelocities);
        return 0.5 * kineticEnergy.get(0, 0);
    }

    @Test
    public void compareMassMatrixCalculators() {
        double eps = 1.0E-10;
        this.setUpRandomChainRobot();
        ArrayList<Object> massMatrixCalculators = new ArrayList<Object>();
        massMatrixCalculators.add(new DifferentialIDMassMatrixCalculator(this.worldFrame, this.elevator));
        massMatrixCalculators.add(new MassMatrixCalculator(){
            CompositeRigidBodyMassMatrixCalculator crbmmc;
            {
                this.crbmmc = new CompositeRigidBodyMassMatrixCalculator((RigidBodyReadOnly)MassMatrixCalculatorTest.this.elevator);
            }

            public void getMassMatrix(DMatrixRMaj massMatrixToPack) {
                massMatrixToPack.set((DMatrixD1)this.getMassMatrix());
            }

            public DMatrixRMaj getMassMatrix() {
                return this.crbmmc.getMassMatrix();
            }

            public JointBasics[] getJointsInOrder() {
                return this.crbmmc.getInput().getJointsToConsider().toArray(new JointBasics[0]);
            }

            public void compute() {
                this.crbmmc.reset();
            }
        });
        ArrayList<DMatrixRMaj> massMatrices = new ArrayList<DMatrixRMaj>();
        int nDoFs = MultiBodySystemTools.computeDegreesOfFreedom(this.joints);
        for (int i = 0; i < massMatrixCalculators.size(); ++i) {
            massMatrices.add(new DMatrixRMaj(nDoFs, nDoFs));
        }
        DMatrixRMaj diffMassMatrix = new DMatrixRMaj(nDoFs, nDoFs);
        int nIterations = 10000;
        for (int i = 0; i < nIterations; ++i) {
            MultiBodySystemRandomTools.nextState((Random)this.random, (JointStateType)JointStateType.CONFIGURATION, (double)-1.5707963267948966, (double)1.5707963267948966, this.joints);
            MultiBodySystemRandomTools.nextState((Random)this.random, (JointStateType)JointStateType.VELOCITY, this.joints);
            MultiBodySystemRandomTools.nextState((Random)this.random, (JointStateType)JointStateType.ACCELERATION, this.joints);
            this.elevator.updateFramesRecursively();
            for (int j = 0; j < massMatrixCalculators.size(); ++j) {
                ((MassMatrixCalculator)massMatrixCalculators.get(j)).compute();
                massMatrices.set(j, ((MassMatrixCalculator)massMatrixCalculators.get(j)).getMassMatrix());
                if (j <= 0) continue;
                CommonOps_DDRM.subtract((DMatrixD1)((DMatrixD1)massMatrices.get(j)), (DMatrixD1)((DMatrixD1)massMatrices.get(j - 1)), (DMatrixD1)diffMassMatrix);
                double[] data = diffMassMatrix.getData();
                for (int k = 0; k < data.length; ++k) {
                    Assert.assertEquals(0.0, data[k], eps);
                }
            }
        }
    }
}

