/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.mecano.algorithms.InverseDynamicsCalculator;
import us.ihmc.mecano.multiBodySystem.Joint;
import us.ihmc.mecano.multiBodySystem.OneDoFJoint;
import us.ihmc.mecano.multiBodySystem.PrismaticJoint;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoRandomTools;
import us.ihmc.mecano.tools.MecanoTestTools;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.screwTheory.GravityCoriolisExternalWrenchMatrixCalculator;

public class GravityCoriolisExternalWrenchMatrixCalculatorTest {
    private static final int ITERATIONS = 500;
    private static final double ONE_DOF_JOINT_EPSILON = 8.0E-12;
    private static final double FLOATING_JOINT_EPSILON = 2.0E-11;
    private static final double ALL_JOINT_EPSILON = 1.0E-4;

    @Test
    public void testPrismaticJointChain() throws Exception {
        Random random = new Random(21654L);
        for (int i = 0; i < 500; ++i) {
            int numberOfJoints = random.nextInt(50) + 1;
            List joints = MultiBodySystemRandomTools.nextPrismaticJointChain((Random)random, (int)numberOfJoints);
            this.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.emptyList(), 8.0E-12);
            this.compareAgainstInverseDynamicsCalculator(random, i, joints, GravityCoriolisExternalWrenchMatrixCalculatorTest.nextExternalWrenches(random, joints), Collections.emptyList(), 8.0E-12);
            this.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.singletonList((PrismaticJoint)joints.get(random.nextInt(joints.size()))), 8.0E-12);
        }
    }

    @Test
    public void testPrismaticJointTree() throws Exception {
        Random random = new Random(21654L);
        for (int i = 0; i < 500; ++i) {
            int numberOfJoints = random.nextInt(50) + 1;
            List joints = MultiBodySystemRandomTools.nextPrismaticJointTree((Random)random, (int)numberOfJoints);
            this.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.emptyList(), 8.0E-12);
            this.compareAgainstInverseDynamicsCalculator(random, i, joints, GravityCoriolisExternalWrenchMatrixCalculatorTest.nextExternalWrenches(random, joints), Collections.emptyList(), 8.0E-12);
            this.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.singletonList((PrismaticJoint)joints.get(random.nextInt(joints.size()))), 8.0E-12);
        }
    }

    @Test
    public void testRevoluteJointChain() throws Exception {
        Random random = new Random(2654L);
        for (int i = 0; i < 500; ++i) {
            int numberOfJoints = random.nextInt(50) + 1;
            List joints = MultiBodySystemRandomTools.nextRevoluteJointChain((Random)random, (int)numberOfJoints);
            this.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.emptyList(), 8.0E-12);
            this.compareAgainstInverseDynamicsCalculator(random, i, joints, GravityCoriolisExternalWrenchMatrixCalculatorTest.nextExternalWrenches(random, joints), Collections.emptyList(), 8.0E-12);
            this.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.singletonList((RevoluteJoint)joints.get(random.nextInt(joints.size()))), 8.0E-12);
        }
    }

    @Test
    public void testRevoluteJointTree() throws Exception {
        Random random = new Random(21654L);
        for (int i = 0; i < 500; ++i) {
            List joints = MultiBodySystemRandomTools.nextRevoluteJointTree((Random)random, (int)(random.nextInt(50) + 1));
            this.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.emptyList(), 8.0E-12);
            this.compareAgainstInverseDynamicsCalculator(random, i, joints, GravityCoriolisExternalWrenchMatrixCalculatorTest.nextExternalWrenches(random, joints), Collections.emptyList(), 8.0E-12);
            joints = MultiBodySystemRandomTools.nextRevoluteJointTree((Random)random, (int)(random.nextInt(40) + 1));
            this.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.singletonList((RevoluteJoint)joints.get(random.nextInt(joints.size()))), 8.0E-12);
        }
    }

    @Test
    public void testOneDoFJointChain() throws Exception {
        Random random = new Random(21654L);
        for (int i = 0; i < 500; ++i) {
            int numberOfJoints = random.nextInt(50) + 1;
            List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
            this.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.emptyList(), 8.0E-12);
            this.compareAgainstInverseDynamicsCalculator(random, i, joints, GravityCoriolisExternalWrenchMatrixCalculatorTest.nextExternalWrenches(random, joints), Collections.emptyList(), 8.0E-12);
            this.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.singletonList((OneDoFJoint)joints.get(random.nextInt(joints.size()))), 8.0E-12);
        }
    }

    @Test
    public void testOneDoFJointTree() throws Exception {
        Random random = new Random(21654L);
        for (int i = 0; i < 500; ++i) {
            int numberOfJoints = random.nextInt(50) + 1;
            List joints = MultiBodySystemRandomTools.nextOneDoFJointTree((Random)random, (int)numberOfJoints);
            this.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.emptyList(), 8.0E-12);
            this.compareAgainstInverseDynamicsCalculator(random, i, joints, GravityCoriolisExternalWrenchMatrixCalculatorTest.nextExternalWrenches(random, joints), Collections.emptyList(), 8.0E-12);
            this.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.singletonList((OneDoFJoint)joints.get(random.nextInt(joints.size()))), 8.0E-12);
        }
    }

    @Test
    public void testFloatingRevoluteJointChain() throws Exception {
        Random random = new Random(21654L);
        for (int i = 0; i < 500; ++i) {
            int numberOfJoints = random.nextInt(40) + 1;
            List joints = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(random, numberOfJoints).getJoints();
            this.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.emptyList(), 2.0E-11);
            this.compareAgainstInverseDynamicsCalculator(random, i, joints, GravityCoriolisExternalWrenchMatrixCalculatorTest.nextExternalWrenches(random, joints), Collections.emptyList(), 2.0E-11);
            this.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.singletonList((Joint)joints.get(random.nextInt(joints.size()))), 4.0E-11);
        }
    }

    @Test
    public void testJointChain() throws Exception {
        Random random = new Random(21654L);
        for (int i = 0; i < 500; ++i) {
            int numberOfJoints = random.nextInt(40) + 1;
            List joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
            this.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.emptyList(), 1.0E-4);
            this.compareAgainstInverseDynamicsCalculator(random, i, joints, GravityCoriolisExternalWrenchMatrixCalculatorTest.nextExternalWrenches(random, joints), Collections.emptyList(), 1.0E-4);
            this.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.singletonList((JointBasics)joints.get(random.nextInt(joints.size()))), 1.0E-4);
        }
    }

    private void compareAgainstInverseDynamicsCalculator(Random random, int iteration, List<? extends JointBasics> joints, Map<RigidBodyReadOnly, WrenchReadOnly> externalWrenches, List<? extends JointReadOnly> jointsToIgnore, double epsilon) {
        MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, joints);
        MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, joints);
        MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.ACCELERATION, joints);
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)joints.get(0).getPredecessor());
        MultiBodySystemReadOnly multiBodySystemInput = MultiBodySystemReadOnly.toMultiBodySystemInput((RigidBodyReadOnly)rootBody, jointsToIgnore);
        rootBody.updateFramesRecursively();
        double gravity = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)-1.0);
        InverseDynamicsCalculator inverseDynamicsCalculator = new InverseDynamicsCalculator(multiBodySystemInput, true, false);
        inverseDynamicsCalculator.setGravitionalAcceleration(gravity);
        GravityCoriolisExternalWrenchMatrixCalculator gcewmCalculator = new GravityCoriolisExternalWrenchMatrixCalculator(multiBodySystemInput);
        gcewmCalculator.setGravitionalAcceleration(gravity);
        int numberOfDoFs = joints.stream().mapToInt(JointReadOnly::getDegreesOfFreedom).sum();
        externalWrenches.forEach((arg_0, arg_1) -> ((InverseDynamicsCalculator)inverseDynamicsCalculator).setExternalWrench(arg_0, arg_1));
        inverseDynamicsCalculator.compute();
        DMatrixRMaj tau_expected = inverseDynamicsCalculator.getJointTauMatrix();
        externalWrenches.forEach((arg_0, arg_1) -> ((GravityCoriolisExternalWrenchMatrixCalculator)gcewmCalculator).setExternalWrench(arg_0, arg_1));
        gcewmCalculator.compute();
        DMatrixRMaj tau_actual = gcewmCalculator.getJointTauMatrix();
        boolean areEqual = MatrixFeatures_DDRM.isEquals((DMatrixD1)tau_expected, (DMatrixD1)tau_actual, (double)epsilon);
        if (!areEqual) {
            System.out.println("iteration: " + iteration);
            double maxError = 0.0;
            DMatrixRMaj output = new DMatrixRMaj(numberOfDoFs, 3);
            for (int row = 0; row < numberOfDoFs; ++row) {
                output.set(row, 0, tau_expected.get(row, 0));
                output.set(row, 1, tau_actual.get(row, 0));
                double error = tau_expected.get(row, 0) - tau_actual.get(row, 0);
                output.set(row, 2, error);
                maxError = Math.max(maxError, Math.abs(error));
            }
            output.print(EuclidCoreIOTools.getStringFormat((int)9, (int)6));
            System.out.println("Max error: " + maxError);
        }
        Assertions.assertTrue((boolean)areEqual);
        List allRigidBodies = rootBody.subtreeList();
        for (RigidBodyReadOnly rigidBody : allRigidBodies) {
            try {
                SpatialAccelerationReadOnly expectedAccelerationOfBody = inverseDynamicsCalculator.getAccelerationProvider().getAccelerationOfBody(rigidBody);
                if (expectedAccelerationOfBody == null) {
                    Assertions.assertNull((Object)gcewmCalculator.getAccelerationProvider().getAccelerationOfBody(rigidBody));
                    continue;
                }
                SpatialAcceleration actualAccelerationOfBody = new SpatialAcceleration((SpatialMotionReadOnly)gcewmCalculator.getAccelerationProvider().getAccelerationOfBody(rigidBody));
                actualAccelerationOfBody.changeFrame(expectedAccelerationOfBody.getReferenceFrame());
                MecanoTestTools.assertSpatialAccelerationEquals((SpatialAccelerationReadOnly)expectedAccelerationOfBody, (SpatialAccelerationReadOnly)actualAccelerationOfBody, (double)epsilon);
                for (int i = 0; i < 5; ++i) {
                    RigidBodyBasics otherRigidBody = (RigidBodyBasics)allRigidBodies.get(random.nextInt(allRigidBodies.size()));
                    SpatialAccelerationReadOnly expectedRelativeAcceleration = inverseDynamicsCalculator.getAccelerationProvider().getRelativeAcceleration(rigidBody, (RigidBodyReadOnly)otherRigidBody);
                    if (expectedAccelerationOfBody == null) {
                        Assertions.assertNull((Object)gcewmCalculator.getAccelerationProvider().getRelativeAcceleration((RigidBodyReadOnly)otherRigidBody, rigidBody));
                        continue;
                    }
                    SpatialAccelerationReadOnly actualRelativeAcceleration = gcewmCalculator.getAccelerationProvider().getRelativeAcceleration(rigidBody, (RigidBodyReadOnly)otherRigidBody);
                    MecanoTestTools.assertSpatialAccelerationEquals((SpatialAccelerationReadOnly)expectedRelativeAcceleration, (SpatialAccelerationReadOnly)actualRelativeAcceleration, (double)epsilon);
                }
            }
            catch (NullPointerException nullPointerException) {
            }
        }
    }

    public static Map<RigidBodyReadOnly, WrenchReadOnly> nextExternalWrenches(Random random, List<? extends JointReadOnly> joints) {
        return joints.stream().filter(j -> random.nextBoolean()).map(j -> j.getSuccessor()).collect(Collectors.toMap(b -> b, b -> MecanoRandomTools.nextWrench((Random)random, (ReferenceFrame)b.getBodyFixedFrame(), (ReferenceFrame)b.getBodyFixedFrame())));
    }
}

