/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.util.List;
import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.Joint;
import us.ihmc.mecano.multiBodySystem.OneDoFJoint;
import us.ihmc.mecano.multiBodySystem.PrismaticJoint;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.SixDoFJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoTestTools;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.screwTheory.GeometricJacobian;

public class GeometricJacobianTest {
    private final Random random = new Random(101L);
    private GeometricJacobian bodyManipulatorJacobian;
    private GeometricJacobian spatialManipulatorJacobian;
    private PrismaticJoint joint1;
    private RevoluteJoint joint2;
    private PrismaticJoint joint3;

    @BeforeEach
    public void setUp() throws Exception {
        this.buildMechanismAndJacobians();
        this.joint1.setQ(this.random.nextDouble());
        this.joint2.setQ(this.random.nextDouble());
        this.joint3.setQ(this.random.nextDouble());
    }

    @AfterEach
    public void tearDown() throws Exception {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testAgainstTwistCalculatorChainRobot() throws Exception {
        Random random = new Random(4324342L);
        int numberOfJoints = random.nextInt(100);
        List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)((OneDoFJoint)joints.get(0)).getSuccessor());
        Twist expectedTwist = new Twist();
        Twist actualTwist = new Twist();
        for (int i = 0; i < 1000; ++i) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (double)-1.5707963267948966, (double)1.5707963267948966, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (double)-10.0, (double)10.0, (Iterable)joints);
            rootBody.updateFramesRecursively();
            int randomEndEffectorIndex = random.nextInt(numberOfJoints);
            RigidBodyBasics randomEndEffector = ((OneDoFJoint)joints.get(randomEndEffectorIndex)).getSuccessor();
            GeometricJacobian rootJacobian = new GeometricJacobian(rootBody, randomEndEffector, (ReferenceFrame)randomEndEffector.getBodyFixedFrame());
            rootJacobian.compute();
            DMatrixRMaj jointVelocitiesMatrix = new DMatrixRMaj(rootJacobian.getNumberOfColumns(), 1);
            MultiBodySystemTools.extractJointsState((JointReadOnly[])rootJacobian.getJointsInOrder(), (JointStateType)JointStateType.VELOCITY, (DMatrix)jointVelocitiesMatrix);
            randomEndEffector.getBodyFixedFrame().getTwistRelativeToOther((ReferenceFrame)rootBody.getBodyFixedFrame(), (TwistBasics)expectedTwist);
            rootJacobian.getTwist(jointVelocitiesMatrix, actualTwist);
            MecanoTestTools.assertTwistEquals((TwistReadOnly)expectedTwist, (TwistReadOnly)actualTwist, (double)1.0E-12);
            RigidBodyBasics randomBase = ((OneDoFJoint)joints.get(random.nextInt(randomEndEffectorIndex + 1))).getPredecessor();
            GeometricJacobian jacobian = new GeometricJacobian(randomBase, randomEndEffector, (ReferenceFrame)randomEndEffector.getBodyFixedFrame());
            jacobian.compute();
            jointVelocitiesMatrix.reshape(jacobian.getNumberOfColumns(), 1);
            MultiBodySystemTools.extractJointsState((JointReadOnly[])jacobian.getJointsInOrder(), (JointStateType)JointStateType.VELOCITY, (DMatrix)jointVelocitiesMatrix);
            randomEndEffector.getBodyFixedFrame().getTwistRelativeToOther((ReferenceFrame)randomBase.getBodyFixedFrame(), (TwistBasics)expectedTwist);
            jacobian.getTwist(jointVelocitiesMatrix, actualTwist);
            MecanoTestTools.assertTwistEquals((TwistReadOnly)expectedTwist, (TwistReadOnly)actualTwist, (double)1.0E-12);
        }
    }

    @Test
    public void testAgainstTwistCalculatorFloatingJointRobot() throws Exception {
        Random random = new Random(4324342L);
        int numberOfJoints = random.nextInt(100);
        MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain floatingChain = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(random, numberOfJoints);
        SixDoFJoint floatingJoint = floatingChain.getRootJoint();
        List revoluteJoints = floatingChain.getRevoluteJoints();
        List joints = floatingChain.getJoints();
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)((Joint)joints.get(0)).getSuccessor());
        Twist expectedTwist = new Twist();
        Twist actualTwist = new Twist();
        for (int i = 0; i < 1000; ++i) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (JointBasics)floatingJoint);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (JointBasics)floatingJoint);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (double)-1.5707963267948966, (double)1.5707963267948966, (Iterable)revoluteJoints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (double)-10.0, (double)10.0, (Iterable)revoluteJoints);
            floatingChain.getElevator().updateFramesRecursively();
            int randomEndEffectorIndex = random.nextInt(numberOfJoints);
            RigidBodyBasics randomEndEffector = ((Joint)joints.get(randomEndEffectorIndex)).getSuccessor();
            GeometricJacobian rootJacobian = new GeometricJacobian(rootBody, randomEndEffector, (ReferenceFrame)randomEndEffector.getBodyFixedFrame());
            rootJacobian.compute();
            DMatrixRMaj jointVelocitiesMatrix = new DMatrixRMaj(rootJacobian.getNumberOfColumns(), 1);
            MultiBodySystemTools.extractJointsState((JointReadOnly[])rootJacobian.getJointsInOrder(), (JointStateType)JointStateType.VELOCITY, (DMatrix)jointVelocitiesMatrix);
            randomEndEffector.getBodyFixedFrame().getTwistRelativeToOther((ReferenceFrame)rootBody.getBodyFixedFrame(), (TwistBasics)expectedTwist);
            rootJacobian.getTwist(jointVelocitiesMatrix, actualTwist);
            MecanoTestTools.assertTwistEquals((TwistReadOnly)expectedTwist, (TwistReadOnly)actualTwist, (double)1.0E-12);
            RigidBodyBasics randomBase = ((Joint)joints.get(random.nextInt(randomEndEffectorIndex + 1))).getPredecessor();
            GeometricJacobian jacobian = new GeometricJacobian(randomBase, randomEndEffector, (ReferenceFrame)randomEndEffector.getBodyFixedFrame());
            jacobian.compute();
            jointVelocitiesMatrix.reshape(jacobian.getNumberOfColumns(), 1);
            MultiBodySystemTools.extractJointsState((JointReadOnly[])jacobian.getJointsInOrder(), (JointStateType)JointStateType.VELOCITY, (DMatrix)jointVelocitiesMatrix);
            randomEndEffector.getBodyFixedFrame().getTwistRelativeToOther((ReferenceFrame)randomBase.getBodyFixedFrame(), (TwistBasics)expectedTwist);
            jacobian.getTwist(jointVelocitiesMatrix, actualTwist);
            MecanoTestTools.assertTwistEquals((TwistReadOnly)expectedTwist, (TwistReadOnly)actualTwist, (double)1.0E-12);
        }
    }

    @Test
    public void testDuindamExample() {
        this.joint1.getPredecessor().updateFramesRecursively();
        this.bodyManipulatorJacobian.compute();
        this.spatialManipulatorJacobian.compute();
        double q1d = this.random.nextDouble();
        double q2d = this.random.nextDouble();
        double q3d = this.random.nextDouble();
        DMatrixRMaj qd = new DMatrixRMaj(3, 1);
        qd.set(0, 0, q1d);
        qd.set(1, 0, q2d);
        qd.set(2, 0, q3d);
        DMatrixRMaj twistMatrixFromBodyManipulatorJacobian = new DMatrixRMaj(6, 1);
        CommonOps_DDRM.mult((DMatrix1Row)this.bodyManipulatorJacobian.getJacobianMatrix(), (DMatrix1Row)qd, (DMatrix1Row)twistMatrixFromBodyManipulatorJacobian);
        Twist twistFromBodyManipulatorJacobian = new Twist(this.bodyManipulatorJacobian.getEndEffectorFrame(), this.bodyManipulatorJacobian.getBaseFrame(), this.bodyManipulatorJacobian.getJacobianFrame(), (DMatrix)twistMatrixFromBodyManipulatorJacobian);
        Vector3D omegaFromBodyManipulatorJacobian = new Vector3D((Tuple3DReadOnly)twistFromBodyManipulatorJacobian.getAngularPart());
        Vector3D vFromBodyManipulatorJacobian = new Vector3D((Tuple3DReadOnly)twistFromBodyManipulatorJacobian.getLinearPart());
        DMatrixRMaj twistMatrixFromSpatialManipulatorJacobian = new DMatrixRMaj(6, 1);
        CommonOps_DDRM.mult((DMatrix1Row)this.spatialManipulatorJacobian.getJacobianMatrix(), (DMatrix1Row)qd, (DMatrix1Row)twistMatrixFromSpatialManipulatorJacobian);
        Twist twistFromSpatialManipulatorJacobian = new Twist(this.spatialManipulatorJacobian.getEndEffectorFrame(), this.spatialManipulatorJacobian.getBaseFrame(), this.spatialManipulatorJacobian.getJacobianFrame(), (DMatrix)twistMatrixFromSpatialManipulatorJacobian);
        Vector3D omegaFromSpatialManipulatorJacobian = new Vector3D((Tuple3DReadOnly)twistFromSpatialManipulatorJacobian.getAngularPart());
        Vector3D vFromSpatialManipulatorJacobian = new Vector3D((Tuple3DReadOnly)twistFromSpatialManipulatorJacobian.getLinearPart());
        double q1 = this.joint1.getQ();
        double q2 = this.joint2.getQ();
        double q3 = this.joint3.getQ();
        double epsilon = 1.0E-8;
        Vector3D omegaBodyByHand = new Vector3D(-q2d, 0.0, 0.0);
        Vector3D vBodyByHand = new Vector3D(0.0, -Math.cos(q2) * q1d + q3 * q2d, -Math.sin(q2) * q1d + q3d);
        Vector3D omegaBodyError = new Vector3D((Tuple3DReadOnly)omegaFromBodyManipulatorJacobian);
        omegaBodyError.sub((Tuple3DReadOnly)omegaBodyByHand);
        Assert.assertEquals(0.0, omegaBodyError.length(), epsilon);
        Vector3D vBodyError = new Vector3D((Tuple3DReadOnly)vFromBodyManipulatorJacobian);
        vBodyError.sub((Tuple3DReadOnly)vBodyByHand);
        Assert.assertEquals(0.0, vBodyError.length(), epsilon);
        Vector3D omegaSpatialByHand = new Vector3D(-q2d, 0.0, 0.0);
        Vector3D vSpatialByHand = new Vector3D(0.0, -q1d - 3.0 * q2d + Math.sin(q2) * q3d, -q1 * q2d + Math.cos(q2) * q3d);
        Vector3D omegaSpatialError = new Vector3D((Tuple3DReadOnly)omegaFromSpatialManipulatorJacobian);
        omegaSpatialError.sub((Tuple3DReadOnly)omegaSpatialByHand);
        Assert.assertEquals(0.0, omegaSpatialError.length(), epsilon);
        Vector3D vSpatialError = new Vector3D((Tuple3DReadOnly)vFromSpatialManipulatorJacobian);
        vSpatialError.sub((Tuple3DReadOnly)vSpatialByHand);
        Assert.assertEquals(0.0, vSpatialError.length(), epsilon);
        FrameVector3D omegaInBaseFrame = new FrameVector3D((FrameTuple3DReadOnly)twistFromBodyManipulatorJacobian.getAngularPart());
        omegaInBaseFrame.changeFrame(twistFromBodyManipulatorJacobian.getBaseFrame());
        FrameVector3D vInBaseFrame = new FrameVector3D((FrameTuple3DReadOnly)twistFromBodyManipulatorJacobian.getLinearPart());
        vInBaseFrame.changeFrame(twistFromBodyManipulatorJacobian.getBaseFrame());
        Vector3D omegaInBaseFrameByHand = new Vector3D(-q2d, 0.0, 0.0);
        Vector3D vInBaseFrameByHand = new Vector3D(0.0, -q1d + Math.cos(q2) * q3 * q2d + Math.sin(q2) * q3d, -Math.sin(q2) * q3 * q2d + Math.cos(q2) * q3d);
        omegaBodyError = new Vector3D((Tuple3DReadOnly)omegaInBaseFrame);
        omegaBodyError.sub((Tuple3DReadOnly)omegaInBaseFrameByHand);
        Assert.assertEquals(0.0, omegaBodyError.length(), epsilon);
        vBodyError = new Vector3D((Tuple3DReadOnly)vInBaseFrame);
        vBodyError.sub((Tuple3DReadOnly)vInBaseFrameByHand);
        Assert.assertEquals(0.0, vBodyError.length(), epsilon);
    }

    private void buildMechanismAndJacobians() {
        RigidBody base = new RigidBody("base", ReferenceFrame.getWorldFrame());
        this.joint1 = new PrismaticJoint("joint1", (RigidBodyBasics)base, (Tuple3DReadOnly)new Vector3D(), (Vector3DReadOnly)new Vector3D(0.0, -1.0, 0.0));
        RigidBody body1 = new RigidBody("body1", (JointBasics)this.joint1, (Matrix3DReadOnly)new Matrix3D(), 0.0, (Tuple3DReadOnly)new Vector3D());
        this.joint2 = new RevoluteJoint("joint2", (RigidBodyBasics)body1, (Tuple3DReadOnly)new Vector3D(0.0, 0.0, 3.0), (Vector3DReadOnly)new Vector3D(-1.0, 0.0, 0.0));
        RigidBody body2 = new RigidBody("body2", (JointBasics)this.joint2, (Matrix3DReadOnly)new Matrix3D(), 0.0, (Tuple3DReadOnly)new Vector3D());
        this.joint3 = new PrismaticJoint("joint4", (RigidBodyBasics)body2, (Tuple3DReadOnly)new Vector3D(), (Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0));
        RigidBody body3 = new RigidBody("body3", (JointBasics)this.joint3, (Matrix3DReadOnly)new Matrix3D(), 0.0, (Tuple3DReadOnly)new Vector3D());
        this.bodyManipulatorJacobian = new GeometricJacobian((RigidBodyBasics)base, (RigidBodyBasics)body3, (ReferenceFrame)this.joint3.getFrameAfterJoint());
        this.spatialManipulatorJacobian = new GeometricJacobian((RigidBodyBasics)base, (RigidBodyBasics)body3, (ReferenceFrame)this.joint1.getFrameBeforeJoint());
    }
}

