/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.robotSide;

import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.robotSide.RobotSide;

public class RobotSideTest {
    @Test
    public void testRobotSide() {
        RobotSide leftRobotSide = RobotSide.LEFT;
        RobotSide rightRobotSide = RobotSide.RIGHT;
        Assert.assertEquals(rightRobotSide, leftRobotSide.getOppositeSide());
        Assert.assertEquals(leftRobotSide, rightRobotSide.getOppositeSide());
        Assert.assertEquals("r", rightRobotSide.getShortLowerCaseName());
        Assert.assertEquals("l", leftRobotSide.getShortLowerCaseName());
        Assert.assertEquals("right", rightRobotSide.getCamelCaseNameForStartOfExpression());
        Assert.assertEquals("left", leftRobotSide.getCamelCaseNameForStartOfExpression());
        Assert.assertEquals("Right", rightRobotSide.getCamelCaseNameForMiddleOfExpression());
        Assert.assertEquals("Left", leftRobotSide.getCamelCaseNameForMiddleOfExpression());
        Assert.assertEquals("right", rightRobotSide.getLowerCaseName());
        Assert.assertEquals("left", leftRobotSide.getLowerCaseName());
        Assert.assertEquals("RIGHT", rightRobotSide.getSideNameInAllCaps());
        Assert.assertEquals("LEFT", leftRobotSide.getSideNameInAllCaps());
        Assert.assertEquals("R", rightRobotSide.getSideNameFirstLetter());
        Assert.assertEquals("L", leftRobotSide.getSideNameFirstLetter());
        Assert.assertEquals("/right_leg", rightRobotSide.getSideStringInRobonetFormat());
        Assert.assertEquals("/left_leg", leftRobotSide.getSideStringInRobonetFormat());
        Assert.assertEquals("right_leg", rightRobotSide.getSideStringInRobonetFormatWithoutSlash());
        Assert.assertEquals("left_leg", leftRobotSide.getSideStringInRobonetFormatWithoutSlash());
        Assert.assertEquals(rightRobotSide, RobotSide.getSideFromString((String)"R"));
        Assert.assertEquals(rightRobotSide, RobotSide.getSideFromString((String)"Right"));
        Assert.assertEquals(rightRobotSide, RobotSide.getSideFromString((String)"right"));
        Assert.assertEquals(rightRobotSide, RobotSide.getSideFromString((String)"r"));
        Assert.assertEquals(leftRobotSide, RobotSide.getSideFromString((String)"L"));
        Assert.assertEquals(leftRobotSide, RobotSide.getSideFromString((String)"Left"));
        Assert.assertEquals(leftRobotSide, RobotSide.getSideFromString((String)"left"));
        Assert.assertEquals(leftRobotSide, RobotSide.getSideFromString((String)"l"));
        double numberToTest = 34.33;
        Assert.assertEquals(numberToTest, rightRobotSide.negateIfLeftSide(numberToTest), 1.0E-7);
        Assert.assertEquals(-numberToTest, leftRobotSide.negateIfLeftSide(numberToTest), 1.0E-7);
        numberToTest = 74.99;
        Assert.assertEquals(-numberToTest, rightRobotSide.negateIfRightSide(numberToTest), 1.0E-7);
        Assert.assertEquals(numberToTest, leftRobotSide.negateIfRightSide(numberToTest), 1.0E-7);
    }

    @Test
    public void testCheckRobotSideMatch() {
        RobotSide leftRobotSide = RobotSide.LEFT;
        RobotSide rightRobotSide = RobotSide.RIGHT;
        RobotSide nullRobotSide = null;
        leftRobotSide.checkRobotSideMatch(RobotSide.LEFT);
        rightRobotSide.checkRobotSideMatch(RobotSide.RIGHT);
        try {
            leftRobotSide.checkRobotSideMatch(RobotSide.RIGHT);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            rightRobotSide.checkRobotSideMatch(RobotSide.LEFT);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            leftRobotSide.checkRobotSideMatch(nullRobotSide);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            rightRobotSide.checkRobotSideMatch(nullRobotSide);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

