/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.robotSide;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.robotSide.RecyclingQuadrantDependentList;
import us.ihmc.robotics.robotSide.RobotQuadrant;

public class RecyclingQuadrantDependentListTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testBasicMethods() {
        RecyclingQuadrantDependentList recyclingQuadrantDependentList = new RecyclingQuadrantDependentList(FramePoint3D.class);
        FramePoint3D zeroPoint = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        for (RobotQuadrant robotQuadrant : RobotQuadrant.values) {
            recyclingQuadrantDependentList.add(robotQuadrant);
            Assert.assertTrue("not equal", zeroPoint.epsilonEquals((EuclidFrameGeometry)recyclingQuadrantDependentList.get((Enum)robotQuadrant), 1.0E-7));
        }
        FramePoint3D framePoint = (FramePoint3D)recyclingQuadrantDependentList.get((Enum)RobotQuadrant.FRONT_LEFT);
        recyclingQuadrantDependentList.remove(RobotQuadrant.FRONT_LEFT);
        Assert.assertEquals("not size 3", 3L, recyclingQuadrantDependentList.size());
        recyclingQuadrantDependentList.add(RobotQuadrant.FRONT_LEFT);
        FramePoint3D framePoint2 = (FramePoint3D)recyclingQuadrantDependentList.get((Enum)RobotQuadrant.FRONT_LEFT);
        Assert.assertTrue("not equal", framePoint2.epsilonEquals((EuclidFrameGeometry)framePoint, 1.0E-7));
        Assert.assertTrue("ref not equal", framePoint2 == framePoint);
        for (int i = 0; i < 4; ++i) {
            ((FramePoint3D)recyclingQuadrantDependentList.get((Enum)RobotQuadrant.values[i])).add((double)i, 0.0, 0.0);
        }
        for (int j = 0; j < ((FramePoint3D[])recyclingQuadrantDependentList.keys()).length; ++j) {
            RobotQuadrant[] framePoint3 = ((FramePoint3D[])recyclingQuadrantDependentList.keys())[j];
            Assert.assertEquals("not equal", (double)j, framePoint3.getX(), 1.0E-7);
        }
        recyclingQuadrantDependentList.remove(RobotQuadrant.FRONT_LEFT);
        int k = 0;
        for (RobotQuadrant quadrant : recyclingQuadrantDependentList.quadrants()) {
            ((FramePoint3D)recyclingQuadrantDependentList.get((Enum)quadrant)).set((double)(k - 6), 0.0, 0.0);
            ++k;
        }
        for (int j = 0; j < ((FramePoint3D[])recyclingQuadrantDependentList.keys()).length; ++j) {
            FramePoint3D framePoint3 = ((FramePoint3D[])recyclingQuadrantDependentList.keys())[j];
            Assert.assertEquals("not equal", (double)(j - 6), framePoint3.getX(), 1.0E-7);
        }
    }
}

