/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.referenceFrames;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.referenceFrames.TranslationReferenceFrame;

public class TranslationReferenceFrameTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testUpdateInMiddleFrame() {
        TranslationReferenceFrame frame1 = new TranslationReferenceFrame("frame1", ReferenceFrame.getWorldFrame());
        TranslationReferenceFrame frame2 = new TranslationReferenceFrame("frame2", (ReferenceFrame)frame1);
        TranslationReferenceFrame frame3 = new TranslationReferenceFrame("frame3", (ReferenceFrame)frame2);
        Vector3D translation1 = new Vector3D(0.1, 0.13, 0.45);
        Vector3D translation2 = new Vector3D(0.7, 0.26, 0.09);
        Vector3D translation3 = new Vector3D(0.04, 0.023, 0.067);
        frame1.updateTranslation((Tuple3DReadOnly)translation1);
        frame2.updateTranslation((Tuple3DReadOnly)translation2);
        frame3.updateTranslation((Tuple3DReadOnly)translation3);
        RigidBodyTransform transformToDesiredFrame = frame3.getTransformToDesiredFrame(ReferenceFrame.getWorldFrame());
        Vector3D totalTranslation = new Vector3D();
        Vector3D expectedTranslation = new Vector3D((Tuple3DReadOnly)translation1);
        expectedTranslation.add((Tuple3DReadOnly)translation2);
        expectedTranslation.add((Tuple3DReadOnly)translation3);
        totalTranslation.set((Tuple3DReadOnly)transformToDesiredFrame.getTranslation());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)totalTranslation, (double)1.0E-7);
        translation2.set(0.33, 0.44, 0.11);
        frame2.updateTranslation((Tuple3DReadOnly)translation2);
        transformToDesiredFrame = frame3.getTransformToDesiredFrame(ReferenceFrame.getWorldFrame());
        totalTranslation = new Vector3D();
        expectedTranslation = new Vector3D((Tuple3DReadOnly)translation1);
        expectedTranslation.add((Tuple3DReadOnly)translation2);
        expectedTranslation.add((Tuple3DReadOnly)translation3);
        totalTranslation.set((Tuple3DReadOnly)transformToDesiredFrame.getTranslation());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)totalTranslation, (double)1.0E-7);
    }
}

