/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.optimization;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.interfaces.linsol.LinearSolverDense;
import org.junit.jupiter.api.Test;
import us.ihmc.matrixlib.MatrixTestTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.functionApproximation.DampedLeastSquaresSolver;
import us.ihmc.robotics.optimization.EqualityConstraintEnforcer;

public class EqualityConstraintEnforcerTest {
    @Test
    public void testSimpleCaseOne() {
        int matrixSize = 1;
        DampedLeastSquaresSolver solver = new DampedLeastSquaresSolver(matrixSize);
        EqualityConstraintEnforcer enforcer = new EqualityConstraintEnforcer((LinearSolverDense)solver);
        DMatrixRMaj j = new DMatrixRMaj((double[][])new double[][]{{1.0, 0.0}});
        DMatrixRMaj p = new DMatrixRMaj((double[][])new double[][]{{2.0}});
        enforcer.setConstraint(j, p);
        DMatrixRMaj checkJQEqualsZeroAfterSetConstraint = enforcer.checkJQEqualsZeroAfterSetConstraint();
        MatrixTestTools.assertMatrixEqualsZero((DMatrix)checkJQEqualsZeroAfterSetConstraint, (double)1.0E-7);
        DMatrixRMaj a = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0}});
        DMatrixRMaj b = new DMatrixRMaj((double[][])new double[][]{{5.0}});
        enforcer.constrainEquation(a, b);
        DMatrixRMaj xBar = new DMatrixRMaj((double[][])new double[][]{{99.0}, {3.0}});
        DMatrixRMaj xSolution = enforcer.constrainResult(xBar);
        Assert.assertEquals(xSolution.get(0), 2.0, 1.0E-7);
        Assert.assertEquals(xSolution.get(1), 3.0, 1.0E-7);
    }

    @Test
    public void testSimpleCaseTwo() {
        int matrixSize = 1;
        DampedLeastSquaresSolver solver = new DampedLeastSquaresSolver(matrixSize);
        EqualityConstraintEnforcer enforcer = new EqualityConstraintEnforcer((LinearSolverDense)solver);
        DMatrixRMaj j = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0, 1.0}});
        DMatrixRMaj p = new DMatrixRMaj((double[][])new double[][]{{9.0}});
        enforcer.setConstraint(j, p);
        DMatrixRMaj checkJQEqualsZeroAfterSetConstraint = enforcer.checkJQEqualsZeroAfterSetConstraint();
        MatrixTestTools.assertMatrixEqualsZero((DMatrix)checkJQEqualsZeroAfterSetConstraint, (double)1.0E-7);
        DMatrixRMaj a = new DMatrixRMaj((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}});
        DMatrixRMaj b = new DMatrixRMaj((double[][])new double[][]{{2.0}, {3.0}});
        enforcer.constrainEquation(a, b);
        DMatrixRMaj xBar = new DMatrixRMaj((double[][])new double[][]{{1.0}, {2.0}, {3.0}});
        DMatrixRMaj xSolution = enforcer.constrainResult(xBar);
        Assert.assertEquals(xSolution.get(0), 2.0, 1.0E-7);
        Assert.assertEquals(xSolution.get(1), 3.0, 1.0E-7);
        Assert.assertEquals(xSolution.get(2), 4.0, 1.0E-7);
    }

    @Test
    public void testSimpleCaseThree() {
        int matrixSize = 1;
        DampedLeastSquaresSolver solver = new DampedLeastSquaresSolver(matrixSize);
        EqualityConstraintEnforcer enforcer = new EqualityConstraintEnforcer((LinearSolverDense)solver);
        DMatrixRMaj j = new DMatrixRMaj((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}});
        DMatrixRMaj p = new DMatrixRMaj((double[][])new double[][]{{2.0}, {3.0}, {4.0}});
        enforcer.setConstraint(j, p);
        DMatrixRMaj checkJQEqualsZeroAfterSetConstraint = enforcer.checkJQEqualsZeroAfterSetConstraint();
        MatrixTestTools.assertMatrixEqualsZero((DMatrix)checkJQEqualsZeroAfterSetConstraint, (double)1.0E-7);
        DMatrixRMaj a = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0, 1.0}});
        DMatrixRMaj b = new DMatrixRMaj((double[][])new double[][]{{9.0}});
        enforcer.constrainEquation(a, b);
        DMatrixRMaj xBar = new DMatrixRMaj((double[][])new double[][]{{97.0}, {-3.0}, {65.0}});
        DMatrixRMaj xSolution = enforcer.constrainResult(xBar);
        Assert.assertEquals(xSolution.get(0), 2.0, 1.0E-7);
        Assert.assertEquals(xSolution.get(1), 3.0, 1.0E-7);
        Assert.assertEquals(xSolution.get(2), 4.0, 1.0E-7);
    }

    @Test
    public void testSimpleOverconstrainedCaseFour() {
        int matrixSize = 1;
        DampedLeastSquaresSolver solver = new DampedLeastSquaresSolver(matrixSize);
        EqualityConstraintEnforcer enforcer = new EqualityConstraintEnforcer((LinearSolverDense)solver);
        DMatrixRMaj j = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0}, {1.0, 1.0}});
        DMatrixRMaj p = new DMatrixRMaj((double[][])new double[][]{{1.0}, {2.0}});
        enforcer.setConstraint(j, p);
        DMatrixRMaj checkJQEqualsZeroAfterSetConstraint = enforcer.checkJQEqualsZeroAfterSetConstraint();
        MatrixTestTools.assertMatrixEqualsZero((DMatrix)checkJQEqualsZeroAfterSetConstraint, (double)1.0E-7);
        DMatrixRMaj a = new DMatrixRMaj((double[][])new double[][]{{1.0, 0.0}});
        DMatrixRMaj b = new DMatrixRMaj((double[][])new double[][]{{3.0}});
        enforcer.constrainEquation(a, b);
        DMatrixRMaj xBar = new DMatrixRMaj((double[][])new double[][]{{5.5}, {1.0}});
        DMatrixRMaj xSolution = enforcer.constrainResult(xBar);
        Assert.assertEquals(xSolution.get(0), 3.0, 1.0E-7);
        Assert.assertEquals(xSolution.get(1), -1.5, 1.0E-7);
    }
}

