/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.trajectories.trajectorypoints.EuclideanTrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameEuclideanTrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.YoFrameEuclideanTrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.EuclideanTrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameEuclideanTrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.FrameEuclideanTrajectoryPointTest;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameEuclideanWaypointReadOnly;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoFrameEuclideanTrajectoryPointTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testCommonUsageExample() {
        String namePrefix = "point";
        String nameSuffix = "toTest";
        YoRegistry registry = new YoRegistry("myRegistry");
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        PoseReferenceFrame poseFrame = new PoseReferenceFrame("poseFrame", (FramePose3DReadOnly)new FramePose3D(worldFrame));
        FramePoint3D poseFramePosition = new FramePoint3D(worldFrame, (Tuple3DReadOnly)new Point3D(0.5, 7.7, 9.2));
        poseFrame.setPositionAndUpdate((FramePoint3DReadOnly)poseFramePosition);
        FrameQuaternion poseOrientation = new FrameQuaternion(worldFrame, (Orientation3DReadOnly)new AxisAngle(1.2, 3.9, 4.7, 2.2));
        poseFrame.setOrientationAndUpdate((FrameOrientation3DReadOnly)poseOrientation);
        YoFrameEuclideanTrajectoryPoint yoFrameEuclideanTrajectoryPoint = new YoFrameEuclideanTrajectoryPoint(namePrefix, nameSuffix, registry);
        EuclideanTrajectoryPoint simpleTrajectoryPoint = new EuclideanTrajectoryPoint();
        double time = 3.4;
        Point3D position = new Point3D(1.0, 2.1, 3.7);
        Vector3D linearVelocity = new Vector3D(-0.4, 1.2, 3.3);
        simpleTrajectoryPoint.set(time, (Point3DReadOnly)position, (Vector3DReadOnly)linearVelocity);
        yoFrameEuclideanTrajectoryPoint.setIncludingFrame(worldFrame, (EuclideanTrajectoryPointReadOnly)simpleTrajectoryPoint);
        yoFrameEuclideanTrajectoryPoint.changeFrame((ReferenceFrame)poseFrame);
        RigidBodyTransform transformToPoseFrame = worldFrame.getTransformToDesiredFrame((ReferenceFrame)poseFrame);
        transformToPoseFrame.transform((Point3DBasics)position);
        transformToPoseFrame.transform((Vector3DBasics)linearVelocity);
        namePrefix = "point";
        nameSuffix = "toVerify";
        YoFrameEuclideanTrajectoryPoint expectedYoFrameEuclideanTrajectoryPoint = new YoFrameEuclideanTrajectoryPoint(namePrefix, nameSuffix, registry, (ReferenceFrame)poseFrame);
        expectedYoFrameEuclideanTrajectoryPoint.setTime(time);
        expectedYoFrameEuclideanTrajectoryPoint.getPosition().set((Tuple3DReadOnly)position);
        expectedYoFrameEuclideanTrajectoryPoint.getLinearVelocity().set((Tuple3DReadOnly)linearVelocity);
        Assert.assertEquals(3.4, yoFrameEuclideanTrajectoryPoint.getTime(), 1.0E-7);
        Assert.assertEquals(3.4, expectedYoFrameEuclideanTrajectoryPoint.getTime(), 1.0E-7);
        Assert.assertTrue(expectedYoFrameEuclideanTrajectoryPoint.epsilonEquals((EuclidFrameGeometry)yoFrameEuclideanTrajectoryPoint, 1.0E-10));
    }

    @Test
    public void testConstructor() {
        ReferenceFrame worldFrame;
        double epsilon = 1.0E-20;
        ReferenceFrame expectedFrame = worldFrame = ReferenceFrame.getWorldFrame();
        double expectedTime = 0.0;
        FramePoint3D expectedPosition = new FramePoint3D(expectedFrame);
        FrameVector3D expectedLinearVelocity = new FrameVector3D(expectedFrame);
        String expectedNamePrefix = "test";
        String expectedNameSuffix = "blop";
        YoFrameEuclideanTrajectoryPoint testedYoFrameEuclideanTrajectoryPoint = new YoFrameEuclideanTrajectoryPoint(expectedNamePrefix, expectedNameSuffix, new YoRegistry("schnoop"), expectedFrame);
        this.assertWaypointContainsExpectedData(expectedNamePrefix, expectedNameSuffix, expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity, testedYoFrameEuclideanTrajectoryPoint, epsilon);
    }

    @Test
    public void testSetters() {
        ReferenceFrame worldFrame;
        double epsilon = 1.0E-20;
        Random random = new Random(21651016L);
        ReferenceFrame expectedFrame = worldFrame = ReferenceFrame.getWorldFrame();
        double expectedTime = 0.0;
        FramePoint3D expectedPosition = new FramePoint3D(expectedFrame);
        FrameVector3D expectedLinearVelocity = new FrameVector3D(expectedFrame);
        String expectedNamePrefix = "test";
        String expectedNameSuffix = "blop";
        YoFrameEuclideanTrajectoryPoint testedYoFrameEuclideanTrajectoryPoint = new YoFrameEuclideanTrajectoryPoint(expectedNamePrefix, expectedNameSuffix, new YoRegistry("schnoop"), expectedFrame);
        this.assertWaypointContainsExpectedData(expectedNamePrefix, expectedNameSuffix, expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity, testedYoFrameEuclideanTrajectoryPoint, epsilon);
        expectedFrame = worldFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        testedYoFrameEuclideanTrajectoryPoint.set(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity);
        this.assertWaypointContainsExpectedData(expectedNamePrefix, expectedNameSuffix, expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity, testedYoFrameEuclideanTrajectoryPoint, epsilon);
        expectedFrame = worldFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        testedYoFrameEuclideanTrajectoryPoint.set(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity);
        this.assertWaypointContainsExpectedData(expectedNamePrefix, expectedNameSuffix, expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity, testedYoFrameEuclideanTrajectoryPoint, epsilon);
        expectedFrame = worldFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        YoFrameEuclideanTrajectoryPoint expectedYoFrameEuclideanTrajectoryPoint = new YoFrameEuclideanTrajectoryPoint("sdfsd", "asd", new YoRegistry("asawe"), expectedFrame);
        testedYoFrameEuclideanTrajectoryPoint.set((FrameEuclideanTrajectoryPointReadOnly)expectedYoFrameEuclideanTrajectoryPoint);
        Assert.assertTrue(expectedYoFrameEuclideanTrajectoryPoint.epsilonEquals((EuclidFrameGeometry)testedYoFrameEuclideanTrajectoryPoint, epsilon));
        this.assertWaypointContainsExpectedData(expectedNamePrefix, expectedNameSuffix, testedYoFrameEuclideanTrajectoryPoint.getReferenceFrame(), testedYoFrameEuclideanTrajectoryPoint.getTime(), (FramePoint3DReadOnly)testedYoFrameEuclideanTrajectoryPoint.getPosition(), (FrameVector3DReadOnly)testedYoFrameEuclideanTrajectoryPoint.getLinearVelocity(), testedYoFrameEuclideanTrajectoryPoint, epsilon);
    }

    @Test
    public void testChangeFrame() throws Exception {
        int i;
        ReferenceFrame worldFrame;
        double epsilon = 1.0E-10;
        Random random = new Random(21651016L);
        ReferenceFrame expectedFrame = worldFrame = ReferenceFrame.getWorldFrame();
        double expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        FramePoint3D expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        FrameVector3D expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        String expectedNamePrefix = "test";
        String expectedNameSuffix = "blop";
        YoFrameEuclideanTrajectoryPoint testedYoFrameEuclideanTrajectoryPoint = new YoFrameEuclideanTrajectoryPoint(expectedNamePrefix, expectedNameSuffix, new YoRegistry("schnoop"), expectedFrame);
        testedYoFrameEuclideanTrajectoryPoint.set(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity);
        ReferenceFrame[] randomFrames = new ReferenceFrame[10];
        randomFrames[0] = worldFrame;
        for (i = 1; i < 10; ++i) {
            randomFrames[i] = EuclidFrameRandomTools.nextReferenceFrame((String)("randomFrame" + i), (Random)random, (ReferenceFrame)(random.nextBoolean() ? worldFrame : randomFrames[random.nextInt(i)]));
        }
        for (i = 0; i < 10000; ++i) {
            expectedFrame = randomFrames[random.nextInt(10)];
            expectedPosition.changeFrame(expectedFrame);
            expectedLinearVelocity.changeFrame(expectedFrame);
            testedYoFrameEuclideanTrajectoryPoint.changeFrame(expectedFrame);
            this.assertWaypointContainsExpectedData(expectedNamePrefix, expectedNameSuffix, expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity, testedYoFrameEuclideanTrajectoryPoint, epsilon);
        }
    }

    @Test
    public void testSetToZero() throws Exception {
        ReferenceFrame worldFrame;
        double epsilon = 1.0E-10;
        Random random = new Random(21651016L);
        ReferenceFrame expectedFrame = worldFrame = ReferenceFrame.getWorldFrame();
        double expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        FramePoint3D expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        FrameVector3D expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        String expectedNamePrefix = "test";
        String expectedNameSuffix = "blop";
        YoFrameEuclideanTrajectoryPoint testedYoFrameEuclideanTrajectoryPoint = new YoFrameEuclideanTrajectoryPoint(expectedNamePrefix, expectedNameSuffix, new YoRegistry("schnoop"), expectedFrame);
        testedYoFrameEuclideanTrajectoryPoint.set(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity);
        expectedTime = 0.0;
        expectedPosition.setToZero();
        expectedLinearVelocity.setToZero();
        testedYoFrameEuclideanTrajectoryPoint.setToZero();
        this.assertWaypointContainsExpectedData(expectedNamePrefix, expectedNameSuffix, expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity, testedYoFrameEuclideanTrajectoryPoint, epsilon);
        expectedFrame = EuclidFrameRandomTools.nextReferenceFrame((String)"blop", (Random)random, (ReferenceFrame)worldFrame);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)worldFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)worldFrame);
        testedYoFrameEuclideanTrajectoryPoint.setToZero(worldFrame);
        testedYoFrameEuclideanTrajectoryPoint.set(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity);
        expectedTime = 0.0;
        expectedPosition.setToZero(expectedFrame);
        expectedLinearVelocity.setToZero(expectedFrame);
        testedYoFrameEuclideanTrajectoryPoint.setToZero(expectedFrame);
        this.assertWaypointContainsExpectedData(expectedNamePrefix, expectedNameSuffix, expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity, testedYoFrameEuclideanTrajectoryPoint, epsilon);
    }

    @Test
    public void testSetToNaN() throws Exception {
        ReferenceFrame worldFrame;
        Random random = new Random(21651016L);
        ReferenceFrame expectedFrame = worldFrame = ReferenceFrame.getWorldFrame();
        double expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        FramePoint3D expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        FrameVector3D expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        String expectedNamePrefix = "test";
        String expectedNameSuffix = "blop";
        YoFrameEuclideanTrajectoryPoint testedYoFrameEuclideanTrajectoryPoint = new YoFrameEuclideanTrajectoryPoint(expectedNamePrefix, expectedNameSuffix, new YoRegistry("schnoop"), expectedFrame);
        testedYoFrameEuclideanTrajectoryPoint.set(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity);
        testedYoFrameEuclideanTrajectoryPoint.setToNaN();
        Assert.assertTrue(Double.isNaN(testedYoFrameEuclideanTrajectoryPoint.getTime()));
        Assert.assertTrue(testedYoFrameEuclideanTrajectoryPoint.getPosition().containsNaN());
        Assert.assertTrue(testedYoFrameEuclideanTrajectoryPoint.getLinearVelocity().containsNaN());
        expectedFrame = EuclidFrameRandomTools.nextReferenceFrame((String)"blop", (Random)random, (ReferenceFrame)worldFrame);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)worldFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)worldFrame);
        testedYoFrameEuclideanTrajectoryPoint.setToZero(worldFrame);
        testedYoFrameEuclideanTrajectoryPoint.set(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity);
        testedYoFrameEuclideanTrajectoryPoint.setToNaN(expectedFrame);
        Assert.assertTrue(expectedFrame == testedYoFrameEuclideanTrajectoryPoint.getReferenceFrame());
        Assert.assertTrue(Double.isNaN(testedYoFrameEuclideanTrajectoryPoint.getTime()));
        Assert.assertTrue(testedYoFrameEuclideanTrajectoryPoint.getPosition().containsNaN());
        Assert.assertTrue(testedYoFrameEuclideanTrajectoryPoint.getLinearVelocity().containsNaN());
    }

    private void assertWaypointContainsExpectedData(String expectedNamePrefix, String expectedNameSuffix, ReferenceFrame expectedFrame, double expectedTime, FramePoint3DReadOnly expectedPosition, FrameVector3DReadOnly expectedLinearVelocity, YoFrameEuclideanTrajectoryPoint testedYoFrameEuclideanTrajectoryPoint, double epsilon) {
        Assert.assertTrue(expectedFrame == testedYoFrameEuclideanTrajectoryPoint.getReferenceFrame());
        Assert.assertEquals(expectedTime, testedYoFrameEuclideanTrajectoryPoint.getTime(), epsilon);
        Assert.assertEquals(expectedNamePrefix, testedYoFrameEuclideanTrajectoryPoint.getNamePrefix());
        Assert.assertEquals(expectedNameSuffix, testedYoFrameEuclideanTrajectoryPoint.getNameSuffix());
        Assert.assertTrue(expectedPosition.epsilonEquals((EuclidFrameGeometry)testedYoFrameEuclideanTrajectoryPoint.getPosition(), epsilon));
        Assert.assertTrue(expectedLinearVelocity.epsilonEquals((EuclidFrameGeometry)testedYoFrameEuclideanTrajectoryPoint.getLinearVelocity(), epsilon));
        FrameEuclideanTrajectoryPoint actualFrameEuclideanTrajectoryPoint = new FrameEuclideanTrajectoryPoint(expectedFrame);
        actualFrameEuclideanTrajectoryPoint.set((FrameEuclideanTrajectoryPointReadOnly)testedYoFrameEuclideanTrajectoryPoint);
        FrameEuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, expectedPosition, expectedLinearVelocity, actualFrameEuclideanTrajectoryPoint, epsilon);
        actualFrameEuclideanTrajectoryPoint = new FrameEuclideanTrajectoryPoint(expectedFrame);
        actualFrameEuclideanTrajectoryPoint.set((FrameEuclideanTrajectoryPointReadOnly)testedYoFrameEuclideanTrajectoryPoint);
        FrameEuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, expectedPosition, expectedLinearVelocity, actualFrameEuclideanTrajectoryPoint, epsilon);
        Point3D actualPosition = new Point3D();
        Vector3D actualLinearVelocity = new Vector3D();
        actualPosition.set((Tuple3DReadOnly)testedYoFrameEuclideanTrajectoryPoint.getPosition());
        actualLinearVelocity.set((Tuple3DReadOnly)testedYoFrameEuclideanTrajectoryPoint.getLinearVelocity());
        Assert.assertTrue(expectedPosition.epsilonEquals((EuclidGeometry)actualPosition, epsilon));
        Assert.assertTrue(expectedLinearVelocity.epsilonEquals((EuclidGeometry)actualLinearVelocity, epsilon));
        FramePoint3D actualFramePosition = new FramePoint3D(expectedFrame);
        FrameVector3D actualFrameLinearVelocity = new FrameVector3D(expectedFrame);
        actualFramePosition.set((FrameTuple3DReadOnly)testedYoFrameEuclideanTrajectoryPoint.getPosition());
        actualFrameLinearVelocity.set((FrameTuple3DReadOnly)testedYoFrameEuclideanTrajectoryPoint.getLinearVelocity());
        Assert.assertTrue(expectedPosition.epsilonEquals((EuclidFrameGeometry)actualFramePosition, epsilon));
        Assert.assertTrue(expectedLinearVelocity.epsilonEquals((EuclidFrameGeometry)actualFrameLinearVelocity, epsilon));
        actualFramePosition = new FramePoint3D();
        actualFrameLinearVelocity = new FrameVector3D();
        actualFramePosition.setIncludingFrame((FrameTuple3DReadOnly)testedYoFrameEuclideanTrajectoryPoint.getPosition());
        actualFrameLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)testedYoFrameEuclideanTrajectoryPoint.getLinearVelocity());
        Assert.assertTrue(expectedPosition.epsilonEquals((EuclidFrameGeometry)actualFramePosition, epsilon));
        Assert.assertTrue(expectedLinearVelocity.epsilonEquals((EuclidFrameGeometry)actualFrameLinearVelocity, epsilon));
    }

    @Test
    public void testSomeSetsAngGets() {
        String namePrefix = "point";
        String nameSuffix = "toTest";
        YoRegistry registry = new YoRegistry("myRegistry");
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        YoFrameEuclideanTrajectoryPoint yoFrameEuclideanTrajectoryPoint = new YoFrameEuclideanTrajectoryPoint(namePrefix, nameSuffix, registry, worldFrame);
        yoFrameEuclideanTrajectoryPoint.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        EuclideanTrajectoryPoint simpleTrajectoryPoint = new EuclideanTrajectoryPoint();
        double time = 3.4;
        Point3D position = new Point3D(1.0, 2.1, 3.7);
        Vector3D linearVelocity = new Vector3D(-0.4, 1.2, 3.3);
        simpleTrajectoryPoint.set(time, (Point3DReadOnly)position, (Vector3DReadOnly)linearVelocity);
        yoFrameEuclideanTrajectoryPoint.setIncludingFrame(worldFrame, (EuclideanTrajectoryPointReadOnly)simpleTrajectoryPoint);
        YoFramePoint3D pointForVerification = new YoFramePoint3D("pointForVerification", worldFrame, registry);
        YoFrameVector3D linearVelocityForVerification = new YoFrameVector3D("linearVelocityForVerification", worldFrame, registry);
        pointForVerification.set((FrameTuple3DReadOnly)yoFrameEuclideanTrajectoryPoint.getPosition());
        linearVelocityForVerification.set((FrameTuple3DReadOnly)yoFrameEuclideanTrajectoryPoint.getLinearVelocity());
        Assert.assertEquals(time, yoFrameEuclideanTrajectoryPoint.getTime(), 1.0E-10);
        Assert.assertTrue(pointForVerification.epsilonEquals((EuclidGeometry)position, 1.0E-10));
        Assert.assertTrue(linearVelocityForVerification.epsilonEquals((EuclidGeometry)linearVelocity, 1.0E-10));
        Assert.assertFalse(yoFrameEuclideanTrajectoryPoint.containsNaN());
        yoFrameEuclideanTrajectoryPoint.getPosition().setToNaN();
        Assert.assertTrue(yoFrameEuclideanTrajectoryPoint.containsNaN());
        yoFrameEuclideanTrajectoryPoint.getPosition().setToZero();
        Assert.assertFalse(yoFrameEuclideanTrajectoryPoint.containsNaN());
        yoFrameEuclideanTrajectoryPoint.getLinearVelocity().setToNaN();
        Assert.assertTrue(yoFrameEuclideanTrajectoryPoint.containsNaN());
        yoFrameEuclideanTrajectoryPoint.getLinearVelocity().setToZero();
        position.set((Tuple3DReadOnly)yoFrameEuclideanTrajectoryPoint.getPosition());
        linearVelocity.set((Tuple3DReadOnly)yoFrameEuclideanTrajectoryPoint.getLinearVelocity());
        Assert.assertTrue(position.epsilonEquals((EuclidGeometry)new Point3D(), 1.0E-10));
        Assert.assertTrue(linearVelocity.epsilonEquals((EuclidGeometry)new Vector3D(), 1.0E-10));
        time = 9.9;
        pointForVerification.set(3.9, 2.2, 1.1);
        linearVelocityForVerification.set(8.8, 1.4, 9.22);
        Assert.assertFalse(Math.abs(yoFrameEuclideanTrajectoryPoint.getTime() - time) < 1.0E-7);
        Assert.assertFalse(pointForVerification.epsilonEquals((EuclidGeometry)position, 1.0E-7));
        Assert.assertFalse(linearVelocityForVerification.epsilonEquals((EuclidGeometry)linearVelocity, 1.0E-7));
        yoFrameEuclideanTrajectoryPoint.set(time, (FramePoint3DReadOnly)pointForVerification, (FrameVector3DReadOnly)linearVelocityForVerification);
        position.set((Tuple3DReadOnly)yoFrameEuclideanTrajectoryPoint.getPosition());
        linearVelocity.set((Tuple3DReadOnly)yoFrameEuclideanTrajectoryPoint.getLinearVelocity());
        Assert.assertEquals(time, yoFrameEuclideanTrajectoryPoint.getTime(), 1.0E-10);
        Assert.assertTrue(pointForVerification.epsilonEquals((EuclidGeometry)position, 1.0E-10));
        Assert.assertTrue(linearVelocityForVerification.epsilonEquals((EuclidGeometry)linearVelocity, 1.0E-10));
        YoFrameEuclideanTrajectoryPoint yoFrameEuclideanTrajectoryPointTwo = new YoFrameEuclideanTrajectoryPoint(namePrefix, nameSuffix + "Two", registry, worldFrame);
        double positionDistance = yoFrameEuclideanTrajectoryPoint.positionDistance((FrameEuclideanWaypointReadOnly)yoFrameEuclideanTrajectoryPointTwo);
        Assert.assertEquals(4.610856753359402, positionDistance, 1.0E-7);
        Assert.assertFalse(yoFrameEuclideanTrajectoryPoint.epsilonEquals((EuclidFrameGeometry)yoFrameEuclideanTrajectoryPointTwo, 1.0E-7));
        yoFrameEuclideanTrajectoryPointTwo.set((FrameEuclideanTrajectoryPointReadOnly)yoFrameEuclideanTrajectoryPoint);
        positionDistance = yoFrameEuclideanTrajectoryPoint.positionDistance((FrameEuclideanWaypointReadOnly)yoFrameEuclideanTrajectoryPointTwo);
        Assert.assertEquals(0.0, positionDistance, 1.0E-7);
        Assert.assertTrue(yoFrameEuclideanTrajectoryPoint.epsilonEquals((EuclidFrameGeometry)yoFrameEuclideanTrajectoryPointTwo, 1.0E-7));
        EuclideanTrajectoryPoint simplePoint = new EuclideanTrajectoryPoint();
        simplePoint.set((EuclideanTrajectoryPointReadOnly)yoFrameEuclideanTrajectoryPoint);
        yoFrameEuclideanTrajectoryPoint.setToNaN();
        Assert.assertTrue(yoFrameEuclideanTrajectoryPoint.containsNaN());
        positionDistance = yoFrameEuclideanTrajectoryPoint.positionDistance((FrameEuclideanWaypointReadOnly)yoFrameEuclideanTrajectoryPointTwo);
        Assert.assertTrue(Double.isNaN(positionDistance));
        Assert.assertFalse(yoFrameEuclideanTrajectoryPoint.epsilonEquals((EuclidFrameGeometry)yoFrameEuclideanTrajectoryPointTwo, 1.0E-7));
        EuclideanTrajectoryPoint trajectoryPointAsInterface = simplePoint;
        yoFrameEuclideanTrajectoryPoint.set((EuclideanTrajectoryPointReadOnly)trajectoryPointAsInterface);
        positionDistance = yoFrameEuclideanTrajectoryPoint.positionDistance((FrameEuclideanWaypointReadOnly)yoFrameEuclideanTrajectoryPointTwo);
        Assert.assertEquals(0.0, positionDistance, 1.0E-7);
        Assert.assertTrue(yoFrameEuclideanTrajectoryPoint.epsilonEquals((EuclidFrameGeometry)yoFrameEuclideanTrajectoryPointTwo, 1.0E-7));
        String string = yoFrameEuclideanTrajectoryPoint.toString();
        String expectedString = "Euclidean trajectory point: [time= 9.900, position=( 3.900,  2.200,  1.100 ), linear velocity=( 8.800,  1.400,  9.220 )] - World";
        Assert.assertEquals(expectedString, string);
    }

    @Test
    public void testSomeMoreSettersAndGetters() {
        String namePrefix = "point";
        String nameSuffix = "toTest";
        YoRegistry registry = new YoRegistry("myRegistry");
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        YoFrameEuclideanTrajectoryPoint yoFrameEuclideanTrajectoryPoint = new YoFrameEuclideanTrajectoryPoint(namePrefix, nameSuffix, registry, worldFrame);
        yoFrameEuclideanTrajectoryPoint.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        double time = 3.4;
        FramePoint3D position = new FramePoint3D(worldFrame, 1.0, 2.1, 3.7);
        FrameVector3D linearVelocity = new FrameVector3D(worldFrame, -0.4, 1.2, 3.3);
        yoFrameEuclideanTrajectoryPoint.setTime(time);
        yoFrameEuclideanTrajectoryPoint.getPosition().set((FrameTuple3DReadOnly)position);
        yoFrameEuclideanTrajectoryPoint.getLinearVelocity().set((FrameTuple3DReadOnly)linearVelocity);
        PoseReferenceFrame poseFrame = new PoseReferenceFrame("poseFrame", (FramePose3DReadOnly)new FramePose3D(worldFrame));
        FramePoint3D poseFramePosition = new FramePoint3D(worldFrame, (Tuple3DReadOnly)new Point3D(0.5, 7.7, 9.2));
        poseFrame.setPositionAndUpdate((FramePoint3DReadOnly)poseFramePosition);
        FrameQuaternion poseOrientation = new FrameQuaternion(worldFrame, (Orientation3DReadOnly)new AxisAngle(1.2, 3.9, 4.7, 2.2));
        poseFrame.setOrientationAndUpdate((FrameOrientation3DReadOnly)poseOrientation);
        yoFrameEuclideanTrajectoryPoint.changeFrame((ReferenceFrame)poseFrame);
        Assert.assertFalse(position.epsilonEquals((EuclidFrameGeometry)yoFrameEuclideanTrajectoryPoint.getPosition(), 1.0E-10));
        Assert.assertFalse(linearVelocity.epsilonEquals((EuclidFrameGeometry)yoFrameEuclideanTrajectoryPoint.getLinearVelocity(), 1.0E-10));
        position.changeFrame((ReferenceFrame)poseFrame);
        linearVelocity.changeFrame((ReferenceFrame)poseFrame);
        Assert.assertTrue(position.epsilonEquals((EuclidFrameGeometry)yoFrameEuclideanTrajectoryPoint.getPosition(), 1.0E-10));
        Assert.assertTrue(linearVelocity.epsilonEquals((EuclidFrameGeometry)yoFrameEuclideanTrajectoryPoint.getLinearVelocity(), 1.0E-10));
        YoFrameEuclideanTrajectoryPoint yoFrameEuclideanTrajectoryPointTwo = new YoFrameEuclideanTrajectoryPoint(namePrefix, nameSuffix + "Two", registry, (ReferenceFrame)poseFrame);
        yoFrameEuclideanTrajectoryPointTwo.setTime(time);
        yoFrameEuclideanTrajectoryPointTwo.getPosition().set((FrameTuple3DReadOnly)position);
        yoFrameEuclideanTrajectoryPointTwo.getLinearVelocity().set((FrameTuple3DReadOnly)linearVelocity);
        Assert.assertTrue(yoFrameEuclideanTrajectoryPointTwo.epsilonEquals((EuclidFrameGeometry)yoFrameEuclideanTrajectoryPointTwo, 1.0E-10));
    }
}

