/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.trajectories.trajectorypoints.SE3TrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SE3TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SE3TrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.EuclideanWaypoint;
import us.ihmc.robotics.math.trajectories.waypoints.SE3Waypoint;
import us.ihmc.robotics.math.trajectories.waypoints.SO3Waypoint;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.EuclideanWaypointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SE3WaypointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SO3WaypointReadOnly;
import us.ihmc.robotics.random.RandomGeometry;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;

public class SE3TrajectoryPointTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testCommonUsageExample() {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        PoseReferenceFrame poseFrame = new PoseReferenceFrame("poseFrame", (FramePose3DReadOnly)new FramePose3D(worldFrame));
        FramePoint3D poseFramePosition = new FramePoint3D(worldFrame, (Tuple3DReadOnly)new Point3D(0.5, 7.7, 9.2));
        poseFrame.setPositionAndUpdate((FramePoint3DReadOnly)poseFramePosition);
        FrameQuaternion poseOrientation = new FrameQuaternion(worldFrame, (Orientation3DReadOnly)new AxisAngle(1.2, 3.9, 4.7, 2.2));
        poseFrame.setOrientationAndUpdate((FrameOrientation3DReadOnly)poseOrientation);
        SE3TrajectoryPoint simpleSE3TrajectoryPoint = new SE3TrajectoryPoint();
        SE3TrajectoryPoint simpleTrajectoryPoint = new SE3TrajectoryPoint();
        double time = 3.4;
        Point3D position = new Point3D(1.0, 2.1, 3.7);
        Quaternion orientation = new Quaternion((QuaternionReadOnly)new Quaternion(0.1, 0.22, 0.34, 0.56));
        orientation.normalize();
        Vector3D linearVelocity = new Vector3D(-0.4, 1.2, 3.3);
        Vector3D angularVelocity = new Vector3D(1.7, 8.4, 2.2);
        simpleTrajectoryPoint.set(time, (Point3DReadOnly)position, (Orientation3DReadOnly)orientation, (Vector3DReadOnly)linearVelocity, (Vector3DReadOnly)angularVelocity);
        simpleSE3TrajectoryPoint.set((SE3TrajectoryPointReadOnly)simpleTrajectoryPoint);
        simpleSE3TrajectoryPoint.applyTransform((Transform)worldFrame.getTransformToDesiredFrame((ReferenceFrame)poseFrame));
        RigidBodyTransform transformToPoseFrame = worldFrame.getTransformToDesiredFrame((ReferenceFrame)poseFrame);
        transformToPoseFrame.transform((Point3DBasics)position);
        orientation.applyTransform((Transform)transformToPoseFrame);
        transformToPoseFrame.transform((Vector3DBasics)linearVelocity);
        transformToPoseFrame.transform((Vector3DBasics)angularVelocity);
        SE3TrajectoryPoint expectedSimpleSE3TrajectoryPoint = new SE3TrajectoryPoint();
        expectedSimpleSE3TrajectoryPoint.setTime(time);
        expectedSimpleSE3TrajectoryPoint.getPosition().set((Tuple3DReadOnly)position);
        expectedSimpleSE3TrajectoryPoint.getOrientation().set((Orientation3DReadOnly)orientation);
        expectedSimpleSE3TrajectoryPoint.getLinearVelocity().set((Tuple3DReadOnly)linearVelocity);
        expectedSimpleSE3TrajectoryPoint.getAngularVelocity().set((Tuple3DReadOnly)angularVelocity);
        Assert.assertEquals(3.4, simpleSE3TrajectoryPoint.getTime(), 1.0E-7);
        Assert.assertEquals(3.4, expectedSimpleSE3TrajectoryPoint.getTime(), 1.0E-7);
        Assert.assertTrue(expectedSimpleSE3TrajectoryPoint.epsilonEquals((EuclidGeometry)simpleSE3TrajectoryPoint, 1.0E-10));
    }

    @Test
    public void testConstructors() {
        double epsilon = 1.0E-14;
        Random random = new Random(21651016L);
        double expectedTime = 0.0;
        Point3D expectedPosition = new Point3D();
        Quaternion expectedOrientation = new Quaternion();
        Vector3D expectedLinearVelocity = new Vector3D();
        Vector3D expectedAngularVelocity = new Vector3D();
        SE3TrajectoryPoint testedSimpleSE3TrajectoryPoint = new SE3TrajectoryPoint();
        SE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedPosition, expectedOrientation, expectedLinearVelocity, expectedAngularVelocity, testedSimpleSE3TrajectoryPoint, epsilon);
        expectedTime = 0.0;
        expectedPosition = new Point3D();
        expectedOrientation = new Quaternion();
        expectedLinearVelocity = new Vector3D();
        expectedAngularVelocity = new Vector3D();
        testedSimpleSE3TrajectoryPoint = new SE3TrajectoryPoint();
        SE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedPosition, expectedOrientation, expectedLinearVelocity, expectedAngularVelocity, testedSimpleSE3TrajectoryPoint, epsilon);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = RandomGeometry.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
        expectedOrientation = RandomGeometry.nextQuaternion((Random)random);
        expectedLinearVelocity = RandomGeometry.nextVector3D((Random)random);
        expectedAngularVelocity = RandomGeometry.nextVector3D((Random)random);
        testedSimpleSE3TrajectoryPoint = new SE3TrajectoryPoint(expectedTime, (Point3DReadOnly)expectedPosition, (Orientation3DReadOnly)expectedOrientation, (Vector3DReadOnly)expectedLinearVelocity, (Vector3DReadOnly)expectedAngularVelocity);
        SE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedPosition, expectedOrientation, expectedLinearVelocity, expectedAngularVelocity, testedSimpleSE3TrajectoryPoint, epsilon);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = RandomGeometry.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
        expectedOrientation = RandomGeometry.nextQuaternion((Random)random);
        expectedLinearVelocity = RandomGeometry.nextVector3D((Random)random);
        expectedAngularVelocity = RandomGeometry.nextVector3D((Random)random);
        SE3TrajectoryPoint expectedSimpleSE3TrajectoryPoint = new SE3TrajectoryPoint(expectedTime, (Point3DReadOnly)expectedPosition, (Orientation3DReadOnly)expectedOrientation, (Vector3DReadOnly)expectedLinearVelocity, (Vector3DReadOnly)expectedAngularVelocity);
        testedSimpleSE3TrajectoryPoint = new SE3TrajectoryPoint((SE3TrajectoryPointBasics)expectedSimpleSE3TrajectoryPoint);
        Assert.assertTrue(expectedSimpleSE3TrajectoryPoint.epsilonEquals((EuclidGeometry)testedSimpleSE3TrajectoryPoint, epsilon));
        SE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedSimpleSE3TrajectoryPoint.getTime(), expectedPosition, expectedOrientation, expectedLinearVelocity, expectedAngularVelocity, testedSimpleSE3TrajectoryPoint, epsilon);
        double expectedFinalTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        Point3D expectedFinalPosition = RandomGeometry.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
        Quaternion expectedFinalOrientation = RandomGeometry.nextQuaternion((Random)random);
        Vector3D expectedFinalLinearVelocity = RandomGeometry.nextVector3D((Random)random);
        Vector3D expectedFinalAngularVelocity = RandomGeometry.nextVector3D((Random)random);
        SE3TrajectoryPoint expectedSE3TrajectoryPoint = new SE3TrajectoryPoint();
        expectedSE3TrajectoryPoint.setTime(expectedFinalTime);
        expectedSE3TrajectoryPoint.getPosition().set((Tuple3DReadOnly)expectedFinalPosition);
        expectedSE3TrajectoryPoint.getOrientation().set((Orientation3DReadOnly)expectedFinalOrientation);
        expectedSE3TrajectoryPoint.getLinearVelocity().set((Tuple3DReadOnly)expectedFinalLinearVelocity);
        expectedSE3TrajectoryPoint.getAngularVelocity().set((Tuple3DReadOnly)expectedFinalAngularVelocity);
        testedSimpleSE3TrajectoryPoint = new SE3TrajectoryPoint((SE3TrajectoryPointBasics)expectedSE3TrajectoryPoint);
        SE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFinalTime, expectedFinalPosition, expectedFinalOrientation, expectedFinalLinearVelocity, expectedFinalAngularVelocity, testedSimpleSE3TrajectoryPoint, epsilon);
    }

    @Test
    public void testSetters() {
        double epsilon = 1.0E-14;
        Random random = new Random(21651016L);
        double expectedTime = 0.0;
        Point3D expectedPosition = new Point3D();
        Quaternion expectedOrientation = new Quaternion();
        Vector3D expectedLinearVelocity = new Vector3D();
        Vector3D expectedAngularVelocity = new Vector3D();
        SE3TrajectoryPoint testedSimpleSE3TrajectoryPoint = new SE3TrajectoryPoint();
        SE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedPosition, expectedOrientation, expectedLinearVelocity, expectedAngularVelocity, testedSimpleSE3TrajectoryPoint, epsilon);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = RandomGeometry.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
        expectedOrientation = RandomGeometry.nextQuaternion((Random)random);
        expectedLinearVelocity = RandomGeometry.nextVector3D((Random)random);
        expectedAngularVelocity = RandomGeometry.nextVector3D((Random)random);
        testedSimpleSE3TrajectoryPoint.set(expectedTime, (Point3DReadOnly)expectedPosition, (Orientation3DReadOnly)expectedOrientation, (Vector3DReadOnly)expectedLinearVelocity, (Vector3DReadOnly)expectedAngularVelocity);
        SE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedPosition, expectedOrientation, expectedLinearVelocity, expectedAngularVelocity, testedSimpleSE3TrajectoryPoint, epsilon);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = RandomGeometry.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
        expectedOrientation = RandomGeometry.nextQuaternion((Random)random);
        expectedLinearVelocity = RandomGeometry.nextVector3D((Random)random);
        expectedAngularVelocity = RandomGeometry.nextVector3D((Random)random);
        testedSimpleSE3TrajectoryPoint.set(expectedTime, (Point3DReadOnly)expectedPosition, (Orientation3DReadOnly)expectedOrientation, (Vector3DReadOnly)expectedLinearVelocity, (Vector3DReadOnly)expectedAngularVelocity);
        SE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedPosition, expectedOrientation, expectedLinearVelocity, expectedAngularVelocity, testedSimpleSE3TrajectoryPoint, epsilon);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = RandomGeometry.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
        expectedOrientation = RandomGeometry.nextQuaternion((Random)random);
        expectedLinearVelocity = RandomGeometry.nextVector3D((Random)random);
        expectedAngularVelocity = RandomGeometry.nextVector3D((Random)random);
        testedSimpleSE3TrajectoryPoint.set(expectedTime, (Point3DReadOnly)expectedPosition, (Orientation3DReadOnly)expectedOrientation, (Vector3DReadOnly)expectedLinearVelocity, (Vector3DReadOnly)expectedAngularVelocity);
        SE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedPosition, expectedOrientation, expectedLinearVelocity, expectedAngularVelocity, testedSimpleSE3TrajectoryPoint, epsilon);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = RandomGeometry.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
        expectedOrientation = RandomGeometry.nextQuaternion((Random)random);
        expectedLinearVelocity = RandomGeometry.nextVector3D((Random)random);
        expectedAngularVelocity = RandomGeometry.nextVector3D((Random)random);
        SE3TrajectoryPoint expectedSimpleSE3TrajectoryPoint = new SE3TrajectoryPoint(expectedTime, (Point3DReadOnly)expectedPosition, (Orientation3DReadOnly)expectedOrientation, (Vector3DReadOnly)expectedLinearVelocity, (Vector3DReadOnly)expectedAngularVelocity);
        testedSimpleSE3TrajectoryPoint.set((SE3TrajectoryPointReadOnly)expectedSimpleSE3TrajectoryPoint);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = RandomGeometry.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
        expectedOrientation = RandomGeometry.nextQuaternion((Random)random);
        expectedLinearVelocity = RandomGeometry.nextVector3D((Random)random);
        expectedAngularVelocity = RandomGeometry.nextVector3D((Random)random);
        expectedSimpleSE3TrajectoryPoint = new SE3TrajectoryPoint(expectedTime, (Point3DReadOnly)expectedPosition, (Orientation3DReadOnly)expectedOrientation, (Vector3DReadOnly)expectedLinearVelocity, (Vector3DReadOnly)expectedAngularVelocity);
        testedSimpleSE3TrajectoryPoint.set((SE3TrajectoryPointReadOnly)expectedSimpleSE3TrajectoryPoint);
        Assert.assertTrue(expectedSimpleSE3TrajectoryPoint.epsilonEquals((EuclidGeometry)testedSimpleSE3TrajectoryPoint, epsilon));
        SE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedSimpleSE3TrajectoryPoint.getTime(), expectedPosition, expectedOrientation, expectedLinearVelocity, expectedAngularVelocity, testedSimpleSE3TrajectoryPoint, epsilon);
        double expectedFinalTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        Point3D expectedFinalPosition = RandomGeometry.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
        Quaternion expectedFinalOrientation = RandomGeometry.nextQuaternion((Random)random);
        Vector3D expectedFinalLinearVelocity = RandomGeometry.nextVector3D((Random)random);
        Vector3D expectedFinalAngularVelocity = RandomGeometry.nextVector3D((Random)random);
        SE3TrajectoryPoint expectedSE3TrajectoryPoint = new SE3TrajectoryPoint();
        expectedSE3TrajectoryPoint.setTime(expectedFinalTime);
        expectedSE3TrajectoryPoint.getPosition().set((Tuple3DReadOnly)expectedFinalPosition);
        expectedSE3TrajectoryPoint.getOrientation().set((Orientation3DReadOnly)expectedFinalOrientation);
        expectedSE3TrajectoryPoint.getLinearVelocity().set((Tuple3DReadOnly)expectedFinalLinearVelocity);
        expectedSE3TrajectoryPoint.getAngularVelocity().set((Tuple3DReadOnly)expectedFinalAngularVelocity);
        testedSimpleSE3TrajectoryPoint.set((SE3TrajectoryPointReadOnly)expectedSE3TrajectoryPoint);
        SE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFinalTime, expectedFinalPosition, expectedFinalOrientation, expectedFinalLinearVelocity, expectedFinalAngularVelocity, testedSimpleSE3TrajectoryPoint, epsilon);
    }

    @Test
    public void testChangeFrame() throws Exception {
        ReferenceFrame worldFrame;
        double epsilon = 1.0E-10;
        Random random = new Random(21651016L);
        ReferenceFrame expectedFrame = worldFrame = ReferenceFrame.getWorldFrame();
        double expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        Point3D expectedPosition = new Point3D((Tuple3DReadOnly)RandomGeometry.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0));
        Quaternion expectedOrientation = new Quaternion((QuaternionReadOnly)RandomGeometry.nextQuaternion((Random)random));
        Vector3D expectedLinearVelocity = new Vector3D((Tuple3DReadOnly)RandomGeometry.nextVector3D((Random)random));
        Vector3D expectedAngularVelocity = new Vector3D((Tuple3DReadOnly)RandomGeometry.nextVector3D((Random)random));
        SE3TrajectoryPoint testedSimpleSE3TrajectoryPoint = new SE3TrajectoryPoint(expectedTime, (Point3DReadOnly)expectedPosition, (Orientation3DReadOnly)expectedOrientation, (Vector3DReadOnly)expectedLinearVelocity, (Vector3DReadOnly)expectedAngularVelocity);
        for (int i = 0; i < 10000; ++i) {
            expectedFrame = EuclidFrameRandomTools.nextReferenceFrame((String)("randomFrame" + i), (Random)random, (ReferenceFrame)(random.nextBoolean() ? worldFrame : expectedFrame));
            expectedPosition.applyTransform((Transform)worldFrame.getTransformToDesiredFrame(expectedFrame));
            expectedOrientation.applyTransform((Transform)worldFrame.getTransformToDesiredFrame(expectedFrame));
            expectedLinearVelocity.applyTransform((Transform)worldFrame.getTransformToDesiredFrame(expectedFrame));
            expectedAngularVelocity.applyTransform((Transform)worldFrame.getTransformToDesiredFrame(expectedFrame));
            testedSimpleSE3TrajectoryPoint.applyTransform((Transform)worldFrame.getTransformToDesiredFrame(expectedFrame));
            SE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedPosition, expectedOrientation, expectedLinearVelocity, expectedAngularVelocity, testedSimpleSE3TrajectoryPoint, epsilon);
        }
    }

    @Test
    public void testSetToZero() throws Exception {
        double epsilon = 1.0E-10;
        Random random = new Random(21651016L);
        double expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        Point3D expectedPosition = RandomGeometry.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
        Quaternion expectedOrientation = RandomGeometry.nextQuaternion((Random)random);
        Vector3D expectedLinearVelocity = RandomGeometry.nextVector3D((Random)random);
        Vector3D expectedAngularVelocity = RandomGeometry.nextVector3D((Random)random);
        SE3TrajectoryPoint testedSimpleSE3TrajectoryPoint = new SE3TrajectoryPoint(expectedTime, (Point3DReadOnly)expectedPosition, (Orientation3DReadOnly)expectedOrientation, (Vector3DReadOnly)expectedLinearVelocity, (Vector3DReadOnly)expectedAngularVelocity);
        expectedTime = 0.0;
        expectedPosition.set(0.0, 0.0, 0.0);
        expectedOrientation.set(0.0, 0.0, 0.0, 1.0);
        expectedLinearVelocity.set(0.0, 0.0, 0.0);
        expectedAngularVelocity.set(0.0, 0.0, 0.0);
        testedSimpleSE3TrajectoryPoint.setToZero();
        SE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedPosition, expectedOrientation, expectedLinearVelocity, expectedAngularVelocity, testedSimpleSE3TrajectoryPoint, epsilon);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = RandomGeometry.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
        expectedOrientation = RandomGeometry.nextQuaternion((Random)random);
        expectedLinearVelocity = RandomGeometry.nextVector3D((Random)random);
        expectedAngularVelocity = RandomGeometry.nextVector3D((Random)random);
        testedSimpleSE3TrajectoryPoint.set(expectedTime, (Point3DReadOnly)expectedPosition, (Orientation3DReadOnly)expectedOrientation, (Vector3DReadOnly)expectedLinearVelocity, (Vector3DReadOnly)expectedAngularVelocity);
        expectedTime = 0.0;
        expectedPosition.set(0.0, 0.0, 0.0);
        expectedOrientation.set(0.0, 0.0, 0.0, 1.0);
        expectedLinearVelocity.set(0.0, 0.0, 0.0);
        expectedAngularVelocity.set(0.0, 0.0, 0.0);
        testedSimpleSE3TrajectoryPoint.setToZero();
        SE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedPosition, expectedOrientation, expectedLinearVelocity, expectedAngularVelocity, testedSimpleSE3TrajectoryPoint, epsilon);
    }

    @Test
    public void testSetToNaN() throws Exception {
        Random random = new Random(21651016L);
        double expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        Point3D expectedPosition = RandomGeometry.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
        Quaternion expectedOrientation = RandomGeometry.nextQuaternion((Random)random);
        Vector3D expectedLinearVelocity = RandomGeometry.nextVector3D((Random)random);
        Vector3D expectedAngularVelocity = RandomGeometry.nextVector3D((Random)random);
        SE3TrajectoryPoint testedSimpleSE3TrajectoryPoint = new SE3TrajectoryPoint(expectedTime, (Point3DReadOnly)expectedPosition, (Orientation3DReadOnly)expectedOrientation, (Vector3DReadOnly)expectedLinearVelocity, (Vector3DReadOnly)expectedAngularVelocity);
        testedSimpleSE3TrajectoryPoint.setToNaN();
        Assert.assertTrue(Double.isNaN(testedSimpleSE3TrajectoryPoint.getTime()));
        Assert.assertTrue(testedSimpleSE3TrajectoryPoint.containsNaN());
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = RandomGeometry.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
        expectedOrientation = RandomGeometry.nextQuaternion((Random)random);
        expectedLinearVelocity = RandomGeometry.nextVector3D((Random)random);
        expectedAngularVelocity = RandomGeometry.nextVector3D((Random)random);
        testedSimpleSE3TrajectoryPoint.set(expectedTime, (Point3DReadOnly)expectedPosition, (Orientation3DReadOnly)expectedOrientation, (Vector3DReadOnly)expectedLinearVelocity, (Vector3DReadOnly)expectedAngularVelocity);
        testedSimpleSE3TrajectoryPoint.setToNaN();
        Assert.assertTrue(Double.isNaN(testedSimpleSE3TrajectoryPoint.getTime()));
        Assert.assertTrue(testedSimpleSE3TrajectoryPoint.containsNaN());
    }

    static void assertTrajectoryPointContainsExpectedData(double expectedTime, Point3D expectedPosition, Quaternion expectedOrientation, Vector3D expectedLinearVelocity, Vector3D expectedAngularVelocity, SE3TrajectoryPoint testedSimpleSE3TrajectoryPoint, double epsilon) {
        Assert.assertEquals(expectedTime, testedSimpleSE3TrajectoryPoint.getTime(), epsilon);
        Assert.assertTrue(expectedPosition.epsilonEquals((EuclidGeometry)testedSimpleSE3TrajectoryPoint.getPosition(), epsilon));
        Assert.assertTrue(expectedOrientation + ", " + testedSimpleSE3TrajectoryPoint.getOrientation(), expectedOrientation.epsilonEquals((EuclidGeometry)testedSimpleSE3TrajectoryPoint.getOrientation(), epsilon));
        Assert.assertTrue(expectedLinearVelocity.epsilonEquals((EuclidGeometry)testedSimpleSE3TrajectoryPoint.getLinearVelocity(), epsilon));
        Assert.assertTrue(expectedAngularVelocity.epsilonEquals((EuclidGeometry)testedSimpleSE3TrajectoryPoint.getAngularVelocity(), epsilon));
        Point3D actualPosition = new Point3D();
        Quaternion actualOrientation = new Quaternion();
        Vector3D actualLinearVelocity = new Vector3D();
        Vector3D actualAngularVelocity = new Vector3D();
        actualPosition.set((Tuple3DReadOnly)testedSimpleSE3TrajectoryPoint.getPosition());
        actualOrientation.set((QuaternionReadOnly)testedSimpleSE3TrajectoryPoint.getOrientation());
        actualLinearVelocity.set((Tuple3DReadOnly)testedSimpleSE3TrajectoryPoint.getLinearVelocity());
        actualAngularVelocity.set((Tuple3DReadOnly)testedSimpleSE3TrajectoryPoint.getAngularVelocity());
        Assert.assertTrue(expectedPosition.epsilonEquals((EuclidGeometry)actualPosition, epsilon));
        Assert.assertTrue(expectedOrientation.epsilonEquals((EuclidGeometry)actualOrientation, epsilon));
        Assert.assertTrue(expectedLinearVelocity.epsilonEquals((EuclidGeometry)actualLinearVelocity, epsilon));
        Assert.assertTrue(expectedAngularVelocity.epsilonEquals((EuclidGeometry)actualAngularVelocity, epsilon));
        Point3D actualFramePosition = new Point3D();
        Quaternion actualFrameOrientation = new Quaternion();
        Vector3D actualFrameLinearVelocity = new Vector3D();
        Vector3D actualFrameAngularVelocity = new Vector3D();
        actualFramePosition.set((Tuple3DReadOnly)testedSimpleSE3TrajectoryPoint.getPosition());
        actualFrameOrientation.set((QuaternionReadOnly)testedSimpleSE3TrajectoryPoint.getOrientation());
        actualFrameLinearVelocity.set((Tuple3DReadOnly)testedSimpleSE3TrajectoryPoint.getLinearVelocity());
        actualFrameAngularVelocity.set((Tuple3DReadOnly)testedSimpleSE3TrajectoryPoint.getAngularVelocity());
        Assert.assertTrue(expectedPosition.epsilonEquals((EuclidGeometry)actualFramePosition, epsilon));
        Assert.assertTrue(expectedOrientation.epsilonEquals((EuclidGeometry)actualFrameOrientation, epsilon));
        Assert.assertTrue(expectedLinearVelocity.epsilonEquals((EuclidGeometry)actualFrameLinearVelocity, epsilon));
        Assert.assertTrue(expectedAngularVelocity.epsilonEquals((EuclidGeometry)actualFrameAngularVelocity, epsilon));
        actualFramePosition = new Point3D();
        actualFrameOrientation = new Quaternion();
        actualFrameLinearVelocity = new Vector3D();
        actualFrameAngularVelocity = new Vector3D();
        actualFramePosition.set((Tuple3DReadOnly)testedSimpleSE3TrajectoryPoint.getPosition());
        actualFrameOrientation.set((QuaternionReadOnly)testedSimpleSE3TrajectoryPoint.getOrientation());
        actualFrameLinearVelocity.set((Tuple3DReadOnly)testedSimpleSE3TrajectoryPoint.getLinearVelocity());
        actualFrameAngularVelocity.set((Tuple3DReadOnly)testedSimpleSE3TrajectoryPoint.getAngularVelocity());
        Assert.assertTrue(expectedPosition.epsilonEquals((EuclidGeometry)actualFramePosition, epsilon));
        Assert.assertTrue(expectedOrientation.epsilonEquals((EuclidGeometry)actualFrameOrientation, epsilon));
        Assert.assertTrue(expectedLinearVelocity.epsilonEquals((EuclidGeometry)actualFrameLinearVelocity, epsilon));
        Assert.assertTrue(expectedAngularVelocity.epsilonEquals((EuclidGeometry)actualFrameAngularVelocity, epsilon));
    }

    @Test
    public void testSomeSetsAngGets() {
        SE3TrajectoryPoint simpleSE3TrajectoryPoint = new SE3TrajectoryPoint();
        SE3TrajectoryPoint simpleTrajectoryPoint = new SE3TrajectoryPoint();
        double time = 3.4;
        Point3D position = new Point3D(1.0, 2.1, 3.7);
        Quaternion orientation = new Quaternion((QuaternionReadOnly)new Quaternion(0.1, 0.22, 0.34, 0.56));
        orientation.normalize();
        Vector3D linearVelocity = new Vector3D(-0.4, 1.2, 3.3);
        Vector3D angularVelocity = new Vector3D(1.7, 8.4, 2.2);
        simpleTrajectoryPoint.set(time, (Point3DReadOnly)position, (Orientation3DReadOnly)orientation, (Vector3DReadOnly)linearVelocity, (Vector3DReadOnly)angularVelocity);
        simpleSE3TrajectoryPoint.set((SE3TrajectoryPointReadOnly)simpleTrajectoryPoint);
        Point3D pointForVerification = new Point3D();
        Quaternion quaternionForVerification = new Quaternion();
        Vector3D linearVelocityForVerification = new Vector3D();
        Vector3D angularVelocityForVerification = new Vector3D();
        pointForVerification.set((Tuple3DReadOnly)simpleSE3TrajectoryPoint.getPosition());
        quaternionForVerification.set((QuaternionReadOnly)simpleSE3TrajectoryPoint.getOrientation());
        linearVelocityForVerification.set((Tuple3DReadOnly)simpleSE3TrajectoryPoint.getLinearVelocity());
        angularVelocityForVerification.set((Tuple3DReadOnly)simpleSE3TrajectoryPoint.getAngularVelocity());
        Assert.assertEquals(time, simpleSE3TrajectoryPoint.getTime(), 1.0E-10);
        Assert.assertTrue(pointForVerification.epsilonEquals((EuclidGeometry)position, 1.0E-10));
        Assert.assertTrue(quaternionForVerification.epsilonEquals((EuclidGeometry)orientation, 1.0E-10));
        Assert.assertTrue(linearVelocityForVerification.epsilonEquals((EuclidGeometry)linearVelocity, 1.0E-10));
        Assert.assertTrue(angularVelocityForVerification.epsilonEquals((EuclidGeometry)angularVelocity, 1.0E-10));
        Assert.assertFalse(simpleSE3TrajectoryPoint.containsNaN());
        simpleSE3TrajectoryPoint.getPosition().setToNaN();
        Assert.assertTrue(simpleSE3TrajectoryPoint.containsNaN());
        simpleSE3TrajectoryPoint.getPosition().setToZero();
        Assert.assertFalse(simpleSE3TrajectoryPoint.containsNaN());
        simpleSE3TrajectoryPoint.getOrientation().setToNaN();
        Assert.assertTrue(simpleSE3TrajectoryPoint.containsNaN());
        simpleSE3TrajectoryPoint.getOrientation().setToZero();
        Assert.assertFalse(simpleSE3TrajectoryPoint.containsNaN());
        simpleSE3TrajectoryPoint.getLinearVelocity().setToNaN();
        Assert.assertTrue(simpleSE3TrajectoryPoint.containsNaN());
        simpleSE3TrajectoryPoint.getLinearVelocity().setToZero();
        Assert.assertFalse(simpleSE3TrajectoryPoint.containsNaN());
        simpleSE3TrajectoryPoint.getAngularVelocity().setToNaN();
        Assert.assertTrue(simpleSE3TrajectoryPoint.containsNaN());
        simpleSE3TrajectoryPoint.getAngularVelocity().setToZero();
        Assert.assertFalse(simpleSE3TrajectoryPoint.containsNaN());
        position.set((Tuple3DReadOnly)simpleSE3TrajectoryPoint.getPosition());
        orientation.set((QuaternionReadOnly)simpleSE3TrajectoryPoint.getOrientation());
        linearVelocity.set((Tuple3DReadOnly)simpleSE3TrajectoryPoint.getLinearVelocity());
        angularVelocity.set((Tuple3DReadOnly)simpleSE3TrajectoryPoint.getAngularVelocity());
        Assert.assertTrue(position.epsilonEquals((EuclidGeometry)new Point3D(), 1.0E-10));
        Assert.assertTrue(orientation.epsilonEquals((EuclidGeometry)new Quaternion(), 1.0E-10));
        Assert.assertTrue(linearVelocity.epsilonEquals((EuclidGeometry)new Vector3D(), 1.0E-10));
        Assert.assertTrue(angularVelocity.epsilonEquals((EuclidGeometry)new Vector3D(), 1.0E-10));
        time = 9.9;
        pointForVerification.set(3.9, 2.2, 1.1);
        quaternionForVerification.set(0.2, 0.6, 1.1, 2.1);
        quaternionForVerification.normalize();
        linearVelocityForVerification.set(8.8, 1.4, 9.22);
        angularVelocityForVerification.set(7.1, 2.2, 3.33);
        Assert.assertFalse(Math.abs(simpleSE3TrajectoryPoint.getTime() - time) < 1.0E-7);
        Assert.assertFalse(pointForVerification.epsilonEquals((EuclidGeometry)position, 1.0E-7));
        Assert.assertFalse(quaternionForVerification.epsilonEquals((EuclidGeometry)orientation, 1.0E-7));
        Assert.assertFalse(linearVelocityForVerification.epsilonEquals((EuclidGeometry)linearVelocity, 1.0E-7));
        Assert.assertFalse(angularVelocityForVerification.epsilonEquals((EuclidGeometry)angularVelocity, 1.0E-7));
        simpleSE3TrajectoryPoint.set(time, (Point3DReadOnly)pointForVerification, (Orientation3DReadOnly)quaternionForVerification, (Vector3DReadOnly)linearVelocityForVerification, (Vector3DReadOnly)angularVelocityForVerification);
        position.set((Tuple3DReadOnly)simpleSE3TrajectoryPoint.getPosition());
        orientation.set((QuaternionReadOnly)simpleSE3TrajectoryPoint.getOrientation());
        linearVelocity.set((Tuple3DReadOnly)simpleSE3TrajectoryPoint.getLinearVelocity());
        angularVelocity.set((Tuple3DReadOnly)simpleSE3TrajectoryPoint.getAngularVelocity());
        Assert.assertEquals(time, simpleSE3TrajectoryPoint.getTime(), 1.0E-10);
        Assert.assertTrue(pointForVerification.epsilonEquals((EuclidGeometry)position, 1.0E-10));
        Assert.assertTrue(quaternionForVerification.epsilonEquals((EuclidGeometry)orientation, 1.0E-10));
        Assert.assertTrue(linearVelocityForVerification.epsilonEquals((EuclidGeometry)linearVelocity, 1.0E-10));
        Assert.assertTrue(angularVelocityForVerification.epsilonEquals((EuclidGeometry)angularVelocity, 1.0E-10));
        SE3TrajectoryPoint simpleSE3TrajectoryPointTwo = new SE3TrajectoryPoint();
        double positionDistance = simpleSE3TrajectoryPoint.positionDistance((EuclideanWaypointReadOnly)simpleSE3TrajectoryPointTwo);
        Assert.assertEquals(4.610856753359402, positionDistance, 1.0E-7);
        Assert.assertFalse(simpleSE3TrajectoryPoint.epsilonEquals((EuclidGeometry)simpleSE3TrajectoryPointTwo, 1.0E-7));
        simpleSE3TrajectoryPointTwo.set((SE3TrajectoryPointReadOnly)simpleSE3TrajectoryPoint);
        positionDistance = simpleSE3TrajectoryPoint.positionDistance((EuclideanWaypointReadOnly)simpleSE3TrajectoryPointTwo);
        Assert.assertEquals(0.0, positionDistance, 1.0E-7);
        Assert.assertTrue(simpleSE3TrajectoryPoint.epsilonEquals((EuclidGeometry)simpleSE3TrajectoryPointTwo, 1.0E-7));
        SE3TrajectoryPoint simplePoint = new SE3TrajectoryPoint();
        simplePoint.set((SE3TrajectoryPointReadOnly)simpleSE3TrajectoryPoint);
        simpleSE3TrajectoryPoint.setToNaN();
        Assert.assertTrue(simpleSE3TrajectoryPoint.containsNaN());
        positionDistance = simpleSE3TrajectoryPoint.positionDistance((EuclideanWaypointReadOnly)simpleSE3TrajectoryPointTwo);
        Assert.assertTrue(Double.isNaN(positionDistance));
        Assert.assertFalse(simpleSE3TrajectoryPoint.epsilonEquals((EuclidGeometry)simpleSE3TrajectoryPointTwo, 1.0E-7));
        SE3TrajectoryPoint trajectoryPointAsInterface = simplePoint;
        simpleSE3TrajectoryPoint.set((SE3TrajectoryPointReadOnly)trajectoryPointAsInterface);
        positionDistance = simpleSE3TrajectoryPoint.positionDistance((EuclideanWaypointReadOnly)simpleSE3TrajectoryPointTwo);
        Assert.assertEquals(0.0, positionDistance, 1.0E-7);
        Assert.assertTrue(simpleSE3TrajectoryPoint.epsilonEquals((EuclidGeometry)simpleSE3TrajectoryPointTwo, 1.0E-7));
    }

    @Test
    public void testSomeMoreSettersAndGetters() {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        SE3TrajectoryPoint simpleSE3TrajectoryPoint = new SE3TrajectoryPoint();
        double time = 3.4;
        Point3D position = new Point3D(1.0, 2.1, 3.7);
        Quaternion orientation = new Quaternion((QuaternionReadOnly)new Quaternion(0.1, 0.22, 0.34, 0.56));
        Vector3D linearVelocity = new Vector3D(-0.4, 1.2, 3.3);
        Vector3D angularVelocity = new Vector3D(1.7, 8.4, 2.2);
        simpleSE3TrajectoryPoint.setTime(time);
        simpleSE3TrajectoryPoint.getPosition().set((Tuple3DReadOnly)position);
        simpleSE3TrajectoryPoint.getOrientation().set((Orientation3DReadOnly)orientation);
        simpleSE3TrajectoryPoint.getLinearVelocity().set((Tuple3DReadOnly)linearVelocity);
        simpleSE3TrajectoryPoint.getAngularVelocity().set((Tuple3DReadOnly)angularVelocity);
        PoseReferenceFrame poseFrame = new PoseReferenceFrame("poseFrame", (FramePose3DReadOnly)new FramePose3D(worldFrame));
        FramePoint3D poseFramePosition = new FramePoint3D(worldFrame, (Tuple3DReadOnly)new Point3D(0.5, 7.7, 9.2));
        poseFrame.setPositionAndUpdate((FramePoint3DReadOnly)poseFramePosition);
        FrameQuaternion poseOrientation = new FrameQuaternion(worldFrame, (Orientation3DReadOnly)new AxisAngle(1.2, 3.9, 4.7, 2.2));
        poseFrame.setOrientationAndUpdate((FrameOrientation3DReadOnly)poseOrientation);
        simpleSE3TrajectoryPoint.applyTransform((Transform)worldFrame.getTransformToDesiredFrame((ReferenceFrame)poseFrame));
        Assert.assertFalse(position.epsilonEquals((EuclidGeometry)simpleSE3TrajectoryPoint.getPosition(), 1.0E-10));
        Assert.assertFalse(orientation.epsilonEquals((EuclidGeometry)simpleSE3TrajectoryPoint.getOrientation(), 1.0E-10));
        Assert.assertFalse(linearVelocity.epsilonEquals((EuclidGeometry)simpleSE3TrajectoryPoint.getLinearVelocity(), 1.0E-10));
        Assert.assertFalse(angularVelocity.epsilonEquals((EuclidGeometry)simpleSE3TrajectoryPoint.getAngularVelocity(), 1.0E-10));
        position.applyTransform((Transform)worldFrame.getTransformToDesiredFrame((ReferenceFrame)poseFrame));
        orientation.applyTransform((Transform)worldFrame.getTransformToDesiredFrame((ReferenceFrame)poseFrame));
        linearVelocity.applyTransform((Transform)worldFrame.getTransformToDesiredFrame((ReferenceFrame)poseFrame));
        angularVelocity.applyTransform((Transform)worldFrame.getTransformToDesiredFrame((ReferenceFrame)poseFrame));
        Assert.assertTrue(position.epsilonEquals((EuclidGeometry)simpleSE3TrajectoryPoint.getPosition(), 1.0E-10));
        Assert.assertTrue(orientation.epsilonEquals((EuclidGeometry)simpleSE3TrajectoryPoint.getOrientation(), 1.0E-10));
        Assert.assertTrue(linearVelocity.epsilonEquals((EuclidGeometry)simpleSE3TrajectoryPoint.getLinearVelocity(), 1.0E-10));
        Assert.assertTrue(angularVelocity.epsilonEquals((EuclidGeometry)simpleSE3TrajectoryPoint.getAngularVelocity(), 1.0E-10));
        SE3TrajectoryPoint simpleSE3TrajectoryPointTwo = new SE3TrajectoryPoint();
        simpleSE3TrajectoryPointTwo.setTime(time);
        simpleSE3TrajectoryPointTwo.getPosition().set((Tuple3DReadOnly)position);
        simpleSE3TrajectoryPointTwo.getOrientation().set((Orientation3DReadOnly)orientation);
        simpleSE3TrajectoryPointTwo.getLinearVelocity().set((Tuple3DReadOnly)linearVelocity);
        simpleSE3TrajectoryPointTwo.getAngularVelocity().set((Tuple3DReadOnly)angularVelocity);
        Assert.assertTrue(simpleSE3TrajectoryPointTwo.epsilonEquals((EuclidGeometry)simpleSE3TrajectoryPoint, 1.0E-10));
        simpleSE3TrajectoryPointTwo = new SE3TrajectoryPoint();
        simpleSE3TrajectoryPointTwo.set(time, (Point3DReadOnly)position, (Orientation3DReadOnly)orientation, (Vector3DReadOnly)linearVelocity, (Vector3DReadOnly)angularVelocity);
        Assert.assertTrue(simpleSE3TrajectoryPointTwo.epsilonEquals((EuclidGeometry)simpleSE3TrajectoryPoint, 1.0E-10));
        simpleSE3TrajectoryPointTwo = new SE3TrajectoryPoint();
        SE3Waypoint simpleSE3Waypoint = new SE3Waypoint();
        simpleSE3Waypoint.set((SE3WaypointReadOnly)simpleSE3TrajectoryPoint);
        simpleSE3TrajectoryPointTwo.set(time, (SE3WaypointReadOnly)simpleSE3Waypoint);
        Assert.assertTrue(simpleSE3TrajectoryPointTwo.epsilonEquals((EuclidGeometry)simpleSE3TrajectoryPoint, 1.0E-10));
        simpleSE3TrajectoryPointTwo = new SE3TrajectoryPoint();
        simpleSE3TrajectoryPointTwo.set(time, (SE3WaypointReadOnly)simpleSE3Waypoint);
        Assert.assertTrue(simpleSE3TrajectoryPointTwo.epsilonEquals((EuclidGeometry)simpleSE3TrajectoryPoint, 1.0E-10));
        simpleSE3TrajectoryPointTwo = new SE3TrajectoryPoint();
        SE3TrajectoryPoint euclideanWaypoint = simpleSE3TrajectoryPoint;
        SE3TrajectoryPoint so3Waypoint = simpleSE3TrajectoryPoint;
        simpleSE3TrajectoryPointTwo.set(time, (EuclideanWaypointReadOnly)euclideanWaypoint, (SO3WaypointReadOnly)so3Waypoint);
        Assert.assertTrue(simpleSE3TrajectoryPointTwo.epsilonEquals((EuclidGeometry)simpleSE3TrajectoryPoint, 1.0E-10));
        simpleSE3TrajectoryPointTwo = new SE3TrajectoryPoint();
        euclideanWaypoint = new EuclideanWaypoint();
        so3Waypoint = new SO3Waypoint();
        euclideanWaypoint.set((EuclideanWaypointReadOnly)simpleSE3TrajectoryPoint.getEuclideanWaypoint());
        so3Waypoint.set((SO3WaypointReadOnly)simpleSE3TrajectoryPoint.getSO3Waypoint());
        simpleSE3TrajectoryPointTwo.set(time, (EuclideanWaypointReadOnly)euclideanWaypoint, (SO3WaypointReadOnly)so3Waypoint);
        Assert.assertTrue(simpleSE3TrajectoryPointTwo.epsilonEquals((EuclidGeometry)simpleSE3TrajectoryPoint, 1.0E-10));
        Point3D positionToPack = new Point3D();
        Quaternion orientationToPack = new Quaternion();
        Vector3D linearVelocityToPack = new Vector3D();
        Vector3D angularVelocityToPack = new Vector3D();
        positionToPack.set((Tuple3DReadOnly)simpleSE3TrajectoryPoint.getPosition());
        linearVelocityToPack.set((Tuple3DReadOnly)simpleSE3TrajectoryPoint.getLinearVelocity());
        orientationToPack.set((QuaternionReadOnly)simpleSE3TrajectoryPoint.getOrientation());
        angularVelocityToPack.set((Tuple3DReadOnly)simpleSE3TrajectoryPoint.getAngularVelocity());
        simpleSE3TrajectoryPointTwo = new SE3TrajectoryPoint();
        simpleSE3TrajectoryPointTwo.set(time, (Point3DReadOnly)positionToPack, (Orientation3DReadOnly)orientationToPack, (Vector3DReadOnly)linearVelocityToPack, (Vector3DReadOnly)angularVelocityToPack);
        Assert.assertTrue(simpleSE3TrajectoryPointTwo.epsilonEquals((EuclidGeometry)simpleSE3TrajectoryPoint, 1.0E-10));
    }
}

