/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.trajectories.StraightLinePositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.core.FramePolynomial3D;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsPositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.interfaces.FixedFramePositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameEuclideanTrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameEuclideanTrajectoryPointReadOnly;
import us.ihmc.robotics.trajectories.providers.FramePositionProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class MultipleWaypointsPositionTrajectoryGeneratorTest {
    private final double EPSILON = 0.001;

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void test() {
        YoRegistry registry = new YoRegistry("traj");
        double trajectoryTime = 1.0;
        double dt = 0.001;
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        DoubleProvider trajectoryTimeProvider = () -> trajectoryTime;
        FramePositionProvider initialPositionProvider = () -> new FramePoint3D(worldFrame, 1.0, 0.0, 1.0);
        FramePositionProvider finalPositionProvider = () -> new FramePoint3D(worldFrame, 0.2, 1.0, 0.4);
        StraightLinePositionTrajectoryGenerator simpleTrajectory = new StraightLinePositionTrajectoryGenerator("simpleTraj", worldFrame, trajectoryTimeProvider, initialPositionProvider, finalPositionProvider, registry);
        simpleTrajectory.initialize();
        int numberOfWaypoints = 11;
        MultipleWaypointsPositionTrajectoryGenerator multipleWaypointTrajectory = new MultipleWaypointsPositionTrajectoryGenerator("testedTraj", 50, worldFrame, registry);
        multipleWaypointTrajectory.clear();
        FramePoint3D waypointPosition = new FramePoint3D();
        FrameVector3D waypointVelocity = new FrameVector3D();
        for (int i = 0; i < numberOfWaypoints; ++i) {
            double timeAtWaypoint = (double)i * trajectoryTime / ((double)numberOfWaypoints - 1.0);
            simpleTrajectory.compute(timeAtWaypoint);
            waypointPosition.setIncludingFrame((FrameTuple3DReadOnly)simpleTrajectory.getPosition());
            waypointVelocity.setIncludingFrame((FrameTuple3DReadOnly)simpleTrajectory.getVelocity());
            multipleWaypointTrajectory.appendWaypoint(timeAtWaypoint, (FramePoint3DReadOnly)waypointPosition, (FrameVector3DReadOnly)waypointVelocity);
        }
        multipleWaypointTrajectory.initialize();
        FramePoint3D positionToPackMultiple = new FramePoint3D(worldFrame);
        FrameVector3D velocityToPackMultiple = new FrameVector3D(worldFrame);
        FrameVector3D accelerationToPackMultiple = new FrameVector3D(worldFrame);
        FramePoint3D positionToPackSimple = new FramePoint3D(worldFrame);
        FrameVector3D velocityToPackSimple = new FrameVector3D(worldFrame);
        FrameVector3D accelerationToPackSimple = new FrameVector3D(worldFrame);
        for (double t = 0.0; t <= trajectoryTime; t += dt) {
            multipleWaypointTrajectory.compute(t);
            multipleWaypointTrajectory.getLinearData((FramePoint3DBasics)positionToPackMultiple, (FrameVector3DBasics)velocityToPackMultiple, (FrameVector3DBasics)accelerationToPackMultiple);
            simpleTrajectory.compute(t);
            simpleTrajectory.getLinearData((FramePoint3DBasics)positionToPackSimple, (FrameVector3DBasics)velocityToPackSimple, (FrameVector3DBasics)accelerationToPackSimple);
            boolean positionEqual = positionToPackMultiple.epsilonEquals((EuclidFrameGeometry)positionToPackSimple, 0.001);
            Assert.assertTrue(positionEqual);
            boolean velocityEqual = velocityToPackMultiple.epsilonEquals((EuclidFrameGeometry)velocityToPackSimple, 0.005);
            Assert.assertTrue(velocityEqual);
        }
    }

    @Test
    public void testRandomCreation() {
        int iter;
        FramePolynomial3D polynomial;
        double duration;
        FrameEuclideanTrajectoryPoint endWaypoint;
        FrameEuclideanTrajectoryPoint startWaypoint;
        int firstWaypointIdx;
        int iter2;
        double time;
        Random random = new Random(1738L);
        double trajectoryDuration = 1.0;
        int numberOfSamples = 10;
        List<FrameEuclideanTrajectoryPoint> waypoints = this.createRandomWaypoints(random, numberOfSamples, trajectoryDuration, ReferenceFrame.getWorldFrame());
        MultipleWaypointsPositionTrajectoryGenerator trajectory = this.createRandomReferenceTrajectory(waypoints, ReferenceFrame.getWorldFrame(), new YoRegistry("Test"));
        FrameEuclideanTrajectoryPoint firstWaypoint = waypoints.get(0);
        FrameEuclideanTrajectoryPoint lastWaypoint = waypoints.get(waypoints.size() - 1);
        Assert.assertEquals(0.0, firstWaypoint.getTime(), 0.001);
        Assert.assertEquals(trajectoryDuration, lastWaypoint.getTime(), 0.001);
        Assert.assertEquals(lastWaypoint.getTime(), trajectory.getLastWaypointTime(), 0.001);
        FramePoint3D startPosition = new FramePoint3D((FrameTuple3DReadOnly)firstWaypoint.getPosition());
        FramePoint3D lastPosition = new FramePoint3D((FrameTuple3DReadOnly)lastWaypoint.getPosition());
        double dt = 0.005;
        int itersPerTick = 5;
        for (time = -1.0; time < 0.0; time += dt) {
            for (iter2 = 0; iter2 < itersPerTick; ++iter2) {
                trajectory.compute(time);
                EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)startPosition, (EuclidFrameGeometry)trajectory.getPosition(), (double)0.001);
                EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)new FrameVector3D(), (EuclidFrameGeometry)trajectory.getVelocity(), (double)0.001);
                EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)new FrameVector3D(), (EuclidFrameGeometry)trajectory.getAcceleration(), (double)0.001);
            }
        }
        for (time = 0.0; time <= trajectory.getLastWaypointTime(); time += dt) {
            firstWaypointIdx = this.getFirstWaypoint(time, waypoints);
            startWaypoint = waypoints.get(firstWaypointIdx);
            endWaypoint = waypoints.get(firstWaypointIdx + 1);
            duration = endWaypoint.getTime() - startWaypoint.getTime();
            polynomial = new FramePolynomial3D(5, ReferenceFrame.getWorldFrame());
            polynomial.setCubic(0.0, duration, (FramePoint3DReadOnly)startWaypoint.getPosition(), (FrameVector3DReadOnly)startWaypoint.getLinearVelocity(), (FramePoint3DReadOnly)endWaypoint.getPosition(), (FrameVector3DReadOnly)endWaypoint.getLinearVelocity());
            polynomial.compute(time - startWaypoint.getTime());
            for (iter = 0; iter < itersPerTick; ++iter) {
                trajectory.compute(time);
                Assert.assertEquals(firstWaypointIdx, trajectory.getCurrentWaypointIndex());
                EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)polynomial.getPosition(), (EuclidFrameGeometry)trajectory.getPosition(), (double)0.001);
                EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)polynomial.getVelocity(), (EuclidFrameGeometry)trajectory.getVelocity(), (double)0.001);
                EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)polynomial.getAcceleration(), (EuclidFrameGeometry)trajectory.getAcceleration(), (double)0.001);
            }
        }
        for (time = trajectory.getLastWaypointTime(); time >= 0.0; time -= dt) {
            firstWaypointIdx = this.getFirstWaypoint(time, waypoints);
            startWaypoint = waypoints.get(firstWaypointIdx);
            endWaypoint = waypoints.get(firstWaypointIdx + 1);
            duration = endWaypoint.getTime() - startWaypoint.getTime();
            polynomial = new FramePolynomial3D(5, ReferenceFrame.getWorldFrame());
            polynomial.setCubic(0.0, duration, (FramePoint3DReadOnly)startWaypoint.getPosition(), (FrameVector3DReadOnly)startWaypoint.getLinearVelocity(), (FramePoint3DReadOnly)endWaypoint.getPosition(), (FrameVector3DReadOnly)endWaypoint.getLinearVelocity());
            polynomial.compute(time - startWaypoint.getTime());
            for (iter = 0; iter < itersPerTick; ++iter) {
                trajectory.compute(time);
                Assert.assertEquals(firstWaypointIdx, trajectory.getCurrentWaypointIndex());
                EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)polynomial.getPosition(), (EuclidFrameGeometry)trajectory.getPosition(), (double)0.001);
                EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)polynomial.getVelocity(), (EuclidFrameGeometry)trajectory.getVelocity(), (double)0.001);
                EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)polynomial.getAcceleration(), (EuclidFrameGeometry)trajectory.getAcceleration(), (double)0.001);
            }
        }
        for (time = trajectoryDuration + dt; time <= trajectoryDuration + 1.0; time += dt) {
            for (iter2 = 0; iter2 < itersPerTick; ++iter2) {
                trajectory.compute(time);
                EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)lastPosition, (EuclidFrameGeometry)trajectory.getPosition(), (double)0.001);
                EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)new FrameVector3D(), (EuclidFrameGeometry)trajectory.getVelocity(), (double)0.001);
                EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)new FrameVector3D(), (EuclidFrameGeometry)trajectory.getAcceleration(), (double)0.001);
            }
        }
    }

    private int getFirstWaypoint(double time, List<FrameEuclideanTrajectoryPoint> waypoints) {
        for (int i = 0; i < waypoints.size() - 1; ++i) {
            if (time < waypoints.get(i).getTime()) {
                return -1;
            }
            if (!(time >= waypoints.get(i).getTime()) || !(time <= waypoints.get(i + 1).getTime())) continue;
            return i;
        }
        return -1;
    }

    private List<FrameEuclideanTrajectoryPoint> createRandomWaypoints(Random random, int numberOfWaypoints, double duration, ReferenceFrame referenceFrame) {
        ArrayList<FrameEuclideanTrajectoryPoint> waypoints = new ArrayList<FrameEuclideanTrajectoryPoint>();
        for (int i = 0; i < numberOfWaypoints; ++i) {
            double time = (double)i * duration / (double)(numberOfWaypoints - 1);
            PositionTrajectoryState state = new PositionTrajectoryState(random, time, referenceFrame);
            waypoints.add(state.getWaypoint());
        }
        return waypoints;
    }

    private MultipleWaypointsPositionTrajectoryGenerator createRandomReferenceTrajectory(List<FrameEuclideanTrajectoryPoint> waypoints, ReferenceFrame referenceFrame, YoRegistry registry) {
        MultipleWaypointsPositionTrajectoryGenerator referenceTrajectory = new MultipleWaypointsPositionTrajectoryGenerator("referenceTrajectory", 10, referenceFrame, registry);
        for (int i = 0; i < waypoints.size(); ++i) {
            referenceTrajectory.appendWaypoint((FrameEuclideanTrajectoryPointReadOnly)waypoints.get(i));
        }
        referenceTrajectory.initialize();
        return referenceTrajectory;
    }

    private class PositionTrajectoryState {
        public final double time;
        public final FramePoint3D position;
        public final FrameVector3D linearVelocity;
        public final FrameVector3D linearAcceleration;
        private final ReferenceFrame expressedInFrame;

        public PositionTrajectoryState(FixedFramePositionTrajectoryGenerator trajectory, double time, ReferenceFrame expressedInFrame) {
            this.position = new FramePoint3D(expressedInFrame);
            this.linearVelocity = new FrameVector3D(expressedInFrame);
            this.linearAcceleration = new FrameVector3D(expressedInFrame);
            this.time = time;
            this.expressedInFrame = expressedInFrame;
            trajectory.compute(time);
            trajectory.getLinearData((FramePoint3DBasics)this.position, (FrameVector3DBasics)this.linearVelocity, (FrameVector3DBasics)this.linearAcceleration);
        }

        public PositionTrajectoryState(Random random, double time, ReferenceFrame expressedInFrame) {
            this.time = time;
            this.position = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expressedInFrame, (double)1.0, (double)1.0, (double)1.0);
            this.linearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expressedInFrame, (double)-10.0, (double)10.0, (double)-10.0, (double)10.0, (double)-10.0, (double)10.0);
            this.linearAcceleration = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expressedInFrame, (double)-100.0, (double)100.0, (double)-100.0, (double)100.0, (double)-100.0, (double)100.0);
            this.expressedInFrame = expressedInFrame;
        }

        public FrameEuclideanTrajectoryPoint getWaypoint() {
            return new FrameEuclideanTrajectoryPoint(this.time, (FramePoint3DReadOnly)this.position, (FrameVector3DReadOnly)this.linearVelocity);
        }

        public FramePoint3DReadOnly getPosition() {
            this.position.changeFrame(this.expressedInFrame);
            return new FramePoint3D((FrameTuple3DReadOnly)this.position);
        }

        public FrameVector3DReadOnly getLinearVelocity() {
            this.linearVelocity.changeFrame(this.expressedInFrame);
            return new FrameVector3D((FrameTuple3DReadOnly)this.linearVelocity);
        }

        public void assertEpsilonEquals(PositionTrajectoryState other, double epsilon) {
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)this.position, (EuclidFrameGeometry)other.position, (double)epsilon);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)this.linearVelocity, (EuclidFrameGeometry)other.linearVelocity, (double)epsilon);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)this.linearAcceleration, (EuclidFrameGeometry)other.linearAcceleration, (double)epsilon);
        }
    }
}

