/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.generators;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.robotics.math.trajectories.generators.MultiCubicSpline1DSolver;

public class MultiCubicSpline1DSolverTest {
    @Test
    public void testAccelerationIntegrationResult() {
        DMatrixRMaj solution = new DMatrixRMaj(1, 1);
        MultiCubicSpline1DSolver solver = new MultiCubicSpline1DSolver();
        double[] times = new double[]{0.0, 0.25, 0.75, 1.0};
        solver.setEndpoints(0.0, 1.0, 0.0, 1.0);
        solver.addWaypoint(2.0, times[1]);
        solver.addWaypoint(-2.0, times[2]);
        double costUsingNative = solver.solveAndComputeCost(solution);
        int numberOfSplines = solution.getNumRows() / 4;
        double expectedAccelerationIntegrated = 0.0;
        for (int i = 0; i < numberOfSplines; ++i) {
            int offset = i * 4;
            double c0 = solution.get(offset + 0);
            double c1 = solution.get(offset + 1);
            double t0 = times[i];
            double tf = times[i + 1];
            expectedAccelerationIntegrated += 12.0 * c0 * c0 * (tf * tf * tf - t0 * t0 * t0) + 12.0 * c0 * c1 * (tf * tf - t0 * t0) + 4.0 * c1 * c1 * (tf - t0);
        }
        double dt = 1.0E-5;
        double accelerationNumericallyIntegrated = 0.0;
        for (double t = dt; t <= 1.0; t += dt) {
            double accCurr = solver.computeAcceleration(t, solution);
            accelerationNumericallyIntegrated += MathTools.square((double)Math.abs(accCurr)) * dt;
        }
        Assertions.assertEquals((double)(expectedAccelerationIntegrated *= 0.5), (double)costUsingNative, (double)(Math.max(expectedAccelerationIntegrated, 1.0) * 1.0E-12));
        Assertions.assertEquals((double)(accelerationNumericallyIntegrated *= 0.5), (double)costUsingNative, (double)(Math.max(accelerationNumericallyIntegrated, 1.0) * 1.0E-7));
    }

    @Test
    public void testGetWaypointVelocityFromSolution() {
        Random random = new Random(45435L);
        DMatrixRMaj solution = new DMatrixRMaj(2, 1);
        MultiCubicSpline1DSolver solver = new MultiCubicSpline1DSolver();
        for (int i = 0; i < 100; ++i) {
            int j;
            int numberOfWaypoints = random.nextInt(10) + 1;
            double startPosition = EuclidCoreRandomTools.nextDouble((Random)random);
            double endPosition = EuclidCoreRandomTools.nextDouble((Random)random);
            double[] waypointPositions = random.doubles(numberOfWaypoints, -0.5, 10.0).toArray();
            double[] waypointTimes = new double[numberOfWaypoints];
            double[] weights = new double[numberOfWaypoints + 1];
            double sumOfWeights = 0.0;
            for (j = 0; j < weights.length; ++j) {
                weights[j] = random.nextDouble();
                sumOfWeights += weights[j];
            }
            for (j = 0; j < numberOfWaypoints; ++j) {
                waypointTimes[j] = weights[j] / sumOfWeights;
                if (j <= 0) continue;
                int n = j;
                waypointTimes[n] = waypointTimes[n] + waypointTimes[j - 1];
            }
            solver.clearWeights();
            solver.clearWaypoints();
            solver.setEndpoints(startPosition, 0.0, endPosition, 0.0);
            for (int j2 = 0; j2 < numberOfWaypoints; ++j2) {
                solver.addWaypoint(waypointPositions[j2], waypointTimes[j2]);
            }
            solver.solve(solution);
            int waypointIndex = random.nextInt(numberOfWaypoints);
            double waypointTime = waypointTimes[waypointIndex];
            double expectedVelocity = MultiCubicSpline1DSolverTest.computeExpectedVelocity(waypointTime, waypointIndex, solution);
            double actualVelocity = solver.computeWaypointVelocityFromSolution(waypointIndex, solution);
            Assertions.assertEquals((double)expectedVelocity, (double)actualVelocity, (double)(1.0E-10 * Math.max(1.0, Math.abs(expectedVelocity))));
        }
    }

    @Test
    public void testGetPosition() {
        Random random = new Random(45435L);
        DMatrixRMaj solution = new DMatrixRMaj(2, 1);
        MultiCubicSpline1DSolver solver = new MultiCubicSpline1DSolver();
        for (int i = 0; i < 100; ++i) {
            int j;
            int numberOfWaypoints = random.nextInt(10) + 1;
            double startPosition = EuclidCoreRandomTools.nextDouble((Random)random);
            double endPosition = EuclidCoreRandomTools.nextDouble((Random)random);
            double startVelocity = EuclidCoreRandomTools.nextDouble((Random)random);
            double endVelocity = EuclidCoreRandomTools.nextDouble((Random)random);
            double[] waypointPositions = random.doubles(numberOfWaypoints, -0.5, 10.0).toArray();
            double[] waypointTimes = new double[numberOfWaypoints];
            double[] weights = new double[numberOfWaypoints + 1];
            double sumOfWeights = 0.0;
            for (j = 0; j < weights.length; ++j) {
                weights[j] = random.nextDouble();
                sumOfWeights += weights[j];
            }
            for (j = 0; j < numberOfWaypoints; ++j) {
                waypointTimes[j] = weights[j] / sumOfWeights;
                if (j <= 0) continue;
                int n = j;
                waypointTimes[n] = waypointTimes[n] + waypointTimes[j - 1];
            }
            solver.clearWeights();
            solver.clearWaypoints();
            solver.setEndpoints(startPosition, startVelocity, endPosition, endVelocity);
            for (int j2 = 0; j2 < numberOfWaypoints; ++j2) {
                solver.addWaypoint(waypointPositions[j2], waypointTimes[j2]);
            }
            solver.solve(solution);
            Assertions.assertEquals((double)startPosition, (double)solver.computePosition(0.0, solution));
            Assertions.assertEquals((double)startPosition, (double)solver.computePosition(-0.1, solution));
            Assertions.assertEquals((double)endPosition, (double)solver.computePosition(1.0, solution));
            Assertions.assertEquals((double)endPosition, (double)solver.computePosition(1.1, solution));
            for (int segmentIndex = 0; segmentIndex < numberOfWaypoints; ++segmentIndex) {
                int firstWaypointIndex = segmentIndex;
                double firstWaypointTime = waypointTimes[firstWaypointIndex];
                double secondWaypointTime = segmentIndex >= numberOfWaypoints - 1 ? 1.0 : waypointTimes[firstWaypointIndex + 1];
                double expectedPosition = MultiCubicSpline1DSolverTest.computeExpectedPosition(firstWaypointTime, firstWaypointIndex, solution);
                double actualPosition = solver.computePosition(firstWaypointTime, solution);
                Assertions.assertEquals((double)expectedPosition, (double)actualPosition, (double)(1.0E-10 * Math.max(1.0, Math.abs(expectedPosition))));
                Assertions.assertEquals((double)waypointPositions[firstWaypointIndex], (double)expectedPosition, (double)(1.0E-7 * Math.max(1.0, Math.abs(waypointPositions[firstWaypointIndex]))));
                double time = EuclidCoreRandomTools.nextDouble((Random)random, (double)firstWaypointTime, (double)secondWaypointTime);
                expectedPosition = MultiCubicSpline1DSolverTest.computeExpectedPosition(time, firstWaypointIndex + 1, solution);
                actualPosition = solver.computePosition(time, solution);
                Assertions.assertEquals((double)expectedPosition, (double)actualPosition, (double)(1.0E-10 * Math.max(1.0, Math.abs(expectedPosition))));
            }
        }
    }

    @Test
    public void testGetVelocity() {
        Random random = new Random(45435L);
        DMatrixRMaj solution = new DMatrixRMaj(2, 1);
        MultiCubicSpline1DSolver solver = new MultiCubicSpline1DSolver();
        for (int i = 0; i < 100; ++i) {
            int j;
            int numberOfWaypoints = random.nextInt(10) + 1;
            double startPosition = EuclidCoreRandomTools.nextDouble((Random)random);
            double endPosition = EuclidCoreRandomTools.nextDouble((Random)random);
            double startVelocity = EuclidCoreRandomTools.nextDouble((Random)random);
            double endVelocity = EuclidCoreRandomTools.nextDouble((Random)random);
            double[] waypointPositions = random.doubles(numberOfWaypoints, -0.5, 10.0).toArray();
            double[] waypointTimes = new double[numberOfWaypoints];
            double[] weights = new double[numberOfWaypoints + 1];
            double sumOfWeights = 0.0;
            for (j = 0; j < weights.length; ++j) {
                weights[j] = random.nextDouble();
                sumOfWeights += weights[j];
            }
            for (j = 0; j < numberOfWaypoints; ++j) {
                waypointTimes[j] = weights[j] / sumOfWeights;
                if (j <= 0) continue;
                int n = j;
                waypointTimes[n] = waypointTimes[n] + waypointTimes[j - 1];
            }
            solver.clearWeights();
            solver.clearWaypoints();
            solver.setEndpoints(startPosition, startVelocity, endPosition, endVelocity);
            for (int j2 = 0; j2 < numberOfWaypoints; ++j2) {
                solver.addWaypoint(waypointPositions[j2], waypointTimes[j2]);
            }
            solver.solve(solution);
            Assertions.assertEquals((double)startVelocity, (double)solver.computeVelocity(0.0, solution));
            Assertions.assertEquals((double)startVelocity, (double)solver.computeVelocity(-0.1, solution));
            Assertions.assertEquals((double)endVelocity, (double)solver.computeVelocity(1.0, solution));
            Assertions.assertEquals((double)endVelocity, (double)solver.computeVelocity(1.1, solution));
            for (int segmentIndex = 0; segmentIndex < numberOfWaypoints; ++segmentIndex) {
                int firstWaypointIndex = segmentIndex;
                double firstWaypointTime = waypointTimes[firstWaypointIndex];
                double secondWaypointTime = segmentIndex >= numberOfWaypoints - 1 ? 1.0 : waypointTimes[firstWaypointIndex + 1];
                double expectedVelocity = MultiCubicSpline1DSolverTest.computeExpectedVelocity(firstWaypointTime, firstWaypointIndex, solution);
                double actualVelocity = solver.computeVelocity(firstWaypointTime, solution);
                Assertions.assertEquals((double)expectedVelocity, (double)actualVelocity, (double)(1.0E-10 * Math.max(1.0, Math.abs(expectedVelocity))));
                double time = EuclidCoreRandomTools.nextDouble((Random)random, (double)firstWaypointTime, (double)secondWaypointTime);
                expectedVelocity = MultiCubicSpline1DSolverTest.computeExpectedVelocity(time, firstWaypointIndex + 1, solution);
                actualVelocity = solver.computeVelocity(time, solution);
                Assertions.assertEquals((double)expectedVelocity, (double)actualVelocity, (double)(1.0E-10 * Math.max(1.0, Math.abs(expectedVelocity))));
            }
        }
    }

    private static double computeExpectedPosition(double time, int waypointIndex, DMatrixRMaj solution) {
        DMatrixRMaj tempLine = new DMatrixRMaj(1, 4);
        DMatrixRMaj tempCoeffs = new DMatrixRMaj(4, 1);
        MultiCubicSpline1DSolver.getPositionConstraintABlock((double)time, (int)0, (int)0, (DMatrixRMaj)tempLine);
        int index = waypointIndex * 4;
        CommonOps_DDRM.extract((DMatrix)solution, (int)index, (int)(index + 4), (int)0, (int)1, (DMatrix)tempCoeffs, (int)0, (int)0);
        return CommonOps_DDRM.dot((DMatrixD1)tempCoeffs, (DMatrixD1)tempLine);
    }

    private static double computeExpectedVelocity(double waypointTime, int waypointIndex, DMatrixRMaj solution) {
        DMatrixRMaj tempLine = new DMatrixRMaj(1, 4);
        DMatrixRMaj tempCoeffs = new DMatrixRMaj(4, 1);
        MultiCubicSpline1DSolver.getVelocityConstraintABlock((double)waypointTime, (int)0, (int)0, (DMatrixRMaj)tempLine);
        int index = waypointIndex * 4;
        CommonOps_DDRM.extract((DMatrix)solution, (int)index, (int)(index + 4), (int)0, (int)1, (DMatrix)tempCoeffs, (int)0, (int)0);
        return CommonOps_DDRM.dot((DMatrixD1)tempCoeffs, (DMatrixD1)tempLine);
    }
}

