/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.trajectories.yoVariables.YoParabolicTrajectoryGenerator;
import us.ihmc.robotics.random.RandomGeometry;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoParabolicTrajectoryGeneratorTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testConditions() {
        YoRegistry registry = new YoRegistry("registry");
        ReferenceFrame referenceFrame = ReferenceFrame.getWorldFrame();
        FramePoint3D initialPosition = new FramePoint3D(referenceFrame, 0.0, 0.0, 0.0);
        FramePoint3D intermediatePosition = new FramePoint3D(referenceFrame, 0.5, 0.5, 2.5);
        FramePoint3D finalPosition = new FramePoint3D(referenceFrame, 1.0, 1.0, 1.0);
        double intermediateParameter = 0.5;
        YoParabolicTrajectoryGenerator trajectoryGenerator = new YoParabolicTrajectoryGenerator("test", referenceFrame, registry);
        trajectoryGenerator.initialize(initialPosition, intermediatePosition, finalPosition, intermediateParameter);
        double delta = 1.0E-10;
        FramePoint3D positionToPack = new FramePoint3D(referenceFrame);
        trajectoryGenerator.getPosition(positionToPack, 0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)initialPosition, (EuclidGeometry)positionToPack, (double)delta);
        trajectoryGenerator.getPosition(positionToPack, intermediateParameter);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)intermediatePosition, (EuclidGeometry)positionToPack, (double)delta);
        trajectoryGenerator.getPosition(positionToPack, 1.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)finalPosition, (EuclidGeometry)positionToPack, (double)delta);
    }

    @Test
    public void testIllegalParameter1() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            double intermediateParameter = 1.1;
            ReferenceFrame referenceFrame = ReferenceFrame.getWorldFrame();
            FramePoint3D initialPosition = new FramePoint3D(referenceFrame, 0.0, 0.0, 0.0);
            FramePoint3D intermediatePosition = new FramePoint3D(referenceFrame, 0.5, 0.5, 2.5);
            FramePoint3D finalPosition = new FramePoint3D(referenceFrame, 1.0, 1.0, 1.0);
            YoRegistry registry = new YoRegistry("registry");
            YoParabolicTrajectoryGenerator trajectoryGenerator = new YoParabolicTrajectoryGenerator("test", referenceFrame, registry);
            trajectoryGenerator.initialize(initialPosition, intermediatePosition, finalPosition, intermediateParameter);
        });
    }

    @Test
    public void testIllegalParameter2() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            double intermediateParameter = -0.1;
            ReferenceFrame referenceFrame = ReferenceFrame.getWorldFrame();
            FramePoint3D initialPosition = new FramePoint3D(referenceFrame, 0.0, 0.0, 0.0);
            FramePoint3D intermediatePosition = new FramePoint3D(referenceFrame, 0.5, 0.5, 2.5);
            FramePoint3D finalPosition = new FramePoint3D(referenceFrame, 1.0, 1.0, 1.0);
            YoRegistry registry = new YoRegistry("registry");
            YoParabolicTrajectoryGenerator trajectoryGenerator = new YoParabolicTrajectoryGenerator("test", referenceFrame, registry);
            trajectoryGenerator.initialize(initialPosition, intermediatePosition, finalPosition, intermediateParameter);
        });
    }

    @Test
    public void testIllegalParameter3() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            ReferenceFrame referenceFrame = ReferenceFrame.getWorldFrame();
            YoParabolicTrajectoryGenerator trajectoryGenerator = null;
            try {
                double intermediateParameter = 0.7;
                FramePoint3D initialPosition = new FramePoint3D(referenceFrame, 0.0, 0.0, 0.0);
                FramePoint3D intermediatePosition = new FramePoint3D(referenceFrame, 0.5, 0.5, 2.5);
                FramePoint3D finalPosition = new FramePoint3D(referenceFrame, 1.0, 1.0, 1.0);
                YoRegistry registry = new YoRegistry("registry");
                trajectoryGenerator = new YoParabolicTrajectoryGenerator("test", referenceFrame, registry);
                trajectoryGenerator.initialize(initialPosition, intermediatePosition, finalPosition, intermediateParameter);
            }
            catch (RuntimeException e) {
                Assert.fail();
            }
            FramePoint3D positionToPack = new FramePoint3D(referenceFrame);
            trajectoryGenerator.getPosition(positionToPack, 1.1);
        });
    }

    @Test
    public void testApex() {
        YoRegistry registry = new YoRegistry("registry");
        ReferenceFrame referenceFrame = ReferenceFrame.getWorldFrame();
        FramePoint3D initialPosition = new FramePoint3D(referenceFrame, 0.0, 0.0, 0.0);
        FramePoint3D intermediatePosition = new FramePoint3D(referenceFrame, 0.5, 0.5, 2.5);
        FramePoint3D finalPosition = new FramePoint3D(referenceFrame, 1.0, 1.0, 0.0);
        double intermediateParameter = 0.5;
        YoParabolicTrajectoryGenerator trajectoryGenerator = new YoParabolicTrajectoryGenerator("test", referenceFrame, registry);
        trajectoryGenerator.initialize(initialPosition, intermediatePosition, finalPosition, intermediateParameter);
        double delta = 1.0E-10;
        FramePoint3D positionToPack = new FramePoint3D(referenceFrame);
        int n = 1000;
        double smallestDifference = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            double parameter = (double)i / (double)n;
            trajectoryGenerator.getPosition(positionToPack, parameter);
            double difference = intermediatePosition.getZ() - positionToPack.getZ();
            if (!(difference < smallestDifference)) continue;
            smallestDifference = difference;
        }
        Assert.assertTrue(smallestDifference < delta);
        Assert.assertTrue(smallestDifference >= 0.0);
    }

    @Test
    public void testVelocity() {
        YoRegistry registry = new YoRegistry("registry");
        Random random = new Random(186L);
        ReferenceFrame referenceFrame = ReferenceFrame.getWorldFrame();
        YoParabolicTrajectoryGenerator trajectoryGenerator = new YoParabolicTrajectoryGenerator("test", referenceFrame, registry);
        int nTests = 100;
        for (int i = 0; i < nTests; ++i) {
            FramePoint3D initialPosition = new FramePoint3D(referenceFrame, (Tuple3DReadOnly)RandomGeometry.nextVector3D((Random)random));
            FramePoint3D intermediatePosition = new FramePoint3D(referenceFrame, (Tuple3DReadOnly)RandomGeometry.nextVector3D((Random)random));
            FramePoint3D finalPosition = new FramePoint3D(referenceFrame, (Tuple3DReadOnly)RandomGeometry.nextVector3D((Random)random));
            double intermediateParameter = random.nextDouble();
            trajectoryGenerator.initialize(initialPosition, intermediatePosition, finalPosition, intermediateParameter);
            FramePoint3D position1 = new FramePoint3D(referenceFrame);
            FramePoint3D position2 = new FramePoint3D(referenceFrame);
            double dt = 1.0E-9;
            double parameter = random.nextDouble();
            trajectoryGenerator.getPosition(position1, parameter);
            trajectoryGenerator.getPosition(position2, parameter + dt);
            FrameVector3D numericalVelocity = new FrameVector3D((FrameTuple3DReadOnly)position2);
            numericalVelocity.sub((FrameTuple3DReadOnly)position1);
            numericalVelocity.scale(1.0 / dt);
            FrameVector3D velocityFromTrajectoryGenerator = new FrameVector3D(referenceFrame);
            trajectoryGenerator.getVelocity(velocityFromTrajectoryGenerator, parameter);
            double delta = 1.0E-4;
            EuclidCoreTestTools.assertEquals((EuclidGeometry)numericalVelocity, (EuclidGeometry)velocityFromTrajectoryGenerator, (double)delta);
        }
    }

    @Test
    public void testInitialVelocity() {
        YoRegistry registry = new YoRegistry("registry");
        Random random = new Random(186L);
        ReferenceFrame referenceFrame = ReferenceFrame.getWorldFrame();
        YoParabolicTrajectoryGenerator trajectoryGenerator = new YoParabolicTrajectoryGenerator("test", referenceFrame, registry);
        FramePoint3D initialPosition = new FramePoint3D(referenceFrame, (Tuple3DReadOnly)RandomGeometry.nextVector3D((Random)random));
        FrameVector3D initialVelocity = new FrameVector3D(referenceFrame, (Tuple3DReadOnly)RandomGeometry.nextVector3D((Random)random));
        FramePoint3D finalPosition = new FramePoint3D(referenceFrame, (Tuple3DReadOnly)RandomGeometry.nextVector3D((Random)random));
        trajectoryGenerator.initialize(initialPosition, initialVelocity, finalPosition);
        FramePoint3D initialPositionBack = new FramePoint3D(referenceFrame);
        trajectoryGenerator.getPosition(initialPositionBack, 0.0);
        FrameVector3D initialVelocityBack = new FrameVector3D(referenceFrame);
        trajectoryGenerator.getVelocity(initialVelocityBack, 0.0);
        FramePoint3D finalPositionBack = new FramePoint3D(referenceFrame);
        trajectoryGenerator.getPosition(finalPositionBack, 1.0);
        double delta = 0.0;
        EuclidCoreTestTools.assertEquals((EuclidGeometry)initialPosition, (EuclidGeometry)initialPositionBack, (double)delta);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)initialVelocity, (EuclidGeometry)initialVelocityBack, (double)delta);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)finalPosition, (EuclidGeometry)finalPositionBack, (double)delta);
    }
}

