/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.trajectories.StraightLinePositionTrajectoryGenerator;
import us.ihmc.robotics.trajectories.providers.FramePositionProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class StraightLinePositionTrajectoryGeneratorTest {
    private static final double EPSILON = 1.0E-10;
    private String namePrefix = "namePrefixTEST";
    private ReferenceFrame referenceFrame;
    private DoubleProvider trajectoryTimeProvider;
    private StraightLinePositionTrajectoryGenerator generator;
    private FramePositionProvider initialPositionProvider;
    private FramePositionProvider finalPositionProvider;
    private FramePoint3D position;
    private YoRegistry parentRegistry;
    private double xValue = Math.random();
    private double yValue = Math.random();
    private double zValue = Math.random();
    private static double finalTime = 10.0;

    @BeforeEach
    public void setUp() {
        this.parentRegistry = new YoRegistry("parentRegistryTEST");
        this.referenceFrame = ReferenceFrameTools.constructARootFrame((String)"rootNameTEST");
        this.position = new FramePoint3D(this.referenceFrame, this.xValue, this.yValue, this.zValue);
        this.initialPositionProvider = () -> this.position;
        this.finalPositionProvider = () -> this.position;
        this.trajectoryTimeProvider = () -> 10.0;
    }

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testConstructor() {
        try {
            this.generator = new StraightLinePositionTrajectoryGenerator(this.namePrefix, this.referenceFrame, this.trajectoryTimeProvider, this.initialPositionProvider, this.finalPositionProvider, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.generator = new StraightLinePositionTrajectoryGenerator(this.namePrefix, this.referenceFrame, this.trajectoryTimeProvider, this.initialPositionProvider, this.finalPositionProvider, this.parentRegistry);
    }

    @Test
    public void testIsDone() {
        this.generator = new StraightLinePositionTrajectoryGenerator(this.namePrefix, this.referenceFrame, this.trajectoryTimeProvider, this.initialPositionProvider, this.finalPositionProvider, this.parentRegistry);
        this.generator.initialize();
        this.generator.compute(5.0);
        Assert.assertFalse(this.generator.isDone());
        this.generator.compute(finalTime + 1.0E-10);
        Assert.assertTrue(this.generator.isDone());
    }

    @Test
    public void testGet() {
        this.generator = new StraightLinePositionTrajectoryGenerator(this.namePrefix, this.referenceFrame, this.trajectoryTimeProvider, this.initialPositionProvider, this.finalPositionProvider, this.parentRegistry);
        FramePoint3D positionToPack = new FramePoint3D();
        positionToPack.setIncludingFrame((FrameTuple3DReadOnly)this.generator.getPosition());
        Assert.assertEquals(this.referenceFrame, positionToPack.getReferenceFrame());
    }

    @Test
    public void testPackVelocity() {
        this.generator = new StraightLinePositionTrajectoryGenerator(this.namePrefix, this.referenceFrame, this.trajectoryTimeProvider, this.initialPositionProvider, this.finalPositionProvider, this.parentRegistry);
        FrameVector3D velocityToPack = new FrameVector3D(ReferenceFrame.getWorldFrame(), 10.0, 10.0, 10.0);
        Assert.assertFalse(this.referenceFrame.equals((Object)velocityToPack.getReferenceFrame()));
        velocityToPack.setIncludingFrame((FrameTuple3DReadOnly)this.generator.getVelocity());
        Assert.assertEquals(0.0, velocityToPack.getX(), 1.0E-10);
        Assert.assertEquals(0.0, velocityToPack.getY(), 1.0E-10);
        Assert.assertEquals(0.0, velocityToPack.getZ(), 1.0E-10);
        Assert.assertSame(this.referenceFrame, velocityToPack.getReferenceFrame());
    }

    @Test
    public void testPackAcceleration() {
        this.generator = new StraightLinePositionTrajectoryGenerator(this.namePrefix, this.referenceFrame, this.trajectoryTimeProvider, this.initialPositionProvider, this.finalPositionProvider, this.parentRegistry);
        FrameVector3D accelerationToPack = new FrameVector3D(ReferenceFrame.getWorldFrame(), 10.0, 10.0, 10.0);
        Assert.assertFalse(this.referenceFrame.equals((Object)accelerationToPack.getReferenceFrame()));
        accelerationToPack.setIncludingFrame((FrameTuple3DReadOnly)this.generator.getAcceleration());
        Assert.assertEquals(0.0, accelerationToPack.getX(), 1.0E-10);
        Assert.assertEquals(0.0, accelerationToPack.getY(), 1.0E-10);
        Assert.assertEquals(0.0, accelerationToPack.getZ(), 1.0E-10);
        Assert.assertSame(this.referenceFrame, accelerationToPack.getReferenceFrame());
    }

    @Test
    public void testPackLinearData() {
        FramePoint3D positionToPack = new FramePoint3D(this.referenceFrame);
        positionToPack.setIncludingFrame(this.referenceFrame, 4.4, 3.3, 1.4);
        this.generator = new StraightLinePositionTrajectoryGenerator(this.namePrefix, this.referenceFrame, this.trajectoryTimeProvider, this.initialPositionProvider, this.finalPositionProvider, this.parentRegistry);
        positionToPack.setIncludingFrame((FrameTuple3DReadOnly)this.generator.getPosition());
        Assert.assertEquals(this.referenceFrame, positionToPack.getReferenceFrame());
        positionToPack.setIncludingFrame((FrameTuple3DReadOnly)this.generator.getPosition());
        Assert.assertEquals(this.referenceFrame, positionToPack.getReferenceFrame());
        FrameVector3D velocityToPack = new FrameVector3D(ReferenceFrame.getWorldFrame(), 10.0, 10.0, 10.0);
        FrameVector3D accelerationToPack = new FrameVector3D(ReferenceFrame.getWorldFrame(), 10.0, 10.0, 10.0);
        Assert.assertFalse(this.referenceFrame.equals((Object)velocityToPack.getReferenceFrame()));
        Assert.assertTrue(ReferenceFrame.getWorldFrame().equals((Object)velocityToPack.getReferenceFrame()));
        Assert.assertFalse(this.referenceFrame.equals((Object)accelerationToPack.getReferenceFrame()));
        Assert.assertTrue(ReferenceFrame.getWorldFrame().equals((Object)accelerationToPack.getReferenceFrame()));
        this.generator.getLinearData((FramePoint3DBasics)positionToPack, (FrameVector3DBasics)velocityToPack, (FrameVector3DBasics)accelerationToPack);
        Assert.assertEquals(0.0, positionToPack.getX(), 1.0E-10);
        Assert.assertEquals(0.0, positionToPack.getY(), 1.0E-10);
        Assert.assertEquals(0.0, positionToPack.getZ(), 1.0E-10);
        Assert.assertSame(this.referenceFrame, positionToPack.getReferenceFrame());
        Assert.assertEquals(0.0, velocityToPack.getX(), 1.0E-10);
        Assert.assertEquals(0.0, velocityToPack.getY(), 1.0E-10);
        Assert.assertEquals(0.0, velocityToPack.getZ(), 1.0E-10);
        Assert.assertSame(this.referenceFrame, velocityToPack.getReferenceFrame());
        Assert.assertEquals(0.0, accelerationToPack.getX(), 1.0E-10);
        Assert.assertEquals(0.0, accelerationToPack.getY(), 1.0E-10);
        Assert.assertEquals(0.0, accelerationToPack.getZ(), 1.0E-10);
        Assert.assertSame(this.referenceFrame, accelerationToPack.getReferenceFrame());
    }
}

