/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.trajectories.PolynomialBasicsTest;
import us.ihmc.robotics.math.trajectories.core.Polynomial;
import us.ihmc.robotics.math.trajectories.interfaces.PolynomialBasics;

public class PolynomialTest
extends PolynomialBasicsTest {
    @Override
    public PolynomialBasics getPolynomial(int maxNumberOfCoefficients) {
        return new Polynomial(maxNumberOfCoefficients);
    }

    @Test
    public void testQuinticTrajectory() {
        Polynomial quinticTrajectory = new Polynomial(-10.0, 10.0, new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0});
        quinticTrajectory.setQuintic(0.0, 1.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0);
        quinticTrajectory.compute(0.0);
        Assert.assertEquals(quinticTrajectory.getValue(), 1.0, 1.0E-7);
        Assert.assertEquals(quinticTrajectory.getVelocity(), 2.0, 1.0E-7);
        Assert.assertEquals(quinticTrajectory.getAcceleration(), 3.0, 1.0E-7);
        quinticTrajectory.compute(1.0);
        Assert.assertEquals(quinticTrajectory.getValue(), 4.0, 1.0E-7);
        Assert.assertEquals(quinticTrajectory.getVelocity(), 5.0, 1.0E-7);
        Assert.assertEquals(quinticTrajectory.getAcceleration(), 6.0, 1.0E-7);
        quinticTrajectory.setQuintic(-1.0, 1.0, 1.0, -2.0, 3.0, -4.0, -5.0, 6.0);
        quinticTrajectory.compute(-1.0);
        Assert.assertEquals(quinticTrajectory.getValue(), 1.0, 1.0E-7);
        Assert.assertEquals(quinticTrajectory.getVelocity(), -2.0, 1.0E-7);
        Assert.assertEquals(quinticTrajectory.getAcceleration(), 3.0, 1.0E-7);
        quinticTrajectory.compute(1.0);
        Assert.assertEquals(quinticTrajectory.getValue(), -4.0, 1.0E-7);
        Assert.assertEquals(quinticTrajectory.getVelocity(), -5.0, 1.0E-7);
        Assert.assertEquals(quinticTrajectory.getAcceleration(), 6.0, 1.0E-7);
    }
}

